/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDAnnotationImpl;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.impl.XSDModelGroupImpl;
import org.eclipse.xsd.impl.XSDNamedComponentImpl;
import org.eclipse.xsd.impl.XSDRedefinableComponentImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDModelGroupDefinitionImpl
extends XSDRedefinableComponentImpl
implements XSDModelGroupDefinition {
    protected XSDAnnotation annotation = null;
    protected XSDModelGroup modelGroup = null;
    protected XSDModelGroupDefinition resolvedModelGroupDefinition = this;
    protected int analysisState;

    public static XSDModelGroupDefinition createModelGroupDefinition(Node node) {
        if (XSDConstants.nodeType(node) == 16) {
            XSDModelGroupDefinition xsdModelGroupDefinition = XSDFactory.eINSTANCE.createXSDModelGroupDefinition();
            xsdModelGroupDefinition.setElement((Element)node);
            return xsdModelGroupDefinition;
        }
        return null;
    }

    protected XSDModelGroupDefinitionImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDModelGroupDefinition();
    }

    public Boolean getModelGroupDefinitionReference() {
        return new Boolean(this.isModelGroupDefinitionReference());
    }

    protected boolean isUpdatingDOM() {
        return super.isUpdatingDOM() || this.getContainer() instanceof XSDConcreteComponentImpl && ((XSDConcreteComponentImpl)this.getContainer()).isUpdatingDOM();
    }

    public Element createElement() {
        Element newElement = this.createElement(16);
        this.setElement(newElement);
        XSDModelGroup theModelGroup = this.getModelGroup();
        if (theModelGroup != null) {
            Element modelGroupElement = ((XSDConcreteComponentImpl)((Object)theModelGroup)).createElement();
            newElement.appendChild(modelGroupElement);
        }
        return newElement;
    }

    protected void patch() {
        XSDModelGroupDefinition newResolvedModelGroupDefinition;
        super.patch();
        XSDModelGroupDefinition theResolvedModelGroupDefinition = this.getResolvedModelGroupDefinition();
        if (theResolvedModelGroupDefinition != this && theResolvedModelGroupDefinition.getContainer() == null && (newResolvedModelGroupDefinition = this.resolveModelGroupDefinition(theResolvedModelGroupDefinition.getTargetNamespace(), theResolvedModelGroupDefinition.getName())).getContainer() != null) {
            this.handleNewResolvedModelGroupDefinition(newResolvedModelGroupDefinition);
        }
    }

    protected boolean analyze() {
        switch (this.analysisState) {
            case 0: {
                this.analysisState = 1;
                super.analyze();
                this.handleAnalysis();
                if (this.analysisState == 1) {
                    this.analysisState = 2;
                    return true;
                }
                return false;
            }
            case 2: {
                return true;
            }
        }
        this.analysisState = 3;
        return false;
    }

    protected void handleAnalysis() {
        XSDModelGroupDefinition theResolvedModelGroupDefinition = this.getResolvedModelGroupDefinition();
        if (theResolvedModelGroupDefinition != this && theResolvedModelGroupDefinition.getContainer() != null) {
            ((XSDConcreteComponentImpl)((Object)theResolvedModelGroupDefinition)).analyze();
        }
    }

    public void validate() {
        super.validate();
        Element theElement = this.getElement();
        if (theElement != null) {
            if (this.getContainer() instanceof XSDSchema || this.getContainer() instanceof XSDRedefine) {
                this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-group", theElement, new String[]{"id", "name"});
                this.checkComplexContent("namedGroup", "http://www.w3.org/TR/xmlschema-1/", "element-group", theElement);
            } else {
                this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", "element-group", theElement, new String[]{"id", "maxOccurs", "minOccurs", "ref"});
                this.checkComplexContent("groupRef", "http://www.w3.org/TR/xmlschema-1/", "element-group", theElement);
            }
            this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", "element-attributeGroup", theElement, "id", false);
        }
        if (this.getContainer() instanceof XSDSchema || this.getContainer() instanceof XSDRedefine) {
            if (this.isModelGroupDefinitionReference()) {
                if (theElement == null) {
                    this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "cvc-complex-type.3", "ref");
                }
            } else {
                this.checkBuiltInTypeConstraint("NCName", this.getName(), "http://www.w3.org/TR/xmlschema-1/", "element-group", theElement, "name", true);
                if (this.isCircular()) {
                    this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "coss-modelGroup.2");
                }
                if (this.getModelGroup() != null) {
                    ((XSDModelGroupImpl)this.getModelGroup()).validateRoot();
                }
            }
        } else if (this.isModelGroupDefinitionReference()) {
            XSDModelGroupDefinition theResolvedModelGroupDefinition = this.getResolvedModelGroupDefinition();
            if (theResolvedModelGroupDefinition.getContainer() == null) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "_UI_UnresolvedModelGroupDefinition_message", theResolvedModelGroupDefinition.getURI());
            }
        } else if (theElement == null) {
            this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "cvc-complex-type.3", "name");
        }
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        XSDModelGroupDefinition newResolvedModelGroupDefinition = this;
        if (changedElement.hasAttributeNS(null, "ref")) {
            newResolvedModelGroupDefinition = this.resolveModelGroupDefinitionURI(XSDConstants.lookupQNameForAttribute(changedElement, "ref"));
        }
        this.handleNewResolvedModelGroupDefinition(newResolvedModelGroupDefinition);
    }

    protected void handleNewResolvedModelGroupDefinition(XSDModelGroupDefinition newResolvedModelGroupDefinition) {
        XSDModelGroupDefinition redefinedModelGroupDefinition;
        XSDSchema redefinedSchema;
        if (newResolvedModelGroupDefinition.getContainer() instanceof XSDRedefine && newResolvedModelGroupDefinition.contains(this) && (redefinedSchema = ((XSDRedefine)newResolvedModelGroupDefinition.getContainer()).getIncorporatedSchema()) != null && (redefinedModelGroupDefinition = (XSDModelGroupDefinition)((XSDSchemaImpl)redefinedSchema).getRedefinitionMap().get(newResolvedModelGroupDefinition)) != null) {
            newResolvedModelGroupDefinition = redefinedModelGroupDefinition;
        }
        if (newResolvedModelGroupDefinition != this.getResolvedModelGroupDefinition()) {
            this.setResolvedModelGroupDefinition(newResolvedModelGroupDefinition);
            if (this.getContainer() instanceof XSDParticle) {
                ((XSDParticle)this.getContainer()).setTerm(newResolvedModelGroupDefinition.getModelGroup());
            }
        }
    }

    protected void handleUnreconciledElement(Element child, List newContents, List remainingContents) {
        XSDAnnotation xsdAnnotation = XSDAnnotationImpl.createAnnotation(child);
        if (xsdAnnotation != null) {
            if (newContents.isEmpty()) {
                newContents.add(xsdAnnotation);
            }
        } else {
            XSDModelGroup xsdModelGroup = XSDModelGroupImpl.createModelGroup(child);
            if (xsdModelGroup != null) {
                newContents.add(xsdModelGroup);
            }
        }
    }

    protected void handleReconciliation(List newContents, List remainingContents) {
        this.handleAnnotationReconciliation(XSDPackage.eINSTANCE.getXSDModelGroupDefinition_Annotation(), newContents, remainingContents);
        if (remainingContents.remove(this.getModelGroup())) {
            this.setModelGroup(null);
        }
        if (!newContents.isEmpty()) {
            this.setModelGroup((XSDModelGroup)newContents.get(0));
        }
    }

    protected void changeReference(EReference eReference) {
        XSDModelGroupDefinition theResolvedModelGroupDefinition;
        super.changeReference(eReference);
        Element theElement = this.getElement();
        if (theElement != null && (eReference == null || eReference == XSDPackage.eINSTANCE.getXSDModelGroupDefinition_ResolvedModelGroupDefinition()) && (theResolvedModelGroupDefinition = this.getResolvedModelGroupDefinition()) != this) {
            this.niceSetAttributeURIValue(theElement, "ref", theResolvedModelGroupDefinition.getURI());
            if (eReference != null && this.getContainer() instanceof XSDParticle) {
                ((XSDParticle)this.getContainer()).setTerm(theResolvedModelGroupDefinition.getModelGroup());
            }
        }
    }

    protected void adoptContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.adoptContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.eINSTANCE.getXSDModelGroupDefinition_ModelGroup()) {
            this.traverseToRootForPatching();
        }
    }

    protected void orphanContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.orphanContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.eINSTANCE.getXSDModelGroupDefinition_ModelGroup()) {
            this.traverseToRootForPatching();
        }
    }

    public boolean isModelGroupDefinitionReference() {
        return this != this.getResolvedModelGroupDefinition();
    }

    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(XSDAnnotation newAnnotation) {
        if (newAnnotation != this.annotation) {
            NotificationChain msgs = null;
            if (this.annotation != null) {
                msgs = ((InternalEObject)this.annotation).eInverseRemove((InternalEObject)this, -14, null, msgs);
            }
            if (newAnnotation != null) {
                msgs = ((InternalEObject)newAnnotation).eInverseAdd((InternalEObject)this, -14, null, msgs);
            }
            if ((msgs = this.basicSetAnnotation(newAnnotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)newAnnotation, (Object)newAnnotation));
        }
    }

    public NotificationChain basicSetAnnotation(XSDAnnotation newAnnotation, NotificationChain msgs) {
        XSDAnnotation oldAnnotation = this.annotation;
        this.annotation = newAnnotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldAnnotation, (Object)newAnnotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public XSDModelGroup getModelGroup() {
        return this.modelGroup;
    }

    public void setModelGroup(XSDModelGroup newModelGroup) {
        if (newModelGroup != this.modelGroup) {
            NotificationChain msgs = null;
            if (this.modelGroup != null) {
                msgs = ((InternalEObject)this.modelGroup).eInverseRemove((InternalEObject)this, -15, null, msgs);
            }
            if (newModelGroup != null) {
                msgs = ((InternalEObject)newModelGroup).eInverseAdd((InternalEObject)this, -15, null, msgs);
            }
            if ((msgs = this.basicSetModelGroup(newModelGroup, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)newModelGroup, (Object)newModelGroup));
        }
    }

    public NotificationChain basicSetModelGroup(XSDModelGroup newModelGroup, NotificationChain msgs) {
        XSDModelGroup oldModelGroup = this.modelGroup;
        this.modelGroup = newModelGroup;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldModelGroup, (Object)newModelGroup);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public XSDModelGroupDefinition getResolvedModelGroupDefinition() {
        return this.resolvedModelGroupDefinition;
    }

    public void setResolvedModelGroupDefinition(XSDModelGroupDefinition newResolvedModelGroupDefinition) {
        XSDModelGroupDefinition oldResolvedModelGroupDefinition = this.resolvedModelGroupDefinition;
        this.resolvedModelGroupDefinition = newResolvedModelGroupDefinition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldResolvedModelGroupDefinition, (Object)this.resolvedModelGroupDefinition));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove((Object)otherEnd, msgs);
                }
                case 13: {
                    return this.basicSetAnnotation(null, msgs);
                }
                case 14: {
                    return this.basicSetModelGroup(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getName();
            }
            case 6: {
                return this.getTargetNamespace();
            }
            case 7: {
                return this.getAliasName();
            }
            case 8: {
                return this.getURI();
            }
            case 9: {
                return this.getAliasURI();
            }
            case 10: {
                return this.getQName();
            }
            case 11: {
                return this.isCircular() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 12: {
                return this.isModelGroupDefinitionReference() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return this.getAnnotation();
            }
            case 14: {
                return this.getModelGroup();
            }
            case 15: {
                return this.getResolvedModelGroupDefinition();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setName((String)newValue);
                return;
            }
            case 6: {
                this.setTargetNamespace((String)newValue);
                return;
            }
            case 13: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
            case 14: {
                this.setModelGroup((XSDModelGroup)newValue);
                return;
            }
            case 15: {
                this.setResolvedModelGroupDefinition((XSDModelGroupDefinition)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(XSDConcreteComponentImpl.ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setName(XSDNamedComponentImpl.NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setTargetNamespace(XSDNamedComponentImpl.TARGET_NAMESPACE_EDEFAULT);
                return;
            }
            case 13: {
                this.setAnnotation(null);
                return;
            }
            case 14: {
                this.setModelGroup(null);
                return;
            }
            case 15: {
                this.setResolvedModelGroupDefinition(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return XSDConcreteComponentImpl.ELEMENT_EDEFAULT == null ? this.element != null : !XSDConcreteComponentImpl.ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return XSDNamedComponentImpl.NAME_EDEFAULT == null ? this.name != null : !XSDNamedComponentImpl.NAME_EDEFAULT.equals(this.name);
            }
            case 6: {
                return XSDNamedComponentImpl.TARGET_NAMESPACE_EDEFAULT == null ? this.targetNamespace != null : !XSDNamedComponentImpl.TARGET_NAMESPACE_EDEFAULT.equals(this.targetNamespace);
            }
            case 7: {
                return this.getAliasName() != null;
            }
            case 8: {
                return this.getURI() != null;
            }
            case 9: {
                return this.getAliasURI() != null;
            }
            case 10: {
                return this.getQName() != null;
            }
            case 11: {
                return this.isCircular();
            }
            case 12: {
                return this.isModelGroupDefinitionReference();
            }
            case 13: {
                return this.annotation != null;
            }
            case 14: {
                return this.modelGroup != null;
            }
            case 15: {
                return this.resolvedModelGroupDefinition != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String getQName() {
        XSDModelGroupDefinition resolvedModelGroupDefinition = this.getResolvedModelGroupDefinition();
        if (resolvedModelGroupDefinition == this) {
            return super.getQName();
        }
        return resolvedModelGroupDefinition.getQName(this);
    }

    public boolean isNamedComponentReference() {
        return this.isModelGroupDefinitionReference();
    }

    public XSDNamedComponent getResolvedNamedComponent() {
        return this.getResolvedModelGroupDefinition();
    }

    public boolean isCircular() {
        return this.analysisState == 3;
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDModelGroupDefinitionImpl clonedModelGroupDefinition = (XSDModelGroupDefinitionImpl)this.getXSDFactory().createXSDModelGroupDefinition();
        clonedModelGroupDefinition.isReconciling = true;
        if (this.isModelGroupDefinitionReference()) {
            XSDModelGroupDefinition theResolvedModelGroupDefinition = this.getResolvedModelGroupDefinition();
            clonedModelGroupDefinition.setResolvedModelGroupDefinition(this.createUnresolvedModelGroupDefinition(theResolvedModelGroupDefinition.getTargetNamespace(), theResolvedModelGroupDefinition.getName()));
        } else if (this.getName() != null) {
            clonedModelGroupDefinition.setName(this.getName());
        }
        if (deep) {
            if (this.getAnnotation() != null) {
                clonedModelGroupDefinition.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
            }
            if (this.getModelGroup() != null) {
                clonedModelGroupDefinition.setModelGroup((XSDModelGroup)this.getModelGroup().cloneConcreteComponent(deep, shareDOM));
            }
        }
        if (shareDOM && this.getElement() != null) {
            clonedModelGroupDefinition.setElement(this.getElement());
        }
        clonedModelGroupDefinition.isReconciling = shareDOM;
        return clonedModelGroupDefinition;
    }
}

