/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.xsd2ecore;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.domain.MappingDomain;
import org.eclipse.emf.mapping.domain.PluginAdapterFactoryMappingDomain;
import org.eclipse.emf.mapping.provider.MappingItemProviderAdapterFactory;
import org.eclipse.emf.mapping.xsd2ecore.XSD2EcoreFactory;
import org.eclipse.xsd.ecore.MapBuilder;
import org.eclipse.xsd.provider.XSDItemProviderAdapterFactory;

public class XSD2EcoreMapper
implements MapBuilder.Mapper {
    protected MappingRoot mappingRoot;
    protected boolean topToBottom = true;

    public EObject getRoot() {
        return this.getMappingRoot();
    }

    public MappingRoot getMappingRoot() {
        if (this.mappingRoot == null) {
            this.mappingRoot = XSD2EcoreFactory.eINSTANCE.createXSD2EcoreMappingRoot();
            XSDItemProviderAdapterFactory xsdAdapterFactory = new XSDItemProviderAdapterFactory();
            EcoreItemProviderAdapterFactory ecoreAdapterFactory = new EcoreItemProviderAdapterFactory();
            ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ResourceItemProviderAdapterFactory(), new MappingItemProviderAdapterFactory(), new XSDItemProviderAdapterFactory(), new EcoreItemProviderAdapterFactory()});
            this.mappingRoot.setDomain((MappingDomain)new PluginAdapterFactoryMappingDomain((AdapterFactory)composedAdapterFactory, (AdapterFactory)xsdAdapterFactory, (AdapterFactory)ecoreAdapterFactory, null, null));
            this.mappingRoot.setTopToBottom(this.topToBottom);
        }
        return this.mappingRoot;
    }

    public void map(Collection inputs, Collection outputs) {
        Mapping mapping = this.topToBottom ? this.getMappingRoot().createMapping(inputs, outputs) : this.getMappingRoot().createMapping(outputs, inputs);
        Mapping parent = this.mappingRoot.getParentMapping(mapping.getMappedObjects());
        parent.getNested().add(mapping);
        Iterator i = parent.getNested().iterator();
        while (i.hasNext()) {
            Mapping otherMapping = (Mapping)i.next();
            if (otherMapping == mapping || this.mappingRoot.getParentMapping(otherMapping.getMappedObjects()) != mapping) continue;
            i.remove();
            mapping.getNested().add(otherMapping);
        }
    }

    public void addInput(EObject input) {
        if (input instanceof EPackage) {
            this.topToBottom = false;
        }
        this.getMappingRoot().getInputs().add(input);
    }

    public void addOutput(EObject output) {
        this.getMappingRoot().getOutputs().add(output);
    }
}

