/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.xsd2ecore.presentation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.command.InitializeCopyCommand;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.command.InitializeCopyOverrideCommand;
import org.eclipse.emf.mapping.domain.AdapterFactoryMappingDomain;
import org.eclipse.emf.mapping.domain.MappingDomain;
import org.eclipse.emf.mapping.domain.PluginAdapterFactoryMappingDomain;
import org.eclipse.emf.mapping.presentation.MappingEditor;
import org.eclipse.emf.mapping.provider.MappingItemProviderAdapterFactory;
import org.eclipse.emf.mapping.xsd2ecore.XSD2EcoreFactory;
import org.eclipse.emf.mapping.xsd2ecore.XSD2EcoreMappingRoot;
import org.eclipse.emf.mapping.xsd2ecore.presentation.XSD2EcoreEditorPlugin;
import org.eclipse.emf.mapping.xsd2ecore.provider.XSD2EcoreItemProviderAdapterFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xsd.provider.XSDItemProviderAdapterFactory;

public class XSD2EcoreEditor
extends MappingEditor {
    public XSD2EcoreEditor() {
        this.topLabel = XSD2EcoreEditorPlugin.INSTANCE.getString("_UI_XMLSchema_label");
        this.bottomLabel = XSD2EcoreEditorPlugin.INSTANCE.getString("_UI_Ecore_label");
    }

    protected AdapterFactoryMappingDomain createMappingDomain() {
        ComposedAdapterFactory mappingAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ResourceItemProviderAdapterFactory(), new MappingItemProviderAdapterFactory(), new XSD2EcoreItemProviderAdapterFactory()});
        BasicCommandStack commandStack = new BasicCommandStack();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        MyMappingDomain mappingDomain = new MyMappingDomain((AdapterFactory)mappingAdapterFactory, (AdapterFactory)new XSDItemProviderAdapterFactory(), (AdapterFactory)new EcoreItemProviderAdapterFactory(), (CommandStack)commandStack, null);
        return mappingDomain;
    }

    protected void handleMissingModelFile() {
        try {
            IFile mappingModelFile = this.modelFile.getFile().getParent().getFile((IPath)new Path(new Path(this.modelFile.getName()).removeFileExtension().toOSString() + ".mapper"));
            MappingRoot originalRootObject = (MappingRoot)((Resource)this.mappingDomain.getResourceSet().getResources().iterator().next()).getContents().get(0);
            this.modelFile = new FileEditorInput(mappingModelFile);
            Resource mappingModelResource = null;
            if (mappingModelFile.exists()) {
                Resource resource = this.mappingDomain.loadResource(this.getURIFromFile(this.modelFile.getFile()));
                this.mappingRoot = (MappingRoot)resource.getContents().get(0);
            } else {
                mappingModelResource = this.mappingDomain.getResourceSet().createResource(URI.createFileURI((String)this.modelFile.getFile().getFullPath().toString()));
                this.mappingRoot = XSD2EcoreFactory.eINSTANCE.createXSD2EcoreMappingRoot();
                mappingModelResource.getContents().add(this.mappingRoot);
                this.mappingDomain.getResourceSet().getResources().add(mappingModelResource);
                this.mappingRoot.getInputs().add(originalRootObject);
                IFile outputModelFile = this.modelFile.getFile().getParent().getFile((IPath)new Path(new Path(this.modelFile.getName()).removeFileExtension().toOSString() + "_mapper_result.classside"));
                Resource outputResource = null;
                if (outputModelFile.exists()) {
                    outputResource = this.mappingDomain.loadResource(this.getURIFromFile(outputModelFile));
                } else {
                    outputResource = this.mappingDomain.getResourceSet().createResource(URI.createURI((String)this.getURIFromFile(outputModelFile)));
                    XSD2EcoreMappingRoot xsd2EcoreMappingRoot = XSD2EcoreFactory.eINSTANCE.createXSD2EcoreMappingRoot();
                    outputResource.getContents().add(xsd2EcoreMappingRoot);
                    this.mappingRoot.getOutputs().addAll(outputResource.getContents());
                }
                this.doSave(null);
            }
            this.mappingRoot.setDomain((MappingDomain)this.mappingDomain);
            this.mappingRoot.setTopToBottom(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class MyMappingDomain
    extends PluginAdapterFactoryMappingDomain {
        public MyMappingDomain(AdapterFactory mappingDomainAdapterFactory, AdapterFactory topDomainAdapterFactory, AdapterFactory bottomDomainAdapterFactory, CommandStack commandStack, String mappingDomainKey) {
            super(mappingDomainAdapterFactory, topDomainAdapterFactory, bottomDomainAdapterFactory, commandStack, mappingDomainKey);
        }

        protected Command createInitializeCopyOverrideCommand(InitializeCopyCommand initializeCopyCommand) {
            EObject copy = initializeCopyCommand.getCopy();
            EObject owner = initializeCopyCommand.getOwner();
            if (!((AdapterFactoryMappingDomain)this).isSameEditingDomainAdapterFactory) {
                return new MyInitializeCopyOverrideCommand((MappingDomain)this, initializeCopyCommand);
            }
            return null;
        }
    }

    public static class MyInitializeCopyOverrideCommand
    extends InitializeCopyOverrideCommand {
        public MyInitializeCopyOverrideCommand(MappingDomain domain, InitializeCopyCommand initializeCommand) {
            super(domain, initializeCommand);
        }

        public void execute() {
            super.execute();
        }
    }
}

