/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.DanglingHREFException;
import org.eclipse.emf.ecore.xmi.IllegalValueException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.internal.QName;

public class XMLHelperImpl
implements XMLHelper {
    protected static final Integer INTEGER_DATATYPE_IS_MANY = new Integer(2);
    protected static final Integer INTEGER_DATATYPE_SINGLE = new Integer(1);
    protected static final Integer INTEGER_IS_MANY_ADD = new Integer(3);
    protected static final Integer INTEGER_IS_MANY_MOVE = new Integer(4);
    protected EPackage noNamespacePackage;
    protected XMLResource.XMLMap xmlMap;
    protected ExtendedMetaData extendedMetaData;
    protected EPackage.Registry packageRegistry;
    protected XMLResource resource;
    protected URI resourceURI;
    protected boolean deresolve;
    protected Map packages;
    protected Map featuresToKinds;
    protected String processDanglingHREF;
    protected DanglingHREFException danglingHREFException;
    protected EMap prefixesToURIs;
    protected NamespaceSupport namespaceSupport;
    protected EClass anySimpleType;
    protected boolean seenEmptyStringMapping;
    protected EPackage xmlSchemaTypePackage = XMLTypePackage.eINSTANCE;

    public static String saveString(Map options, List contents, String encoding, XMLHelper helper) throws Exception {
        if (helper == null) {
            helper = new XMIHelperImpl();
        }
        if (!options.containsKey("DECLARE_XML")) {
            options = new HashMap<String, Boolean>(options);
            options.put("DECLARE_XML", Boolean.FALSE);
        }
        XMISaveImpl save = new XMISaveImpl(options, helper, encoding);
        ((XMLHelperImpl)helper).processDanglingHREF = (String)options.get("PROCESS_DANGLING_HREF");
        save.traverse(contents);
        char[] chars = save.toChar();
        return new String(chars);
    }

    public XMLHelperImpl() {
        this.packages = new HashMap();
        this.featuresToKinds = new HashMap();
        this.prefixesToURIs = new BasicEMap();
        this.namespaceSupport = new NamespaceSupport();
    }

    public XMLHelperImpl(XMLResource resource) {
        this();
        this.setResource(resource);
    }

    public void setNoNamespacePackage(EPackage pkg) {
        this.noNamespacePackage = pkg;
    }

    public EPackage getNoNamespacePackage() {
        return this.noNamespacePackage != null ? this.noNamespacePackage : (this.extendedMetaData != null ? this.extendedMetaData.getPackage(null) : null);
    }

    public void setXMLMap(XMLResource.XMLMap map) {
        this.xmlMap = map;
        if (map != null && map.getNoNamespacePackage() != null) {
            this.setNoNamespacePackage(map.getNoNamespacePackage());
        }
    }

    public XMLResource.XMLMap getXMLMap() {
        return this.xmlMap;
    }

    public void setExtendedMetaData(ExtendedMetaData extendedMetaData) {
        this.extendedMetaData = extendedMetaData;
        if (extendedMetaData != null && extendedMetaData.getPackage(null) != null) {
            this.setNoNamespacePackage(extendedMetaData.getPackage(null));
        }
    }

    public ExtendedMetaData getExtendedMetaData() {
        return this.extendedMetaData;
    }

    public XMLResource getResource() {
        return this.resource;
    }

    public void setResource(XMLResource resource) {
        this.resource = resource;
        if (resource == null) {
            this.resourceURI = null;
            this.deresolve = false;
            this.packageRegistry = EPackage.Registry.INSTANCE;
        } else {
            this.resourceURI = resource.getURI();
            this.deresolve = this.resourceURI != null && !this.resourceURI.isRelative() && this.resourceURI.isHierarchical();
            this.packageRegistry = resource.getResourceSet() == null ? EPackage.Registry.INSTANCE : resource.getResourceSet().getPackageRegistry();
        }
    }

    public Object getValue(EObject obj, EStructuralFeature f) {
        return obj.eGet(f, false);
    }

    public String getQName(EClass c) {
        XMLResource.XMLInfo clsInfo;
        String name = this.getName((ENamedElement)c);
        if (this.xmlMap != null && (clsInfo = this.xmlMap.getInfo((ENamedElement)c)) != null) {
            String targetNamespace = clsInfo.getTargetNamespace();
            return this.getQName(targetNamespace, name);
        }
        return this.getQName(c.getEPackage(), name);
    }

    public String getQName(EDataType c) {
        XMLResource.XMLInfo clsInfo;
        String name = this.getName((ENamedElement)c);
        if (this.xmlMap != null && (clsInfo = this.xmlMap.getInfo((ENamedElement)c)) != null) {
            String targetNamespace = clsInfo.getTargetNamespace();
            return this.getQName(targetNamespace, name);
        }
        return this.getQName(c.getEPackage(), name);
    }

    public String getQName(EStructuralFeature feature) {
        XMLResource.XMLInfo info;
        if (this.extendedMetaData != null) {
            String name;
            String namespace = this.extendedMetaData.getNamespace(feature);
            String result = name = this.extendedMetaData.getName(feature);
            if (namespace != null) {
                EPackage ePackage = this.extendedMetaData.getPackage(namespace);
                if (ePackage == null) {
                    ePackage = this.extendedMetaData.demandPackage(namespace);
                }
                if ((result = this.getQName(ePackage, name)).length() == name.length() && this.extendedMetaData.getFeatureKind(feature) == 2) {
                    result = this.getQName(ePackage, name, true);
                }
            }
            return result;
        }
        String name = this.getName((ENamedElement)feature);
        if (this.xmlMap != null && (info = this.xmlMap.getInfo((ENamedElement)feature)) != null) {
            return this.getQName(info.getTargetNamespace(), name);
        }
        return name;
    }

    protected String getQName(EPackage ePackage, String name) {
        return this.getQName(ePackage, name, false);
    }

    protected String getQName(EPackage ePackage, String name, boolean mustHavePrefix) {
        String nsPrefix = this.getPrefix(ePackage, mustHavePrefix);
        if ("".equals(nsPrefix)) {
            return name;
        }
        return String.valueOf(nsPrefix) + ":" + name;
    }

    public String getPrefix(EPackage ePackage) {
        return this.getPrefix(ePackage, false);
    }

    protected String getPrefix(EPackage ePackage, boolean mustHavePrefix) {
        String nsPrefix = (String)this.packages.get(ePackage);
        if (nsPrefix == null || mustHavePrefix && nsPrefix.length() == 0) {
            String nsURI = this.xmlSchemaTypePackage == ePackage ? "http://www.w3.org/2001/XMLSchema" : (this.extendedMetaData == null ? ePackage.getNsURI() : this.extendedMetaData.getNamespace(ePackage));
            boolean found = false;
            Iterator i = this.prefixesToURIs.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                if (!(nsURI == null ? entry.getValue() == null : nsURI.equals(entry.getValue()))) continue;
                nsPrefix = (String)entry.getKey();
                if (mustHavePrefix && nsPrefix.length() <= 0) continue;
                found = true;
                break;
            }
            if (!found) {
                String currentValue;
                if (nsURI != null) {
                    String string = nsPrefix = this.xmlSchemaTypePackage == ePackage ? "xsd" : ePackage.getNsPrefix();
                }
                if (nsPrefix == null) {
                    String string = nsPrefix = mustHavePrefix ? "_" : "";
                }
                if (this.prefixesToURIs.containsKey((Object)nsPrefix) && ((currentValue = (String)this.prefixesToURIs.get((Object)nsPrefix)) == null ? nsURI != null : !currentValue.equals(nsURI))) {
                    int index = 1;
                    while (this.prefixesToURIs.containsKey((Object)(String.valueOf(nsPrefix) + "_" + index))) {
                        ++index;
                    }
                    nsPrefix = String.valueOf(nsPrefix) + "_" + index;
                }
                this.prefixesToURIs.put((Object)nsPrefix, (Object)nsURI);
            }
            if (!this.packages.containsKey(ePackage)) {
                this.packages.put(ePackage, nsPrefix);
            }
        }
        return nsPrefix;
    }

    public List getPrefixes(EPackage ePackage) {
        UniqueEList result = new UniqueEList();
        result.add(this.getPrefix(ePackage));
        String namespace = this.extendedMetaData == null ? ePackage.getNsURI() : this.extendedMetaData.getNamespace(ePackage);
        Iterator i = this.prefixesToURIs.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            if (!(namespace == null ? entry.getValue() == null : namespace.equals(entry.getValue()))) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    protected String getQName(String uri, String name) {
        EPackage ePackage;
        if (uri == null) {
            EPackage theNoNamespacePackage = this.getNoNamespacePackage();
            if (theNoNamespacePackage != null) {
                this.packages.put(theNoNamespacePackage, "");
            }
            return name;
        }
        EPackage ePackage2 = ePackage = this.extendedMetaData == null ? EPackage.Registry.INSTANCE.getEPackage(uri) : this.extendedMetaData.getPackage(uri);
        if (ePackage == null) {
            if (this.extendedMetaData != null) {
                return this.getQName(this.extendedMetaData.demandPackage(uri), name);
            }
            return name;
        }
        return this.getQName(ePackage, name);
    }

    public String getName(ENamedElement obj) {
        String result;
        XMLResource.XMLInfo info;
        if (this.extendedMetaData != null) {
            return obj instanceof EStructuralFeature ? this.extendedMetaData.getName((EStructuralFeature)obj) : this.extendedMetaData.getName((EClassifier)obj);
        }
        if (this.xmlMap != null && (info = this.xmlMap.getInfo(obj)) != null && (result = info.getName()) != null) {
            return result;
        }
        return obj.getName();
    }

    public String getID(EObject obj) {
        return this.resource == null ? null : this.resource.getID(obj);
    }

    public String getIDREF(EObject obj) {
        return this.resource == null ? null : this.resource.getURIFragment(obj);
    }

    protected URI handleDanglingHREF(EObject object) {
        if (!"DISCARD".equals(this.processDanglingHREF)) {
            DanglingHREFException exception = new DanglingHREFException("The object '" + object + "' is not contained in a resource.", this.resource.getURI().toString(), 0, 0);
            if (this.danglingHREFException == null) {
                this.danglingHREFException = exception;
            }
            this.resource.getErrors().add((Object)exception);
        }
        return null;
    }

    public String getHREF(EObject obj) {
        InternalEObject o = (InternalEObject)obj;
        URI objectURI = o.eProxyURI();
        if (objectURI == null) {
            Resource otherResource = obj.eResource();
            if (otherResource == null) {
                objectURI = this.handleDanglingHREF(obj);
                if (objectURI == null) {
                    return null;
                }
            } else {
                objectURI = this.getHREF(otherResource, obj);
            }
        }
        objectURI = this.deresolve(objectURI);
        return objectURI.toString();
    }

    protected URI getHREF(Resource otherResource, EObject obj) {
        return otherResource.getURI().appendFragment(otherResource.getURIFragment(obj));
    }

    public URI deresolve(URI uri) {
        URI deresolvedURI;
        if (this.deresolve && !uri.isRelative() && (deresolvedURI = uri.deresolve(this.resourceURI, true, true, false)).hasRelativePath()) {
            uri = deresolvedURI;
        }
        return uri;
    }

    public int getFeatureKind(EStructuralFeature feature) {
        Integer kind = (Integer)this.featuresToKinds.get(feature);
        if (kind != null) {
            return kind;
        }
        this.computeFeatureKind(feature);
        kind = (Integer)this.featuresToKinds.get(feature);
        if (kind != null) {
            return kind;
        }
        return 5;
    }

    public EObject createObject(EFactory eFactory, String classXMIName) {
        EPackage ePackage = eFactory.getEPackage();
        if (this.extendedMetaData != null) {
            EClassifier eClassifier = this.extendedMetaData.getType(ePackage, classXMIName);
            if (eClassifier == null) {
                return null;
            }
            if (eClassifier instanceof EClass) {
                return eFactory.create((EClass)eClassifier);
            }
            SimpleAnyType result = (SimpleAnyType)EcoreUtil.create((EClass)this.anySimpleType);
            result.setInstanceType((EDataType)eClassifier);
            return result;
        }
        EClass eClass = (EClass)ePackage.getEClassifier(classXMIName);
        if (eClass == null && this.xmlMap != null) {
            eClass = (EClass)this.xmlMap.getClassifier(ePackage.getNsURI(), classXMIName);
        }
        if (eClass != null) {
            return eFactory.create(eClass);
        }
        return null;
    }

    public EStructuralFeature getFeature(EClass eClass, String namespaceURI, String name) {
        EStructuralFeature feature = this.getFeatureWithoutMap(eClass, name);
        if (feature == null && this.xmlMap != null && (feature = this.xmlMap.getFeature(eClass, namespaceURI, name)) != null) {
            this.computeFeatureKind(feature);
        }
        return feature;
    }

    public EStructuralFeature getFeature(EClass eClass, String namespaceURI, String name, boolean isElement) {
        if (this.extendedMetaData != null) {
            EStructuralFeature eStructuralFeature;
            EStructuralFeature eStructuralFeature2 = isElement ? this.extendedMetaData.getElement(eClass, namespaceURI, name) : (eStructuralFeature = this.extendedMetaData.getAttribute(eClass, namespaceURI == "" ? null : namespaceURI, name));
            if (eStructuralFeature != null) {
                this.computeFeatureKind(eStructuralFeature);
            } else {
                eStructuralFeature = this.getFeature(eClass, namespaceURI, name);
                if (eStructuralFeature != null && this.extendedMetaData.getFeatureKind(eStructuralFeature) != 0) {
                    eStructuralFeature = null;
                }
            }
            return eStructuralFeature;
        }
        return this.getFeature(eClass, namespaceURI, name);
    }

    protected EStructuralFeature getFeatureWithoutMap(EClass eClass, String name) {
        EStructuralFeature feature = eClass.getEStructuralFeature(name);
        if (feature != null) {
            this.computeFeatureKind(feature);
        }
        return feature;
    }

    protected void computeFeatureKind(EStructuralFeature feature) {
        EClassifier eClassifier = feature.getEType();
        if (eClassifier instanceof EDataType) {
            if (feature.isMany()) {
                this.featuresToKinds.put(feature, INTEGER_DATATYPE_IS_MANY);
            } else {
                this.featuresToKinds.put(feature, INTEGER_DATATYPE_SINGLE);
            }
        } else if (feature.isMany()) {
            EReference reference = (EReference)feature;
            EReference opposite = reference.getEOpposite();
            if (opposite == null || opposite.isTransient() || !opposite.isMany()) {
                this.featuresToKinds.put(feature, INTEGER_IS_MANY_ADD);
            } else {
                this.featuresToKinds.put(feature, INTEGER_IS_MANY_MOVE);
            }
        }
    }

    public String getJavaEncoding(String xmlEncoding) {
        return xmlEncoding;
    }

    public String getXMLEncoding(String javaEncoding) {
        return javaEncoding;
    }

    public EPackage[] packages() {
        TreeMap<String, EPackage> map = new TreeMap<String, EPackage>();
        Iterator i = this.packages.entrySet().iterator();
        while (i.hasNext()) {
            EPackage conflict;
            Map.Entry entry = i.next();
            EPackage ePackage = (EPackage)entry.getKey();
            String prefix = this.getPrefix(ePackage);
            if (prefix == null) {
                prefix = "";
            }
            if ((conflict = map.put(prefix, ePackage)) == null || conflict.eResource() == null) continue;
            map.put(prefix, conflict);
        }
        EPackage[] result = new EPackage[map.size()];
        map.values().toArray(result);
        return result;
    }

    public void setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        EStructuralFeature targetFeature;
        if (this.extendedMetaData != null && (targetFeature = this.extendedMetaData.getAffiliation(object.eClass(), feature)) != null && targetFeature != feature) {
            EStructuralFeature group = this.extendedMetaData.getGroup(targetFeature);
            if (group != null) {
                targetFeature = group;
            }
            if (targetFeature.getEType() == EcorePackage.eINSTANCE.getEFeatureMapEntry()) {
                FeatureMap featureMap = (FeatureMap)object.eGet(targetFeature);
                EClassifier eClassifier = feature.getEType();
                if (eClassifier instanceof EDataType) {
                    EDataType eDataType = (EDataType)eClassifier;
                    EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                    value = this.createFromString(eFactory, eDataType, (String)value);
                }
                featureMap.add(feature, value);
                return;
            }
            feature = targetFeature;
        }
        int kind = this.getFeatureKind(feature);
        switch (kind) {
            case 1: 
            case 2: {
                EClassifier eClassifier = feature.getEType();
                EDataType eDataType = (EDataType)eClassifier;
                EFactory eFactory = eDataType.getEPackage().getEFactoryInstance();
                if (kind == 2) {
                    InternalEList list = (InternalEList)object.eGet(feature);
                    if (position == -2) {
                        StringTokenizer stringTokenizer = new StringTokenizer((String)value, " ");
                        while (stringTokenizer.hasMoreTokens()) {
                            String token = stringTokenizer.nextToken();
                            list.addUnique(this.createFromString(eFactory, eDataType, token));
                        }
                        if (!list.isEmpty()) break;
                        list.clear();
                        break;
                    }
                    if (value == null) {
                        list.addUnique(null);
                        break;
                    }
                    list.addUnique(this.createFromString(eFactory, eDataType, (String)value));
                    break;
                }
                if (value == null) {
                    object.eSet(feature, null);
                    break;
                }
                object.eSet(feature, this.createFromString(eFactory, eDataType, (String)value));
                break;
            }
            case 3: 
            case 4: {
                InternalEList list = (InternalEList)object.eGet(feature);
                if (position == -1) {
                    list.addUnique(value);
                    break;
                }
                if (position == -2) {
                    list.clear();
                    break;
                }
                if (kind == 3) {
                    list.addUnique(position, value);
                    break;
                }
                list.move(position, value);
                break;
            }
            default: {
                object.eSet(feature, value);
            }
        }
    }

    public List setManyReference(XMLHelper.ManyReference reference, String location) {
        EStructuralFeature feature = reference.getFeature();
        int kind = this.getFeatureKind(feature);
        InternalEList list = (InternalEList)reference.getObject().eGet(feature);
        BasicEList xmiExceptions = new BasicEList();
        Object[] values = reference.getValues();
        int[] positions = reference.getPositions();
        if (kind == 3) {
            int i = 0;
            int l = values.length;
            while (i < l) {
                if (values[i] != null) {
                    try {
                        list.addUnique(positions[i], values[i]);
                    }
                    catch (RuntimeException e) {
                        xmiExceptions.add(new IllegalValueException(reference.getObject(), feature, values[i], e, location, reference.getLineNumber(), reference.getColumnNumber()));
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            int l = values.length;
            while (i < l) {
                if (values[i] != null) {
                    try {
                        list.move(positions[i], values[i]);
                    }
                    catch (RuntimeException e) {
                        xmiExceptions.add(new IllegalValueException(reference.getObject(), feature, values[i], e, location, reference.getLineNumber(), reference.getColumnNumber()));
                    }
                }
                ++i;
            }
        }
        if (xmiExceptions.isEmpty()) {
            return null;
        }
        return xmiExceptions;
    }

    public void setProcessDanglingHREF(String value) {
        this.processDanglingHREF = value;
    }

    public DanglingHREFException getDanglingHREFException() {
        return this.danglingHREFException;
    }

    public URI resolve(URI relative, URI base) {
        return relative.resolve(base);
    }

    public void pushContext() {
        this.namespaceSupport.pushContext();
    }

    public void popContext() {
        this.namespaceSupport.popContext();
    }

    public void addPrefix(String prefix, String uri) {
        if (!"xml".equals(prefix) && !"xmlns".equals(prefix)) {
            uri = uri.length() == 0 ? null : uri;
            this.namespaceSupport.declarePrefix(prefix, uri);
            Object originalURI = null;
            if (prefix.length() == 0 && this.seenEmptyStringMapping) {
                originalURI = uri;
            } else {
                originalURI = this.prefixesToURIs.put((Object)prefix, (Object)uri);
                if (originalURI != null) {
                    this.prefixesToURIs.put((Object)prefix, originalURI);
                    originalURI = uri;
                }
            }
            this.addNSDeclaration(prefix, (String)originalURI);
        }
    }

    public String getURI(String prefix) {
        return "xml".equals(prefix) ? "http://www.w3.org/XML/1998/namespace" : ("xmlns".equals(prefix) ? "http://www.w3.org/2000/xmlns/" : this.namespaceSupport.getURI(prefix));
    }

    public EMap getPrefixToNamespaceMap() {
        return this.prefixesToURIs;
    }

    public void setPrefixToNamespaceMap(EMap prefixToNamespaceMap) {
        Iterator i = prefixToNamespaceMap.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            String prefix = (String)entry.getKey();
            String namespace = (String)entry.getValue();
            EPackage ePackage = null;
            if (this.extendedMetaData == null) {
                ePackage = this.packageRegistry.getEPackage(namespace);
            } else {
                ePackage = this.extendedMetaData.getPackage(namespace);
                if (ePackage == null && !"http://www.w3.org/2001/XMLSchema-instance".equals(namespace)) {
                    ePackage = "http://www.w3.org/2001/XMLSchema".equals(namespace) ? this.xmlSchemaTypePackage : this.extendedMetaData.demandPackage(namespace);
                }
            }
            if (ePackage != null && !this.packages.containsKey(ePackage)) {
                this.packages.put(ePackage, prefix);
            }
            this.prefixesToURIs.put((Object)prefix, (Object)namespace);
        }
    }

    public void setAnySimpleType(EClass type) {
        this.anySimpleType = type;
    }

    public String convertToString(EFactory factory, EDataType dataType, Object value) {
        if (this.extendedMetaData != null) {
            if (value instanceof List) {
                List list = (List)value;
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    this.updateQNamePrefix(factory, dataType, i.next(), true);
                }
                return factory.convertToString(dataType, value);
            }
            return this.updateQNamePrefix(factory, dataType, value, false);
        }
        return factory.convertToString(dataType, value);
    }

    protected Object createFromString(EFactory eFactory, EDataType eDataType, String value) {
        Object obj = eFactory.createFromString(eDataType, value);
        if (this.extendedMetaData != null) {
            if (obj instanceof List) {
                List list = (List)obj;
                int i = 0;
                while (i < list.size()) {
                    this.updateQNameURI(list.get(i));
                    ++i;
                }
            } else {
                this.updateQNameURI(obj);
            }
        }
        return obj;
    }

    protected void updateQNameURI(Object value) {
        if (value instanceof QName) {
            QName qname = (QName)value;
            String namespace = this.getURI(qname.getPrefix());
            qname.setNamespaceURI(namespace);
            if (qname.getPrefix().length() > 0 && qname.getNamespaceURI().length() == 0) {
                throw new IllegalArgumentException("The prefix '" + qname.getPrefix() + "' is not declared for the QName '" + qname.toString() + "'");
            }
            if (namespace == null) {
                this.seenEmptyStringMapping = true;
                String uri = (String)this.prefixesToURIs.get((Object)"");
                if (uri != null) {
                    this.prefixesToURIs.put((Object)"", (Object)namespace);
                    this.addNSDeclaration("", uri);
                }
            }
        }
    }

    protected String updateQNamePrefix(EFactory factory, EDataType dataType, Object value, boolean list) {
        if (value instanceof QName) {
            QName qname = (QName)value;
            String namespace = qname.getNamespaceURI();
            if (namespace.length() == 0) {
                qname.setPrefix("");
                return qname.getLocalPart();
            }
            EPackage ePackage = this.extendedMetaData.getPackage(namespace);
            if (ePackage == null) {
                ePackage = this.extendedMetaData.demandPackage(namespace);
            }
            String prefix = this.getPrefix(ePackage, true);
            if (!this.packages.containsKey(ePackage)) {
                this.packages.put(ePackage, prefix);
            }
            qname.setPrefix(prefix);
            return !list ? qname.toString() : null;
        }
        return !list ? factory.convertToString(dataType, value) : null;
    }

    protected void addNSDeclaration(String prefix, String uri) {
        if (uri != null) {
            int index = 1;
            while (this.prefixesToURIs.containsKey((Object)(String.valueOf(prefix) + "_" + index))) {
                ++index;
            }
            this.prefixesToURIs.put((Object)(String.valueOf(prefix) + "_" + index), (Object)uri);
        }
    }

    protected static class NamespaceSupport {
        protected String[] namespace = new String[32];
        protected int namespaceSize = 0;
        protected int[] context = new int[8];
        protected int currentContext = -1;
        protected String[] prefixes = new String[16];

        protected NamespaceSupport() {
        }

        public void pushContext() {
            if (this.currentContext + 1 == this.context.length) {
                int[] contextarray = new int[this.context.length * 2];
                System.arraycopy(this.context, 0, contextarray, 0, this.context.length);
                this.context = contextarray;
            }
            this.context[++this.currentContext] = this.namespaceSize;
        }

        public void popContext() {
            this.namespaceSize = this.context[this.currentContext--];
        }

        public boolean declarePrefix(String prefix, String uri) {
            int i = this.namespaceSize;
            while (i > this.context[this.currentContext]) {
                if (this.namespace[i - 2].equals(prefix)) {
                    this.namespace[i - 1] = uri;
                    return true;
                }
                i -= 2;
            }
            if (this.namespaceSize == this.namespace.length) {
                String[] namespacearray = new String[this.namespaceSize * 2];
                System.arraycopy(this.namespace, 0, namespacearray, 0, this.namespaceSize);
                this.namespace = namespacearray;
            }
            this.namespace[this.namespaceSize++] = prefix;
            this.namespace[this.namespaceSize++] = uri;
            return false;
        }

        public String getURI(String prefix) {
            int i = this.namespaceSize;
            while (i > 0) {
                if (this.namespace[i - 2].equals(prefix)) {
                    return this.namespace[i - 1];
                }
                i -= 2;
            }
            return null;
        }
    }
}

