/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: SDOPackageImpl.java,v 1.7 2004/06/19 18:34:21 emerks Exp $
 */
package org.eclipse.emf.ecore.sdo.impl;


import java.io.ObjectStreamException;
import java.util.List;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.change.ChangePackage;
import org.eclipse.emf.ecore.change.impl.ChangePackageImpl;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.emf.ecore.sdo.EChangeSummary;
import org.eclipse.emf.ecore.sdo.EChangeSummarySetting;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.sdo.EDataObjectAnyType;
import org.eclipse.emf.ecore.sdo.EDataObjectSimpleAnyType;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.sdo.EType;
import org.eclipse.emf.ecore.sdo.InternalEDataObject;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.sdo.util.ESequence;

import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

import org.eclipse.emf.ecore.xml.type.impl.XMLTypePackageImpl;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class SDOPackageImpl extends EPackageImpl implements SDOPackage
{
  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eDataObjectEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eDataGraphEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eChangeSummaryEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass ePropertyEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass dataObjectEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eSequenceEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass dataGraphEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass changeSummaryEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eTypeEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass typeEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass propertyEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass sequenceEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eChangeSummarySettingEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass internalEDataObjectEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eDataObjectAnyTypeEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eDataObjectSimpleAnyTypeEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass changeSummarySettingEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EDataType eJavaListEDataType = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EDataType eObjectStreamExceptionEDataType = null;

  /**
   * Creates an instance of the model <b>Package</b>, registered with
   * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
   * package URI value.
   * <p>Note: the correct way to create the package is via the static
   * factory method {@link #init init()}, which also performs
   * initialization of the package, or returns the registered package,
   * if one already exists.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.ecore.EPackage.Registry
   * @see org.eclipse.emf.ecore.sdo.SDOPackage#eNS_URI
   * @see #init()
   * @generated
   */
  private SDOPackageImpl()
  {
    super(eNS_URI, SDOFactory.eINSTANCE);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private static boolean isInited = false;

  /**
   * Creates, registers, and initializes the <b>Package</b> for this
   * model, and for any others upon which it depends.  Simple
   * dependencies are satisfied by calling this method on all
   * dependent packages before doing anything else.  This method drives
   * initialization for interdependent packages directly, in parallel
   * with this package, itself.
   * <p>Of this package and its interdependencies, all packages which
   * have not yet been registered by their URI values are first created
   * and registered.  The packages are then initialized in two steps:
   * meta-model objects for all of the packages are created before any
   * are initialized, since one package's meta-model objects may refer to
   * those of another.
   * <p>Invocation of this method will not affect any packages that have
   * already been initialized.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #eNS_URI
   * @see #createPackageContents()
   * @see #initializePackageContents()
   * @generated
   */
  public static SDOPackage init()
  {
    if (isInited) return (SDOPackage)EPackage.Registry.INSTANCE.get(SDOPackage.eNS_URI);

    // Obtain or create and register package
    SDOPackageImpl theSDOPackage = (SDOPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof SDOPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new SDOPackageImpl());

    isInited = true;

    // Initialize simple dependencies
    EcorePackageImpl.init();
    ChangePackageImpl.init();
    XMLTypePackageImpl.init();

    // Create package meta-data objects
    theSDOPackage.createPackageContents();

    // Initialize created meta-data
    theSDOPackage.initializePackageContents();

    return theSDOPackage;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEDataObject()
  {
    return eDataObjectEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEDataGraph()
  {
    return eDataGraphEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getEDataGraph_ResourceSet()
  {
    return (EAttribute)eDataGraphEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getEDataGraph_RootResource()
  {
    return (EAttribute)eDataGraphEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getEDataGraph_EChangeSummary()
  {
    return (EReference)eDataGraphEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getEDataGraph_ERootObject()
  {
    return (EReference)eDataGraphEClass.getEStructuralFeatures().get(3);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEChangeSummary()
  {
    return eChangeSummaryEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getEChangeSummary_EDataGraph()
  {
    return (EReference)eChangeSummaryEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEProperty()
  {
    return ePropertyEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getEProperty_EStructuralFeature()
  {
    return (EReference)ePropertyEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getDataObject()
  {
    return dataObjectEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getESequence()
  {
    return eSequenceEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getDataGraph()
  {
    return dataGraphEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getDataGraph_RootObject()
  {
    return (EReference)dataGraphEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getDataGraph_ChangeSummary()
  {
    return (EReference)dataGraphEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getChangeSummary()
  {
    return changeSummaryEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getChangeSummary_Logging()
  {
    return (EAttribute)changeSummaryEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getChangeSummary_DataGraph()
  {
    return (EReference)changeSummaryEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getChangeSummary_ChangedDataObjects()
  {
    return (EReference)changeSummaryEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEType()
  {
    return eTypeEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getEType_EClassifier()
  {
    return (EReference)eTypeEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getType()
  {
    return typeEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getType_Name()
  {
    return (EAttribute)typeEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getType_URI()
  {
    return (EAttribute)typeEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getType_InstanceClass()
  {
    return (EAttribute)typeEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getType_Properties()
  {
    return (EReference)typeEClass.getEStructuralFeatures().get(3);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getProperty()
  {
    return propertyEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getProperty_Name()
  {
    return (EAttribute)propertyEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getProperty_Many()
  {
    return (EAttribute)propertyEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getProperty_Containment()
  {
    return (EAttribute)propertyEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getProperty_Default()
  {
    return (EAttribute)propertyEClass.getEStructuralFeatures().get(3);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getProperty_Type()
  {
    return (EReference)propertyEClass.getEStructuralFeatures().get(4);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getProperty_ContainingType()
  {
    return (EReference)propertyEClass.getEStructuralFeatures().get(5);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getSequence()
  {
    return sequenceEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEChangeSummarySetting()
  {
    return eChangeSummarySettingEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getInternalEDataObject()
  {
    return internalEDataObjectEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEDataObjectAnyType()
  {
    return eDataObjectAnyTypeEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEDataObjectSimpleAnyType()
  {
    return eDataObjectSimpleAnyTypeEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getChangeSummarySetting()
  {
    return changeSummarySettingEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getChangeSummarySetting_Property()
  {
    return (EReference)changeSummarySettingEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EDataType getEJavaList()
  {
    return eJavaListEDataType;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EDataType getEObjectStreamException()
  {
    return eObjectStreamExceptionEDataType;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public SDOFactory getSDOFactory()
  {
    return (SDOFactory)getEFactoryInstance();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private boolean isCreated = false;

  /**
   * Creates the meta-model objects for the package.  This method is
   * guarded to have no affect on any invocation but its first.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void createPackageContents()
  {
    if (isCreated) return;
    isCreated = true;

    // Create classes and their features
    eChangeSummaryEClass = createEClass(ECHANGE_SUMMARY);
    createEReference(eChangeSummaryEClass, ECHANGE_SUMMARY__EDATA_GRAPH);

    eChangeSummarySettingEClass = createEClass(ECHANGE_SUMMARY_SETTING);

    eDataGraphEClass = createEClass(EDATA_GRAPH);
    createEAttribute(eDataGraphEClass, EDATA_GRAPH__RESOURCE_SET);
    createEAttribute(eDataGraphEClass, EDATA_GRAPH__ROOT_RESOURCE);
    createEReference(eDataGraphEClass, EDATA_GRAPH__ECHANGE_SUMMARY);
    createEReference(eDataGraphEClass, EDATA_GRAPH__EROOT_OBJECT);

    eDataObjectEClass = createEClass(EDATA_OBJECT);

    ePropertyEClass = createEClass(EPROPERTY);
    createEReference(ePropertyEClass, EPROPERTY__ESTRUCTURAL_FEATURE);

    changeSummaryEClass = createEClass(CHANGE_SUMMARY);
    createEAttribute(changeSummaryEClass, CHANGE_SUMMARY__LOGGING);
    createEReference(changeSummaryEClass, CHANGE_SUMMARY__DATA_GRAPH);
    createEReference(changeSummaryEClass, CHANGE_SUMMARY__CHANGED_DATA_OBJECTS);

    changeSummarySettingEClass = createEClass(CHANGE_SUMMARY_SETTING);
    createEReference(changeSummarySettingEClass, CHANGE_SUMMARY_SETTING__PROPERTY);

    dataGraphEClass = createEClass(DATA_GRAPH);
    createEReference(dataGraphEClass, DATA_GRAPH__ROOT_OBJECT);
    createEReference(dataGraphEClass, DATA_GRAPH__CHANGE_SUMMARY);

    dataObjectEClass = createEClass(DATA_OBJECT);

    eSequenceEClass = createEClass(ESEQUENCE);

    eTypeEClass = createEClass(ETYPE);
    createEReference(eTypeEClass, ETYPE__ECLASSIFIER);

    propertyEClass = createEClass(PROPERTY);
    createEAttribute(propertyEClass, PROPERTY__NAME);
    createEAttribute(propertyEClass, PROPERTY__MANY);
    createEAttribute(propertyEClass, PROPERTY__CONTAINMENT);
    createEAttribute(propertyEClass, PROPERTY__DEFAULT);
    createEReference(propertyEClass, PROPERTY__TYPE);
    createEReference(propertyEClass, PROPERTY__CONTAINING_TYPE);

    sequenceEClass = createEClass(SEQUENCE);

    typeEClass = createEClass(TYPE);
    createEAttribute(typeEClass, TYPE__NAME);
    createEAttribute(typeEClass, TYPE__URI);
    createEAttribute(typeEClass, TYPE__INSTANCE_CLASS);
    createEReference(typeEClass, TYPE__PROPERTIES);

    internalEDataObjectEClass = createEClass(INTERNAL_EDATA_OBJECT);

    eDataObjectAnyTypeEClass = createEClass(EDATA_OBJECT_ANY_TYPE);

    eDataObjectSimpleAnyTypeEClass = createEClass(EDATA_OBJECT_SIMPLE_ANY_TYPE);

    // Create data types
    eJavaListEDataType = createEDataType(EJAVA_LIST);
    eObjectStreamExceptionEDataType = createEDataType(EOBJECT_STREAM_EXCEPTION);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private boolean isInitialized = false;

  /**
   * Complete the initialization of the package and its meta-model.  This
   * method is guarded to have no affect on any invocation but its first.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void initializePackageContents()
  {
    if (isInitialized) return;
    isInitialized = true;

    // Initialize package
    setName(eNAME);
    setNsPrefix(eNS_PREFIX);
    setNsURI(eNS_URI);

    // Obtain other dependent packages
    ChangePackageImpl theChangePackage = (ChangePackageImpl)EPackage.Registry.INSTANCE.getEPackage(ChangePackage.eNS_URI);
    EcorePackageImpl theEcorePackage = (EcorePackageImpl)EPackage.Registry.INSTANCE.getEPackage(EcorePackage.eNS_URI);
    XMLTypePackageImpl theXMLTypePackage = (XMLTypePackageImpl)EPackage.Registry.INSTANCE.getEPackage(XMLTypePackage.eNS_URI);

    // Add supertypes to classes
    eChangeSummaryEClass.getESuperTypes().add(theChangePackage.getChangeDescription());
    eChangeSummaryEClass.getESuperTypes().add(this.getChangeSummary());
    eChangeSummarySettingEClass.getESuperTypes().add(theChangePackage.getFeatureChange());
    eChangeSummarySettingEClass.getESuperTypes().add(this.getChangeSummarySetting());
    eDataGraphEClass.getESuperTypes().add(this.getDataGraph());
    eDataObjectEClass.getESuperTypes().add(theEcorePackage.getEObject());
    eDataObjectEClass.getESuperTypes().add(this.getDataObject());
    ePropertyEClass.getESuperTypes().add(this.getProperty());
    eSequenceEClass.getESuperTypes().add(this.getSequence());
    eTypeEClass.getESuperTypes().add(this.getType());
    internalEDataObjectEClass.getESuperTypes().add(this.getEDataObject());
    eDataObjectAnyTypeEClass.getESuperTypes().add(theXMLTypePackage.getAnyType());
    eDataObjectAnyTypeEClass.getESuperTypes().add(this.getEDataObject());
    eDataObjectSimpleAnyTypeEClass.getESuperTypes().add(theXMLTypePackage.getSimpleAnyType());
    eDataObjectSimpleAnyTypeEClass.getESuperTypes().add(this.getEDataObjectAnyType());

    // Initialize classes and features; add operations and parameters
    initEClass(eChangeSummaryEClass, EChangeSummary.class, "EChangeSummary", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getEChangeSummary_EDataGraph(), this.getEDataGraph(), this.getEDataGraph_EChangeSummary(), "eDataGraph", null, 1, 1, EChangeSummary.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(eChangeSummarySettingEClass, EChangeSummarySetting.class, "EChangeSummarySetting", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

    initEClass(eDataGraphEClass, EDataGraph.class, "EDataGraph", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getEDataGraph_ResourceSet(), theEcorePackage.getEResourceSet(), "resourceSet", null, 0, 1, EDataGraph.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getEDataGraph_RootResource(), theEcorePackage.getEResource(), "rootResource", null, 0, 1, EDataGraph.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getEDataGraph_EChangeSummary(), this.getEChangeSummary(), this.getEChangeSummary_EDataGraph(), "eChangeSummary", null, 1, 1, EDataGraph.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getEDataGraph_ERootObject(), theEcorePackage.getEObject(), null, "eRootObject", null, 1, 1, EDataGraph.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    EOperation op = addEOperation(eDataGraphEClass, theEcorePackage.getEClassifier(), "getEClassifier");
    addEParameter(op, ecorePackage.getEString(), "namespaceURI");
    addEParameter(op, ecorePackage.getEString(), "typeName");

    op = addEOperation(eDataGraphEClass, theEcorePackage.getEObject(), "createEObject");
    addEParameter(op, theEcorePackage.getEClass(), "type");

    initEClass(eDataObjectEClass, EDataObject.class, "EDataObject", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

    addEOperation(eDataObjectEClass, this.getEJavaList(), "getInstanceProperties");

    initEClass(ePropertyEClass, EProperty.class, "EProperty", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getEProperty_EStructuralFeature(), theEcorePackage.getEStructuralFeature(), null, "eStructuralFeature", null, 1, 1, EProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(changeSummaryEClass, ChangeSummary.class, "ChangeSummary", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getChangeSummary_Logging(), ecorePackage.getEBoolean(), "logging", null, 0, 1, ChangeSummary.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getChangeSummary_DataGraph(), this.getDataGraph(), this.getDataGraph_ChangeSummary(), "dataGraph", null, 1, 1, ChangeSummary.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getChangeSummary_ChangedDataObjects(), this.getDataObject(), null, "changedDataObjects", null, 0, -1, ChangeSummary.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    addEOperation(changeSummaryEClass, null, "beginLogging");

    addEOperation(changeSummaryEClass, null, "endLogging");

    op = addEOperation(changeSummaryEClass, ecorePackage.getEBoolean(), "isCreated");
    addEParameter(op, this.getDataObject(), "dataObject");

    op = addEOperation(changeSummaryEClass, ecorePackage.getEBoolean(), "isDeleted");
    addEParameter(op, this.getDataObject(), "dataObject");

    op = addEOperation(changeSummaryEClass, this.getEJavaList(), "getOldValues");
    addEParameter(op, this.getDataObject(), "dataObject");

    initEClass(changeSummarySettingEClass, ChangeSummary.Setting.class, "ChangeSummarySetting", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);
    initEReference(getChangeSummarySetting_Property(), this.getProperty(), null, "property", null, 1, 1, ChangeSummary.Setting.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    addEOperation(changeSummarySettingEClass, ecorePackage.getEBoolean(), "isSet");

    addEOperation(changeSummarySettingEClass, theEcorePackage.getEJavaObject(), "getValue");

    initEClass(dataGraphEClass, DataGraph.class, "DataGraph", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);
    initEReference(getDataGraph_RootObject(), this.getDataObject(), null, "rootObject", null, 1, 1, DataGraph.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getDataGraph_ChangeSummary(), this.getChangeSummary(), this.getChangeSummary_DataGraph(), "changeSummary", null, 1, 1, DataGraph.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    op = addEOperation(dataGraphEClass, this.getDataObject(), "createRootObject");
    addEParameter(op, ecorePackage.getEString(), "namespaceURI");
    addEParameter(op, ecorePackage.getEString(), "typeName");

    op = addEOperation(dataGraphEClass, this.getDataObject(), "createRootObject");
    addEParameter(op, this.getType(), "type");

    op = addEOperation(dataGraphEClass, this.getType(), "getType");
    addEParameter(op, ecorePackage.getEString(), "namespaceURI");
    addEParameter(op, ecorePackage.getEString(), "typeName");

    initEClass(dataObjectEClass, DataObject.class, "DataObject", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEJavaObject(), "get");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, null, "set");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, theEcorePackage.getEJavaObject(), "value");

    op = addEOperation(dataObjectEClass, ecorePackage.getEBoolean(), "isSet");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, null, "unset");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, theEcorePackage.getEJavaObject(), "get");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, null, "set");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, theEcorePackage.getEJavaObject(), "value");

    op = addEOperation(dataObjectEClass, ecorePackage.getEBoolean(), "isSet");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, null, "unset");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, theEcorePackage.getEJavaObject(), "get");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, null, "set");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, theEcorePackage.getEJavaObject(), "value");

    op = addEOperation(dataObjectEClass, ecorePackage.getEBoolean(), "isSet");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, null, "unset");
    addEParameter(op, this.getProperty(), "property");

    addEOperation(dataObjectEClass, this.getDataObject(), "getContainer");

    addEOperation(dataObjectEClass, this.getProperty(), "getContainmentProperty");

    addEOperation(dataObjectEClass, this.getDataGraph(), "getDataGraph");

    addEOperation(dataObjectEClass, this.getType(), "getType");

    op = addEOperation(dataObjectEClass, theEcorePackage.getEBigDecimal(), "getBigDecimal");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, theEcorePackage.getEBigInteger(), "getBigInteger");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, ecorePackage.getEBoolean(), "getBoolean");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, ecorePackage.getEByte(), "getByte");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, theEcorePackage.getEByteArray(), "getBytes");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, ecorePackage.getEChar(), "getChar");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, this.getDataObject(), "getDataObject");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, theEcorePackage.getEDate(), "getDate");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, ecorePackage.getEDouble(), "getDouble");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, ecorePackage.getEFloat(), "getFloat");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, ecorePackage.getEInt(), "getInt");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, this.getEJavaList(), "getList");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, ecorePackage.getELong(), "getLong");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, this.getSequence(), "getSequence");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, ecorePackage.getEShort(), "getShort");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, ecorePackage.getEString(), "getString");
    addEParameter(op, ecorePackage.getEString(), "path");

    op = addEOperation(dataObjectEClass, null, "setBigDecimal");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, theEcorePackage.getEBigDecimal(), "value");

    op = addEOperation(dataObjectEClass, null, "setBigInteger");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, theEcorePackage.getEBigInteger(), "value");

    op = addEOperation(dataObjectEClass, null, "setBoolean");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, ecorePackage.getEBoolean(), "value");

    op = addEOperation(dataObjectEClass, null, "setByte");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, ecorePackage.getEByte(), "value");

    op = addEOperation(dataObjectEClass, null, "setBytes");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, theEcorePackage.getEByteArray(), "value");

    op = addEOperation(dataObjectEClass, null, "setChar");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, ecorePackage.getEChar(), "value");

    op = addEOperation(dataObjectEClass, null, "setDataObject");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, this.getDataObject(), "value");

    op = addEOperation(dataObjectEClass, null, "setDate");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, theEcorePackage.getEDate(), "value");

    op = addEOperation(dataObjectEClass, null, "setDouble");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, ecorePackage.getEDouble(), "value");

    op = addEOperation(dataObjectEClass, null, "setFloat");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, ecorePackage.getEFloat(), "value");

    op = addEOperation(dataObjectEClass, null, "setInt");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, ecorePackage.getEInt(), "value");

    op = addEOperation(dataObjectEClass, null, "setList");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, this.getEJavaList(), "value");

    op = addEOperation(dataObjectEClass, null, "setLong");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, ecorePackage.getELong(), "value");

    op = addEOperation(dataObjectEClass, null, "setShort");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, ecorePackage.getEShort(), "value");

    op = addEOperation(dataObjectEClass, null, "setString");
    addEParameter(op, ecorePackage.getEString(), "path");
    addEParameter(op, ecorePackage.getEString(), "value");

    op = addEOperation(dataObjectEClass, theEcorePackage.getEBigDecimal(), "getBigDecimal");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, theEcorePackage.getEBigInteger(), "getBigInteger");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, ecorePackage.getEBoolean(), "getBoolean");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, ecorePackage.getEByte(), "getByte");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, theEcorePackage.getEByteArray(), "getBytes");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, ecorePackage.getEChar(), "getChar");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, this.getDataObject(), "getDataObject");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, theEcorePackage.getEDate(), "getDate");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, ecorePackage.getEDouble(), "getDouble");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, ecorePackage.getEFloat(), "getFloat");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, ecorePackage.getEInt(), "getInt");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, this.getEJavaList(), "getList");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, ecorePackage.getELong(), "getLong");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, this.getSequence(), "getSequence");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, ecorePackage.getEShort(), "getShort");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, ecorePackage.getEString(), "getString");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, null, "setBigDecimal");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, theEcorePackage.getEBigDecimal(), "value");

    op = addEOperation(dataObjectEClass, null, "setBigInteger");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, theEcorePackage.getEBigInteger(), "value");

    op = addEOperation(dataObjectEClass, null, "setBoolean");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, ecorePackage.getEBoolean(), "value");

    op = addEOperation(dataObjectEClass, null, "setByte");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, ecorePackage.getEByte(), "value");

    op = addEOperation(dataObjectEClass, null, "setBytes");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, theEcorePackage.getEByteArray(), "value");

    op = addEOperation(dataObjectEClass, null, "setChar");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, ecorePackage.getEChar(), "value");

    op = addEOperation(dataObjectEClass, null, "setDataObject");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, this.getDataObject(), "value");

    op = addEOperation(dataObjectEClass, null, "setDate");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, theEcorePackage.getEDate(), "value");

    op = addEOperation(dataObjectEClass, null, "setDouble");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, ecorePackage.getEDouble(), "value");

    op = addEOperation(dataObjectEClass, null, "setFloat");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, ecorePackage.getEFloat(), "value");

    op = addEOperation(dataObjectEClass, null, "setInt");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, ecorePackage.getEInt(), "value");

    op = addEOperation(dataObjectEClass, null, "setList");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, this.getEJavaList(), "value");

    op = addEOperation(dataObjectEClass, null, "setLong");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, ecorePackage.getELong(), "value");

    op = addEOperation(dataObjectEClass, null, "setShort");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, ecorePackage.getEShort(), "value");

    op = addEOperation(dataObjectEClass, null, "setString");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, ecorePackage.getEString(), "value");

    op = addEOperation(dataObjectEClass, theEcorePackage.getEBigDecimal(), "getBigDecimal");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, theEcorePackage.getEBigInteger(), "getBigInteger");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, ecorePackage.getEBoolean(), "getBoolean");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, ecorePackage.getEByte(), "getByte");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, theEcorePackage.getEByteArray(), "getBytes");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, ecorePackage.getEChar(), "getChar");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, this.getDataObject(), "getDataObject");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, theEcorePackage.getEDate(), "getDate");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, ecorePackage.getEDouble(), "getDouble");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, ecorePackage.getEFloat(), "getFloat");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, ecorePackage.getEInt(), "getInt");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, this.getEJavaList(), "getList");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, ecorePackage.getELong(), "getLong");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, this.getSequence(), "getSequence");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, ecorePackage.getEShort(), "getShort");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, ecorePackage.getEString(), "getString");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, null, "setBigDecimal");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, theEcorePackage.getEBigDecimal(), "value");

    op = addEOperation(dataObjectEClass, null, "setBigInteger");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, theEcorePackage.getEBigInteger(), "value");

    op = addEOperation(dataObjectEClass, null, "setBoolean");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, ecorePackage.getEBoolean(), "value");

    op = addEOperation(dataObjectEClass, null, "setByte");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, ecorePackage.getEByte(), "value");

    op = addEOperation(dataObjectEClass, null, "setBytes");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, theEcorePackage.getEByteArray(), "value");

    op = addEOperation(dataObjectEClass, null, "setChar");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, ecorePackage.getEChar(), "value");

    op = addEOperation(dataObjectEClass, null, "setDataObject");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, this.getDataObject(), "value");

    op = addEOperation(dataObjectEClass, null, "setDate");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, theEcorePackage.getEDate(), "value");

    op = addEOperation(dataObjectEClass, null, "setDouble");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, ecorePackage.getEDouble(), "value");

    op = addEOperation(dataObjectEClass, null, "setFloat");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, ecorePackage.getEFloat(), "value");

    op = addEOperation(dataObjectEClass, null, "setInt");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, ecorePackage.getEInt(), "value");

    op = addEOperation(dataObjectEClass, null, "setList");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, this.getEJavaList(), "value");

    op = addEOperation(dataObjectEClass, null, "setLong");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, ecorePackage.getELong(), "value");

    op = addEOperation(dataObjectEClass, null, "setShort");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, ecorePackage.getEShort(), "value");

    op = addEOperation(dataObjectEClass, null, "setString");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, ecorePackage.getEString(), "value");

    op = addEOperation(dataObjectEClass, this.getDataObject(), "createDataObject");
    addEParameter(op, ecorePackage.getEString(), "propertyName");

    op = addEOperation(dataObjectEClass, this.getDataObject(), "createDataObject");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");

    op = addEOperation(dataObjectEClass, this.getDataObject(), "createDataObject");
    addEParameter(op, this.getProperty(), "property");

    op = addEOperation(dataObjectEClass, this.getDataObject(), "createDataObject");
    addEParameter(op, ecorePackage.getEString(), "propertyName");
    addEParameter(op, ecorePackage.getEString(), "namespaceURI");
    addEParameter(op, ecorePackage.getEString(), "typeName");

    op = addEOperation(dataObjectEClass, this.getDataObject(), "createDataObject");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, ecorePackage.getEString(), "namespaceURI");
    addEParameter(op, ecorePackage.getEString(), "typeName");

    op = addEOperation(dataObjectEClass, this.getDataObject(), "createDataObject");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, this.getType(), "type");

    addEOperation(dataObjectEClass, null, "delete");

    initEClass(eSequenceEClass, ESequence.class, "ESequence", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);

    addEOperation(eSequenceEClass, theEcorePackage.getEFeatureMap(), "featureMap");

    initEClass(eTypeEClass, EType.class, "EType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getEType_EClassifier(), theEcorePackage.getEClassifier(), null, "eClassifier", null, 1, 1, EType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    op = addEOperation(eTypeEClass, this.getEProperty(), "getEProperty");
    addEParameter(op, ecorePackage.getEString(), "propertyName");

    initEClass(propertyEClass, Property.class, "Property", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getProperty_Name(), ecorePackage.getEString(), "name", null, 0, 1, Property.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getProperty_Many(), ecorePackage.getEBoolean(), "many", null, 0, 1, Property.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getProperty_Containment(), ecorePackage.getEBoolean(), "containment", null, 0, 1, Property.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getProperty_Default(), theEcorePackage.getEJavaObject(), "default", null, 0, 1, Property.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getProperty_Type(), this.getType(), null, "type", null, 1, 1, Property.class, !IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getProperty_ContainingType(), this.getType(), this.getType_Properties(), "containingType", null, 1, 1, Property.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(sequenceEClass, Sequence.class, "Sequence", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);

    addEOperation(sequenceEClass, ecorePackage.getEInt(), "size");

    op = addEOperation(sequenceEClass, this.getProperty(), "getProperty");
    addEParameter(op, ecorePackage.getEInt(), "index");

    op = addEOperation(sequenceEClass, theEcorePackage.getEJavaObject(), "getValue");
    addEParameter(op, ecorePackage.getEInt(), "index");

    op = addEOperation(sequenceEClass, theEcorePackage.getEJavaObject(), "setValue");
    addEParameter(op, ecorePackage.getEInt(), "index");
    addEParameter(op, theEcorePackage.getEJavaObject(), "value");

    op = addEOperation(sequenceEClass, ecorePackage.getEBoolean(), "add");
    addEParameter(op, ecorePackage.getEString(), "propertyName");
    addEParameter(op, theEcorePackage.getEJavaObject(), "value");

    op = addEOperation(sequenceEClass, ecorePackage.getEBoolean(), "add");
    addEParameter(op, ecorePackage.getEInt(), "propertIndex");
    addEParameter(op, theEcorePackage.getEJavaObject(), "value");

    op = addEOperation(sequenceEClass, ecorePackage.getEBoolean(), "add");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, theEcorePackage.getEJavaObject(), "value");

    op = addEOperation(sequenceEClass, null, "add");
    addEParameter(op, ecorePackage.getEInt(), "index");
    addEParameter(op, ecorePackage.getEString(), "propertyName");
    addEParameter(op, theEcorePackage.getEJavaObject(), "value");

    op = addEOperation(sequenceEClass, null, "add");
    addEParameter(op, ecorePackage.getEInt(), "index");
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex");
    addEParameter(op, theEcorePackage.getEJavaObject(), "value");

    op = addEOperation(sequenceEClass, null, "add");
    addEParameter(op, ecorePackage.getEInt(), "index");
    addEParameter(op, this.getProperty(), "property");
    addEParameter(op, theEcorePackage.getEJavaObject(), "value");

    initEClass(typeEClass, Type.class, "Type", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getType_Name(), ecorePackage.getEString(), "name", null, 0, 1, Type.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getType_URI(), ecorePackage.getEString(), "uRI", null, 0, 1, Type.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getType_InstanceClass(), theEcorePackage.getEJavaClass(), "instanceClass", null, 0, 1, Type.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getType_Properties(), this.getProperty(), this.getProperty_ContainingType(), "properties", null, 0, -1, Type.class, !IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    op = addEOperation(typeEClass, ecorePackage.getEBoolean(), "isInstance");
    addEParameter(op, theEcorePackage.getEJavaObject(), "object");

    op = addEOperation(typeEClass, this.getProperty(), "getProperty");
    addEParameter(op, ecorePackage.getEString(), "propertyName");

    initEClass(internalEDataObjectEClass, InternalEDataObject.class, "InternalEDataObject", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

    op = addEOperation(internalEDataObjectEClass, theEcorePackage.getEJavaObject(), "writeReplace");
    addEException(op, this.getEObjectStreamException());

    initEClass(eDataObjectAnyTypeEClass, EDataObjectAnyType.class, "EDataObjectAnyType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

    initEClass(eDataObjectSimpleAnyTypeEClass, EDataObjectSimpleAnyType.class, "EDataObjectSimpleAnyType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

    // Initialize data types
    initEDataType(eJavaListEDataType, List.class, "EJavaList", !IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
    initEDataType(eObjectStreamExceptionEDataType, ObjectStreamException.class, "EObjectStreamException", !IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);

    // Create resource
    createResource(eNS_URI);

    // Create annotations
    // http://www.eclipse.org/emf/2002/GenModel
    createGenModelAnnotations();
    // http:///org/eclipse/emf/ecore/util/ExtendedMetaData
    createExtendedMetaDataAnnotations();
  }

  /**
   * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void createGenModelAnnotations()
  {
    String source = "http://www.eclipse.org/emf/2002/GenModel";		
    addAnnotation
      ((EOperation)eDataObjectEClass.getEOperations().get(0), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getInstanceProperties(this);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(0), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.get(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(1), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.set(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(2), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.isSet(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(3), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.unset(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(4), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.get(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(5), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.set(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(6), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.isSet(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(7), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.unset(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(8), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.get(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(9), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.set(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(10), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.isSet(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(11), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.unset(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(12), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getContainer(this);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(13), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getContainmentProperty(this);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(14), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getDataGraph(this);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(15), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getType(this);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(16), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getBigDecimal(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(17), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getBigInteger(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(18), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getBoolean(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(19), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getByte(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(20), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getBytes(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(21), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getChar(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(22), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getDataObject(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(23), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getDate(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(24), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getDouble(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(25), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getFloat(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(26), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getInt(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(27), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getList(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(28), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getLong(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(29), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getSequence(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(30), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getShort(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(31), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getString(this, path);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(32), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setBigDecimal(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(33), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setBigInteger(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(34), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setBoolean(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(35), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setByte(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(36), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setBytes(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(37), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setChar(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(38), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setDataObject(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(39), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setDate(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(40), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setDouble(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(41), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setFloat(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(42), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setInt(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(43), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setList(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(44), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setLong(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(45), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setShort(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(46), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setString(this, path, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(47), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getBigDecimal(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(48), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getBigInteger(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(49), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getBoolean(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(50), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getByte(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(51), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getBytes(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(52), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getChar(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(53), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getDataObject(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(54), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getDate(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(55), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getDouble(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(56), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getFloat(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(57), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getInt(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(58), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getList(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(59), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getLong(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(60), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getSequence(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(61), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getShort(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(62), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getString(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(63), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setBigDecimal(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(64), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setBigInteger(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(65), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setBoolean(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(66), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setByte(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(67), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setBytes(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(68), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setChar(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(69), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setDataObject(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(70), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setDate(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(71), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setDouble(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(72), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setFloat(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(73), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setInt(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(74), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setList(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(75), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setLong(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(76), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setShort(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(77), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setString(this, propertyIndex, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(78), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getBigDecimal(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(79), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getBigInteger(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(80), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getBoolean(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(81), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getByte(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(82), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getBytes(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(83), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getChar(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(84), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getDataObject(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(85), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getDate(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(86), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getDouble(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(87), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getFloat(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(88), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getInt(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(89), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getList(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(90), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getLong(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(91), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getSequence(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(92), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getShort(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(93), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.getString(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(94), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setBigDecimal(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(95), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setBigInteger(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(96), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setBoolean(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(97), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setByte(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(98), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setBytes(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(99), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setChar(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(100), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setDataObject(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(101), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setDate(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(102), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setDouble(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(103), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setFloat(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(104), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setInt(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(105), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setList(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(106), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setLong(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(107), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setShort(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(108), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.setString(this, property, value);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(109), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.createDataObject(this, propertyName);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(110), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.createDataObject(this, propertyIndex);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(111), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.createDataObject(this, property);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(112), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.createDataObject(this, propertyName, namespaceURI, typeName);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(113), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.createDataObject(this, propertyIndex, namespaceURI, typeName);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(114), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.createDataObject(this, property, type);"
       });		
    addAnnotation
      ((EOperation)dataObjectEClass.getEOperations().get(115), 
       source, 
       new String[] 
       {
       "body", "<%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.delete(this);"
       });		
    addAnnotation
      ((EOperation)internalEDataObjectEClass.getEOperations().get(0), 
       source, 
       new String[] 
       {
       "body", "return <%org.eclipse.emf.ecore.sdo.util.SDOUtil%>.writeReplace(this);"
       });		
  }

  /**
   * Initializes the annotations for <b>http:///org/eclipse/emf/ecore/util/ExtendedMetaData</b>.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void createExtendedMetaDataAnnotations()
  {
    String source = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";																																																																																																																								
    addAnnotation
      (eDataObjectAnyTypeEClass, 
       source, 
       new String[] 
       {
       "kind", "mixed"
       });		
    addAnnotation
      (eDataObjectSimpleAnyTypeEClass, 
       source, 
       new String[] 
       {
       "kind", "simple"
       });
  }

} //SDOPackageImpl
