/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: SDOSwitch.java,v 1.3 2004/05/16 17:04:36 emerks Exp $
 */
package org.eclipse.emf.ecore.sdo.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.sdo.*;

import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;

import java.util.List;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.emf.ecore.sdo.SDOPackage
 * @generated
 */
public class SDOSwitch {
  /**
   * The cached model package
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected static SDOPackage modelPackage;

  /**
   * Creates an instance of the switch.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public SDOSwitch()
  {
    if (modelPackage == null)
    {
      modelPackage = SDOPackage.eINSTANCE;
    }
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  public Object doSwitch(EObject theEObject)
  {
    return doSwitch(theEObject.eClass(), theEObject);
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  protected Object doSwitch(EClass theEClass, EObject theEObject)
  {
    if (theEClass.eContainer() == modelPackage)
    {
      return doSwitch(theEClass.getClassifierID(), theEObject);
    }
    else
    {
      List eSuperTypes = theEClass.getESuperTypes();
      return
        eSuperTypes.isEmpty() ?
          defaultCase(theEObject) :
          doSwitch((EClass)eSuperTypes.get(0), theEObject);
    }
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  protected Object doSwitch(int classifierID, EObject theEObject)
  {
    switch (classifierID)
    {
      case SDOPackage.ECHANGE_SUMMARY:
      {
        EChangeSummary eChangeSummary = (EChangeSummary)theEObject;
        Object result = caseEChangeSummary(eChangeSummary);
        if (result == null) result = caseChangeDescription(eChangeSummary);
        if (result == null) result = caseChangeSummary(eChangeSummary);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case SDOPackage.ECHANGE_SUMMARY_SETTING:
      {
        EChangeSummarySetting eChangeSummarySetting = (EChangeSummarySetting)theEObject;
        Object result = caseEChangeSummarySetting(eChangeSummarySetting);
        if (result == null) result = caseFeatureChange(eChangeSummarySetting);
        if (result == null) result = caseChangeSummarySetting(eChangeSummarySetting);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case SDOPackage.EDATA_GRAPH:
      {
        EDataGraph eDataGraph = (EDataGraph)theEObject;
        Object result = caseEDataGraph(eDataGraph);
        if (result == null) result = caseDataGraph(eDataGraph);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case SDOPackage.EDATA_OBJECT:
      {
        EDataObject eDataObject = (EDataObject)theEObject;
        Object result = caseEDataObject(eDataObject);
        if (result == null) result = caseDataObject(eDataObject);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case SDOPackage.EPROPERTY:
      {
        EProperty eProperty = (EProperty)theEObject;
        Object result = caseEProperty(eProperty);
        if (result == null) result = caseProperty(eProperty);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case SDOPackage.ETYPE:
      {
        EType eType = (EType)theEObject;
        Object result = caseEType(eType);
        if (result == null) result = caseType(eType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case SDOPackage.EDATA_OBJECT_ANY_TYPE:
      {
        EDataObjectAnyType eDataObjectAnyType = (EDataObjectAnyType)theEObject;
        Object result = caseEDataObjectAnyType(eDataObjectAnyType);
        if (result == null) result = caseAnyType(eDataObjectAnyType);
        if (result == null) result = caseEDataObject(eDataObjectAnyType);
        if (result == null) result = caseDataObject(eDataObjectAnyType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case SDOPackage.EDATA_OBJECT_SIMPLE_ANY_TYPE:
      {
        EDataObjectSimpleAnyType eDataObjectSimpleAnyType = (EDataObjectSimpleAnyType)theEObject;
        Object result = caseEDataObjectSimpleAnyType(eDataObjectSimpleAnyType);
        if (result == null) result = caseSimpleAnyType(eDataObjectSimpleAnyType);
        if (result == null) result = caseEDataObjectAnyType(eDataObjectSimpleAnyType);
        if (result == null) result = caseAnyType(eDataObjectSimpleAnyType);
        if (result == null) result = caseEDataObject(eDataObjectSimpleAnyType);
        if (result == null) result = caseDataObject(eDataObjectSimpleAnyType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      default: return defaultCase(theEObject);
    }
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>EData Object</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>EData Object</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseEDataObject(EDataObject object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>EData Graph</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>EData Graph</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseEDataGraph(EDataGraph object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>EChange Summary</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>EChange Summary</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseEChangeSummary(EChangeSummary object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>EProperty</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>EProperty</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseEProperty(EProperty object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>Data Object</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>Data Object</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseDataObject(DataObject object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>ESequence</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>ESequence</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseESequence(ESequence object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>Data Graph</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>Data Graph</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseDataGraph(DataGraph object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>Change Summary</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>Change Summary</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseChangeSummary(ChangeSummary object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>EType</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>EType</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseEType(EType object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseType(Type object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>Property</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>Property</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseProperty(Property object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>Sequence</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>Sequence</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseSequence(Sequence object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>EChange Summary Setting</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>EChange Summary Setting</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseEChangeSummarySetting(EChangeSummarySetting object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>Internal EData Object</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>Internal EData Object</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseInternalEDataObject(InternalEDataObject object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>EData Object Any Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>EData Object Any Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseEDataObjectAnyType(EDataObjectAnyType object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>EData Object Simple Any Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>EData Object Simple Any Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseEDataObjectSimpleAnyType(EDataObjectSimpleAnyType object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>Description</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>Description</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseChangeDescription(ChangeDescription object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>Feature Change</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>Feature Change</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseFeatureChange(FeatureChange object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>Any Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>Any Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseAnyType(AnyType object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>Simple Any Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>Simple Any Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseSimpleAnyType(SimpleAnyType object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>Change Summary Setting</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>Change Summary Setting</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public Object caseChangeSummarySetting(ChangeSummary.Setting object)
  {
    return null;
  }

  /**
   * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch, but this is the last case anyway.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject)
   * @generated
   */
  public Object defaultCase(EObject object)
  {
    return null;
  }

} //SDOSwitch
