/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.rose2ecore.parser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.emf.codegen.ecore.rose2ecore.parser.RoseLexer;
import org.eclipse.emf.codegen.ecore.rose2ecore.parser.RoseLoader;
import org.eclipse.emf.codegen.ecore.rose2ecore.parser.RoseParser;
import org.eclipse.emf.codegen.ecore.rose2ecore.parser.RoseWriter;

public class RoseTree
implements PropertyChangeListener {
    protected RoseLoader loader;
    protected RoseLexer lexer;
    protected RoseParser parser;
    protected String inFileName;
    protected String outFileName;

    public RoseTree(String[] args) throws Exception {
        if (args.length > 0) {
            this.inFileName = args[0];
        }
        String isTree = "false";
        String noPresentation = "false";
        if (args.length > 1) {
            isTree = args[1];
        }
        if (args.length > 2) {
            noPresentation = args[2];
        }
        if (args.length > 3) {
            this.outFileName = args[3];
        }
        this.loader = new RoseLoader(this.inFileName);
        this.loader.addPropertyChangeListener(this);
        this.loader.setProgressIncrement(5);
        this.loader.setLower(25);
        this.loader.setUpper(50);
        this.lexer = new RoseLexer(this.loader);
        this.parser = isTree.equals("true") ? (noPresentation.equals("true") ? new RoseParser(this.lexer, true, true) : new RoseParser(this.lexer, true, false)) : (noPresentation.equals("true") ? new RoseParser(this.lexer, false, true) : new RoseParser(this.lexer, false, false));
        this.parser.parse();
        System.out.println("parser is done");
    }

    public void writeRose() throws Exception {
        RoseWriter writer = new RoseWriter(this.outFileName, this.parser.getVersionTree(), this.parser.getModelTree());
        writer.addPropertyChangeListener(this);
        writer.setProgressIncrement(20);
        writer.setLower(20);
        writer.setUpper(60);
        writer.write();
    }

    public void traverse() {
        BufferedReader buffReader = new BufferedReader(new InputStreamReader(System.in));
        String str = null;
        ArrayList<Integer> v = new ArrayList<Integer>();
        block2: while (true) {
            try {
                this.parser.traverseTree(v);
                System.out.print("input path >");
                str = buffReader.readLine();
                StringTokenizer st = new StringTokenizer(str);
                v.clear();
                while (true) {
                    if (!st.hasMoreTokens()) continue block2;
                    String tok = st.nextToken();
                    if (tok.equals("q")) {
                        return;
                    }
                    Integer integ = new Integer(tok);
                    v.add(integ);
                }
            }
            catch (Exception exception) {
                System.out.println("RoseTree - Exception while readLine");
                continue;
            }
            break;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("ROSE_WRITE_PROGRESS")) {
            Integer oldValue = (Integer)evt.getOldValue();
            Integer newValue = (Integer)evt.getNewValue();
            System.out.println("saving ... " + oldValue + " " + newValue);
        } else if (evt.getPropertyName().equals("ROSE_LOADER_PROGRESS")) {
            Integer oldValue = (Integer)evt.getOldValue();
            Integer newValue = (Integer)evt.getNewValue();
            System.out.println("loading ... " + oldValue + " " + newValue);
        }
    }
}

