/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AbstractOverrideableCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class SetCommand
extends AbstractOverrideableCommand {
    protected static final String LABEL = EMFEditPlugin.INSTANCE.getString("_UI_SetCommand_label");
    protected static final String DESCRIPTION = EMFEditPlugin.INSTANCE.getString("_UI_SetCommand_description");
    protected EObject owner;
    protected EStructuralFeature feature;
    protected Object value;
    protected Object oldValue;
    protected boolean canUndo = true;
    protected static final EcorePackage ecorePackage = EcorePackage.eINSTANCE;
    static /* synthetic */ Class class$0;

    public static Command create(EditingDomain domain, final Object owner, Object feature, Object value) {
        Class<?> clazz;
        if (owner instanceof EObject && ((EObject)owner).eClass().getEAllReferences().contains(feature)) {
            EReference eReference = (EReference)feature;
            if (eReference.isMany()) {
                List values;
                CompoundCommand compound = new CompoundCommand(Integer.MIN_VALUE, LABEL, DESCRIPTION){

                    public Collection getAffectedObjects() {
                        return Collections.singleton(owner);
                    }
                };
                List oldValues = (List)((EObject)owner).eGet((EStructuralFeature)eReference);
                if (!oldValues.isEmpty()) {
                    compound.append(RemoveCommand.create(domain, owner, feature, (Collection)new BasicEList((Collection)oldValues)));
                }
                if (!(values = (List)value).isEmpty()) {
                    compound.append(AddCommand.create(domain, owner, feature, values));
                }
                return compound;
            }
            if (eReference.getEOpposite() != null) {
                EReference eOtherEnd = eReference.getEOpposite();
                if (eOtherEnd.isMany()) {
                    Object oldValue = ((EObject)owner).eGet((EStructuralFeature)eReference);
                    if (value == null) {
                        if (oldValue == null) {
                            Class<?> clazz2 = class$0;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = class$0 = Class.forName("org.eclipse.emf.edit.command.SetCommand");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            return domain.createCommand(clazz2, new CommandParameter(owner, (Object)eReference, value));
                        }
                        return RemoveCommand.create(domain, oldValue, (Object)eOtherEnd, Collections.singleton(owner));
                    }
                    CommandWrapper addCommand = new CommandWrapper(AddCommand.create(domain, value, (Object)eOtherEnd, Collections.singleton(owner))){

                        public Collection getAffectedObjects() {
                            return Collections.singleton(owner);
                        }
                    };
                    if (oldValue == null) {
                        return addCommand;
                    }
                    CompoundCommand compound = new CompoundCommand(Integer.MIN_VALUE, LABEL, DESCRIPTION);
                    compound.append(RemoveCommand.create(domain, oldValue, (Object)eOtherEnd, Collections.singleton(owner)));
                    compound.append((Command)addCommand);
                    return compound;
                }
                if (eOtherEnd.isContainment()) {
                    if (value != null) {
                        return new CommandWrapper(SetCommand.create(domain, value, eOtherEnd, owner)){

                            public Collection getResult() {
                                return Collections.singleton(owner);
                            }

                            public Collection getAffectedObjects() {
                                return Collections.singleton(owner);
                            }
                        };
                    }
                } else if (value instanceof EObject && ((EObject)value).eGet((EStructuralFeature)eOtherEnd) != null) {
                    CompoundCommand compound = new CompoundCommand(Integer.MIN_VALUE){

                        public boolean canUndo() {
                            return true;
                        }
                    };
                    Class<?> clazz3 = class$0;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$0 = Class.forName("org.eclipse.emf.edit.command.SetCommand");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    compound.append(domain.createCommand(clazz3, new CommandParameter(value, (Object)eOtherEnd, null)));
                    Class<?> clazz4 = class$0;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$0 = Class.forName("org.eclipse.emf.edit.command.SetCommand");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    compound.append(domain.createCommand(clazz4, new CommandParameter(owner, (Object)eReference, value)));
                    return compound;
                }
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.command.SetCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return domain.createCommand(clazz, new CommandParameter(owner, feature, value));
    }

    public SetCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value) {
        super(domain, LABEL, DESCRIPTION);
        this.owner = owner;
        this.feature = feature;
        this.value = value;
    }

    public EObject getOwner() {
        return this.owner;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    protected boolean prepare() {
        boolean result = false;
        if (this.owner != null) {
            EReference eReference;
            if (this.domain.isReadOnly(this.owner.eResource())) {
                return false;
            }
            EClass eMetaObject = this.owner.eClass();
            if (eMetaObject.getEAllAttributes().contains((Object)this.feature)) {
                EAttribute eAttribute = (EAttribute)this.feature;
                EClassifier eType = eAttribute.getEType();
                if (eAttribute.isMany()) {
                    this.oldValue = new BasicEList((Collection)((EList)this.owner.eGet(this.feature)));
                    if (this.value == null) {
                        result = true;
                    } else if (this.value instanceof EList) {
                        EList list = (EList)this.value;
                        result = true;
                        Iterator objects = list.iterator();
                        while (objects.hasNext()) {
                            if (eType.isInstance(objects.next())) continue;
                            result = false;
                            break;
                        }
                    }
                } else {
                    if (this.owner.eIsSet((EStructuralFeature)eAttribute)) {
                        this.oldValue = this.owner.eGet(this.feature);
                    }
                    result = this.value == null || eType.isInstance(this.value);
                }
            } else if (eMetaObject.getEAllReferences().contains((Object)this.feature) && !(eReference = (EReference)this.feature).isMany()) {
                this.oldValue = this.owner.eGet(this.feature);
                if (this.value == null || eReference.getEType().isInstance(this.value)) {
                    result = true;
                    if (eReference.isContainment()) {
                        EObject container = this.owner;
                        while (container != null) {
                            if (this.value == container) {
                                result = false;
                                break;
                            }
                            container = container.eContainer();
                        }
                    }
                    if (result && eReference.getEOpposite() != null) {
                        EReference eOtherEnd = eReference.getEOpposite();
                        this.canUndo = eOtherEnd.isMany() ? this.oldValue == null : this.value == null || ((EObject)this.value).eGet((EStructuralFeature)eOtherEnd) == null;
                    }
                }
            }
        }
        return result;
    }

    public void doExecute() {
        if (this.value == null) {
            this.owner.eUnset(this.feature);
        } else {
            this.owner.eSet(this.feature, this.value);
        }
    }

    public boolean doCanUndo() {
        return this.canUndo;
    }

    public void doUndo() {
        if (this.oldValue == null) {
            this.owner.eUnset(this.feature);
        } else {
            this.owner.eSet(this.feature, this.oldValue);
        }
    }

    public void doRedo() {
        if (this.value == null) {
            this.owner.eUnset(this.feature);
        } else {
            this.owner.eSet(this.feature, this.value);
        }
    }

    public Collection doGetResult() {
        return Collections.singleton(this.owner);
    }

    public Collection doGetAffectedObjects() {
        return Collections.singleton(this.owner);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (owner: " + this.owner + ")");
        result.append(" (feature: " + this.feature + ")");
        result.append(" (value: " + this.value + ")");
        result.append(" (oldValue: " + this.oldValue + ")");
        return result.toString();
    }
}

