/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.presentation;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.presentation.EMFProjectWizard;
import org.eclipse.emf.codegen.ecore.genmodel.presentation.GenModelEditor;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelEditPlugin;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class GenModelActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(GenModelEditPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                GenModelActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                GenModelEditPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(GenModelEditPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return GenModelActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (GenModelActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)GenModelActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected IMenuManager generateMenuManager;
    protected IAction reloadAction = new ReloadAction();
    protected IAction generateAction = new GenerateAction(GenModelEditPlugin.INSTANCE.getString("_UI_GenerateModel_menu_item")){

        protected boolean canGenerate(GenBase genObject) {
            return genObject.canGenerate();
        }

        protected void generate(GenBase genObject, IProgressMonitor progressMonitor) {
            genObject.generate(progressMonitor);
        }
    };
    protected IAction generateEditAction = new GenerateAction(GenModelEditPlugin.INSTANCE.getString("_UI_GenerateEdit_menu_item")){

        protected boolean canGenerate(GenBase genObject) {
            return genObject.canGenerateEdit();
        }

        protected void generate(GenBase genObject, IProgressMonitor progressMonitor) {
            genObject.generateEdit(progressMonitor);
        }
    };
    protected IAction generateEditorAction = new GenerateAction(GenModelEditPlugin.INSTANCE.getString("_UI_GenerateEditor_menu_item")){

        protected boolean canGenerate(GenBase genObject) {
            return genObject.canGenerateEditor();
        }

        protected void generate(GenBase genObject, IProgressMonitor progressMonitor) {
            genObject.generateEditor(progressMonitor);
        }
    };
    protected IAction generateSchemaAction = new GenerateAction(GenModelEditPlugin.INSTANCE.getString("_UI_GenerateSchema_menu_item")){

        protected boolean canGenerate(GenBase genObject) {
            return genObject instanceof GenModel || genObject instanceof GenPackage && ((GenPackage)genObject).hasClassifiers();
        }

        protected void generate(GenBase genObject, IProgressMonitor progressMonitor) {
            progressMonitor.beginTask("", 3);
            if (genObject instanceof GenModel) {
                Iterator i = ((GenModel)genObject).getGenPackages().iterator();
                while (i.hasNext()) {
                    this.generate((GenBase)((GenPackage)i.next()), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                }
            } else if (genObject instanceof GenPackage) {
                ((GenPackage)genObject).generateSchema();
            }
        }
    };
    protected IAction generateAllAction = new GenerateAction(GenModelEditPlugin.INSTANCE.getString("_UI_GenerateAll_menu_item")){

        protected boolean canGenerate(GenBase genObject) {
            return genObject.canGenerate() || genObject.canGenerateEdit() || genObject.canGenerateEditor();
        }

        protected void generate(GenBase genObject, IProgressMonitor progressMonitor) {
            progressMonitor.beginTask("", 3);
            genObject.generate((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            genObject.generateEdit((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            genObject.generateEditor((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
    };

    protected ISelection getActiveEditorSelection() {
        return this.activeEditorPart == null ? null : ((GenModelEditor)this.activeEditorPart).getSelection();
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        this.generateMenuManager = new MenuManager(GenModelEditPlugin.INSTANCE.getString("_UI_Generate_menu"), "org.eclipse.emf.codegen.ecore.genmodelMenuID");
        menuManager.insertAfter("additions", (IContributionItem)this.generateMenuManager);
        this.generateMenuManager.add(this.generateAction);
        this.generateMenuManager.add(this.generateEditAction);
        this.generateMenuManager.add(this.generateEditorAction);
        this.generateMenuManager.add(this.generateAllAction);
        this.generateMenuManager.add((IContributionItem)new Separator("schema-actions"));
        this.generateMenuManager.add(this.generateSchemaAction);
        this.generateMenuManager.add((IContributionItem)new Separator("global-actions"));
        this.generateMenuManager.add(this.reloadAction);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("genmodel-settings"));
        toolBarManager.add((IContributionItem)new Separator("genmodel-additions"));
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IContributionItem[] items = this.generateMenuManager.getItems();
        int i = 0;
        int len = items.length;
        while (i < len) {
            items[i].update();
            ++i;
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        this.generateAllAction.setEnabled(this.generateAllAction.isEnabled());
        this.generateSchemaAction.setEnabled(this.generateSchemaAction.isEnabled());
        this.generateEditorAction.setEnabled(this.generateEditorAction.isEnabled());
        this.generateEditAction.setEnabled(this.generateEditAction.isEnabled());
        this.generateAction.setEnabled(this.generateAction.isEnabled());
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        super.menuAboutToShow(menuManager);
        menuManager.insertBefore("additions", (IContributionItem)new Separator("generate-actions"));
        menuManager.insertAfter("generate-actions", this.generateAllAction);
        menuManager.insertAfter("generate-actions", this.generateEditorAction);
        menuManager.insertAfter("generate-actions", this.generateEditAction);
        menuManager.insertAfter("generate-actions", this.generateAction);
        menuManager.insertBefore("additions", (IContributionItem)new Separator("schema-actions"));
        menuManager.insertAfter("schema-actions", this.generateSchemaAction);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    protected class ReloadAction
    extends Action {
        public ReloadAction() {
            super(GenModelEditPlugin.INSTANCE.getString("_UI_GenModel_Reload"));
        }

        public void run() {
            IFile file = ((IFileEditorInput)GenModelActionBarContributor.this.activeEditorPart.getEditorInput()).getFile();
            EMFProjectWizard emfProjectWizard = new EMFProjectWizard(file);
            WizardDialog wizardDialog = new WizardDialog(GenModelActionBarContributor.this.activeEditorPart.getEditorSite().getShell(), (IWizard)emfProjectWizard);
            wizardDialog.create();
            wizardDialog.getShell().setSize(540, 580);
            wizardDialog.open();
            ((GenModelEditor)GenModelActionBarContributor.this.activeEditorPart).handleActivate();
        }
    }

    protected abstract class GenerateAction
    extends Action {
        public GenerateAction(String text) {
            super(text);
        }

        protected abstract boolean canGenerate(GenBase var1);

        protected abstract void generate(GenBase var1, IProgressMonitor var2);

        public boolean isEnabled() {
            ISelection s = GenModelActionBarContributor.this.getActiveEditorSelection();
            if (!(s instanceof IStructuredSelection)) {
                return false;
            }
            IStructuredSelection ss = (IStructuredSelection)s;
            if (ss.size() == 0) {
                return false;
            }
            Iterator iter = ss.iterator();
            while (iter.hasNext()) {
                Object selected = iter.next();
                if (selected instanceof GenBase && this.canGenerate((GenBase)selected)) continue;
                return false;
            }
            return true;
        }

        public void run() {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(this){
                final /* synthetic */ GenerateAction this$1;
                {
                    this.this$1 = generateAction;
                }

                protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                    List selection = ((IStructuredSelection)GenerateAction.access$0(this.this$1).getActiveEditorSelection()).toList();
                    progressMonitor.beginTask("", selection.size());
                    try {
                        Iterator<E> iter = selection.iterator();
                        while (iter.hasNext()) {
                            this.this$1.generate((GenBase)iter.next(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                        }
                    }
                    catch (Exception exception) {
                        GenModelEditPlugin.INSTANCE.log(exception);
                    }
                    progressMonitor.done();
                }
            };
            try {
                new ProgressMonitorDialog(GenModelActionBarContributor.this.activeEditorPart.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            }
            catch (Exception exception) {
                GenModelEditPlugin.INSTANCE.log(exception);
            }
        }

        static /* synthetic */ GenModelActionBarContributor access$0(GenerateAction generateAction) {
            return generateAction.GenModelActionBarContributor.this;
        }
    }
}

