/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDParser;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XSDResourceImpl
extends ResourceImpl {
    public static String XSD_TRACK_LOCATION = "XSD_TRACK_LOCATION";
    public static String XSD_PROGRESS_MONITOR = "XSD_PROGRESS_MONITOR";
    public static String XSD_ENCODING = "XSD_ENCODING";
    protected static final SchemaLocator SCHEMA_LOCATOR = new SchemaLocator();
    protected Collection attachedSchemas;

    public static void serialize(OutputStream outputStream, Element element) {
        XSDResourceImpl.serialize(outputStream, element, null);
    }

    public static void serialize(OutputStream outputStream, Element element, String encoding) {
        try {
            XSDResourceImpl.doSerialize(outputStream, element, encoding);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static void doSerialize(OutputStream outputStream, Element element) throws IOException {
        XSDResourceImpl.doSerialize(outputStream, element, null);
    }

    protected static void doSerialize(OutputStream outputStream, Element element, String encoding) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            transformer.transform(new DOMSource(element), new StreamResult(outputStream));
        }
        catch (TransformerException exception) {
            XSDPlugin.INSTANCE.log(exception);
        }
    }

    public static void serialize(OutputStream outputStream, Document document) {
        XSDResourceImpl.serialize(outputStream, document, null);
    }

    public static void serialize(OutputStream outputStream, Document document, String encoding) {
        try {
            XSDResourceImpl.doSerialize(outputStream, document, encoding);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static void doSerialize(OutputStream outputStream, Document document) throws IOException {
        XSDResourceImpl.doSerialize(outputStream, document, null);
    }

    protected static void doSerialize(OutputStream outputStream, Document document, String encoding) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (TransformerException exception) {
            XSDPlugin.INSTANCE.log(exception);
        }
    }

    protected static Document getDocument(InputStream inputStream, ErrorHandler errorHandler) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            EntityResolver entityResolver = XSDResourceImpl.createEntityResolver();
            documentBuilder.setEntityResolver(entityResolver);
            documentBuilder.setErrorHandler(errorHandler);
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (ParserConfigurationException exception) {
            throw new Resource.IOWrappedException((Exception)exception);
        }
        catch (SAXException exception) {
            throw new Resource.IOWrappedException((Exception)exception);
        }
    }

    protected static EntityResolver createEntityResolver() {
        final String baseURL = XSDPlugin.INSTANCE.getBaseURL().toString();
        DefaultHandler entityResolver = new DefaultHandler(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                InputSource inputSource;
                if ("-//W3C//DTD XMLSCHEMA 200102//EN".equals(publicId) || "http://www.w3.org/2001/XMLSchema.dtd".equals(systemId)) {
                    inputSource = new InputSource(String.valueOf(baseURL) + "cache/www.w3.org/2001/XMLSchema.dtd");
                    inputSource.setPublicId(publicId);
                } else {
                    try {
                        inputSource = super.resolveEntity(publicId, systemId);
                    }
                    catch (IOException exception) {
                        throw new SAXException(exception);
                    }
                }
                return inputSource;
            }
        };
        return entityResolver;
    }

    protected static void assignDiagnostics(XSDSchema xsdSchema, Collection xsdDiagnostics) {
        if (!xsdDiagnostics.isEmpty()) {
            xsdSchema.getDiagnostics().addAll(xsdDiagnostics);
            Iterator i = xsdDiagnostics.iterator();
            while (i.hasNext()) {
                XSDDiagnostic xsdDiagnostic = (XSDDiagnostic)i.next();
                xsdDiagnostic.getComponents().add((Object)xsdSchema);
                if (xsdSchema.getElement() == null) continue;
                xsdDiagnostic.setNode(xsdSchema.getElement());
            }
        }
    }

    public XSDResourceImpl() {
    }

    public XSDResourceImpl(URI uri) {
        super(uri);
    }

    protected void doSave(OutputStream os, Map options) throws IOException {
        XSDSchema xsdSchema = this.getSchema();
        if (xsdSchema != null) {
            Document document = xsdSchema.getDocument();
            if (document == null) {
                xsdSchema.updateDocument();
                document = xsdSchema.getDocument();
            }
            if (xsdSchema.getElement() == null) {
                xsdSchema.updateElement();
            }
            XSDResourceImpl.doSerialize(os, document, options == null ? null : (String)options.get(XSD_ENCODING));
        }
    }

    public XSDSchema getSchema() {
        return this.getContents().size() >= 1 && this.getContents().get(0) instanceof XSDSchema ? (XSDSchema)this.getContents().get(0) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doLoad(InputStream inputStream, Map options) throws IOException {
        XSDParser xsdParser;
        IProgressMonitor progressMonitor;
        block22: {
            Object monitor;
            this.attachedSchemas = new ArrayList();
            progressMonitor = null;
            Object v0 = monitor = options == null ? null : options.get("XSD_PROGRESS_MONITOR");
            if (monitor != null) {
                progressMonitor = monitor;
                progressMonitor.setTaskName(XSDPlugin.INSTANCE.getString("_UI_ResourceLoad_progress"));
                progressMonitor.subTask(this.getURI().toString());
            }
            xsdParser = new XSDParser();
            try {
                Document document;
                if (options != null && Boolean.TRUE.equals(options.get("XSD_TRACK_LOCATION"))) {
                    xsdParser.parse(inputStream);
                    document = xsdParser.getDocument();
                } else {
                    document = XSDResourceImpl.getDocument(inputStream, xsdParser);
                }
                if (xsdParser.getEncoding() != null) {
                    this.getDefaultSaveOptions().put(XSD_ENCODING, xsdParser.getEncoding());
                }
                if (document != null && document.getDocumentElement() != null) {
                    ResourceSet globalResourceSet = XSDSchemaImpl.getGlobalResourceSet();
                    Object oldMonitor = globalResourceSet.getLoadOptions().get("XSD_PROGRESS_MONITOR");
                    try {
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put("XSD_PROGRESS_MONITOR", progressMonitor);
                        if (options != null && (options.containsKey("XSD_MAGIC_XML_SCHEMA") || options.containsKey("XSD_XML_SCHEMA"))) {
                            this.handleSchemaElement(document.getDocumentElement(), true);
                        } else if (!this.findSchemas(document.getDocumentElement())) {
                            this.handleSchemaElement(document.getDocumentElement(), false);
                        }
                        Object var9_12 = null;
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put("XSD_PROGRESS_MONITOR", oldMonitor);
                        break block22;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        XSDSchemaImpl.getGlobalResourceSet().getLoadOptions().put("XSD_PROGRESS_MONITOR", oldMonitor);
                        throw throwable;
                    }
                }
                this.handleSchemaElement(null, false);
            }
            catch (Exception exception) {
                XSDPlugin.INSTANCE.log(exception);
                this.handleSchemaElement(null, false);
            }
        }
        Iterator i = this.getContents().iterator();
        while (i.hasNext()) {
            XSDSchema xsdSchema = (XSDSchema)i.next();
            XSDResourceImpl.assignDiagnostics(xsdSchema, xsdParser.getDiagnostics());
            Iterator diagnostics = xsdParser.getDiagnostics().iterator();
            while (diagnostics.hasNext()) {
                XSDDiagnostic xsdDiagnostic = (XSDDiagnostic)diagnostics.next();
                switch (xsdDiagnostic.getSeverity().getValue()) {
                    case 0: 
                    case 1: {
                        this.getErrors().add((Object)xsdDiagnostic);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.getWarnings().add((Object)xsdDiagnostic);
                        break;
                    }
                }
            }
        }
        if (this.getContents().size() > 1) {
            this.eAdapters().add((Object)SCHEMA_LOCATOR);
        }
        String schemaLocation = this.getURI().toString();
        Collection previouslyAttachedSchemas = this.attachedSchemas;
        this.attachedSchemas = null;
        Iterator i2 = previouslyAttachedSchemas.iterator();
        while (i2.hasNext()) {
            XSDSchema xsdSchema = (XSDSchema)i2.next();
            xsdSchema.setSchemaLocation(schemaLocation);
        }
        if (progressMonitor != null) {
            progressMonitor.worked(1);
        }
    }

    protected boolean findSchemas(Element element) {
        if (XSDConstants.nodeType(element) == 33) {
            this.handleSchemaElement(element, false);
            return true;
        }
        boolean result = false;
        Node child = element.getFirstChild();
        while (child != null) {
            if (child instanceof Element && this.findSchemas((Element)child)) {
                result = true;
            }
            child = child.getNextSibling();
        }
        return result;
    }

    protected void handleSchemaElement(Element element, boolean isMeta) {
        XSDSchema xsdSchema;
        if (element == null) {
            xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
            xsdSchema.getQNamePrefixToNamespaceMap().put(null, "http://www.w3.org/2001/XMLSchema");
        } else {
            xsdSchema = isMeta ? XSDSchemaImpl.createMetaSchema(element) : XSDSchemaImpl.createSchema(element);
        }
        this.getContents().add((Object)xsdSchema);
    }

    public void attached(EObject eObject) {
        super.attached(eObject);
        if (eObject instanceof XSDSchema) {
            if (this.attachedSchemas != null) {
                this.attachedSchemas.add(eObject);
            } else if (!(eObject instanceof XSDSchemaImpl) || ((XSDSchemaImpl)eObject).getPendingSchemaLocation() == null) {
                ((XSDSchema)eObject).setSchemaLocation(this.getURI().toString());
            }
        }
    }

    public String getURIFragment(EObject eObject) {
        XSDConcreteComponent xsdConcreteComponent;
        Element theElement;
        if (eObject instanceof XSDConcreteComponent && (theElement = (xsdConcreteComponent = (XSDConcreteComponent)eObject).getElement()) != null && theElement.hasAttributeNS(null, "id") && theElement.getOwnerDocument().getElementById(theElement.getAttributeNS(null, "id")) == theElement) {
            return theElement.getAttributeNS(null, "id");
        }
        return super.getURIFragment(eObject);
    }

    public EObject getEObject(String uriFragment) {
        Element theElement;
        if (!uriFragment.startsWith("/") && (theElement = this.getSchema().getElement()) != null) {
            Element resultElement = theElement.getOwnerDocument().getElementById(uriFragment);
            ArrayList<Element> parents = new ArrayList<Element>();
            Node parent = resultElement;
            while (parent != null) {
                if (parent.getNodeType() == 1) {
                    parents.add((Element)parent);
                }
                parent = parent.getParentNode();
            }
            return ((XSDSchemaImpl)this.getSchema()).getBestConcreteComponent(parents);
        }
        return super.getEObject(uriFragment);
    }

    public Map getDefaultSaveOptions() {
        if (this.defaultSaveOptions == null) {
            this.defaultSaveOptions = new HashMap();
        }
        return this.defaultSaveOptions;
    }

    public Map getLoadSaveOptions() {
        if (this.defaultLoadOptions == null) {
            this.defaultLoadOptions = new HashMap();
        }
        return this.defaultLoadOptions;
    }

    public void setModified(boolean isModified) {
        if (this.isModified != isModified) {
            super.setModified(isModified);
        }
    }

    public static class SchemaLocator
    extends AdapterImpl
    implements XSDSchemaLocator {
        static /* synthetic */ Class class$0;

        public XSDSchema locateSchema(XSDSchema xsdSchema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocation) {
            Resource resource;
            if (rawSchemaLocationURI == null && (resource = xsdSchema.eResource()) != null) {
                Iterator i = resource.getContents().iterator();
                while (i.hasNext()) {
                    XSDSchema otherSchema = (XSDSchema)i.next();
                    if (!(namespaceURI == null ? otherSchema.getTargetNamespace() == null : namespaceURI.equals(otherSchema.getTargetNamespace()))) continue;
                    return otherSchema;
                }
            }
            return null;
        }

        public boolean isAdapterForType(Object type) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.xsd.util.XSDSchemaLocator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return type == clazz;
        }
    }
}

