/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.java.util;

import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.java.JClass;
import org.eclipse.emf.java.JMethod;
import org.eclipse.emf.java.JPackage;
import org.eclipse.emf.java.JVisibility;
import org.eclipse.emf.java.JavaFactory;
import org.eclipse.emf.java.util.JavaPackageResourceFactoryImpl;
import org.eclipse.emf.java.util.JavaPackageResourceImpl;

public class JavaUtil {
    public static final String JAVA_PACKAGE_RESOURCE = "http:///org/eclipse/emf/java/.packages";
    public static final URI JAVA_PACKAGE_RESOURCE_URI = URI.createURI((String)"http:///org/eclipse/emf/java/.packages");

    public static URI createJPackageProxyURI(String packageName) {
        return JAVA_PACKAGE_RESOURCE_URI.appendFragment("/" + packageName);
    }

    public static JPackage createJPackageProxy(String packageName) {
        JPackage jPackage = JavaFactory.eINSTANCE.createJPackage();
        ((InternalEObject)jPackage).eSetProxyURI(JavaUtil.createJPackageProxyURI(packageName));
        return jPackage;
    }

    public static URI createJClassProxyURI(Class javaClass) {
        String suffix = "";
        while (javaClass.getComponentType() != null) {
            suffix = String.valueOf(suffix) + "/[]";
            javaClass = javaClass.getComponentType();
        }
        String className = javaClass.getName();
        String packageName = "";
        int index = className.lastIndexOf(".");
        if (index != -1) {
            packageName = className.substring(0, index);
            className = className.substring(index + 1);
        }
        if (javaClass.isPrimitive()) {
            packageName = "java.lang";
        }
        return JAVA_PACKAGE_RESOURCE_URI.appendFragment("/" + packageName + "/" + className.replace('$', '/') + suffix);
    }

    public static JClass createJClassProxy(Class javaClass) {
        JClass jClass = JavaFactory.eINSTANCE.createJClass();
        ((InternalEObject)jClass).eSetProxyURI(JavaUtil.createJClassProxyURI(javaClass));
        return jClass;
    }

    public static URI createJClassProxyURI(String className) {
        StringBuffer result = new StringBuffer("/");
        result.append(className);
        int i = 0;
        while (i < result.length()) {
            ++i;
        }
        int dotIndex = className.lastIndexOf(".");
        if (dotIndex != -1) {
            result.setCharAt(dotIndex + 1, '/');
        }
        int i2 = dotIndex + 2;
        while (i2 < result.length()) {
            switch (result.charAt(i2)) {
                case '$': {
                    result.setCharAt(i2, '/');
                    break;
                }
                case '[': {
                    result.insert(i2++, '/');
                }
            }
            ++i2;
        }
        if (dotIndex == -1) {
            result.insert(0, '/');
        }
        return JAVA_PACKAGE_RESOURCE_URI.appendFragment(result.toString());
    }

    public static JClass createJClassProxy(String className) {
        JClass jClass = JavaFactory.eINSTANCE.createJClass();
        ((InternalEObject)jClass).eSetProxyURI(JavaUtil.createJClassProxyURI(className));
        return jClass;
    }

    public static URI createJClassProxyURI(URI javaSourceURI) {
        return javaSourceURI.appendFragment("//@types.0");
    }

    public static JClass createJClassProxy(URI javaSourceURI) {
        JClass jClass = JavaFactory.eINSTANCE.createJClass();
        ((InternalEObject)jClass).eSetProxyURI(JavaUtil.createJClassProxyURI(javaSourceURI));
        return jClass;
    }

    public static JVisibility getFlagVisibility(int flags) {
        if ((flags & 1) != 0) {
            return JVisibility.PUBLIC_LITERAL;
        }
        if ((flags & 4) != 0) {
            return JVisibility.PROTECTED_LITERAL;
        }
        if ((flags & 2) != 0) {
            return JVisibility.PRIVATE_LITERAL;
        }
        return JVisibility.PACKAGE_LITERAL;
    }

    public static JVisibility getModifierVisibility(int modifiers) {
        if (Modifier.isPublic(modifiers)) {
            return JVisibility.PUBLIC_LITERAL;
        }
        if (Modifier.isProtected(modifiers)) {
            return JVisibility.PROTECTED_LITERAL;
        }
        if (Modifier.isPrivate(modifiers)) {
            return JVisibility.PRIVATE_LITERAL;
        }
        return JVisibility.PACKAGE_LITERAL;
    }

    public static boolean isPrefixOf(String name, String fullName) {
        if (fullName.startsWith(name)) {
            int fullNameLength;
            int nameLength = name.length();
            if (nameLength == (fullNameLength = fullName.length())) {
                return true;
            }
            if (nameLength > fullNameLength) {
                return fullName.charAt(nameLength) == '.';
            }
            return false;
        }
        return false;
    }

    public static class StandAloneTest {
        static /* synthetic */ Class class$0;

        public static void main(String[] arguments) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("packages", new JavaPackageResourceFactoryImpl());
            JavaPackageResourceImpl javaPackageResource = (JavaPackageResourceImpl)resourceSet.getResource(JAVA_PACKAGE_RESOURCE_URI, true);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.java.util.JavaUtil$StandAloneTest");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            javaPackageResource.setClassLoader(clazz.getClassLoader());
            JClass thisClass = (JClass)resourceSet.getEObject(JAVA_PACKAGE_RESOURCE_URI.appendFragment("/org.eclipse.emf.java.util/JavaUtil/StandAloneTest"), true);
            System.out.println("All Methods of " + thisClass.getQualifiedName());
            Iterator i = thisClass.getAllMethods().iterator();
            while (i.hasNext()) {
                JMethod jMethod = (JMethod)i.next();
                System.out.println("  " + jMethod.getQualifiedName());
            }
            System.exit(1);
        }
    }
}

