package org.eclipse.emf.codegen.ecore.templates.model;

import java.util.*;
import org.eclipse.emf.codegen.ecore.genmodel.*;

public class ValidatorClass
{
  protected final String NL = System.getProperties().getProperty("line.separator");
  protected final String TEXT_1 = "";
  protected final String TEXT_2 = "/**" + NL + " * <copyright>" + NL + " * </copyright>" + NL + " *" + NL + " * ";
  protected final String TEXT_3 = "Id";
  protected final String TEXT_4 = NL + " */" + NL + "package ";
  protected final String TEXT_5 = ";" + NL;
  protected final String TEXT_6 = NL + NL + "/**" + NL + " * <!-- begin-user-doc -->" + NL + " * The <b>Validator</b> for the model." + NL + " * <!-- end-user-doc -->" + NL + " * @see ";
  protected final String TEXT_7 = NL + " * @generated" + NL + " */" + NL + "public class ";
  protected final String TEXT_8 = " extends ";
  protected final String TEXT_9 = NL + "{";
  protected final String TEXT_10 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_11 = " copyright = \"";
  protected final String TEXT_12 = "\";";
  protected final String TEXT_13 = NL;
  protected final String TEXT_14 = NL + "\t/**" + NL + "\t * The cached model package" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_15 = " INSTANCE = new ";
  protected final String TEXT_16 = "();" + NL + "" + NL + "\t/**" + NL + "\t * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @see org.eclipse.emf.common.util.Diagnostic#getSource()" + NL + "\t * @see org.eclipse.emf.common.util.Diagnostic#getCode()" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic static final String DIAGNOSTIC_SOURCE = \"";
  protected final String TEXT_17 = "\";" + NL;
  protected final String TEXT_18 = NL + "\t/**" + NL + "\t * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint '";
  protected final String TEXT_19 = "' of '";
  protected final String TEXT_20 = "'." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic static final int ";
  protected final String TEXT_21 = "__";
  protected final String TEXT_22 = " = ";
  protected final String TEXT_23 = ";" + NL;
  protected final String TEXT_24 = NL + "\t/**" + NL + "\t * A constant with a fixed name that can be used as the base value for additional hand written constants." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprivate static final int GENERATED_DIAGNOSTIC_CODE_COUNT = ";
  protected final String TEXT_25 = ";" + NL;
  protected final String TEXT_26 = NL + "\t/**" + NL + "\t * The cached base package validator." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected ";
  protected final String TEXT_27 = " ";
  protected final String TEXT_28 = "Validator;" + NL;
  protected final String TEXT_29 = NL + "\t/**" + NL + "\t * Creates an instance of the switch." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic ";
  protected final String TEXT_30 = "()" + NL + "\t{";
  protected final String TEXT_31 = NL + "\t\t";
  protected final String TEXT_32 = "Validator = ";
  protected final String TEXT_33 = ".INSTANCE;";
  protected final String TEXT_34 = NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * Returns the package of this validator switch." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected EPackage getEPackage()" + NL + "\t{" + NL + "\t  return ";
  protected final String TEXT_35 = ".eINSTANCE;" + NL + "\t}" + NL + "" + NL + "\t/**" + NL + "\t * Calls <code>validateXXX</code> for the corresonding classifier of the model." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tprotected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map context)" + NL + "\t{" + NL + "\t\tswitch (classifierID)" + NL + "\t\t{";
  protected final String TEXT_36 = NL + "\t\t\tcase ";
  protected final String TEXT_37 = ".";
  protected final String TEXT_38 = ":";
  protected final String TEXT_39 = NL + "\t\t\t\treturn validate";
  protected final String TEXT_40 = "(((";
  protected final String TEXT_41 = ")value).";
  protected final String TEXT_42 = "(), diagnostics, context);";
  protected final String TEXT_43 = NL + "\t\t\t\treturn validate";
  protected final String TEXT_44 = "(value, diagnostics, context);";
  protected final String TEXT_45 = NL + "\t\t\t\treturn validate";
  protected final String TEXT_46 = "((";
  protected final String TEXT_47 = ")value, diagnostics, context);";
  protected final String TEXT_48 = NL + "\t\t\t\treturn validate";
  protected final String TEXT_49 = "((";
  protected final String TEXT_50 = ")value, diagnostics, context);";
  protected final String TEXT_51 = NL + "\t\t\tdefault: " + NL + "\t\t\t\treturn true;" + NL + "\t\t}" + NL + "\t}" + NL;
  protected final String TEXT_52 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic boolean validate";
  protected final String TEXT_53 = "(";
  protected final String TEXT_54 = " ";
  protected final String TEXT_55 = ", DiagnosticChain ";
  protected final String TEXT_56 = ", Map ";
  protected final String TEXT_57 = ")" + NL + "\t{";
  protected final String TEXT_58 = NL + "\t\treturn true;";
  protected final String TEXT_59 = NL + "\t\treturn validate_EveryDefaultConstraint(";
  protected final String TEXT_60 = "(";
  protected final String TEXT_61 = ")";
  protected final String TEXT_62 = ", ";
  protected final String TEXT_63 = ", ";
  protected final String TEXT_64 = ");";
  protected final String TEXT_65 = NL + "\t\tboolean ";
  protected final String TEXT_66 = " = ";
  protected final String TEXT_67 = "validate";
  protected final String TEXT_68 = "_";
  protected final String TEXT_69 = "(";
  protected final String TEXT_70 = ", ";
  protected final String TEXT_71 = ", ";
  protected final String TEXT_72 = ");";
  protected final String TEXT_73 = NL + "\t\tif (";
  protected final String TEXT_74 = " || ";
  protected final String TEXT_75 = " != null) result &= ";
  protected final String TEXT_76 = "validate";
  protected final String TEXT_77 = "_";
  protected final String TEXT_78 = "(";
  protected final String TEXT_79 = ", ";
  protected final String TEXT_80 = ", ";
  protected final String TEXT_81 = ");";
  protected final String TEXT_82 = NL + "\t\treturn ";
  protected final String TEXT_83 = ";";
  protected final String TEXT_84 = NL + "\t}" + NL;
  protected final String TEXT_85 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t * @see #validate";
  protected final String TEXT_86 = "_";
  protected final String TEXT_87 = NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_88 = " ";
  protected final String TEXT_89 = "__VALUE = ";
  protected final String TEXT_90 = ";" + NL;
  protected final String TEXT_91 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t * @see #validate";
  protected final String TEXT_92 = "_";
  protected final String TEXT_93 = NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_94 = " ";
  protected final String TEXT_95 = "__VALUE = ";
  protected final String TEXT_96 = ";" + NL;
  protected final String TEXT_97 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t * @see #validate";
  protected final String TEXT_98 = "_";
  protected final String TEXT_99 = NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_100 = " ";
  protected final String TEXT_101 = "__UPPER_BOUND = ";
  protected final String TEXT_102 = ";" + NL + "" + NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t * @see #validate";
  protected final String TEXT_103 = "_";
  protected final String TEXT_104 = NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_105 = " ";
  protected final String TEXT_106 = "__LOWER_BOUND = ";
  protected final String TEXT_107 = ";" + NL;
  protected final String TEXT_108 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t * @see #validate";
  protected final String TEXT_109 = "_";
  protected final String TEXT_110 = NL + "\t */" + NL + "\tpublic static final  PatternMatcher [][] ";
  protected final String TEXT_111 = "__VALUES =" + NL + "\t\tnew PatternMatcher [][] " + NL + "\t\t{";
  protected final String TEXT_112 = NL + "\t\t\tnew PatternMatcher [] " + NL + "\t\t\t{";
  protected final String TEXT_113 = NL + "\t\t\t\t";
  protected final String TEXT_114 = ".createPatternMatcher(";
  protected final String TEXT_115 = ")";
  protected final String TEXT_116 = NL + "\t\t\t}";
  protected final String TEXT_117 = NL + "\t\t};" + NL;
  protected final String TEXT_118 = NL + "\t/**" + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t * @see #validate";
  protected final String TEXT_119 = "_";
  protected final String TEXT_120 = NL + "\t */" + NL + "\tpublic static final ";
  protected final String TEXT_121 = " ";
  protected final String TEXT_122 = "__VALUES =" + NL + "\t\twrapEnumerationValues" + NL + "\t\t\t(new Object[] " + NL + "\t\t\t {";
  protected final String TEXT_123 = NL + "\t\t\t\t ";
  protected final String TEXT_124 = "new ";
  protected final String TEXT_125 = "(";
  protected final String TEXT_126 = ")";
  protected final String TEXT_127 = NL + "\t\t\t });" + NL;
  protected final String TEXT_128 = NL + "\t/**" + NL + "\t * Validates the ";
  protected final String TEXT_129 = " constraint of '<em>";
  protected final String TEXT_130 = "</em>'." + NL + "\t * <!-- begin-user-doc -->" + NL + "\t * <!-- end-user-doc -->" + NL + "\t * @generated" + NL + "\t */" + NL + "\tpublic boolean validate";
  protected final String TEXT_131 = "_";
  protected final String TEXT_132 = "(";
  protected final String TEXT_133 = " ";
  protected final String TEXT_134 = ", DiagnosticChain ";
  protected final String TEXT_135 = ", Map ";
  protected final String TEXT_136 = ")" + NL + "\t{";
  protected final String TEXT_137 = NL + "\t\tboolean ";
  protected final String TEXT_138 = " = true;" + NL + "\t\tfor (";
  protected final String TEXT_139 = " i = ";
  protected final String TEXT_140 = ".iterator(); i.hasNext() && (result || diagnostics != null); )" + NL + "\t\t{" + NL + "\t\t\tObject item = i.next();" + NL + "\t\t\tif (";
  protected final String TEXT_141 = ".eINSTANCE.get";
  protected final String TEXT_142 = "().isInstance(item))" + NL + "\t\t\t{" + NL + "\t\t\t\tresult &= ";
  protected final String TEXT_143 = "validate";
  protected final String TEXT_144 = "(";
  protected final String TEXT_145 = "(";
  protected final String TEXT_146 = "(";
  protected final String TEXT_147 = ")";
  protected final String TEXT_148 = ").";
  protected final String TEXT_149 = "()";
  protected final String TEXT_150 = ", ";
  protected final String TEXT_151 = ", ";
  protected final String TEXT_152 = ");" + NL + "\t\t\t}" + NL + "\t\t\telse" + NL + "\t\t\t{" + NL + "\t\t\t\tresult = false;" + NL + "\t\t\t\treportDataValueTypeViolation(";
  protected final String TEXT_153 = ".eINSTANCE.get";
  protected final String TEXT_154 = "(), item, ";
  protected final String TEXT_155 = ", ";
  protected final String TEXT_156 = ");" + NL + "\t\t\t}" + NL + "\t\t}" + NL + "\t  return result;";
  protected final String TEXT_157 = NL + "\t\tboolean ";
  protected final String TEXT_158 = " = true;";
  protected final String TEXT_159 = NL + "\t\t";
  protected final String TEXT_160 = "else ";
  protected final String TEXT_161 = "if (";
  protected final String TEXT_162 = ".eINSTANCE.get";
  protected final String TEXT_163 = "().isInstance(";
  protected final String TEXT_164 = "))" + NL + "\t\t{" + NL + "\t\t\tresult &= ";
  protected final String TEXT_165 = "validate";
  protected final String TEXT_166 = "(";
  protected final String TEXT_167 = "(";
  protected final String TEXT_168 = "(";
  protected final String TEXT_169 = ")";
  protected final String TEXT_170 = ").";
  protected final String TEXT_171 = "()";
  protected final String TEXT_172 = ", ";
  protected final String TEXT_173 = ", ";
  protected final String TEXT_174 = ");" + NL + "\t\t}";
  protected final String TEXT_175 = NL + "\t  return result;";
  protected final String TEXT_176 = NL + "\t\treturn validatePattern(";
  protected final String TEXT_177 = ".eINSTANCE.get";
  protected final String TEXT_178 = "(), ";
  protected final String TEXT_179 = "new ";
  protected final String TEXT_180 = "(";
  protected final String TEXT_181 = ")";
  protected final String TEXT_182 = ", ";
  protected final String TEXT_183 = "__VALUES, ";
  protected final String TEXT_184 = ", ";
  protected final String TEXT_185 = ");";
  protected final String TEXT_186 = NL + "\t\t";
  protected final String TEXT_187 = " ";
  protected final String TEXT_188 = " = new ";
  protected final String TEXT_189 = "(";
  protected final String TEXT_190 = ");";
  protected final String TEXT_191 = NL + "\t\tboolean ";
  protected final String TEXT_192 = " = ";
  protected final String TEXT_193 = "__VALUES.contains(";
  protected final String TEXT_194 = ");" + NL + "\t\tif (!";
  protected final String TEXT_195 = " && ";
  protected final String TEXT_196 = " != null) " + NL + "\t\t\treportEnumerationViolation(";
  protected final String TEXT_197 = ".eINSTANCE.get";
  protected final String TEXT_198 = "(), ";
  protected final String TEXT_199 = ", ";
  protected final String TEXT_200 = "__VALUES, ";
  protected final String TEXT_201 = ", ";
  protected final String TEXT_202 = ");" + NL + "\t\treturn ";
  protected final String TEXT_203 = "; ";
  protected final String TEXT_204 = NL + "\t\tboolean ";
  protected final String TEXT_205 = " = ";
  protected final String TEXT_206 = " ";
  protected final String TEXT_207 = " ";
  protected final String TEXT_208 = "__VALUE;" + NL + "\t\tif (!";
  protected final String TEXT_209 = " && ";
  protected final String TEXT_210 = " != null) " + NL + "\t\t\treportMinViolation(";
  protected final String TEXT_211 = ".eINSTANCE.get";
  protected final String TEXT_212 = "(), new ";
  protected final String TEXT_213 = "(";
  protected final String TEXT_214 = "), new ";
  protected final String TEXT_215 = "(";
  protected final String TEXT_216 = "__VALUE), ";
  protected final String TEXT_217 = ", ";
  protected final String TEXT_218 = ", ";
  protected final String TEXT_219 = ");" + NL + "\t\treturn ";
  protected final String TEXT_220 = ";";
  protected final String TEXT_221 = NL + "\t\tint ";
  protected final String TEXT_222 = " = ";
  protected final String TEXT_223 = ".compareCalendar(";
  protected final String TEXT_224 = ", ";
  protected final String TEXT_225 = "__VALUE);" + NL + "\t\tboolean ";
  protected final String TEXT_226 = " = ";
  protected final String TEXT_227 = " == 0 || ";
  protected final String TEXT_228 = " == 1;";
  protected final String TEXT_229 = NL + "\t\tint ";
  protected final String TEXT_230 = " = ";
  protected final String TEXT_231 = ".compareDuration(";
  protected final String TEXT_232 = ", ";
  protected final String TEXT_233 = "__VALUE);" + NL + "\t\tboolean ";
  protected final String TEXT_234 = " = ";
  protected final String TEXT_235 = " == 0 || ";
  protected final String TEXT_236 = " == 1;";
  protected final String TEXT_237 = NL + "\t\tboolean ";
  protected final String TEXT_238 = " = ";
  protected final String TEXT_239 = ".compareTo(";
  protected final String TEXT_240 = "__VALUE) ";
  protected final String TEXT_241 = " 0;";
  protected final String TEXT_242 = NL + "\t\tif (!";
  protected final String TEXT_243 = " && ";
  protected final String TEXT_244 = " != null) " + NL + "\t\t\treportMinViolation(";
  protected final String TEXT_245 = ".eINSTANCE.get";
  protected final String TEXT_246 = "(), ";
  protected final String TEXT_247 = ", ";
  protected final String TEXT_248 = "__VALUE, ";
  protected final String TEXT_249 = ", ";
  protected final String TEXT_250 = ", ";
  protected final String TEXT_251 = ");" + NL + "\t\treturn ";
  protected final String TEXT_252 = "; ";
  protected final String TEXT_253 = NL + "\t\tboolean ";
  protected final String TEXT_254 = " = ";
  protected final String TEXT_255 = " ";
  protected final String TEXT_256 = " ";
  protected final String TEXT_257 = "__VALUE;" + NL + "\t\tif (!";
  protected final String TEXT_258 = " && ";
  protected final String TEXT_259 = " != null) " + NL + "\t\t\treportMaxViolation(";
  protected final String TEXT_260 = ".eINSTANCE.get";
  protected final String TEXT_261 = "(), new ";
  protected final String TEXT_262 = "(";
  protected final String TEXT_263 = "), new ";
  protected final String TEXT_264 = "(";
  protected final String TEXT_265 = "__VALUE), ";
  protected final String TEXT_266 = ", ";
  protected final String TEXT_267 = ", ";
  protected final String TEXT_268 = ");" + NL + "\t\treturn ";
  protected final String TEXT_269 = "; ";
  protected final String TEXT_270 = NL + "\t\tint ";
  protected final String TEXT_271 = " = ";
  protected final String TEXT_272 = ".compareCalendar(";
  protected final String TEXT_273 = ", ";
  protected final String TEXT_274 = "__VALUE);" + NL + "\t\tboolean ";
  protected final String TEXT_275 = " = ";
  protected final String TEXT_276 = " == 0 || ";
  protected final String TEXT_277 = " == -1;";
  protected final String TEXT_278 = NL + "\t\tint ";
  protected final String TEXT_279 = " = ";
  protected final String TEXT_280 = ".compareDuration(";
  protected final String TEXT_281 = ", ";
  protected final String TEXT_282 = "__VALUE);" + NL + "\t\tboolean ";
  protected final String TEXT_283 = " = ";
  protected final String TEXT_284 = " == 0 || ";
  protected final String TEXT_285 = " == -1;";
  protected final String TEXT_286 = NL + "\t\tboolean ";
  protected final String TEXT_287 = " = ";
  protected final String TEXT_288 = ".compareTo(";
  protected final String TEXT_289 = "__VALUE) ";
  protected final String TEXT_290 = " 0;";
  protected final String TEXT_291 = NL + "\t\tif (!";
  protected final String TEXT_292 = " && ";
  protected final String TEXT_293 = " != null) " + NL + "\t\t\treportMaxViolation(";
  protected final String TEXT_294 = ".eINSTANCE.get";
  protected final String TEXT_295 = "(), ";
  protected final String TEXT_296 = ", ";
  protected final String TEXT_297 = "__VALUE, ";
  protected final String TEXT_298 = ", ";
  protected final String TEXT_299 = ", ";
  protected final String TEXT_300 = ");" + NL + "\t\treturn ";
  protected final String TEXT_301 = "; ";
  protected final String TEXT_302 = NL + "\t\tint length = ";
  protected final String TEXT_303 = ".";
  protected final String TEXT_304 = ";  " + NL + "\t\tboolean ";
  protected final String TEXT_305 = " = length >= ";
  protected final String TEXT_306 = ";" + NL + "\t\tif (!";
  protected final String TEXT_307 = " && ";
  protected final String TEXT_308 = " != null) " + NL + "\t\t\treportMinLengthViolation(";
  protected final String TEXT_309 = ".eINSTANCE.get";
  protected final String TEXT_310 = "(), ";
  protected final String TEXT_311 = ", length, ";
  protected final String TEXT_312 = ", ";
  protected final String TEXT_313 = ", ";
  protected final String TEXT_314 = ");" + NL + "\t\treturn ";
  protected final String TEXT_315 = ";";
  protected final String TEXT_316 = NL + "\t\tint length = ";
  protected final String TEXT_317 = ".";
  protected final String TEXT_318 = ";  " + NL + "\t\tboolean ";
  protected final String TEXT_319 = " = length <= ";
  protected final String TEXT_320 = ";" + NL + "\t\tif (!";
  protected final String TEXT_321 = " && ";
  protected final String TEXT_322 = " != null) " + NL + "\t\t\treportMaxLengthViolation(";
  protected final String TEXT_323 = ".eINSTANCE.get";
  protected final String TEXT_324 = "(), ";
  protected final String TEXT_325 = ", length, ";
  protected final String TEXT_326 = ", ";
  protected final String TEXT_327 = ", ";
  protected final String TEXT_328 = ");" + NL + "\t\treturn ";
  protected final String TEXT_329 = ";";
  protected final String TEXT_330 = NL + "\t\tboolean ";
  protected final String TEXT_331 = " = ";
  protected final String TEXT_332 = " > ";
  protected final String TEXT_333 = "__LOWER_BOUND && ";
  protected final String TEXT_334 = " < ";
  protected final String TEXT_335 = "__UPPER_BOUND;" + NL + "\t\tif (!";
  protected final String TEXT_336 = " && ";
  protected final String TEXT_337 = " != null) " + NL + "\t\t\treportTotalDigitsViolation(";
  protected final String TEXT_338 = ".eINSTANCE.get";
  protected final String TEXT_339 = "(), new ";
  protected final String TEXT_340 = "(";
  protected final String TEXT_341 = "), ";
  protected final String TEXT_342 = ", ";
  protected final String TEXT_343 = ", ";
  protected final String TEXT_344 = ");";
  protected final String TEXT_345 = NL + "\t\tboolean ";
  protected final String TEXT_346 = " = ";
  protected final String TEXT_347 = ".unscaledValue().abs().toString().length() <= ";
  protected final String TEXT_348 = ";" + NL + "\t\tif (!";
  protected final String TEXT_349 = " && ";
  protected final String TEXT_350 = " != null) " + NL + "\t\t\treportTotalDigitsViolation(";
  protected final String TEXT_351 = ".eINSTANCE.get";
  protected final String TEXT_352 = "(), ";
  protected final String TEXT_353 = ", ";
  protected final String TEXT_354 = ", ";
  protected final String TEXT_355 = ", ";
  protected final String TEXT_356 = ");";
  protected final String TEXT_357 = NL + "\t\tboolean ";
  protected final String TEXT_358 = " = ";
  protected final String TEXT_359 = ".compareTo(";
  protected final String TEXT_360 = "__LOWER_BOUND) > 0 && ";
  protected final String TEXT_361 = ".compareTo(";
  protected final String TEXT_362 = "__UPPER_BOUND) < 0;" + NL + "\t\tif (!";
  protected final String TEXT_363 = " && ";
  protected final String TEXT_364 = " != null) " + NL + "\t\t\treportTotalDigitsViolation(";
  protected final String TEXT_365 = ".eINSTANCE.get";
  protected final String TEXT_366 = "(), ";
  protected final String TEXT_367 = ", ";
  protected final String TEXT_368 = ", ";
  protected final String TEXT_369 = ", ";
  protected final String TEXT_370 = ");";
  protected final String TEXT_371 = NL + "\t\treturn ";
  protected final String TEXT_372 = "; ";
  protected final String TEXT_373 = NL + "\t\tboolean ";
  protected final String TEXT_374 = " = ";
  protected final String TEXT_375 = ".scale() <= ";
  protected final String TEXT_376 = ";" + NL + "\t\tif (!";
  protected final String TEXT_377 = " && ";
  protected final String TEXT_378 = " != null) " + NL + "\t\t\treportFractionDigitsViolation(";
  protected final String TEXT_379 = ".eINSTANCE.get";
  protected final String TEXT_380 = "(), ";
  protected final String TEXT_381 = ", ";
  protected final String TEXT_382 = ", ";
  protected final String TEXT_383 = ", ";
  protected final String TEXT_384 = ");" + NL + "\t\treturn ";
  protected final String TEXT_385 = "; ";
  protected final String TEXT_386 = NL + "\t\t// TODO override the constraint" + NL + "\t\treturn ";
  protected final String TEXT_387 = "validate";
  protected final String TEXT_388 = "_";
  protected final String TEXT_389 = "(";
  protected final String TEXT_390 = ", ";
  protected final String TEXT_391 = ", ";
  protected final String TEXT_392 = ");";
  protected final String TEXT_393 = NL + "\t\t// TODO implement the constraint" + NL + "\t\treturn true;";
  protected final String TEXT_394 = NL + "\t\t// TODO override the constraint" + NL + "\t\treturn ";
  protected final String TEXT_395 = "validate";
  protected final String TEXT_396 = "_";
  protected final String TEXT_397 = "(";
  protected final String TEXT_398 = ", ";
  protected final String TEXT_399 = ", ";
  protected final String TEXT_400 = ");";
  protected final String TEXT_401 = NL + "\t\treturn ";
  protected final String TEXT_402 = ".";
  protected final String TEXT_403 = "(";
  protected final String TEXT_404 = ", ";
  protected final String TEXT_405 = ");";
  protected final String TEXT_406 = NL + "\t\t// TODO implement the constraint" + NL + "\t\treturn true;";
  protected final String TEXT_407 = NL + "\t}" + NL;
  protected final String TEXT_408 = NL + "} //";
  protected final String TEXT_409 = NL;

  public String generate(Object argument)
  {
    StringBuffer stringBuffer = new StringBuffer();
    
/**
 * <copyright>
 *
 * Copyright (c) 2002-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 */

    GenPackage genPackage = (GenPackage)argument; GenModel genModel=genPackage.getGenModel();
    stringBuffer.append(TEXT_1);
    stringBuffer.append(TEXT_2);
    stringBuffer.append("$");
    stringBuffer.append(TEXT_3);
    stringBuffer.append("$");
    stringBuffer.append(TEXT_4);
    stringBuffer.append(genPackage.getUtilitiesPackageName());
    stringBuffer.append(TEXT_5);
    genModel.addImport("java.util.Map");
    genModel.addImport("org.eclipse.emf.common.util.DiagnosticChain");
    genModel.addImport("org.eclipse.emf.ecore.EPackage");
    if (!genPackage.hasJavaLangConflict()) genModel.addImport(genPackage.getInterfacePackageName() + ".*");
    genModel.markImportLocation(stringBuffer);
    genModel.addPseudoImport("org.eclipse.emf.ecore.EValidator.Registry");
    genModel.addPseudoImport("org.eclipse.emf.ecore.EValidator.SubstitutionLabelProvider");
    genModel.addPseudoImport("org.eclipse.emf.ecore.EValidator.PatternMatcher");
    stringBuffer.append(TEXT_6);
    stringBuffer.append(genPackage.getQualifiedPackageInterfaceName());
    stringBuffer.append(TEXT_7);
    stringBuffer.append(genPackage.getValidatorClassName());
    stringBuffer.append(TEXT_8);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.util.EObjectValidator"));
    stringBuffer.append(TEXT_9);
    if (genModel.getCopyrightText() != null) {
    stringBuffer.append(TEXT_10);
    stringBuffer.append(genModel.getImportedName("java.lang.String"));
    stringBuffer.append(TEXT_11);
    stringBuffer.append(genModel.getCopyrightText());
    stringBuffer.append(TEXT_12);
    stringBuffer.append(genModel.getNonNLS());
    stringBuffer.append(TEXT_13);
    }
    stringBuffer.append(TEXT_14);
    stringBuffer.append(genPackage.getValidatorClassName());
    stringBuffer.append(TEXT_15);
    stringBuffer.append(genPackage.getValidatorClassName());
    stringBuffer.append(TEXT_16);
    stringBuffer.append(genPackage.getInterfacePackageName());
    stringBuffer.append(TEXT_17);
    int count = 0; for (Iterator i=genPackage.getGenClasses().iterator(); i.hasNext();) { GenClass genClass = (GenClass)i.next();
    for (Iterator j=genClass.getGenOperations().iterator(); j.hasNext();) { GenOperation genOperation = (GenOperation)j.next();
    if (genOperation.isInvariant()) {
    stringBuffer.append(TEXT_18);
    stringBuffer.append(genClass.format(genOperation.getName(), ' ', null, true));
    stringBuffer.append(TEXT_19);
    stringBuffer.append(genClass.getFormattedName());
    stringBuffer.append(TEXT_20);
    stringBuffer.append(genClass.getClassifierID());
    stringBuffer.append(TEXT_21);
    stringBuffer.append(genClass.format(genOperation.getName(), '_', null, false).toUpperCase());
    stringBuffer.append(TEXT_22);
    stringBuffer.append(++count);
    stringBuffer.append(TEXT_23);
    }}}
    stringBuffer.append(TEXT_24);
    stringBuffer.append(count);
    stringBuffer.append(TEXT_25);
    for (Iterator i = genPackage.getAllValidatorBaseGenPackages().iterator(); i.hasNext(); ) { GenPackage baseGenPackage = (GenPackage)i.next(); 
    stringBuffer.append(TEXT_26);
    stringBuffer.append(baseGenPackage.getImportedValidatorClassName());
    stringBuffer.append(TEXT_27);
    stringBuffer.append(genPackage.getValidatorPackageUniqueSafeName(baseGenPackage));
    stringBuffer.append(TEXT_28);
    }
    stringBuffer.append(TEXT_29);
    stringBuffer.append(genPackage.getValidatorClassName());
    stringBuffer.append(TEXT_30);
    for (Iterator i = genPackage.getAllValidatorBaseGenPackages().iterator(); i.hasNext(); ) { GenPackage baseGenPackage = (GenPackage)i.next(); 
    stringBuffer.append(TEXT_31);
    stringBuffer.append(genPackage.getValidatorPackageUniqueSafeName(baseGenPackage));
    stringBuffer.append(TEXT_32);
    stringBuffer.append(baseGenPackage.getImportedValidatorClassName());
    stringBuffer.append(TEXT_33);
    }
    stringBuffer.append(TEXT_34);
    stringBuffer.append(genPackage.getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_35);
    for (Iterator i=genPackage.getGenClassifiers().iterator(); i.hasNext();) { GenClassifier genClassifier = (GenClassifier)i.next();
    stringBuffer.append(TEXT_36);
    stringBuffer.append(genPackage.getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_37);
    stringBuffer.append(genPackage.getClassifierID(genClassifier));
    stringBuffer.append(TEXT_38);
    if (genClassifier instanceof GenDataType) { GenDataType genDataType = (GenDataType)genClassifier;
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_39);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_40);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_41);
    stringBuffer.append(genDataType.getPrimitiveValueFunction());
    stringBuffer.append(TEXT_42);
    } else if (genDataType.isObjectType()) {
    stringBuffer.append(TEXT_43);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_44);
    } else {
    stringBuffer.append(TEXT_45);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_46);
    stringBuffer.append(genDataType.getImportedInstanceClassName());
    stringBuffer.append(TEXT_47);
    }
    } else { GenClass genClass = (GenClass)genClassifier;
    stringBuffer.append(TEXT_48);
    stringBuffer.append(genClass.getName());
    stringBuffer.append(TEXT_49);
    stringBuffer.append(genClass.getImportedInterfaceName());
    stringBuffer.append(TEXT_50);
    }
    }
    stringBuffer.append(TEXT_51);
    for (Iterator i=genPackage.getGenClassifiers().iterator(); i.hasNext();) { GenClassifier genClassifier = (GenClassifier)i.next(); String result = "result".equals(genClassifier.getSafeUncapName()) ? "theResult" : "result"; String diagnostics = "diagnostics".equals(genClassifier.getSafeUncapName()) ? "theDiagnostics" : "diagnostics"; String item = "item".equals(genClassifier.getSafeUncapName()) ? "theItem" : "item"; String context = "context".equals(genClassifier.getSafeUncapName()) ? "theContext" : "context";
    stringBuffer.append(TEXT_52);
    stringBuffer.append(genClassifier.getName());
    stringBuffer.append(TEXT_53);
    stringBuffer.append(genClassifier.getImportedInstanceClassName());
    stringBuffer.append(TEXT_54);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_55);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_56);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_57);
    if (genClassifier.getAllGenConstraints().isEmpty()) {
    stringBuffer.append(TEXT_58);
    } else if (genClassifier.hasOnlyDefaultConstraints()) {
    stringBuffer.append(TEXT_59);
    if (!((GenClass)genClassifier).isEObjectExtension()){
    stringBuffer.append(TEXT_60);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.EObject"));
    stringBuffer.append(TEXT_61);
    }
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_62);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_63);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_64);
    } else { boolean first = true;
    for (Iterator j=genClassifier.getAllGenConstraints().iterator(); j.hasNext(); ) { String constraint = (String)j.next(); 
  GenClassifier constraintImplementor = genClassifier.getConstraintImplementor(constraint); 
  String delegate = constraintImplementor == null || constraintImplementor.getGenPackage() == genPackage ? "" : genPackage.getValidatorPackageUniqueSafeName(constraintImplementor.getGenPackage()) + "Validator."; 
  String cast = constraintImplementor == null && genClassifier instanceof GenClass && !((GenClass)genClassifier).isEObjectExtension() ? "(" + genModel.getImportedName("org.eclipse.emf.ecore.EObject") + ")" : "";
  String accessor = constraintImplementor != null && genClassifier instanceof GenDataType && !((GenDataType)genClassifier).isPrimitiveType() && ((GenDataType)constraintImplementor).isPrimitiveType() ? "." + ((GenDataType)constraintImplementor).getPrimitiveValueFunction() + "()" : "";
    if (first) { first = false;
    stringBuffer.append(TEXT_65);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_66);
    stringBuffer.append(delegate);
    stringBuffer.append(TEXT_67);
    stringBuffer.append(constraintImplementor == null ? "" : constraintImplementor.getName());
    stringBuffer.append(TEXT_68);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_69);
    stringBuffer.append(cast);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(accessor);
    stringBuffer.append(TEXT_70);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_71);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_72);
    } else {
    stringBuffer.append(TEXT_73);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_74);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_75);
    stringBuffer.append(delegate);
    stringBuffer.append(TEXT_76);
    stringBuffer.append(constraintImplementor == null ? "" : constraintImplementor.getName());
    stringBuffer.append(TEXT_77);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_78);
    stringBuffer.append(cast);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(accessor);
    stringBuffer.append(TEXT_79);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_80);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_81);
    }
    }
    stringBuffer.append(TEXT_82);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_83);
    }
    stringBuffer.append(TEXT_84);
    for (Iterator j=genClassifier.getGenConstraints().iterator(); j.hasNext();) 
{ String constraint = (String)j.next();
  GenClassifier constraintDelegate = genClassifier.getConstraintDelegate(constraint); 
  String constant = genClassifier.getClassifierID() + "__" + genClassifier.format(constraint, '_', null, false).toUpperCase();
  String delegate = constraintDelegate == null || constraintDelegate.getGenPackage() == genPackage ? "" : genPackage.getValidatorPackageUniqueSafeName(constraintDelegate.getGenPackage()) + "Validator."; 
  String cast = constraintDelegate == null && genClassifier instanceof GenClass && !((GenClass)genClassifier).isEObjectExtension() ? "(" + genModel.getImportedName("org.eclipse.emf.ecore.EObject") + ")" : "";
  String accessor = constraintDelegate != null && genClassifier instanceof GenDataType && !((GenDataType)genClassifier).isPrimitiveType() && ((GenDataType)constraintDelegate).isPrimitiveType() ? "." + ((GenDataType)constraintDelegate).getPrimitiveValueFunction() + "()" : "";
    if (genClassifier instanceof GenDataType) { GenDataType genDataType = (GenDataType)genClassifier;
    if (constraint.equals("Min") && genDataType.getMinLiteral() != null) {
    stringBuffer.append(TEXT_85);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_86);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_87);
    stringBuffer.append(genDataType.getImportedInstanceClassName());
    stringBuffer.append(TEXT_88);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_89);
    stringBuffer.append(genDataType.getStaticValue(genDataType.getMinLiteral()));
    stringBuffer.append(TEXT_90);
    } else if (constraint.equals("Max") && genDataType.getMaxLiteral() != null) {
    stringBuffer.append(TEXT_91);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_92);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_93);
    stringBuffer.append(genDataType.getImportedInstanceClassName());
    stringBuffer.append(TEXT_94);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_95);
    stringBuffer.append(genDataType.getStaticValue(genDataType.getMaxLiteral()));
    stringBuffer.append(TEXT_96);
    } else if (constraint.equals("TotalDigits") && genDataType.getTotalDigits() != -1 && !"java.math.BigDecimal".equals(genDataType.getQualifiedInstanceClassName())) { String value = "1"; for (int digitCount = genDataType.getTotalDigits(); digitCount > 0; --digitCount) value += "0"; 
    stringBuffer.append(TEXT_97);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_98);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_99);
    stringBuffer.append(genDataType.getImportedInstanceClassName());
    stringBuffer.append(TEXT_100);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_101);
    stringBuffer.append(genDataType.getStaticValue(value));
    stringBuffer.append(TEXT_102);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_103);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_104);
    stringBuffer.append(genDataType.getImportedInstanceClassName());
    stringBuffer.append(TEXT_105);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_106);
    stringBuffer.append(genDataType.getStaticValue("-" + value));
    stringBuffer.append(TEXT_107);
    } else if (constraint.equals("Pattern") && !genDataType.getPatterns().isEmpty()) {
    stringBuffer.append(TEXT_108);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_109);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_110);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_111);
    for (Iterator k = genDataType.getPatterns().iterator(); k.hasNext(); ) { List patternList = (List)k.next();
    stringBuffer.append(TEXT_112);
    for (Iterator p = patternList.iterator(); p.hasNext(); ) { String pattern = (String)p.next();
    stringBuffer.append(TEXT_113);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil"));
    stringBuffer.append(TEXT_114);
    stringBuffer.append(pattern);
    stringBuffer.append(TEXT_115);
    stringBuffer.append(p.hasNext() ? "," : "");
    }
    stringBuffer.append(TEXT_116);
    stringBuffer.append(k.hasNext() ? "," : "");
    }
    stringBuffer.append(TEXT_117);
    } else if (constraint.equals("Enumeration") && !genDataType.getEnumerationLiterals().isEmpty()) {
    stringBuffer.append(TEXT_118);
    stringBuffer.append(genDataType.getName());
    stringBuffer.append(TEXT_119);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_120);
    stringBuffer.append(genModel.getImportedName("java.util.Collection"));
    stringBuffer.append(TEXT_121);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_122);
    for (Iterator k = genDataType.getEnumerationLiterals().iterator(); k.hasNext(); ) { String literal = (String)k.next();
    stringBuffer.append(TEXT_123);
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_124);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_125);
    }
    stringBuffer.append(genDataType.getStaticValue(literal));
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_126);
    }
    stringBuffer.append(k.hasNext() ? "," : "");
    }
    stringBuffer.append(TEXT_127);
    }
    }
    stringBuffer.append(TEXT_128);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_129);
    stringBuffer.append(genClassifier.getFormattedName());
    stringBuffer.append(TEXT_130);
    stringBuffer.append(genClassifier.getName());
    stringBuffer.append(TEXT_131);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_132);
    stringBuffer.append(genClassifier.getImportedInstanceClassName());
    stringBuffer.append(TEXT_133);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_134);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_135);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_136);
    if (genClassifier instanceof GenDataType) { GenDataType genDataType = (GenDataType)genClassifier;
    if (constraint.equals("ItemType") && genDataType.getItemType() != null) { GenDataType itemType = genDataType.getItemType(); String itemDelegate = itemType.getGenPackage() == genPackage ? "" : genPackage.getValidatorPackageUniqueSafeName(itemType.getGenPackage()) + "Validator.";
    stringBuffer.append(TEXT_137);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_138);
    stringBuffer.append(genModel.getImportedName("java.util.Iterator"));
    stringBuffer.append(TEXT_139);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_140);
    stringBuffer.append(itemType.getGenPackage().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_141);
    stringBuffer.append(itemType.getClassifierAccessorName());
    stringBuffer.append(TEXT_142);
    stringBuffer.append(itemDelegate);
    stringBuffer.append(TEXT_143);
    stringBuffer.append(itemType.getName());
    stringBuffer.append(TEXT_144);
    if (itemType.isPrimitiveType()) {
    stringBuffer.append(TEXT_145);
    }
    stringBuffer.append(TEXT_146);
    stringBuffer.append(itemType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_147);
    stringBuffer.append(item);
    if (itemType.isPrimitiveType()) {
    stringBuffer.append(TEXT_148);
    stringBuffer.append(itemType.getPrimitiveValueFunction());
    stringBuffer.append(TEXT_149);
    }
    stringBuffer.append(TEXT_150);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_151);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_152);
    stringBuffer.append(itemType.getGenPackage().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_153);
    stringBuffer.append(itemType.getClassifierAccessorName());
    stringBuffer.append(TEXT_154);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_155);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_156);
    } else if (constraint.equals("MemberTypes") && !genDataType.getMemberTypes().isEmpty()) {
    stringBuffer.append(TEXT_157);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_158);
    for (ListIterator k = genDataType.getMemberTypes().listIterator(); k.hasNext(); ) { GenDataType memberType = (GenDataType)k.next(); String memberDelegate = memberType.getGenPackage() == genPackage ? "" : genPackage.getValidatorPackageUniqueSafeName(memberType.getGenPackage()) + "Validator.";
    stringBuffer.append(TEXT_159);
    if (k.previousIndex() != 0){
    stringBuffer.append(TEXT_160);
    }
    stringBuffer.append(TEXT_161);
    stringBuffer.append(memberType.getGenPackage().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_162);
    stringBuffer.append(memberType.getClassifierAccessorName());
    stringBuffer.append(TEXT_163);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_164);
    stringBuffer.append(memberDelegate);
    stringBuffer.append(TEXT_165);
    stringBuffer.append(memberType.getName());
    stringBuffer.append(TEXT_166);
    if (memberType.isPrimitiveType()) {
    stringBuffer.append(TEXT_167);
    }
    stringBuffer.append(TEXT_168);
    stringBuffer.append(memberType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_169);
    stringBuffer.append(genClassifier.getSafeUncapName());
    if (memberType.isPrimitiveType()) {
    stringBuffer.append(TEXT_170);
    stringBuffer.append(memberType.getPrimitiveValueFunction());
    stringBuffer.append(TEXT_171);
    }
    stringBuffer.append(TEXT_172);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_173);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_174);
    }
    stringBuffer.append(TEXT_175);
    } else if (constraint.equals("Pattern") && !genDataType.getPatterns().isEmpty()) {
    stringBuffer.append(TEXT_176);
    stringBuffer.append(genDataType.getGenPackage().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_177);
    stringBuffer.append(genDataType.getClassifierAccessorName());
    stringBuffer.append(TEXT_178);
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_179);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_180);
    }
    stringBuffer.append(genDataType.getSafeUncapName());
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_181);
    }
    stringBuffer.append(TEXT_182);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_183);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_184);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_185);
    } else if (constraint.equals("Enumeration") && !genDataType.getEnumerationLiterals().isEmpty()) { String variable = genDataType.getSafeUncapName();
    if (genDataType.isPrimitiveType()) { variable = variable + "Object";
    stringBuffer.append(TEXT_186);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_187);
    stringBuffer.append(variable);
    stringBuffer.append(TEXT_188);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_189);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_190);
    }
    stringBuffer.append(TEXT_191);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_192);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_193);
    stringBuffer.append(variable);
    stringBuffer.append(TEXT_194);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_195);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_196);
    stringBuffer.append(genDataType.getGenPackage().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_197);
    stringBuffer.append(genDataType.getClassifierAccessorName());
    stringBuffer.append(TEXT_198);
    stringBuffer.append(variable);
    stringBuffer.append(TEXT_199);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_200);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_201);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_202);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_203);
    } else if (constraint.equals("Min") && genDataType.getMinLiteral() != null) {
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_204);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_205);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_206);
    stringBuffer.append(genDataType.isMinInclusive() ? ">=" : ">");
    stringBuffer.append(TEXT_207);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_208);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_209);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_210);
    stringBuffer.append(genDataType.getGenPackage().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_211);
    stringBuffer.append(genDataType.getClassifierAccessorName());
    stringBuffer.append(TEXT_212);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_213);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_214);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_215);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_216);
    stringBuffer.append(genDataType.isMinInclusive() ? "true" : "false");
    stringBuffer.append(TEXT_217);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_218);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_219);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_220);
    } else { String comparison = "comparison".equals(genClassifier.getSafeUncapName()) ? "theComparison" : "comparison";
    if (genDataType.isXMLCalendar()) {
    stringBuffer.append(TEXT_221);
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_222);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil"));
    stringBuffer.append(TEXT_223);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_224);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_225);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_226);
    if (genDataType.isMinInclusive()) {
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_227);
    }
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_228);
    } else if (genDataType.isXMLDuration()) {
    stringBuffer.append(TEXT_229);
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_230);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil"));
    stringBuffer.append(TEXT_231);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_232);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_233);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_234);
    if (genDataType.isMinInclusive()) {
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_235);
    }
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_236);
    } else {
    stringBuffer.append(TEXT_237);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_238);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_239);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_240);
    stringBuffer.append(genDataType.isMinInclusive() ? ">=" : ">");
    stringBuffer.append(TEXT_241);
    }
    stringBuffer.append(TEXT_242);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_243);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_244);
    stringBuffer.append(genDataType.getGenPackage().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_245);
    stringBuffer.append(genDataType.getClassifierAccessorName());
    stringBuffer.append(TEXT_246);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_247);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_248);
    stringBuffer.append(genDataType.isMinInclusive() ? "true" : "false");
    stringBuffer.append(TEXT_249);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_250);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_251);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_252);
    }
    } else if (constraint.equals("Max") && genDataType.getMaxLiteral() != null) {
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_253);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_254);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_255);
    stringBuffer.append(genDataType.isMaxInclusive() ? "<=" : "<");
    stringBuffer.append(TEXT_256);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_257);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_258);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_259);
    stringBuffer.append(genDataType.getGenPackage().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_260);
    stringBuffer.append(genDataType.getClassifierAccessorName());
    stringBuffer.append(TEXT_261);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_262);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_263);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_264);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_265);
    stringBuffer.append(genDataType.isMaxInclusive() ? "true" : "false");
    stringBuffer.append(TEXT_266);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_267);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_268);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_269);
    } else { String comparison = "comparison".equals(genClassifier.getSafeUncapName()) ? "theComparison" : "comparison";
    if (genDataType.isXMLCalendar()) {
    stringBuffer.append(TEXT_270);
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_271);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil"));
    stringBuffer.append(TEXT_272);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_273);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_274);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_275);
    if (genDataType.isMaxInclusive()) {
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_276);
    }
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_277);
    } else if (genDataType.isXMLDuration()) {
    stringBuffer.append(TEXT_278);
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_279);
    stringBuffer.append(genModel.getImportedName("org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil"));
    stringBuffer.append(TEXT_280);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_281);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_282);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_283);
    if (genDataType.isMaxInclusive()) {
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_284);
    }
    stringBuffer.append(comparison);
    stringBuffer.append(TEXT_285);
    } else {
    stringBuffer.append(TEXT_286);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_287);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_288);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_289);
    stringBuffer.append(genDataType.isMaxInclusive() ? "<=" : "<");
    stringBuffer.append(TEXT_290);
    }
    stringBuffer.append(TEXT_291);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_292);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_293);
    stringBuffer.append(genDataType.getGenPackage().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_294);
    stringBuffer.append(genDataType.getClassifierAccessorName());
    stringBuffer.append(TEXT_295);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_296);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_297);
    stringBuffer.append(genDataType.isMaxInclusive() ? "true" : "false");
    stringBuffer.append(TEXT_298);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_299);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_300);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_301);
    }
    } else if (constraint.equals("MinLength") && genDataType.getMinLength() != -1) {
    stringBuffer.append(TEXT_302);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_303);
    stringBuffer.append(genDataType.getLengthAccessorFunction());
    stringBuffer.append(TEXT_304);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_305);
    stringBuffer.append(genDataType.getMinLength());
    stringBuffer.append(TEXT_306);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_307);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_308);
    stringBuffer.append(genDataType.getGenPackage().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_309);
    stringBuffer.append(genDataType.getClassifierAccessorName());
    stringBuffer.append(TEXT_310);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_311);
    stringBuffer.append(genDataType.getMinLength());
    stringBuffer.append(TEXT_312);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_313);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_314);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_315);
    } else if (constraint.equals("MaxLength") && genDataType.getMaxLength() != -1) {
    stringBuffer.append(TEXT_316);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_317);
    stringBuffer.append(genDataType.getLengthAccessorFunction());
    stringBuffer.append(TEXT_318);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_319);
    stringBuffer.append(genDataType.getMaxLength());
    stringBuffer.append(TEXT_320);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_321);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_322);
    stringBuffer.append(genDataType.getGenPackage().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_323);
    stringBuffer.append(genDataType.getClassifierAccessorName());
    stringBuffer.append(TEXT_324);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_325);
    stringBuffer.append(genDataType.getMaxLength());
    stringBuffer.append(TEXT_326);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_327);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_328);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_329);
    } else if (constraint.equals("TotalDigits") && genDataType.getTotalDigits() != -1) {
    if (genDataType.isPrimitiveType()) {
    stringBuffer.append(TEXT_330);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_331);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_332);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_333);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_334);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_335);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_336);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_337);
    stringBuffer.append(genDataType.getGenPackage().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_338);
    stringBuffer.append(genDataType.getClassifierAccessorName());
    stringBuffer.append(TEXT_339);
    stringBuffer.append(genDataType.getObjectInstanceClassName());
    stringBuffer.append(TEXT_340);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_341);
    stringBuffer.append(genDataType.getTotalDigits());
    stringBuffer.append(TEXT_342);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_343);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_344);
    } else if ("java.math.BigDecimal".equals(genDataType.getQualifiedInstanceClassName())) {
    stringBuffer.append(TEXT_345);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_346);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_347);
    stringBuffer.append(genDataType.getTotalDigits());
    stringBuffer.append(TEXT_348);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_349);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_350);
    stringBuffer.append(genDataType.getGenPackage().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_351);
    stringBuffer.append(genDataType.getClassifierAccessorName());
    stringBuffer.append(TEXT_352);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_353);
    stringBuffer.append(genDataType.getTotalDigits());
    stringBuffer.append(TEXT_354);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_355);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_356);
    } else {
    stringBuffer.append(TEXT_357);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_358);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_359);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_360);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_361);
    stringBuffer.append(constant);
    stringBuffer.append(TEXT_362);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_363);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_364);
    stringBuffer.append(genDataType.getGenPackage().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_365);
    stringBuffer.append(genDataType.getClassifierAccessorName());
    stringBuffer.append(TEXT_366);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_367);
    stringBuffer.append(genDataType.getTotalDigits());
    stringBuffer.append(TEXT_368);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_369);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_370);
    }
    stringBuffer.append(TEXT_371);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_372);
    } else if (constraint.equals("FractionDigits") && genDataType.getFractionDigits() != -1 && "java.math.BigDecimal".equals(genDataType.getQualifiedInstanceClassName())) {
    stringBuffer.append(TEXT_373);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_374);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_375);
    stringBuffer.append(genDataType.getFractionDigits());
    stringBuffer.append(TEXT_376);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_377);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_378);
    stringBuffer.append(genDataType.getGenPackage().getImportedPackageInterfaceName());
    stringBuffer.append(TEXT_379);
    stringBuffer.append(genDataType.getClassifierAccessorName());
    stringBuffer.append(TEXT_380);
    stringBuffer.append(genDataType.getSafeUncapName());
    stringBuffer.append(TEXT_381);
    stringBuffer.append(genDataType.getFractionDigits());
    stringBuffer.append(TEXT_382);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_383);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_384);
    stringBuffer.append(result);
    stringBuffer.append(TEXT_385);
    } else if (constraintDelegate != null) {
    stringBuffer.append(TEXT_386);
    stringBuffer.append(delegate);
    stringBuffer.append(TEXT_387);
    stringBuffer.append(constraintDelegate.getName());
    stringBuffer.append(TEXT_388);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_389);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(accessor);
    stringBuffer.append(TEXT_390);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_391);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_392);
    } else {
    stringBuffer.append(TEXT_393);
    }
    } else if (constraintDelegate != null) {
    stringBuffer.append(TEXT_394);
    stringBuffer.append(delegate);
    stringBuffer.append(TEXT_395);
    stringBuffer.append(constraintDelegate.getName());
    stringBuffer.append(TEXT_396);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_397);
    stringBuffer.append(cast);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_398);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_399);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_400);
    } else { GenOperation genOperation = ((GenClass)genClassifier).getInvariantOperation(constraint); if (genOperation != null) {
    stringBuffer.append(TEXT_401);
    stringBuffer.append(genClassifier.getSafeUncapName());
    stringBuffer.append(TEXT_402);
    stringBuffer.append(constraint);
    stringBuffer.append(TEXT_403);
    stringBuffer.append(diagnostics);
    stringBuffer.append(TEXT_404);
    stringBuffer.append(context);
    stringBuffer.append(TEXT_405);
    } else {
    stringBuffer.append(TEXT_406);
    }}
    stringBuffer.append(TEXT_407);
    }
    }
    stringBuffer.append(TEXT_408);
    stringBuffer.append(genPackage.getValidatorClassName());
    genModel.emitSortedImports();
    stringBuffer.append(TEXT_409);
    return stringBuffer.toString();
  }
}
