/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class DelegatingCommandAction
extends Action
implements ISelectionListener,
ISelectionChangedListener {
    protected IEditorActionDelegate editorActionDelegate;
    protected IEditorPart editorPart;

    public DelegatingCommandAction(IEditorActionDelegate editorActionDelegate) {
        this.editorActionDelegate = editorActionDelegate;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.handleSelection(event.getSelection());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.handleSelection(selection);
    }

    protected void selectionChanged(ISelection selection) {
        this.editorActionDelegate.selectionChanged((IAction)this, selection);
    }

    protected void handleSelection(ISelection selection) {
        this.selectionChanged(selection);
    }

    protected void registerSelectionListener(IEditorPart editorPart) {
        ISelectionProvider selectionProvider = editorPart.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            this.handleSelection(selectionProvider.getSelection());
        }
    }

    protected void unregisterSelectionListener(IEditorPart editorPart) {
        ISelectionProvider selectionProvider = editorPart.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public void setActiveEditor(IEditorPart editorPart) {
        if (this.editorPart != editorPart) {
            if (this.editorPart != null) {
                this.unregisterSelectionListener(this.editorPart);
            }
            this.editorPart = editorPart;
            this.editorActionDelegate.setActiveEditor((IAction)this, editorPart);
            if (editorPart != null) {
                this.registerSelectionListener(editorPart);
            }
        }
    }

    public void run() {
        this.editorActionDelegate.run((IAction)this);
    }
}

