/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: BasicESequence.java,v 1.2.2.1 2005/06/08 18:25:21 nickb Exp $
 */
package org.eclipse.emf.ecore.sdo.util;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

import commonj.sdo.Property;

/**
 *  Delegates to a feature map
 */
public class BasicESequence implements ESequence
{
  protected FeatureMap.Internal featureMap;

  public BasicESequence(FeatureMap.Internal featureMap)
  {
    this.featureMap = featureMap;
  }

  public FeatureMap featureMap()
  {
    return featureMap;
  }

  public int size()
  {
    return featureMap.size();
  }

  public Property getProperty(int index)
  {
    return SDOUtil.adaptProperty(featureMap.getEStructuralFeature(index));
  }
  
  public Object getValue(int index)
  {
    return featureMap.getValue(index);
  }
  
  public Object setValue(int index, Object value)
  {
    return featureMap.setValue(index, value);
  }

  protected EStructuralFeature getEStructuralFeature(String propertyName)
  {
    return featureMap.getEObject().eClass().getEStructuralFeature(propertyName);
  }

  protected EStructuralFeature getEStructuralFeature(int propertyIndex)
  {
    return (EStructuralFeature)featureMap.getEObject().eClass().getEAllStructuralFeatures().get(propertyIndex);
  }

  public boolean add(String propertyName, Object value)
  {
    return featureMap.add(getEStructuralFeature(propertyName), value);
  }

  public boolean add(int propertyIndex, Object value)
  {
    return featureMap.add(getEStructuralFeature(propertyIndex), value);
  }

  public boolean add(Property property, Object value)
  {
    return featureMap.add(((EProperty)property).getEStructuralFeature(), value);
  }

  public void add(int index, String propertyName, Object value)
  {
    featureMap.add(index, getEStructuralFeature(propertyName), value);
  }

  public void add(int index, int propertyIndex, Object value)
  {
    featureMap.add(index, getEStructuralFeature(propertyIndex), value);
  }

  public void add(int index, Property property, Object value)
  {
    featureMap.add(index, ((EProperty)property).getEStructuralFeature(), value);
  }

  public void add(String text)
  {
    FeatureMapUtil.addText(featureMap, text);
  }

  public void add(int index, String text)
  {
    FeatureMapUtil.addText(featureMap, index, text);
  }
 
  public void remove(int index)
  {
    featureMap.remove(index);
  }

  public void move(int toIndex, int fromIndex)
  {
    featureMap.move(toIndex, fromIndex);
  }

  public String toString()
  {
    return featureMap.toString();
  }
}
