/**
 * <copyright>
 *
 * Copyright (c) 2002-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: AddRootTopAction.java,v 1.1.2.1 2005/06/08 18:27:44 nickb Exp $
 */
package org.eclipse.emf.mapping.action;


import java.util.Collection;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;

import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.ui.action.CommandAction;
import org.eclipse.emf.mapping.MappingPackage;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.domain.MappingDomain;


/**
 * This adds new root inputs to the mapping domain's root mapping.
 */
public class AddRootTopAction extends CommandAction 
{
  /**
   * This method should be overriden with a domain-specific implementation 
   * that returns the inputs to be added, e.g., by querying the user with a dialog.
   */
  protected Collection getTopsToAdd()
  {
    return null;
  }

  /**
   * This action ignores the selection.
   */
  public void selectionChanged(IAction action, ISelection selection) 
  {
  }

  public void run(IAction action)
  {
    Collection additions = getTopsToAdd();
    MappingRoot mappingRoot = ((MappingDomain)editingDomain).getMappingRoot();
    command = AddCommand.create
      (editingDomain, 
       mappingRoot, 
       mappingRoot.isTopToBottom() ?
         //mappingRoot.ePackageMapping().getMapping_Inputs() :
         //mappingRoot.ePackageMapping().getMapping_Outputs(),
         MappingPackage.eINSTANCE.getMapping_Inputs() :
         MappingPackage.eINSTANCE.getMapping_Outputs(),
       additions);

    super.run(action);
  }

  public void setActiveEditor(IAction action, IEditorPart editorPart)
  {
    super.setActiveEditor(action, editorPart);
    action.setEnabled(true);
  }
}
