/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.resource.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.NotifierImpl;
import org.eclipse.emf.common.notify.impl.NotifyingListImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class ResourceSetImpl
extends NotifierImpl
implements ResourceSet {
    protected EList resources;
    protected EList adapterFactories;
    protected Map loadOptions;
    protected Resource.Factory.Registry resourceFactoryRegistry;
    protected URIConverter uriConverter;
    protected EPackage.Registry packageRegistry;
    protected Map uriResourceMap;

    public Map getURIResourceMap() {
        return this.uriResourceMap;
    }

    public void setURIResourceMap(Map uriResourceMap) {
        this.uriResourceMap = uriResourceMap;
    }

    public EList getResources() {
        if (this.resources == null) {
            this.resources = new ResourcesEList();
        }
        return this.resources;
    }

    public TreeIterator getAllContents() {
        return EcoreUtil.getAllContents(Collections.singleton(this));
    }

    public EList getAdapterFactories() {
        if (this.adapterFactories == null) {
            this.adapterFactories = new BasicEList(){

                protected boolean useEquals() {
                    return false;
                }

                protected boolean isUnique() {
                    return true;
                }

                protected Object[] newData(int capacity) {
                    return new AdapterFactory[capacity];
                }
            };
        }
        return this.adapterFactories;
    }

    public Map getLoadOptions() {
        if (this.loadOptions == null) {
            this.loadOptions = new HashMap();
        }
        return this.loadOptions;
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        Resource resource = this.getResource(uri.trimFragment(), loadOnDemand);
        if (resource != null) {
            return resource.getEObject(uri.fragment());
        }
        return null;
    }

    protected Resource demandCreateResource(URI uri) {
        return this.createResource(uri);
    }

    protected void demandLoad(Resource resource) throws IOException {
        resource.load(this.getLoadOptions());
    }

    protected void demandLoadHelper(Resource resource) {
        try {
            this.demandLoad(resource);
        }
        catch (Resource.IOWrappedException exception) {
            throw new WrappedException(exception.getWrappedException());
        }
        catch (IOException exception) {
            throw new WrappedException((Exception)exception);
        }
    }

    protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
        EPackage ePackage = this.getPackageRegistry().getEPackage(uri.toString());
        return ePackage == null ? null : ePackage.eResource();
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Resource resource;
        Resource resource2;
        if (this.getURIResourceMap() != null && (resource2 = (Resource)this.getURIResourceMap().get(uri)) != null) {
            if (loadOnDemand && !resource2.isLoaded()) {
                this.demandLoadHelper(resource2);
            }
            return resource2;
        }
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        Iterator i = this.getResources().iterator();
        while (i.hasNext()) {
            resource = (Resource)i.next();
            if (!theURIConverter.normalize(resource.getURI()).equals((Object)normalizedURI)) continue;
            if (loadOnDemand && !resource.isLoaded()) {
                this.demandLoadHelper(resource);
            }
            if (this.getURIResourceMap() != null) {
                this.getURIResourceMap().put(uri, resource);
            }
            return resource;
        }
        Resource delegatedResource = this.delegatedGetResource(uri, loadOnDemand);
        if (delegatedResource != null) {
            if (this.getURIResourceMap() != null) {
                this.getURIResourceMap().put(uri, delegatedResource);
            }
            return delegatedResource;
        }
        if (loadOnDemand) {
            resource = this.demandCreateResource(uri);
            if (resource == null) {
                throw new RuntimeException("Cannot create a resource for '" + uri + "'; a registered resource factory is needed");
            }
            this.demandLoadHelper(resource);
            if (this.getURIResourceMap() != null) {
                this.getURIResourceMap().put(uri, resource);
            }
            return resource;
        }
        return null;
    }

    public Resource createResource(URI uri) {
        Resource.Factory resourceFactory = this.getResourceFactoryRegistry().getFactory(uri);
        if (resourceFactory != null) {
            Resource result = resourceFactory.createResource(uri);
            this.getResources().add((Object)result);
            return result;
        }
        return null;
    }

    public Resource.Factory.Registry getResourceFactoryRegistry() {
        if (this.resourceFactoryRegistry == null) {
            this.resourceFactoryRegistry = new ResourceFactoryRegistryImpl(){

                public Resource.Factory delegatedGetFactory(URI uri) {
                    return Resource.Factory.Registry.INSTANCE.getFactory(uri);
                }
            };
        }
        return this.resourceFactoryRegistry;
    }

    public void setResourceFactoryRegistry(Resource.Factory.Registry resourceFactoryRegistry) {
        this.resourceFactoryRegistry = resourceFactoryRegistry;
    }

    public URIConverter getURIConverter() {
        if (this.uriConverter == null) {
            this.uriConverter = new URIConverterImpl();
        }
        return this.uriConverter;
    }

    public void setURIConverter(URIConverter uriConverter) {
        this.uriConverter = uriConverter;
    }

    public EPackage.Registry getPackageRegistry() {
        if (this.packageRegistry == null) {
            this.packageRegistry = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
        }
        return this.packageRegistry;
    }

    public void setPackageRegistry(EPackage.Registry packageRegistry) {
        this.packageRegistry = packageRegistry;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '@' + Integer.toHexString(this.hashCode()) + " resources=" + (this.resources == null ? "[]" : this.resources.toString());
    }

    protected class ResourcesEList
    extends NotifyingListImpl
    implements InternalEList {
        protected ResourcesEList() {
        }

        protected boolean isNotificationRequired() {
            return ResourceSetImpl.this.eNotificationRequired();
        }

        protected Object[] newData(int capacity) {
            return new Resource[capacity];
        }

        public Object getNotifier() {
            return ResourceSetImpl.this;
        }

        public int getFeatureID() {
            return 0;
        }

        protected boolean useEquals() {
            return false;
        }

        protected boolean hasInverse() {
            return true;
        }

        protected boolean isUnique() {
            return true;
        }

        protected NotificationChain inverseAdd(Object object, NotificationChain notifications) {
            Resource.Internal resource = (Resource.Internal)object;
            return resource.basicSetResourceSet(ResourceSetImpl.this, notifications);
        }

        protected NotificationChain inverseRemove(Object object, NotificationChain notifications) {
            Resource.Internal resource = (Resource.Internal)object;
            if (ResourceSetImpl.this.getURIResourceMap() != null) {
                Iterator i = ResourceSetImpl.this.getURIResourceMap().values().iterator();
                while (i.hasNext()) {
                    if (resource != i.next()) continue;
                    i.remove();
                }
            }
            return resource.basicSetResourceSet(null, notifications);
        }

        public Iterator basicIterator() {
            return super.basicIterator();
        }

        public ListIterator basicListIterator() {
            return super.basicListIterator();
        }

        public ListIterator basicListIterator(int index) {
            return super.basicListIterator(index);
        }

        public List basicList() {
            return super.basicList();
        }
    }
}

