/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.DanglingHREFException;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMLString;
import org.eclipse.emf.ecore.xml.namespace.XMLNamespacePackage;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

public class XMLSaveImpl
implements XMLSave {
    protected XMLHelper helper;
    protected XMLString doc;
    protected boolean declareXSI;
    protected boolean useEncodedAttributeStyle;
    protected boolean declareXML;
    protected boolean saveTypeInfo;
    protected Escape escape;
    protected Lookup featureTable;
    protected String encoding;
    protected String idAttributeName = "id";
    protected String processDanglingHREF;
    protected boolean declareSchemaLocation;
    protected boolean declareSchemaLocationImplementation;
    protected XMLResource.XMLMap map;
    protected ExtendedMetaData extendedMetaData;
    protected EClass anySimpleType;
    protected EClass anyType;
    protected Map eObjectToExtensionMap;
    protected EPackage xmlSchemaTypePackage = XMLTypePackage.eINSTANCE;
    protected int flushThreshold = Integer.MAX_VALUE;
    protected static final int SKIP = 0;
    protected static final int SAME_DOC = 1;
    protected static final int CROSS_DOC = 2;
    protected static final int TRANSIENT = 0;
    protected static final int DATATYPE_SINGLE = 1;
    protected static final int DATATYPE_ELEMENT_SINGLE = 2;
    protected static final int DATATYPE_CONTENT_SINGLE = 3;
    protected static final int DATATYPE_SINGLE_NILLABLE = 4;
    protected static final int DATATYPE_MANY = 5;
    protected static final int OBJECT_CONTAIN_SINGLE = 6;
    protected static final int OBJECT_CONTAIN_MANY = 7;
    protected static final int OBJECT_HREF_SINGLE = 8;
    protected static final int OBJECT_HREF_MANY = 9;
    protected static final int OBJECT_CONTAIN_SINGLE_UNSETTABLE = 10;
    protected static final int OBJECT_CONTAIN_MANY_UNSETTABLE = 11;
    protected static final int OBJECT_HREF_SINGLE_UNSETTABLE = 12;
    protected static final int OBJECT_HREF_MANY_UNSETTABLE = 13;
    protected static final int OBJECT_ELEMENT_SINGLE = 14;
    protected static final int OBJECT_ELEMENT_SINGLE_UNSETTABLE = 15;
    protected static final int OBJECT_ELEMENT_MANY = 16;
    protected static final int OBJECT_ELEMENT_IDREF_SINGLE = 17;
    protected static final int OBJECT_ELEMENT_IDREF_SINGLE_UNSETTABLE = 18;
    protected static final int OBJECT_ELEMENT_IDREF_MANY = 19;
    protected static final int ATTRIBUTE_FEATURE_MAP = 20;
    protected static final int ELEMENT_FEATURE_MAP = 21;
    protected static final String XML_VERSION = "1.0";
    protected static final String XSI_NIL = "xsi:nil";
    protected static final String XSI_TYPE_NS = "xsi:type";
    protected static final String XSI_XMLNS = "xmlns:xsi";
    protected static final String XSI_SCHEMA_LOCATION = "xsi:schemaLocation";
    protected static final String XSI_NO_NAMESPACE_SCHEMA_LOCATION = "xsi:noNamespaceSchemaLocation";
    protected static final int EMPTY_ELEMENT = 1;
    protected static final int CONTENT_ELEMENT = 2;

    public XMLSaveImpl(XMLHelper helper) {
        this.helper = helper;
    }

    public XMLSaveImpl(Map options, XMLHelper helper, String encoding) {
        this.helper = helper;
        this.init(helper.getResource(), options);
        this.encoding = encoding;
    }

    public void save(XMLResource resource, OutputStream outputStream, Map options) throws IOException {
        DanglingHREFException exception;
        EObject root;
        EClass eClass;
        EReference xmlnsPrefixMapFeature;
        this.init(resource, options);
        EList contents = resource.getContents();
        this.traverse((List)contents);
        if (this.encoding.equals("US-ASCII") || this.encoding.equals("ASCII")) {
            this.writeAscii(outputStream);
            outputStream.flush();
        } else {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.helper.getJavaEncoding(this.encoding));
            this.write(outputStreamWriter);
            outputStreamWriter.flush();
        }
        if (this.extendedMetaData != null && contents.size() >= 1 && (xmlnsPrefixMapFeature = this.extendedMetaData.getXMLNSPrefixMapFeature(eClass = (root = (EObject)contents.get(0)).eClass())) != null) {
            EMap xmlnsPrefixMap = (EMap)root.eGet((EStructuralFeature)xmlnsPrefixMapFeature);
            Iterator i = this.helper.getPrefixToNamespaceMap().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                Object currentValue = xmlnsPrefixMap.get(key);
                if (!(currentValue == null ? value != null : !currentValue.equals(value))) continue;
                xmlnsPrefixMap.put(key, value);
            }
        }
        this.featureTable = null;
        this.doc = null;
        if ((this.processDanglingHREF == null || "THROW".equals(this.processDanglingHREF)) && (exception = this.helper.getDanglingHREFException()) != null) {
            this.helper = null;
            throw new Resource.IOWrappedException((Exception)exception);
        }
        this.helper = null;
    }

    protected void init(XMLResource resource, Map options) {
        List lookup;
        Object extendedMetaDataOption;
        int effectiveLineWidth;
        this.declareXSI = false;
        this.useEncodedAttributeStyle = Boolean.TRUE.equals(options.get("USE_ENCODED_ATTRIBUTE_STYLE"));
        this.declareXML = !Boolean.FALSE.equals(options.get("DECLARE_XML"));
        this.declareSchemaLocationImplementation = Boolean.TRUE.equals(options.get("SCHEMA_LOCATION_IMPLEMENTATION"));
        this.declareSchemaLocation = this.declareSchemaLocationImplementation || Boolean.TRUE.equals(options.get("SCHEMA_LOCATION"));
        Integer lineWidth = (Integer)options.get("LINE_WIDTH");
        this.saveTypeInfo = Boolean.TRUE.equals(options.get("SAVE_TYPE_INFORMATION"));
        this.anyType = (EClass)options.get("ANY_TYPE");
        this.anySimpleType = (EClass)options.get("ANY_SIMPLE_TYPE");
        if (this.anyType == null) {
            this.anyType = XMLTypePackage.eINSTANCE.getAnyType();
            this.anySimpleType = XMLTypePackage.eINSTANCE.getSimpleAnyType();
        }
        if (options.get("FLUSH_THRESHOLD") instanceof Integer) {
            this.flushThreshold = (Integer)options.get("FLUSH_THRESHOLD");
        }
        String temporaryFileName = null;
        if (Boolean.TRUE.equals(options.get("USE_FILE_BUFFER"))) {
            try {
                temporaryFileName = File.createTempFile("XMLSave", null).getPath();
            }
            catch (IOException iOException) {}
        }
        int n = effectiveLineWidth = lineWidth == null ? Integer.MAX_VALUE : lineWidth;
        this.doc = Boolean.TRUE.equals(options.get("SAVE_DOCTYPE")) ? (resource != null ? new XMLString(effectiveLineWidth, resource.getPublicId(), resource.getSystemId(), temporaryFileName) : new XMLString(effectiveLineWidth, null, null, temporaryFileName)) : new XMLString(effectiveLineWidth, temporaryFileName);
        if (Boolean.FALSE.equals(options.get("FORMATTED"))) {
            this.doc.setUnformatted(true);
        }
        Escape escape = this.escape = Boolean.TRUE.equals(options.get("SKIP_ESCAPE")) ? null : new Escape();
        if (options.containsKey("ENCODING")) {
            this.encoding = (String)options.get("ENCODING");
        } else if (resource != null) {
            this.encoding = resource.getEncoding();
        }
        this.processDanglingHREF = (String)options.get("PROCESS_DANGLING_HREF");
        this.helper.setProcessDanglingHREF(this.processDanglingHREF);
        this.map = (XMLResource.XMLMap)options.get("XML_MAP");
        if (this.map != null) {
            this.helper.setXMLMap(this.map);
            if (this.map.getIDAttributeName() != null) {
                this.idAttributeName = this.map.getIDAttributeName();
            }
        }
        if ((extendedMetaDataOption = options.get("EXTENDED_META_DATA")) instanceof Boolean) {
            if (extendedMetaDataOption.equals(Boolean.TRUE)) {
                this.extendedMetaData = resource == null || resource.getResourceSet() == null ? ExtendedMetaData.INSTANCE : new BasicExtendedMetaData(resource.getResourceSet().getPackageRegistry());
            }
        } else {
            this.extendedMetaData = (ExtendedMetaData)options.get("EXTENDED_META_DATA");
        }
        if (resource != null) {
            this.eObjectToExtensionMap = resource.getEObjectToExtensionMap();
            if (this.eObjectToExtensionMap.isEmpty()) {
                this.eObjectToExtensionMap = null;
            } else if (this.extendedMetaData == null) {
                Object object = this.extendedMetaData = resource.getResourceSet() == null ? ExtendedMetaData.INSTANCE : new BasicExtendedMetaData(resource.getResourceSet().getPackageRegistry());
            }
        }
        if (this.extendedMetaData != null) {
            EObject root;
            EClass eClass;
            EReference xmlnsPrefixMapFeature;
            this.helper.setExtendedMetaData(this.extendedMetaData);
            if (resource != null && resource.getContents().size() >= 1 && (xmlnsPrefixMapFeature = this.extendedMetaData.getXMLNSPrefixMapFeature(eClass = (root = (EObject)resource.getContents().get(0)).eClass())) != null) {
                EMap xmlnsPrefixMap = (EMap)root.eGet((EStructuralFeature)xmlnsPrefixMapFeature);
                this.helper.setPrefixToNamespaceMap(xmlnsPrefixMap);
            }
        }
        if ((lookup = (List)options.get("USE_CACHED_LOOKUP_TABLE")) != null) {
            if (lookup.isEmpty()) {
                this.featureTable = new Lookup(this.map, this.extendedMetaData);
                lookup.add(this.featureTable);
            } else {
                this.featureTable = (Lookup)lookup.get(0);
            }
        } else {
            this.featureTable = new Lookup(this.map, this.extendedMetaData);
        }
    }

    public void traverse(List contents) {
        int size;
        if (this.declareXML) {
            this.doc.add("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
            this.doc.addLine();
        }
        Object mark = (size = contents.size()) == 1 ? this.writeTopObject((EObject)contents.get(0)) : this.writeTopObjects(contents);
        this.doc.resetToMark(mark);
        this.addNamespaceDeclarations();
    }

    protected Object writeTopObject(EObject top) {
        EClass eClass = top.eClass();
        if (this.extendedMetaData == null || this.extendedMetaData.getDocumentRoot(eClass.getEPackage()) != eClass) {
            String name = this.helper.getQName(eClass);
            this.doc.startElement(name);
            Object mark = this.doc.mark();
            this.saveElementID(top);
            return mark;
        }
        this.doc.startElement(null);
        this.saveFeatures(top);
        return null;
    }

    protected Object writeTopObjects(List contents) {
        return this.writeTopObject((EObject)contents.get(0));
    }

    protected void addNamespaceDeclarations() {
        EPackage noNamespacePackage = this.helper.getNoNamespacePackage();
        EPackage[] packages = this.helper.packages();
        StringBuffer xsiSchemaLocation = null;
        String xsiNoNamespaceSchemaLocation = null;
        if (this.declareSchemaLocation) {
            EMap xsiSchemaLocationMap;
            EObject root;
            EClass eClass;
            EReference xsiSchemaLocationMapFeature;
            XMLResource resource;
            Map handledBySchemaLocationMap = Collections.EMPTY_MAP;
            if (this.extendedMetaData != null && (resource = this.helper.getResource()) != null && resource.getContents().size() >= 1 && (xsiSchemaLocationMapFeature = this.extendedMetaData.getXSISchemaLocationMapFeature(eClass = (root = (EObject)resource.getContents().get(0)).eClass())) != null && !(xsiSchemaLocationMap = (EMap)root.eGet((EStructuralFeature)xsiSchemaLocationMapFeature)).isEmpty()) {
                handledBySchemaLocationMap = xsiSchemaLocationMap.map();
                this.declareXSI = true;
                Iterator i = xsiSchemaLocationMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = (Map.Entry)i.next();
                    String namespace = (String)entry.getKey();
                    URI location = URI.createURI((String)entry.getValue().toString());
                    if (namespace == null) {
                        xsiNoNamespaceSchemaLocation = this.helper.deresolve(location).toString();
                        continue;
                    }
                    if (xsiSchemaLocation == null) {
                        xsiSchemaLocation = new StringBuffer();
                    } else {
                        xsiSchemaLocation.append(' ');
                    }
                    xsiSchemaLocation.append(namespace);
                    xsiSchemaLocation.append(' ');
                    xsiSchemaLocation.append(this.helper.deresolve(location).toString());
                }
            }
            int i = 0;
            while (i < packages.length) {
                EPackage ePackage = packages[i];
                String javaImplementationLocation = null;
                if (this.declareSchemaLocationImplementation) {
                    try {
                        Field field = ePackage.getClass().getField("eINSTANCE");
                        javaImplementationLocation = "java://" + field.getDeclaringClass().getName();
                    }
                    catch (Exception exception) {}
                }
                if (noNamespacePackage == ePackage) {
                    if (ePackage.eResource() != null && !handledBySchemaLocationMap.containsKey(null)) {
                        this.declareXSI = true;
                        if (javaImplementationLocation != null) {
                            xsiNoNamespaceSchemaLocation = javaImplementationLocation;
                        } else {
                            xsiNoNamespaceSchemaLocation = this.helper.getHREF((EObject)ePackage);
                            if (xsiNoNamespaceSchemaLocation.endsWith("#/")) {
                                xsiNoNamespaceSchemaLocation = xsiNoNamespaceSchemaLocation.substring(0, xsiNoNamespaceSchemaLocation.length() - 2);
                            }
                        }
                    }
                } else {
                    String nsURI;
                    Resource resource2 = ePackage.eResource();
                    if (resource2 != null && !handledBySchemaLocationMap.containsKey(nsURI = ePackage.getNsURI())) {
                        URI uri = resource2.getURI();
                        if (javaImplementationLocation != null || (uri == null ? nsURI != null : !uri.toString().equals(nsURI))) {
                            String location;
                            this.declareXSI = true;
                            if (xsiSchemaLocation == null) {
                                xsiSchemaLocation = new StringBuffer();
                            } else {
                                xsiSchemaLocation.append(' ');
                            }
                            xsiSchemaLocation.append(nsURI);
                            xsiSchemaLocation.append(' ');
                            String string = location = javaImplementationLocation == null ? this.helper.getHREF((EObject)ePackage) : javaImplementationLocation;
                            if (location.endsWith("#/")) {
                                location = location.substring(0, location.length() - 2);
                            }
                            xsiSchemaLocation.append(location);
                        }
                    }
                }
                ++i;
            }
        }
        if (this.declareXSI) {
            this.doc.addAttribute(XSI_XMLNS, "http://www.w3.org/2001/XMLSchema-instance");
        }
        int i = 0;
        while (i < packages.length) {
            EPackage ePackage = packages[i];
            if (ePackage != noNamespacePackage && ePackage != XMLNamespacePackage.eINSTANCE) {
                String nsURI;
                String string = nsURI = this.extendedMetaData == null ? ePackage.getNsURI() : this.extendedMetaData.getNamespace(ePackage);
                if (ePackage == this.xmlSchemaTypePackage) {
                    nsURI = "http://www.w3.org/2001/XMLSchema";
                }
                if (nsURI != null && !this.isDuplicateURI(nsURI)) {
                    List nsPrefixes = this.helper.getPrefixes(ePackage);
                    Iterator j = nsPrefixes.iterator();
                    while (j.hasNext()) {
                        String nsPrefix = (String)j.next();
                        if (nsPrefix != null && nsPrefix.length() > 0) {
                            this.doc.addAttributeNS("xmlns", nsPrefix, nsURI);
                            continue;
                        }
                        this.doc.addAttribute("xmlns", nsURI);
                    }
                }
            }
            ++i;
        }
        if (xsiSchemaLocation != null) {
            this.doc.addAttribute(XSI_SCHEMA_LOCATION, xsiSchemaLocation.toString());
        }
        if (xsiNoNamespaceSchemaLocation != null) {
            this.doc.addAttribute(XSI_NO_NAMESPACE_SCHEMA_LOCATION, xsiNoNamespaceSchemaLocation);
        }
    }

    public boolean isDuplicateURI(String nsURI) {
        return false;
    }

    public void write(OutputStreamWriter os) throws IOException {
        int count = 0;
        char[] buffer = new char[8192];
        int pos = 0;
        Iterator i = this.doc.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            int slen = s.length();
            if (slen + pos >= buffer.length) {
                os.write(buffer, 0, pos);
                pos = 0;
                if (slen > buffer.length) {
                    buffer = new char[slen];
                }
            }
            s.getChars(0, slen, buffer, pos);
            pos += slen;
            if ((count += slen) <= this.flushThreshold) continue;
            os.flush();
            count = 0;
        }
        os.write(buffer, 0, pos);
        String temporaryFileName = this.doc.getTemporaryFileName();
        if (temporaryFileName != null) {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(temporaryFileName), "UTF8");
            int length = reader.read(buffer, 0, 8192);
            while (length > 0) {
                os.write(buffer, 0, length);
                if ((count += length) > this.flushThreshold) {
                    os.flush();
                    count = 0;
                }
                length = reader.read(buffer, 0, 8192);
            }
            reader.close();
            new File(temporaryFileName).delete();
        }
        os.flush();
    }

    public void writeAscii(OutputStream os) throws IOException {
        int count = 0;
        char[] buffer = new char[8192];
        byte[] bytes = new byte[8192];
        int pos = 0;
        Iterator i = this.doc.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            int slen = s.length();
            if (slen + pos >= buffer.length) {
                int x = 0;
                while (x < pos) {
                    bytes[x] = (byte)(buffer[x] & 0xFF);
                    ++x;
                }
                os.write(bytes, 0, pos);
                pos = 0;
                if (slen > buffer.length) {
                    buffer = new char[slen];
                    bytes = new byte[slen];
                }
            }
            s.getChars(0, slen, buffer, pos);
            pos += slen;
            if ((count += slen) <= this.flushThreshold) continue;
            os.flush();
            count = 0;
        }
        int x = 0;
        while (x < pos) {
            bytes[x] = (byte)(buffer[x] & 0xFF);
            ++x;
        }
        os.write(bytes, 0, pos);
        String temporaryFileName = this.doc.getTemporaryFileName();
        if (temporaryFileName != null) {
            FileInputStream inputStream = new FileInputStream(temporaryFileName);
            int length = ((InputStream)inputStream).read(bytes, 0, 8192);
            while (length > 0) {
                os.write(bytes, 0, length);
                if ((count += length) > this.flushThreshold) {
                    os.flush();
                    count = 0;
                }
                length = ((InputStream)inputStream).read(bytes, 0, 8192);
            }
            ((InputStream)inputStream).close();
            new File(temporaryFileName).delete();
        }
        os.flush();
    }

    public char[] toChar() {
        int size = this.doc.getLength();
        char[] output = new char[size];
        this.doc.getChars(output, 0);
        return output;
    }

    protected void saveElement(EObject o, EStructuralFeature f) {
        XMLResource.XMLInfo info;
        String name;
        EClass eClass = o.eClass();
        EClassifier eType = f.getEType();
        if (this.extendedMetaData != null && eClass != eType && (name = this.extendedMetaData.getName((EClassifier)eClass)).endsWith("_._type")) {
            String elementName = name.substring(0, name.indexOf("_._"));
            String prefix = this.helper.getPrefix(eClass.getEPackage());
            if (!"".equals(prefix)) {
                elementName = String.valueOf(prefix) + ":" + elementName;
            }
            this.doc.startElement(elementName);
            this.saveElementID(o);
            return;
        }
        if (this.map != null && (info = this.map.getInfo((ENamedElement)eClass)) != null && info.getXMLRepresentation() == 0) {
            String elementName = this.helper.getQName(eClass);
            this.doc.startElement(elementName);
            this.saveElementID(o);
            return;
        }
        String featureName = this.helper.getQName(f);
        this.doc.startElement(featureName);
        if (eClass != eType && eClass != this.anyType) {
            if (eClass == this.anySimpleType) {
                this.saveTypeAttribute(((SimpleAnyType)o).getInstanceType());
            } else {
                this.saveTypeAttribute(eClass);
            }
        }
        this.saveElementID(o);
    }

    protected void saveTypeAttribute(EClass eClass) {
        this.declareXSI = true;
        this.doc.addAttribute(XSI_TYPE_NS, this.helper.getQName(eClass));
    }

    protected void saveTypeAttribute(EDataType eDataType) {
        this.declareXSI = true;
        this.doc.addAttribute(XSI_TYPE_NS, this.helper.getQName(eDataType));
    }

    /*
     * Unable to fully structure code
     */
    protected boolean saveFeatures(EObject o) {
        eClass = o.eClass();
        contentKind = this.extendedMetaData == null ? 0 : this.extendedMetaData.getContentKind(eClass);
        switch (contentKind) {
            case 2: 
            case 3: {
                this.doc.setMixed(true);
            }
        }
        features = this.featureTable.getFeatures(eClass);
        featureKinds = this.featureTable.getKinds(eClass, features);
        elementFeatures = null;
        elementCount = 0;
        content = null;
        i = 0;
        while (i < features.length) {
            block59: {
                kind = featureKinds[i];
                f = features[i];
                if (kind == 0 || !o.eIsSet(f)) break block59;
                block3 : switch (kind) {
                    case 2: {
                        if (contentKind != 2) break;
                        content = this.getDataTypeElementSingleSimple(o, f);
                        break block59;
                    }
                    case 1: {
                        this.saveDataTypeSingle(o, f);
                        break block59;
                    }
                    case 4: {
                        if (this.isNil(o, f)) break;
                        this.saveDataTypeSingle(o, f);
                        break block59;
                    }
                    case 12: {
                        if (this.isNil(o, f)) break;
                    }
                    case 8: {
                        if (this.useEncodedAttributeStyle) {
                            this.saveEObjectSingle(o, f);
                        } else {
                            switch (this.sameDocSingle(o, f)) {
                                case 1: {
                                    this.saveIDRefSingle(o, f);
                                    break;
                                }
                                case 2: {
                                    break block3;
                                }
                            }
                        }
                        break block59;
                    }
                    case 13: {
                        if (!this.isEmpty(o, f)) ** GOTO lbl45
                        this.saveManyEmpty(f);
                        break block59;
                    }
lbl45:
                    // 2 sources

                    case 9: {
                        if (this.useEncodedAttributeStyle) {
                            this.saveEObjectMany(o, f);
                        } else {
                            switch (this.sameDocMany(o, f)) {
                                case 1: {
                                    this.saveIDRefMany(o, f);
                                    break;
                                }
                                case 2: {
                                    break block3;
                                }
                            }
                        }
                        break block59;
                    }
                    case 14: 
                    case 15: {
                        if (contentKind != 2) break;
                        content = this.getElementReferenceSingleSimple(o, f);
                        break block59;
                    }
                    case 16: {
                        if (contentKind != 2) break;
                        content = this.getElementReferenceManySimple(o, f);
                        break block59;
                    }
                    case 17: 
                    case 18: {
                        if (contentKind != 2) break;
                        content = this.getElementIDRefSingleSimple(o, f);
                        break block59;
                    }
                    case 19: {
                        if (contentKind != 2) break;
                        content = this.getElementIDRefManySimple(o, f);
                        break block59;
                    }
                    case 5: 
                    case 11: {
                        if (!this.isEmpty(o, f)) break;
                        this.saveManyEmpty(f);
                        break block59;
                    }
                    case 6: 
                    case 7: 
                    case 10: 
                    case 21: {
                        break;
                    }
                    case 20: {
                        this.saveAttributeFeatureMap(o, f);
                        break block59;
                    }
                    default: {
                        break block59;
                    }
                }
                if (elementFeatures == null) {
                    elementFeatures = new int[features.length];
                }
                elementFeatures[elementCount++] = i;
            }
            ++i;
        }
        this.processAttributeExtensions(o);
        if (elementFeatures == null) {
            if (content == null) {
                content = this.getContent(o, features);
            }
            if (content == null) {
                this.endSaveFeatures(o, 1, null);
                return false;
            }
            this.endSaveFeatures(o, 2, content);
            return true;
        }
        i = 0;
        while (i < elementCount) {
            kind = featureKinds[elementFeatures[i]];
            f = features[elementFeatures[i]];
            switch (kind) {
                case 4: {
                    this.saveNil(f);
                    break;
                }
                case 21: {
                    this.saveElementFeatureMap(o, f);
                    break;
                }
                case 5: {
                    this.saveDataTypeMany(o, f);
                    break;
                }
                case 2: {
                    this.saveDataTypeElementSingle(o, f);
                    break;
                }
                case 10: {
                    if (this.isNil(o, f)) {
                        this.saveNil(f);
                        break;
                    }
                }
                case 6: {
                    this.saveContainedSingle(o, f);
                    break;
                }
                case 7: 
                case 11: {
                    this.saveContainedMany(o, f);
                    break;
                }
                case 12: {
                    if (this.isNil(o, f)) {
                        this.saveNil(f);
                        break;
                    }
                }
                case 8: {
                    this.saveHRefSingle(o, f);
                    break;
                }
                case 9: 
                case 13: {
                    this.saveHRefMany(o, f);
                    break;
                }
                case 15: {
                    if (this.isNil(o, f)) {
                        this.saveNil(f);
                        break;
                    }
                }
                case 14: {
                    this.saveElementReferenceSingle(o, f);
                    break;
                }
                case 16: {
                    this.saveElementReferenceMany(o, f);
                    break;
                }
                case 18: {
                    if (this.isNil(o, f)) {
                        this.saveNil(f);
                        break;
                    }
                }
                case 17: {
                    this.saveElementIDRefSingle(o, f);
                    break;
                }
                case 19: {
                    this.saveElementIDRefMany(o, f);
                }
            }
            ++i;
        }
        this.endSaveFeatures(o, 0, null);
        return true;
    }

    protected void endSaveFeatures(EObject o, int elementType, String content) {
        if (this.processElementExtensions(o)) {
            this.doc.endElement();
        } else {
            switch (elementType) {
                case 1: {
                    this.doc.endEmptyElement();
                    break;
                }
                case 2: {
                    this.doc.endContentElement(content);
                    break;
                }
                default: {
                    this.doc.endElement();
                }
            }
        }
    }

    protected boolean processElementExtensions(EObject object) {
        if (this.eObjectToExtensionMap != null) {
            AnyType anyType = (AnyType)this.eObjectToExtensionMap.get(object);
            return anyType != null && this.saveElementFeatureMap((EObject)anyType, (EStructuralFeature)XMLTypePackage.eINSTANCE.getAnyType_Mixed());
        }
        return false;
    }

    protected void processAttributeExtensions(EObject object) {
        AnyType anyType;
        if (this.eObjectToExtensionMap != null && (anyType = (AnyType)this.eObjectToExtensionMap.get(object)) != null) {
            this.saveAttributeFeatureMap((EObject)anyType, (EStructuralFeature)XMLTypePackage.eINSTANCE.getAnyType_AnyAttribute());
        }
    }

    protected void saveDataTypeSingle(EObject o, EStructuralFeature f) {
        EDataType d = (EDataType)f.getEType();
        EPackage ePackage = d.getEPackage();
        EFactory fac = ePackage.getEFactoryInstance();
        Object value = this.helper.getValue(o, f);
        if (value != null) {
            String svalue = this.helper.convertToString(fac, d, value);
            if (this.escape != null) {
                svalue = this.escape.convert(svalue);
            }
            this.doc.addAttribute(this.helper.getQName(f), svalue);
        }
    }

    protected boolean isNil(EObject o, EStructuralFeature f) {
        return this.helper.getValue(o, f) == null;
    }

    protected boolean isEmpty(EObject o, EStructuralFeature f) {
        return ((List)this.helper.getValue(o, f)).isEmpty();
    }

    protected void saveNil(EStructuralFeature f) {
        String name = this.helper.getQName(f);
        this.doc.startElement(name);
        this.doc.addAttribute(XSI_NIL, "true");
        this.doc.endEmptyElement();
        this.declareXSI = true;
    }

    protected void saveManyEmpty(EStructuralFeature f) {
        this.doc.addAttribute(this.helper.getQName(f), "");
    }

    protected void saveDataTypeMany(EObject o, EStructuralFeature f) {
        EDataType d = (EDataType)f.getEType();
        EPackage ePackage = d.getEPackage();
        EFactory fac = ePackage.getEFactoryInstance();
        List values = (List)this.helper.getValue(o, f);
        int size = values.size();
        if (size > 0) {
            String name = this.helper.getQName(f);
            int i = 0;
            while (i < size) {
                Object value = values.get(i);
                if (value == null) {
                    this.doc.startElement(name);
                    this.doc.addAttribute(XSI_NIL, "true");
                    this.doc.endEmptyElement();
                    this.declareXSI = true;
                } else {
                    this.doc.startElement(name);
                    String svalue = this.helper.convertToString(fac, d, value);
                    if (this.escape != null) {
                        svalue = this.escape.convert(svalue);
                    }
                    this.doc.endContentElement(svalue);
                }
                ++i;
            }
        }
    }

    protected void saveEObjectSingle(EObject o, EStructuralFeature f) {
        EObject value = (EObject)this.helper.getValue(o, f);
        if (value != null) {
            String name = this.helper.getQName(f);
            String id = this.helper.getHREF(value);
            if (id != null) {
                EClass expectedType;
                EClass eClass;
                this.doc.startAttribute(name);
                if (!id.startsWith("#") && (eClass = value.eClass()) != (expectedType = (EClass)f.getEType()) && (this.saveTypeInfo || expectedType.isAbstract())) {
                    this.doc.addAttributeContent(this.helper.getQName(eClass));
                    this.doc.addAttributeContent(" ");
                }
                this.doc.addAttributeContent(id);
                this.doc.endAttribute();
            }
        }
    }

    protected void saveEObjectMany(EObject o, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(o, f);
        if (!values.isEmpty()) {
            String name = this.helper.getQName(f);
            this.doc.startAttribute(name);
            Iterator i = values.basicIterator();
            while (true) {
                EObject value;
                String id;
                if ((id = this.helper.getHREF(value = (EObject)i.next())) != null) {
                    EClass expectedType;
                    EClass eClass;
                    if (!id.startsWith("#") && (eClass = value.eClass()) != (expectedType = (EClass)f.getEType()) && (this.saveTypeInfo || expectedType.isAbstract())) {
                        this.doc.addAttributeContent(this.helper.getQName(eClass));
                        this.doc.addAttributeContent(" ");
                    }
                    this.doc.addAttributeContent(id);
                }
                if (!i.hasNext()) break;
                this.doc.addAttributeContent(" ");
            }
            this.doc.endAttribute();
        }
    }

    protected void saveIDRefSingle(EObject o, EStructuralFeature f) {
        EObject value = (EObject)this.helper.getValue(o, f);
        if (value != null) {
            String name = this.helper.getQName(f);
            String id = this.helper.getIDREF(value);
            this.doc.addAttribute(name, id);
        }
    }

    protected void saveIDRefMany(EObject o, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(o, f);
        if (!values.isEmpty()) {
            String name = this.helper.getQName(f);
            StringBuffer ids = new StringBuffer(values.size() * 10);
            Iterator i = values.basicIterator();
            while (true) {
                EObject value = (EObject)i.next();
                String id = this.helper.getIDREF(value);
                ids.append(id);
                if (!i.hasNext()) break;
                ids.append(" ");
            }
            this.doc.addAttribute(name, ids.toString());
        }
    }

    protected void saveElementReference(EObject remote, EStructuralFeature f) {
        String name = this.helper.getQName(f);
        String href = this.helper.getHREF(remote);
        if (href != null) {
            this.doc.startElement(name);
            EClass eClass = remote.eClass();
            EClass expectedType = (EClass)f.getEType();
            if (eClass != expectedType && (this.saveTypeInfo || expectedType.isAbstract())) {
                this.saveTypeAttribute(eClass);
            }
            this.doc.endContentElement(href);
        }
    }

    protected void saveElementReferenceSingle(EObject o, EStructuralFeature f) {
        EObject value = (EObject)this.helper.getValue(o, f);
        if (value != null) {
            this.saveElementReference(value, f);
        }
    }

    protected void saveElementReferenceMany(EObject o, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(o, f);
        int size = values.size();
        int i = 0;
        while (i < size) {
            this.saveElementReference((EObject)values.basicGet(i), f);
            ++i;
        }
    }

    protected String getElementReferenceSingleSimple(EObject o, EStructuralFeature f) {
        EObject value = (EObject)this.helper.getValue(o, f);
        return this.helper.getHREF(value);
    }

    protected String getElementReferenceManySimple(EObject o, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(o, f);
        StringBuffer result = new StringBuffer();
        int size = values.size();
        int i = 0;
        while (i < size) {
            result.append(this.helper.getHREF((EObject)values.basicGet(i)));
            result.append(' ');
            ++i;
        }
        return result.substring(0, result.length() - 1);
    }

    protected void saveElementIDRef(EObject target, EStructuralFeature f) {
        String name = this.helper.getQName(f);
        String id = this.helper.getIDREF(target);
        this.doc.startElement(name);
        this.doc.endContentElement(id);
    }

    protected void saveElementIDRefSingle(EObject o, EStructuralFeature f) {
        EObject value = (EObject)this.helper.getValue(o, f);
        if (value != null) {
            this.saveElementIDRef(value, f);
        }
    }

    protected void saveElementIDRefMany(EObject o, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(o, f);
        int size = values.size();
        int i = 0;
        while (i < size) {
            this.saveElementIDRef((EObject)values.basicGet(i), f);
            ++i;
        }
    }

    protected String getElementIDRefSingleSimple(EObject o, EStructuralFeature f) {
        EObject value = (EObject)this.helper.getValue(o, f);
        return this.helper.getIDREF(value);
    }

    protected String getElementIDRefManySimple(EObject o, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(o, f);
        StringBuffer result = new StringBuffer();
        int i = 0;
        int size = values.size();
        while (i < size) {
            result.append(this.helper.getIDREF((EObject)values.basicGet(i)));
            result.append(' ');
            ++i;
        }
        return result.substring(0, result.length() - 1);
    }

    protected void saveHref(EObject remote, EStructuralFeature f) {
        String name = this.helper.getQName(f);
        String href = this.helper.getHREF(remote);
        if (href != null) {
            this.doc.startElement(name);
            EClass eClass = remote.eClass();
            EClass expectedType = (EClass)f.getEType();
            if (eClass != expectedType && (this.saveTypeInfo || expectedType.isAbstract())) {
                this.saveTypeAttribute(eClass);
            }
            this.doc.addAttribute("href", href);
            this.doc.endEmptyElement();
        }
    }

    protected void saveHRefSingle(EObject o, EStructuralFeature f) {
        EObject value = (EObject)this.helper.getValue(o, f);
        if (value != null) {
            this.saveHref(value, f);
        }
    }

    protected void saveHRefMany(EObject o, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(o, f);
        int size = values.size();
        int i = 0;
        while (i < size) {
            this.saveHref((EObject)values.basicGet(i), f);
            ++i;
        }
    }

    protected void saveContainedSingle(EObject o, EStructuralFeature f) {
        EObject value = (EObject)this.helper.getValue(o, f);
        if (value != null) {
            this.saveElement(value, f);
        }
    }

    protected void saveContainedMany(EObject o, EStructuralFeature f) {
        List values = (List)this.helper.getValue(o, f);
        int size = values.size();
        int i = 0;
        while (i < size) {
            EObject value = (EObject)values.get(i);
            if (value != null) {
                this.saveElement(value, f);
            }
            ++i;
        }
    }

    protected boolean saveElementFeatureMap(EObject o, EStructuralFeature f) {
        List values = (List)this.helper.getValue(o, f);
        int size = values.size();
        int i = 0;
        while (i < size) {
            String stringValue;
            FeatureMap.Entry entry = (FeatureMap.Entry)values.get(i);
            EStructuralFeature entryFeature = entry.getEStructuralFeature();
            Object value = entry.getValue();
            if (entryFeature instanceof EReference) {
                if (value == null) {
                    this.saveNil(entryFeature);
                } else {
                    EReference referenceEntryFeature = (EReference)entryFeature;
                    if (referenceEntryFeature.isContainment()) {
                        this.saveElement((EObject)value, entryFeature);
                    } else if (referenceEntryFeature.isResolveProxies()) {
                        this.saveElementReference((EObject)value, entryFeature);
                    } else {
                        this.saveElementIDRef((EObject)value, entryFeature);
                    }
                }
            } else if (entryFeature == XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text()) {
                stringValue = value.toString();
                if (this.escape != null) {
                    stringValue = this.escape.convertText(stringValue);
                }
                this.doc.addText(stringValue);
            } else if (entryFeature == XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_CDATA()) {
                stringValue = value.toString();
                if (this.escape != null) {
                    stringValue = this.escape.convertLines(stringValue);
                }
                this.doc.addCDATA(stringValue);
            } else if (entryFeature == XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Comment()) {
                stringValue = value.toString();
                if (this.escape != null) {
                    stringValue = this.escape.convertLines(stringValue);
                }
                this.doc.addComment(stringValue);
            } else if (value == null) {
                this.saveNil(entryFeature);
            } else {
                this.doc.startElement(this.helper.getQName(entryFeature));
                EDataType d = (EDataType)entryFeature.getEType();
                EPackage ePackage = d.getEPackage();
                EFactory fac = ePackage.getEFactoryInstance();
                String svalue = this.helper.convertToString(fac, d, value);
                if (this.escape != null) {
                    svalue = this.escape.convertText(svalue);
                }
                this.doc.endContentElement(svalue);
            }
            ++i;
        }
        return size > 0;
    }

    protected void saveAttributeFeatureMap(EObject o, EStructuralFeature f) {
        List values = (List)this.helper.getValue(o, f);
        int size = values.size();
        int i = 0;
        while (i < size) {
            FeatureMap.Entry entry = (FeatureMap.Entry)values.get(i);
            EStructuralFeature entryFeature = entry.getEStructuralFeature();
            Object value = entry.getValue();
            if (entryFeature instanceof EReference) {
                throw new UnsupportedOperationException();
            }
            EDataType d = (EDataType)entryFeature.getEType();
            EPackage ePackage = d.getEPackage();
            EFactory fac = ePackage.getEFactoryInstance();
            String svalue = this.helper.convertToString(fac, d, value);
            if (this.escape != null) {
                svalue = this.escape.convertText(svalue);
            }
            this.doc.addAttribute(this.helper.getQName(entryFeature), svalue);
            ++i;
        }
    }

    protected int sameDocSingle(EObject o, EStructuralFeature f) {
        InternalEObject value = (InternalEObject)this.helper.getValue(o, f);
        if (value == null) {
            return 0;
        }
        if (value.eIsProxy()) {
            return 2;
        }
        Resource res = value.eResource();
        return res == this.helper.getResource() ? 1 : 2;
    }

    protected int sameDocMany(EObject o, EStructuralFeature f) {
        InternalEList values = (InternalEList)this.helper.getValue(o, f);
        if (values.isEmpty()) {
            return 0;
        }
        Iterator i = values.basicIterator();
        while (i.hasNext()) {
            InternalEObject value = (InternalEObject)i.next();
            if (!value.eIsProxy() && value.eResource() == this.helper.getResource()) continue;
            return 2;
        }
        return 1;
    }

    protected String getContent(EObject o, EStructuralFeature[] features) {
        if (this.map == null) {
            return null;
        }
        int i = 0;
        while (i < features.length) {
            XMLResource.XMLInfo info = this.map.getInfo((ENamedElement)features[i]);
            if (info != null && info.getXMLRepresentation() == 2) {
                Object value = this.helper.getValue(o, features[i]);
                if (value == null) {
                    return null;
                }
                EDataType d = (EDataType)features[i].getEType();
                EPackage ePackage = d.getEPackage();
                EFactory fac = ePackage.getEFactoryInstance();
                String svalue = this.helper.convertToString(fac, d, value);
                if (this.escape != null) {
                    svalue = this.escape.convert(svalue);
                }
                return svalue;
            }
            ++i;
        }
        return null;
    }

    protected void saveDataTypeElementSingle(EObject o, EStructuralFeature f) {
        String name = this.helper.getQName(f);
        Object value = this.helper.getValue(o, f);
        if (value == null) {
            this.doc.startElement(name);
            this.doc.addAttribute(XSI_NIL, "true");
            this.doc.endEmptyElement();
            this.declareXSI = true;
        } else {
            EDataType d = (EDataType)f.getEType();
            EPackage ePackage = d.getEPackage();
            EFactory fac = ePackage.getEFactoryInstance();
            this.doc.startElement(name);
            String svalue = this.helper.convertToString(fac, d, value);
            if (this.escape != null) {
                svalue = this.escape.convert(svalue);
            }
            this.doc.endContentElement(svalue);
        }
    }

    protected String getDataTypeElementSingleSimple(EObject o, EStructuralFeature f) {
        Object value = this.helper.getValue(o, f);
        if (value != null) {
            EDataType d = (EDataType)f.getEType();
            EPackage ePackage = d.getEPackage();
            EFactory fac = ePackage.getEFactoryInstance();
            String svalue = this.helper.convertToString(fac, d, value);
            if (this.escape != null) {
                svalue = this.escape.convert(svalue);
            }
            return svalue;
        }
        return null;
    }

    protected void saveElementID(EObject o) {
        String id = this.helper.getID(o);
        if (id != null) {
            this.doc.addAttribute(this.idAttributeName, id);
        }
        this.saveFeatures(o);
    }

    protected static class Lookup {
        protected static final int SHIFT = 10;
        protected static final int SIZE = 1024;
        protected static final int MASK = 1023;
        protected EClass[] classes;
        protected EStructuralFeature[][] features;
        protected int[][] featureKinds;
        protected XMLResource.XMLMap map;
        protected ExtendedMetaData extendedMetaData;
        static /* synthetic */ Class class$0;

        public Lookup(XMLResource.XMLMap map) {
            this(map, null);
        }

        public Lookup(XMLResource.XMLMap map, ExtendedMetaData extendedMetaData) {
            this.map = map;
            this.extendedMetaData = extendedMetaData;
            this.classes = new EClass[1024];
            this.features = new EStructuralFeature[1024][];
            this.featureKinds = new int[1024][];
        }

        public EStructuralFeature[] getFeatures(EClass cls) {
            int index = this.getIndex(cls);
            EClass c = this.classes[index];
            if (c == cls) {
                return this.features[index];
            }
            EStructuralFeature[] featureList = this.listFeatures(cls);
            if (c == null) {
                this.classes[index] = cls;
                this.features[index] = featureList;
                this.featureKinds[index] = this.listKinds(featureList);
            }
            return featureList;
        }

        public int[] getKinds(EClass cls, EStructuralFeature[] featureList) {
            int index = this.getIndex(cls);
            EClass c = this.classes[index];
            if (c == cls) {
                return this.featureKinds[index];
            }
            int[] kindsList = this.listKinds(featureList);
            if (c == null) {
                this.classes[index] = cls;
                this.features[index] = featureList;
                this.featureKinds[index] = kindsList;
            }
            return kindsList;
        }

        protected int getIndex(EClass cls) {
            String name = cls.getInstanceClassName();
            int index = 0;
            index = name != null ? name.hashCode() & 0x3FF : cls.hashCode() >> 10 & 0x3FF;
            return index;
        }

        protected EStructuralFeature[] listFeatures(EClass cls) {
            if (this.extendedMetaData != null) {
                ArrayList f = new ArrayList();
                f.addAll(cls.getEAllStructuralFeatures());
                List orderedElements = this.extendedMetaData.getAllElements(cls);
                f.removeAll(orderedElements);
                f.addAll(orderedElements);
                return f.toArray(new EStructuralFeature[f.size()]);
            }
            EList f = this.map == null ? cls.getEAllStructuralFeatures() : this.map.getFeatures(cls);
            return f.toArray(new EStructuralFeature[f.size()]);
        }

        protected int[] listKinds(EStructuralFeature[] featureList) {
            int[] kinds = new int[featureList.length];
            int i = featureList.length - 1;
            while (i >= 0) {
                kinds[i] = this.featureKind(featureList[i]);
                --i;
            }
            return kinds;
        }

        protected int featureKind(EStructuralFeature f) {
            if (f.isTransient()) {
                return 0;
            }
            boolean isMany = f.isMany();
            boolean isUnsettable = f.isUnsettable();
            if (f instanceof EReference) {
                XMLResource.XMLInfo info;
                EReference r = (EReference)f;
                if (r.isContainment()) {
                    return isMany ? (isUnsettable ? 11 : 7) : (isUnsettable ? 10 : 6);
                }
                EReference opposite = r.getEOpposite();
                if (opposite != null && opposite.isContainment()) {
                    return 0;
                }
                if (this.map != null && (info = this.map.getInfo((ENamedElement)f)) != null && info.getXMLRepresentation() == 0) {
                    return isMany ? 16 : (r.isUnsettable() ? 15 : 14);
                }
                if (this.extendedMetaData != null) {
                    switch (this.extendedMetaData.getFeatureKind(f)) {
                        case 1: 
                        case 4: {
                            return r.isResolveProxies() ? (isMany ? 16 : (r.isUnsettable() ? 15 : 14)) : (isMany ? 19 : (r.isUnsettable() ? 18 : 17));
                        }
                    }
                }
                return isMany ? (isUnsettable ? 13 : 9) : (isUnsettable ? 12 : 8);
            }
            EDataType d = (EDataType)f.getEType();
            if (!d.isSerializable()) {
                return 0;
            }
            Class clazz = d.getInstanceClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.emf.ecore.util.FeatureMap$Entry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                return this.extendedMetaData != null && this.extendedMetaData.getFeatureKind(f) == 3 ? 20 : 21;
            }
            if (isMany) {
                return 5;
            }
            if (this.extendedMetaData != null) {
                switch (this.extendedMetaData.getFeatureKind(f)) {
                    case 1: 
                    case 4: {
                        return 2;
                    }
                }
            }
            if (isUnsettable && this.map == null) {
                return 4;
            }
            if (this.map == null) {
                return 1;
            }
            XMLResource.XMLInfo info = this.map.getInfo((ENamedElement)f);
            if (info != null && info.getXMLRepresentation() == 0) {
                return 2;
            }
            if (info != null && info.getXMLRepresentation() == 2) {
                return 3;
            }
            if (isUnsettable) {
                return 4;
            }
            return 1;
        }
    }

    protected static class Escape {
        protected char[] value;
        protected final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
        protected final char[] LESS = new char[]{'&', 'l', 't', ';'};
        protected final char[] QUOTE = new char[]{'&', 'q', 'u', 'o', 't', ';'};
        protected final char[] LF = new char[]{'&', '#', 'x', 'A', ';'};
        protected final char[] CR = new char[]{'&', '#', 'x', 'D', ';'};
        protected final char[] TAB = new char[]{'&', '#', 'x', '9', ';'};
        protected final char[] LINE_FEED = System.getProperty("line.separator").toCharArray();

        public Escape() {
            this.value = new char[100];
        }

        public String convert(String input) {
            boolean changed = false;
            int inputLength = input.length();
            this.grow(inputLength);
            input.getChars(0, inputLength, this.value, 0);
            int pos = 0;
            while (inputLength-- > 0) {
                switch (this.value[pos]) {
                    case '&': {
                        pos = this.replace(pos, this.AMP, inputLength);
                        changed = true;
                        break;
                    }
                    case '<': {
                        pos = this.replace(pos, this.LESS, inputLength);
                        changed = true;
                        break;
                    }
                    case '\"': {
                        pos = this.replace(pos, this.QUOTE, inputLength);
                        changed = true;
                        break;
                    }
                    case '\n': {
                        pos = this.replace(pos, this.LF, inputLength);
                        changed = true;
                        break;
                    }
                    case '\r': {
                        pos = this.replace(pos, this.CR, inputLength);
                        changed = true;
                        break;
                    }
                    case '\t': {
                        pos = this.replace(pos, this.TAB, inputLength);
                        changed = true;
                        break;
                    }
                    default: {
                        ++pos;
                    }
                }
            }
            return changed ? new String(this.value, 0, pos) : input;
        }

        public String convertText(String input) {
            boolean changed = false;
            int inputLength = input.length();
            this.grow(inputLength);
            input.getChars(0, inputLength, this.value, 0);
            int pos = 0;
            while (inputLength-- > 0) {
                switch (this.value[pos]) {
                    case '&': {
                        pos = this.replace(pos, this.AMP, inputLength);
                        changed = true;
                        break;
                    }
                    case '<': {
                        pos = this.replace(pos, this.LESS, inputLength);
                        changed = true;
                        break;
                    }
                    case '\"': {
                        pos = this.replace(pos, this.QUOTE, inputLength);
                        changed = true;
                        break;
                    }
                    case '\n': {
                        pos = this.replace(pos, this.LINE_FEED, inputLength);
                        changed = true;
                        break;
                    }
                    default: {
                        ++pos;
                    }
                }
            }
            return changed ? new String(this.value, 0, pos) : input;
        }

        public String convertLines(String input) {
            boolean changed = false;
            int inputLength = input.length();
            this.grow(inputLength);
            input.getChars(0, inputLength, this.value, 0);
            int pos = 0;
            while (inputLength-- > 0) {
                switch (this.value[pos]) {
                    case '\n': {
                        pos = this.replace(pos, this.LINE_FEED, inputLength);
                        changed = true;
                        break;
                    }
                    default: {
                        ++pos;
                    }
                }
            }
            return changed ? new String(this.value, 0, pos) : input;
        }

        protected int replace(int pos, char[] replacement, int inputLength) {
            int rlen = replacement.length;
            int newPos = pos + rlen;
            this.grow(newPos + inputLength);
            System.arraycopy(this.value, pos + 1, this.value, newPos, inputLength);
            System.arraycopy(replacement, 0, this.value, pos, rlen);
            return newPos;
        }

        protected void grow(int newSize) {
            int vlen = this.value.length;
            if (vlen < newSize) {
                char[] newValue = new char[newSize + newSize / 2];
                System.arraycopy(this.value, 0, newValue, 0, vlen);
                this.value = newValue;
            }
        }
    }
}

