/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: SDOFactory.java,v 1.2.2.1 2005/06/08 18:25:21 nickb Exp $
 */
package org.eclipse.emf.ecore.sdo;

import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EStructuralFeature;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.emf.ecore.sdo.SDOPackage
 * @generated
 */
public interface SDOFactory extends EFactory
{
  /**
   * The singleton instance of the factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  SDOFactory eINSTANCE = new org.eclipse.emf.ecore.sdo.impl.SDOFactoryImpl();

  /**
   * Returns a new object of class '<em>EData Object</em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return a new object of class '<em>EData Object</em>'.
   * @generated
   */
  EDataObject createEDataObject();

  /**
   * Returns a new object of class '<em>EData Graph</em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return a new object of class '<em>EData Graph</em>'.
   * @generated
   */
  EDataGraph createEDataGraph();

  /**
   * Returns a new object of class '<em>EChange Summary</em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return a new object of class '<em>EChange Summary</em>'.
   * @generated
   */
  EChangeSummary createEChangeSummary();

  /**
   * Returns a new object of class '<em>EProperty</em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return a new object of class '<em>EProperty</em>'.
   * @generated
   */
  EProperty createEProperty();

  /**
   * Returns a new object of class '<em>EType</em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return a new object of class '<em>EType</em>'.
   * @generated
   */
  EType createEType();

  /**
   * Returns a new object of class '<em>EData Object Any Type</em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return a new object of class '<em>EData Object Any Type</em>'.
   * @generated
   */
  EDataObjectAnyType createEDataObjectAnyType();

  /**
   * Returns a new object of class '<em>EData Object Simple Any Type</em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return a new object of class '<em>EData Object Simple Any Type</em>'.
   * @generated
   */
  EDataObjectSimpleAnyType createEDataObjectSimpleAnyType();

  /**
   * Returns a new object of class '<em>EChange Summary Setting</em>'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return a new object of class '<em>EChange Summary Setting</em>'.
   * @generated
   */
  EChangeSummarySetting createEChangeSummarySetting();

  /**
   * Returns the package supported by this factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the package supported by this factory.
   * @generated
   */
  SDOPackage getSDOPackage();

  EChangeSummarySetting createEChangeSummarySetting(EStructuralFeature eStructuralFeature, Object value, boolean isSet);

} //SDOFactory
