/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: SDOAdapterFactory.java,v 1.2.2.1 2005/06/08 18:25:21 nickb Exp $
 */
package org.eclipse.emf.ecore.sdo.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.sdo.*;

import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.emf.ecore.sdo.SDOPackage
 * @generated
 */
public class SDOAdapterFactory extends AdapterFactoryImpl
{
  /**
   * The cached model package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected static SDOPackage modelPackage;

  /**
   * Creates an instance of the adapter factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public SDOAdapterFactory()
  {
    if (modelPackage == null)
    {
      modelPackage = SDOPackage.eINSTANCE;
    }
  }

  /**
   * Returns whether this factory is applicable for the type of the object.
   * <!-- begin-user-doc -->
   * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
   * <!-- end-user-doc -->
   * @return whether this factory is applicable for the type of the object.
   * @generated
   */
  public boolean isFactoryForType(Object object)
  {
    if (object == modelPackage)
    {
      return true;
    }
    if (object instanceof EObject)
    {
      return ((EObject)object).eClass().getEPackage() == modelPackage;
    }
    return false;
  }

  /**
   * The switch the delegates to the <code>createXXX</code> methods.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected SDOSwitch modelSwitch =
    new SDOSwitch()
    {
      public Object caseEChangeSummary(EChangeSummary object)
      {
        return createEChangeSummaryAdapter();
      }
      public Object caseEChangeSummarySetting(EChangeSummarySetting object)
      {
        return createEChangeSummarySettingAdapter();
      }
      public Object caseEDataGraph(EDataGraph object)
      {
        return createEDataGraphAdapter();
      }
      public Object caseEDataObject(EDataObject object)
      {
        return createEDataObjectAdapter();
      }
      public Object caseEProperty(EProperty object)
      {
        return createEPropertyAdapter();
      }
      public Object caseChangeSummary(ChangeSummary object)
      {
        return createChangeSummaryAdapter();
      }
      public Object caseChangeSummarySetting(ChangeSummary.Setting object)
      {
        return createChangeSummarySettingAdapter();
      }
      public Object caseDataGraph(DataGraph object)
      {
        return createDataGraphAdapter();
      }
      public Object caseDataObject(DataObject object)
      {
        return createDataObjectAdapter();
      }
      public Object caseESequence(ESequence object)
      {
        return createESequenceAdapter();
      }
      public Object caseEType(EType object)
      {
        return createETypeAdapter();
      }
      public Object caseProperty(Property object)
      {
        return createPropertyAdapter();
      }
      public Object caseSequence(Sequence object)
      {
        return createSequenceAdapter();
      }
      public Object caseType(Type object)
      {
        return createTypeAdapter();
      }
      public Object caseInternalEDataObject(InternalEDataObject object)
      {
        return createInternalEDataObjectAdapter();
      }
      public Object caseEDataObjectAnyType(EDataObjectAnyType object)
      {
        return createEDataObjectAnyTypeAdapter();
      }
      public Object caseEDataObjectSimpleAnyType(EDataObjectSimpleAnyType object)
      {
        return createEDataObjectSimpleAnyTypeAdapter();
      }
      public Object caseChangeDescription(ChangeDescription object)
      {
        return createChangeDescriptionAdapter();
      }
      public Object caseFeatureChange(FeatureChange object)
      {
        return createFeatureChangeAdapter();
      }
      public Object caseAnyType(AnyType object)
      {
        return createAnyTypeAdapter();
      }
      public Object caseSimpleAnyType(SimpleAnyType object)
      {
        return createSimpleAnyTypeAdapter();
      }
      public Object defaultCase(EObject object)
      {
        return createEObjectAdapter();
      }
    };

  /**
   * Creates an adapter for the <code>target</code>.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param target the object to adapt.
   * @return the adapter for the <code>target</code>.
   * @generated
   */
  public Adapter createAdapter(Notifier target)
  {
    return (Adapter)modelSwitch.doSwitch((EObject)target);
  }


  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EDataObject <em>EData Object</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EDataObject
   * @generated
   */
  public Adapter createEDataObjectAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EDataGraph <em>EData Graph</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EDataGraph
   * @generated
   */
  public Adapter createEDataGraphAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EChangeSummary <em>EChange Summary</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EChangeSummary
   * @generated
   */
  public Adapter createEChangeSummaryAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EProperty <em>EProperty</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EProperty
   * @generated
   */
  public Adapter createEPropertyAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link commonj.sdo.DataObject <em>Data Object</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see commonj.sdo.DataObject
   * @generated
   */
  public Adapter createDataObjectAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.util.ESequence <em>ESequence</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.util.ESequence
   * @generated
   */
  public Adapter createESequenceAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link commonj.sdo.DataGraph <em>Data Graph</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see commonj.sdo.DataGraph
   * @generated
   */
  public Adapter createDataGraphAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link commonj.sdo.ChangeSummary <em>Change Summary</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see commonj.sdo.ChangeSummary
   * @generated
   */
  public Adapter createChangeSummaryAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EType <em>EType</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EType
   * @generated
   */
  public Adapter createETypeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link commonj.sdo.Type <em>Type</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see commonj.sdo.Type
   * @generated
   */
  public Adapter createTypeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link commonj.sdo.Property <em>Property</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see commonj.sdo.Property
   * @generated
   */
  public Adapter createPropertyAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link commonj.sdo.Sequence <em>Sequence</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see commonj.sdo.Sequence
   * @generated
   */
  public Adapter createSequenceAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EChangeSummarySetting <em>EChange Summary Setting</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EChangeSummarySetting
   * @generated
   */
  public Adapter createEChangeSummarySettingAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.InternalEDataObject <em>Internal EData Object</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.InternalEDataObject
   * @generated
   */
  public Adapter createInternalEDataObjectAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EDataObjectAnyType <em>EData Object Any Type</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EDataObjectAnyType
   * @generated
   */
  public Adapter createEDataObjectAnyTypeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.sdo.EDataObjectSimpleAnyType <em>EData Object Simple Any Type</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.sdo.EDataObjectSimpleAnyType
   * @generated
   */
  public Adapter createEDataObjectSimpleAnyTypeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.change.ChangeDescription <em>Description</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.change.ChangeDescription
   * @generated
   */
  public Adapter createChangeDescriptionAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.change.FeatureChange <em>Feature Change</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.change.FeatureChange
   * @generated
   */
  public Adapter createFeatureChangeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.xml.type.AnyType <em>Any Type</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.xml.type.AnyType
   * @generated
   */
  public Adapter createAnyTypeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.eclipse.emf.ecore.xml.type.SimpleAnyType <em>Simple Any Type</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.eclipse.emf.ecore.xml.type.SimpleAnyType
   * @generated
   */
  public Adapter createSimpleAnyTypeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link commonj.sdo.ChangeSummary.Setting <em>Change Summary Setting</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see commonj.sdo.ChangeSummary.Setting
   * @generated
   */
  public Adapter createChangeSummarySettingAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for the default case.
   * <!-- begin-user-doc -->
   * This default implementation returns null.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @generated
   */
  public Adapter createEObjectAdapter()
  {
    return null;
  }

} //SDOAdapterFactory
