/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: EndLoggingAction.java,v 1.1.2.1 2005/06/08 18:25:22 nickb Exp $
 */
package org.eclipse.emf.ecore.sdo.action;


import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

import commonj.sdo.ChangeSummary;


/**
 * 
 */
public class EndLoggingAction 
  extends ActionDelegate
  implements IActionDelegate
{
  protected ChangeSummary changeSummary;

  public EndLoggingAction()
  {
  }

  public void run(IAction action)
  {
    changeSummary.endLogging();
  }

  public void selectionChanged(IAction action, ISelection selection) 
  {
    if (selection instanceof IStructuredSelection)
    {
      Object object = ((IStructuredSelection)selection).getFirstElement();
      if (object instanceof ChangeSummary)
      {
        changeSummary = (ChangeSummary)object;
        if (changeSummary.isLogging())
        {
          action.setEnabled(true);
          return;
        }
      }
    }
    changeSummary = null;
    action.setEnabled(false);
  }

}
