/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import java.util.Map;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.PerformanceMonitor;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;

class PerformanceMonitorMac
extends PerformanceMonitor {
    private static boolean fgHasElapsedTime = true;
    private static long fgStartupTime;
    private static final String NATIVE_LIBRARY_NAME = "perf_3_1_0";
    private static int fgIsLoaded;

    static {
        fgIsLoaded = 0;
    }

    PerformanceMonitorMac() {
    }

    public static boolean isLoaded() {
        if (fgIsLoaded == 0) {
            try {
                System.loadLibrary(NATIVE_LIBRARY_NAME);
                fgIsLoaded = 2;
            }
            catch (Throwable e) {
                PerformanceTestPlugin.log(e);
                fgIsLoaded = 1;
            }
        }
        return fgIsLoaded == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectOperatingSystemCounters(Map scalars) {
        PerformanceMonitorMac performanceMonitorMac = this;
        synchronized (performanceMonitorMac) {
            int[] counters;
            if (PerformanceMonitorMac.isLoaded() && PerformanceMonitorMac.getrusage(0, counters = new int[18]) == 0) {
                int user_time = counters[0] * 1000 + counters[1] / 1000;
                int kernel_time = counters[2] * 1000 + counters[3] / 1000;
                this.addScalar(scalars, InternalDimensions.KERNEL_TIME, kernel_time);
                this.addScalar(scalars, InternalDimensions.CPU_TIME, user_time + kernel_time);
            }
            long currentTime = System.currentTimeMillis();
            if (!PerformanceTestPlugin.isOldDB()) {
                this.addScalar(scalars, InternalDimensions.SYSTEM_TIME, currentTime);
            }
            if (fgHasElapsedTime) {
                if (fgStartupTime == 0L) {
                    String t = System.getProperty("eclipse.startTime");
                    if (t != null) {
                        try {
                            fgStartupTime = Long.parseLong(t);
                        }
                        catch (NumberFormatException numberFormatException) {
                            fgHasElapsedTime = false;
                        }
                    } else {
                        fgHasElapsedTime = false;
                    }
                }
                this.addScalar(scalars, InternalDimensions.ELAPSED_PROCESS, currentTime - fgStartupTime);
            }
            super.collectOperatingSystemCounters(scalars);
        }
    }

    private static native int getrusage(int var0, int[] var1);
}

