/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.data;

import java.text.NumberFormat;

public class Unit {
    public static final Unit SECOND = new Unit("s", "second", false);
    public static final Unit BYTE = new Unit("byte", "byte", true);
    public static final Unit CARDINAL = new Unit("", "", false);
    public static final Unit INVOCATION = new Unit("invoc.", "invocation", false);
    private static final int T_DECIMAL = 1000;
    private static final int T_BINARY = 1024;
    private final String fShortName;
    private final String fFullName;
    private final boolean fIsBinary;

    public Unit(String shortName, String fullName, boolean binary) {
        this.fShortName = shortName;
        this.fFullName = fullName;
        this.fIsBinary = binary;
    }

    public String getShortName() {
        return this.fShortName;
    }

    public String getFullName() {
        return this.fFullName;
    }

    public String getDisplayValue1(long magnitudel, int multiplier) {
        return this.getDisplayValue1(magnitudel / (long)multiplier);
    }

    public String getDisplayValue1(double magnitude) {
        if (this == SECOND) {
            return Unit.formatedTime((long)(magnitude * 1000.0));
        }
        return this.formatEng((long)magnitude);
    }

    public String getUnformattedValue(double value) {
        if (this == SECOND) {
            return String.valueOf(String.valueOf((long)value)) + " ms";
        }
        return String.valueOf((long)value);
    }

    public String toString() {
        return "Unit [" + this.getShortName() + "]";
    }

    public static String formatedTime(long diff) {
        if (diff < 0L) {
            diff *= -1L;
        }
        if (diff < 1000L) {
            return String.valueOf(String.valueOf(diff)) + " ms";
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        double d = (double)diff / 1000.0;
        if (d < 60.0) {
            return String.valueOf(nf.format(d)) + " s";
        }
        if ((d /= 60.0) < 60.0) {
            return String.valueOf(nf.format(d)) + " m";
        }
        if ((d /= 60.0) < 24.0) {
            return String.valueOf(nf.format(d)) + " h";
        }
        return String.valueOf(nf.format(d /= 24.0)) + " d";
    }

    public String formatEng(long n) {
        int TSD;
        int n2 = TSD = this.fIsBinary ? 1024 : 1000;
        if (n < (long)TSD) {
            return String.valueOf(n);
        }
        double d = (double)n / (double)TSD;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        if (d < (double)TSD) {
            return String.valueOf(nf.format(d)) + "K";
        }
        if ((d /= (double)TSD) < (double)TSD) {
            return String.valueOf(nf.format(d)) + "M";
        }
        if ((d /= (double)TSD) < (double)TSD) {
            return String.valueOf(nf.format(d)) + "G";
        }
        return String.valueOf(nf.format(d /= (double)TSD)) + "T";
    }
}

