/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.performance;

import junit.framework.TestCase;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.InternalPerformanceMeter;
import org.eclipse.test.internal.performance.NullPerformanceMeter;
import org.eclipse.test.internal.performance.OSPerformanceMeterFactory;
import org.eclipse.test.internal.performance.PerformanceMeterFactory;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.eval.AbsoluteBandChecker;
import org.eclipse.test.internal.performance.eval.AssertChecker;
import org.eclipse.test.internal.performance.eval.Evaluator;
import org.eclipse.test.internal.performance.eval.IEvaluator;
import org.eclipse.test.internal.performance.eval.RelativeBandChecker;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceMeter;

public class Performance {
    private static final String PERFORMANCE_METER_FACTORY_PROPERTY = "PerformanceMeterFactory";
    private static Performance fgDefault;
    private PerformanceMeterFactory fPerformanceMeterFactory;
    private IEvaluator fDefaultEvaluator;
    private NullPerformanceMeter fNullPeformanceMeter;

    private Performance() {
    }

    public static Performance getDefault() {
        if (fgDefault == null) {
            fgDefault = new Performance();
        }
        return fgDefault;
    }

    public void assertPerformance(PerformanceMeter performanceMeter) {
        if (this.fDefaultEvaluator == null) {
            this.fDefaultEvaluator = new Evaluator();
            this.fDefaultEvaluator.setAssertCheckers(new AssertChecker[]{new RelativeBandChecker(InternalDimensions.CPU_TIME, 0.0, 1.1f)});
        }
        this.fDefaultEvaluator.evaluate(performanceMeter);
    }

    public void assertPerformanceInRelativeBand(PerformanceMeter performanceMeter, Dimension dim, int lowerPercentage, int upperPercentage) {
        Evaluator e = new Evaluator();
        e.setAssertCheckers(new AssertChecker[]{new RelativeBandChecker((Dim)dim, 1.0 + (double)lowerPercentage / 100.0, 1.0 + (double)upperPercentage / 100.0)});
        e.evaluate(performanceMeter);
    }

    public void assertPerformanceInAbsoluteBand(PerformanceMeter performanceMeter, Dimension dim, int lowerBand, int upperBand) {
        Evaluator e = new Evaluator();
        e.setAssertCheckers(new AssertChecker[]{new AbsoluteBandChecker((Dim)dim, lowerBand, upperBand)});
        e.evaluate(performanceMeter);
    }

    public PerformanceMeter createPerformanceMeter(String scenarioId) {
        return this.getPeformanceMeterFactory().createPerformanceMeter(scenarioId);
    }

    public PerformanceMeter getNullPerformanceMeter() {
        if (this.fNullPeformanceMeter == null) {
            this.fNullPeformanceMeter = new NullPerformanceMeter();
        }
        return this.fNullPeformanceMeter;
    }

    public String getDefaultScenarioId(TestCase test) {
        return String.valueOf(test.getClass().getName()) + '#' + test.getName() + "()";
    }

    public String getDefaultScenarioId(TestCase test, String id) {
        return String.valueOf(this.getDefaultScenarioId(test)) + '-' + id;
    }

    private PerformanceMeterFactory getPeformanceMeterFactory() {
        if (this.fPerformanceMeterFactory == null) {
            this.fPerformanceMeterFactory = this.createPerformanceMeterFactory();
        }
        return this.fPerformanceMeterFactory;
    }

    private PerformanceMeterFactory createPerformanceMeterFactory() {
        PerformanceMeterFactory factory = this.tryInstantiate(System.getProperty(PERFORMANCE_METER_FACTORY_PROPERTY));
        if (factory != null) {
            return factory;
        }
        if (factory != null) {
            return factory;
        }
        return this.createDefaultPerformanceMeterFactory();
    }

    private PerformanceMeterFactory tryInstantiate(String className) {
        return null;
    }

    private PerformanceMeterFactory createDefaultPerformanceMeterFactory() {
        return new OSPerformanceMeterFactory();
    }

    public void tagAsGlobalSummary(PerformanceMeter pm, String shortName, Dimension dimension) {
        this.tagAsGlobalSummary(pm, shortName, new Dimension[]{dimension});
    }

    public void tagAsGlobalSummary(PerformanceMeter pm, String shortName, Dimension[] dimensions) {
        if (pm instanceof InternalPerformanceMeter) {
            InternalPerformanceMeter ipm = (InternalPerformanceMeter)pm;
            ipm.tagAsSummary(true, shortName, dimensions);
        }
    }

    public void tagAsSummary(PerformanceMeter pm, String shortName, Dimension dimension) {
        this.tagAsSummary(pm, shortName, new Dimension[]{dimension});
    }

    public void tagAsSummary(PerformanceMeter pm, String shortName, Dimension[] dimensions) {
        if (pm instanceof InternalPerformanceMeter) {
            InternalPerformanceMeter ipm = (InternalPerformanceMeter)pm;
            ipm.tagAsSummary(false, shortName, dimensions);
        }
    }
}

