/**
 * <copyright>
 *
 * Copyright (c) 2003-2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: EDataGraphImpl.java,v 1.6.2.1 2005/06/08 18:25:21 nickb Exp $
 */
package org.eclipse.emf.ecore.sdo.impl;


import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Iterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.sdo.EChangeSummary;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.sdo.EType;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Type;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>EData Graph</b></em>'.
 * @extends DataGraph, Adapter, EDataGraph.Internal, Serializable
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EDataGraphImpl#getRootObject <em>Root Object</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EDataGraphImpl#getChangeSummary <em>Change Summary</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EDataGraphImpl#getResourceSet <em>Resource Set</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EDataGraphImpl#getRootResource <em>Root Resource</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EDataGraphImpl#getEChangeSummary <em>EChange Summary</em>}</li>
 *   <li>{@link org.eclipse.emf.ecore.sdo.impl.EDataGraphImpl#getERootObject <em>ERoot Object</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class EDataGraphImpl extends EObjectImpl implements EDataGraph, DataGraph, Adapter, EDataGraph.Internal, Serializable
{
  /**
   * The default value of the '{@link #getResourceSet() <em>Resource Set</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getResourceSet()
   * @generated
   * @ordered
   */
  protected static final ResourceSet RESOURCE_SET_EDEFAULT = null;

  /**
   * The cached value of the '{@link #getResourceSet() <em>Resource Set</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getResourceSet()
   * @generated
   * @ordered
   */
  protected ResourceSet resourceSet = RESOURCE_SET_EDEFAULT;

  /**
   * The default value of the '{@link #getRootResource() <em>Root Resource</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getRootResource()
   * @generated
   * @ordered
   */
  protected static final Resource ROOT_RESOURCE_EDEFAULT = null;

  /**
   * The cached value of the '{@link #getEChangeSummary() <em>EChange Summary</em>}' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getEChangeSummary()
   * @generated
   * @ordered
   */
  protected EChangeSummary eChangeSummary = null;

  /**
   * The cached value of the '{@link #getERootObject() <em>ERoot Object</em>}' reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getERootObject()
   * @generated
   * @ordered
   */
  protected EObject eRootObject = null;

  /**
   * The cached extended metadata to wrap the resource set's package registry.
   */
  protected ExtendedMetaData extendedMetaData;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EDataGraphImpl()
  {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected EClass eStaticClass()
  {
    return SDOPackage.eINSTANCE.getEDataGraph();
  }

  public boolean isAdapterForType(Object type)
  {
    return type == EDataGraph.class;
  }

  public void notifyChanged(Notification msg)
  {
  }

  public Notifier getTarget()
  {
    return getResourceSet();
  }

  public void setTarget(Notifier newTarget)
  {
  }

  protected ExtendedMetaData getExtendedMetaData()
  {
    if (extendedMetaData == null)
    {
      getResourceSet();
    }
    return extendedMetaData;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public ResourceSet getResourceSet()
  {
    if (resourceSet == null)
    {
      if (eResource() != null)
      {
        resourceSet = eResource().getResourceSet();
      }
      if (resourceSet == null)
      {
        resourceSet = createResourceSet();
      }
      initializeResourceSet(resourceSet);
    }
    return resourceSet;
  }

  protected ResourceSet createResourceSet()
  {
    return SDOUtil.createResourceSet();
  }

  protected Resource createRootResource()
  {
    Resource result = resourceSet.createResource(URI.createURI("root.xml"));
    result.getContents().clear();
    return result;
  }

  protected Resource createChangeSummaryResource()
  {
    Resource result = resourceSet.createResource(URI.createURI("change-summary.xml"));
    result.getContents().clear();
    return result;
  }

  protected void initializeResourceSet(ResourceSet resourceSet)
  {
    if (resourceSet == null)
    {
      extendedMetaData = null;
    }
    else
    {
      extendedMetaData = new BasicExtendedMetaData(resourceSet.getPackageRegistry());
      resourceSet.eAdapters().add(this);
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setResourceSetGen(ResourceSet newResourceSet)
  {
    ResourceSet oldResourceSet = resourceSet;
    resourceSet = newResourceSet;
    if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, SDOPackage.EDATA_GRAPH__RESOURCE_SET, oldResourceSet, resourceSet));
  }

  public void setResourceSet(ResourceSet newResourceSet)
  {
    if (resourceSet != null)
    {
      resourceSet.eAdapters().remove(this);
    }
    setResourceSetGen(newResourceSet);
    initializeResourceSet(newResourceSet);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public Resource getRootResource()
  {
    if (eRootObject == null)
    {
      Resource result = getResourceSet().getResource(URI.createURI("root.xml"), false);
      if (result == null)
      {
        result = createRootResource();
      }

      return result;
    }
    else
    {
      return eRootObject.eResource();
    }
  }

  public Resource getDataGraphResource()
  {
    Resource result = eResource();
    if (result == null)
    {
      result = getResourceSet().createResource(URI.createURI("all.datagraph"));
      result.getContents().add(this);
    }
    return result;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EChangeSummary getEChangeSummary()
  {
    return eChangeSummary;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public NotificationChain basicSetEChangeSummary(EChangeSummary newEChangeSummary, NotificationChain msgs)
  {
    EChangeSummary oldEChangeSummary = eChangeSummary;
    eChangeSummary = newEChangeSummary;
    if (eNotificationRequired())
    {
      ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, SDOPackage.EDATA_GRAPH__ECHANGE_SUMMARY, oldEChangeSummary, newEChangeSummary);
      if (msgs == null) msgs = notification; else msgs.add(notification);
    }
    return msgs;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setEChangeSummary(EChangeSummary newEChangeSummary)
  {
    if (newEChangeSummary != eChangeSummary)
    {
      NotificationChain msgs = null;
      if (eChangeSummary != null)
        msgs = ((InternalEObject)eChangeSummary).eInverseRemove(this, SDOPackage.ECHANGE_SUMMARY__EDATA_GRAPH, EChangeSummary.class, msgs);
      if (newEChangeSummary != null)
        msgs = ((InternalEObject)newEChangeSummary).eInverseAdd(this, SDOPackage.ECHANGE_SUMMARY__EDATA_GRAPH, EChangeSummary.class, msgs);
      msgs = basicSetEChangeSummary(newEChangeSummary, msgs);
      if (msgs != null) msgs.dispatch();
    }
    else if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, SDOPackage.EDATA_GRAPH__ECHANGE_SUMMARY, newEChangeSummary, newEChangeSummary));
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EObject getERootObject()
  {
    return eRootObject;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setERootObjectGen(EObject newERootObject)
  {
    EObject oldERootObject = eRootObject;
    eRootObject = newERootObject;
    if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, SDOPackage.EDATA_GRAPH__EROOT_OBJECT, oldERootObject, eRootObject));
  }

  public void setERootObject(EObject newERootObject)
  {
    // If there is a resource set already...
    //
    if (resourceSet != null)
    {
      // Get the root resource and if there's a root object in it already, clear it.
      // Then set the root object and add it to the root resource.
      //
      List contents = getRootResource().getContents();
      if (eRootObject != null)
      {
        contents.clear();
      }
      setERootObjectGen(newERootObject);
      if (newERootObject != null)
      {
        contents.add(newERootObject);
      }
    }
    else
    {
      // Set the root object and see if it has a resource we can reuse.
      //
      setERootObjectGen(newERootObject);
      Resource rootResource = newERootObject.eResource();
      if (rootResource != null)
      {
        // If there is no resource set
        //
        if (rootResource.getResourceSet() == null)
        {
          // Demand create one and add this resource to it.
          //
          getResourceSet().getResources().add(rootResource);
        }
        else
        {
          // Reuse the existing resource set.
          //
          setResourceSet(rootResource.getResourceSet());
        }
      }
      else
      {
        // Demand create the resource set and the root resource, and add to it's contents.
        //
        getResourceSet();
        createRootResource().getContents().add(newERootObject);
      }
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public EClassifier getEClassifier(String namespaceURI, String typeName)
  {
    ExtendedMetaData extendedMetaData = getExtendedMetaData();
    EPackage ePackage = extendedMetaData.getPackage(namespaceURI);
    if (ePackage != null)
    {
      EClassifier eClassifier = ePackage.getEClassifier(typeName);
      if (eClassifier == null)
      {
        eClassifier = extendedMetaData.getType(ePackage, typeName);
      }
      return eClassifier;
    }
    else
    {
      return null;
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public Type getType(String namespaceURI, String typeName)
  {
    return getEType(namespaceURI, typeName);
  }

  public EType getEType(String namespaceURI, String typeName)
  {
    EClassifier eClassifier = getEClassifier(namespaceURI, typeName);
    return eClassifier == null ? null : SDOUtil.adaptType(eClassifier);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated NOT
   */
  public EObject createEObject(EClass type)
  {
    return EcoreUtil.create(type);
  }

  public EDataObject createEDataObject(EType type)
  {
    return SDOUtil.create(type);
  }

  public DataObject getRootObject()
  {
    return (EDataObject)getERootObject();
  }

  public DataObject createRootObject(String namespaceURI, String typeName)
  {
    EDataObject eDataObject = SDOUtil.create(getEType(namespaceURI, typeName));
    setERootObject(eDataObject);
    return eDataObject;
  }

  public DataObject createRootObject(Type type)
  {
    EDataObject eDataObject = SDOUtil.create((EType)type);
    setERootObject(eDataObject);
    return eDataObject;
  }

  public ChangeSummary getChangeSummary()
  {
    //FB is this the right place to create the resources?
    EChangeSummary changeSummary = getEChangeSummary();
    if (changeSummary == null)
    {
      getRootResource();
      changeSummary = createEChangeSummary();
      setEChangeSummary(changeSummary);
    }

    if (changeSummary.eResource() == null)
    {
      Resource changeSummaryResource = createChangeSummaryResource();
      changeSummaryResource.getContents().add(changeSummary);
    }

    return changeSummary;
  }

  protected EChangeSummary createEChangeSummary()
  {
    return SDOFactory.eINSTANCE.createEChangeSummary();
  }

  public static class EDataGraphExternalizable implements Externalizable
  {
    protected EDataGraph eDataGraph;
    protected Map writeReplacements = new HashMap();

    public EDataGraphExternalizable()
    {
    }

    public EDataGraphExternalizable(EDataGraph eDataGraph)
    {
      this.eDataGraph = eDataGraph;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException
    {
      ByteArrayOutputStream byteArrayOutputStream =
        new ByteArrayOutputStream()
        {
          public byte [] toByteArray()
          {
            return super.toByteArray();
          }
        };

      eDataGraph.getDataGraphResource().save(byteArrayOutputStream, null);
      objectOutput.writeInt(byteArrayOutputStream.toByteArray().length);
      objectOutput.write(byteArrayOutputStream.toByteArray());
    }

    public void readExternal(ObjectInput objectInput) throws IOException
    {
      int length = objectInput.readInt();
      byte [] bytes = new byte [length];
      objectInput.readFully(bytes);

      ResourceSet resourceSet = createResourceSet();
      Resource resource = resourceSet.createResource(URI.createURI("all.datagraph"));
      resource.load(new ByteArrayInputStream(bytes), null);
      eDataGraph = (EDataGraph)resource.getContents().get(0);
    }

    protected ResourceSet createResourceSet()
    {
      return SDOUtil.createResourceSet();
    }

    public Object getWriteReplacement(EObject eObject)
    {
      Object result = writeReplacements.get(eObject);
      if (result == null)
      {
        result = new EDataObjectExternalizable(eDataGraph, eObject);
        writeReplacements.put(eObject, result);
      }
      return result;
    }

    protected Object readResolve()
    {
      return eDataGraph;
    }
  }

  public static class EDataObjectExternalizable implements Externalizable
  {
    protected EObject eObject;
    protected EDataGraph eDataGraph;

    public EDataObjectExternalizable()
    {
    }

    public EDataObjectExternalizable(EDataGraph eDataGraph, EObject eObject)
    {
      this.eDataGraph = eDataGraph;
      this.eObject = eObject;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException
    {
      // Write the data object reference too.
      String uri = eObject.eResource().getURIFragment(eObject);
      objectOutput.writeUTF(uri);
      objectOutput.writeObject(((EDataGraph.Internal)eDataGraph).getWriteReplacement());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException
    {
      String uri = objectInput.readUTF();
      eDataGraph = (EDataGraph)objectInput.readObject();
      eObject = eDataGraph.getRootResource().getEObject(uri);
    }

    protected Object readResolve()
    {
      return eObject;
    }
  }

  
  protected EDataGraphExternalizable eDataGraphExternalizable;
  protected Adapter modificationTracker;

  public Object getWriteReplacement()
  {
    if (eDataGraphExternalizable == null)
    {
      eDataGraphExternalizable = createEDataGraphExternalizable();
      getRootResource().setTrackingModification(true);
      modificationTracker = 
        new AdapterImpl()
        {
          public void notifyChanged(Notification notification)
          {
            if (notification.getFeatureID(Resource.class) == Resource.RESOURCE__IS_MODIFIED && notification.getNewBooleanValue())
            {
              eDataGraphExternalizable = null;
              modificationTracker = null;
              ((Resource)target).eAdapters().remove(this);
            }
          }
        };
      getRootResource().eAdapters().add(modificationTracker);
    }
    return eDataGraphExternalizable;
  }

  protected EDataGraphExternalizable createEDataGraphExternalizable()
  {
    return new EDataGraphExternalizable(this);
  }

  public Object getWriteReplacement(EObject eObject)
  {
    return ((EDataGraphExternalizable)getWriteReplacement()).getWriteReplacement(eObject);
  }

  public Object writeReplace()
  {
    return getWriteReplacement();
  }

  public EObject eObjectForURIFragmentSegment(String uriFragmentSegment)
  {
    if (uriFragmentSegment.startsWith("@models."))
    {
      if (resourceSet != null)
      {
        int count = Integer.parseInt(uriFragmentSegment.substring(8));
        for (Iterator i = resourceSet.getResources().iterator(); i.hasNext(); )
        {
          Resource ePackageResource =  (Resource)i.next();
          List resourceContents =  ePackageResource.getContents();
          if (resourceContents.size() == 1 && resourceContents.get(0) instanceof EPackage && count-- == 0)
          {
            return (EObject)resourceContents.get(0);
          }
        }
      }

      return null;
    }
    else
    {
      return super.eObjectForURIFragmentSegment(uriFragmentSegment);
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
  {
    if (featureID >= 0)
    {
      switch (eDerivedStructuralFeatureID(featureID, baseClass))
      {
        case SDOPackage.EDATA_GRAPH__ECHANGE_SUMMARY:
          if (eChangeSummary != null)
            msgs = ((InternalEObject)eChangeSummary).eInverseRemove(this, SDOPackage.ECHANGE_SUMMARY__EDATA_GRAPH, EChangeSummary.class, msgs);
          return basicSetEChangeSummary((EChangeSummary)otherEnd, msgs);
        default:
          return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
      }
    }
    if (eContainer != null)
      msgs = eBasicRemoveFromContainer(msgs);
    return eBasicSetContainer(otherEnd, featureID, msgs);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
  {
    if (featureID >= 0)
    {
      switch (eDerivedStructuralFeatureID(featureID, baseClass))
      {
        case SDOPackage.EDATA_GRAPH__ECHANGE_SUMMARY:
          return basicSetEChangeSummary(null, msgs);
        default:
          return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
      }
    }
    return eBasicSetContainer(null, featureID, msgs);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public Object eGet(EStructuralFeature eFeature, boolean resolve)
  {
    switch (eDerivedStructuralFeatureID(eFeature))
    {
      case SDOPackage.EDATA_GRAPH__ROOT_OBJECT:
        return getRootObject();
      case SDOPackage.EDATA_GRAPH__CHANGE_SUMMARY:
        return getChangeSummary();
      case SDOPackage.EDATA_GRAPH__RESOURCE_SET:
        return getResourceSet();
      case SDOPackage.EDATA_GRAPH__ROOT_RESOURCE:
        return getRootResource();
      case SDOPackage.EDATA_GRAPH__ECHANGE_SUMMARY:
        return getEChangeSummary();
      case SDOPackage.EDATA_GRAPH__EROOT_OBJECT:
        return getERootObject();
    }
    return eDynamicGet(eFeature, resolve);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void eSet(EStructuralFeature eFeature, Object newValue)
  {
    switch (eDerivedStructuralFeatureID(eFeature))
    {
      case SDOPackage.EDATA_GRAPH__RESOURCE_SET:
        setResourceSet((ResourceSet)newValue);
        return;
      case SDOPackage.EDATA_GRAPH__ECHANGE_SUMMARY:
        setEChangeSummary((EChangeSummary)newValue);
        return;
      case SDOPackage.EDATA_GRAPH__EROOT_OBJECT:
        setERootObject((EObject)newValue);
        return;
    }
    eDynamicSet(eFeature, newValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void eUnset(EStructuralFeature eFeature)
  {
    switch (eDerivedStructuralFeatureID(eFeature))
    {
      case SDOPackage.EDATA_GRAPH__RESOURCE_SET:
        setResourceSet(RESOURCE_SET_EDEFAULT);
        return;
      case SDOPackage.EDATA_GRAPH__ECHANGE_SUMMARY:
        setEChangeSummary((EChangeSummary)null);
        return;
      case SDOPackage.EDATA_GRAPH__EROOT_OBJECT:
        setERootObject((EObject)null);
        return;
    }
    eDynamicUnset(eFeature);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public boolean eIsSet(EStructuralFeature eFeature)
  {
    switch (eDerivedStructuralFeatureID(eFeature))
    {
      case SDOPackage.EDATA_GRAPH__ROOT_OBJECT:
        return getRootObject() != null;
      case SDOPackage.EDATA_GRAPH__CHANGE_SUMMARY:
        return getChangeSummary() != null;
      case SDOPackage.EDATA_GRAPH__RESOURCE_SET:
        return RESOURCE_SET_EDEFAULT == null ? resourceSet != null : !RESOURCE_SET_EDEFAULT.equals(resourceSet);
      case SDOPackage.EDATA_GRAPH__ROOT_RESOURCE:
        return ROOT_RESOURCE_EDEFAULT == null ? getRootResource() != null : !ROOT_RESOURCE_EDEFAULT.equals(getRootResource());
      case SDOPackage.EDATA_GRAPH__ECHANGE_SUMMARY:
        return eChangeSummary != null;
      case SDOPackage.EDATA_GRAPH__EROOT_OBJECT:
        return eRootObject != null;
    }
    return eDynamicIsSet(eFeature);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public String toString()
  {
    if (eIsProxy()) return super.toString();

    StringBuffer result = new StringBuffer(super.toString());
    result.append(" (resourceSet: ");
    result.append(resourceSet);
    result.append(')');
    return result.toString();
  }

} //EDataGraphImpl
