/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Sample;
import org.eclipse.test.internal.performance.db.DB;
import org.eclipse.test.internal.performance.db.Variations;
import org.eclipse.test.internal.performance.eval.StatisticsSession;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceMeter;

public abstract class InternalPerformanceMeter
extends PerformanceMeter {
    public static final int AVERAGE = -3;
    public static final int BEFORE = 0;
    public static final int AFTER = 1;
    protected static final String VERBOSE_PERFORMANCE_METER_PROPERTY = "InternalPrintPerformanceResults";
    private String fScenarioId;
    private String fShortName;
    private Dimension[] fSummaryDimensions;
    private boolean fSummaryIsGlobal;

    public InternalPerformanceMeter(String scenarioId) {
        this.fScenarioId = scenarioId;
    }

    public void dispose() {
        this.fScenarioId = null;
    }

    public abstract Sample getSample();

    public String getScenarioName() {
        return this.fScenarioId;
    }

    public void commit() {
        Sample sample = this.getSample();
        if (sample != null) {
            Variations variations;
            if (this.fSummaryDimensions != null) {
                sample.tagAsSummary(this.fSummaryIsGlobal, this.fShortName, this.fSummaryDimensions);
            }
            if ((variations = PerformanceTestPlugin.getVariations()) != null) {
                DB.store(variations, sample);
            }
            if (!DB.isActive() || System.getProperty(VERBOSE_PERFORMANCE_METER_PROPERTY) != null) {
                this.printSample(System.out, sample);
            }
        }
    }

    private void printSample(PrintStream ps, Sample sample) {
        ps.print("Scenario '" + this.getScenarioName() + "' ");
        DataPoint[] dataPoints = sample.getDataPoints();
        if (dataPoints.length > 0) {
            StatisticsSession s = new StatisticsSession(dataPoints);
            Dim[] dimensions = dataPoints[0].getDimensions();
            Arrays.sort(dimensions, new DimensionComparator());
            if (dimensions.length > 0) {
                ps.println("(over " + s.getCount(dimensions[0]) + " samples):");
                int i = 0;
                while (i < dimensions.length) {
                    Dim dimension = dimensions[i];
                    double average = s.getAverage(dimension);
                    ps.println("  " + dimension.getName() + ": " + dimension.getDisplayValue(average));
                    ++i;
                }
            }
        }
        ps.println();
    }

    public void tagAsSummary(boolean global, String shortName, Dimension[] dims) {
        this.fSummaryIsGlobal = global;
        this.fShortName = shortName;
        this.fSummaryDimensions = dims;
    }

    private static class DimensionComparator
    implements Comparator {
        DimensionComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Dim)o1).getId() - ((Dim)o2).getId();
        }
    }
}

