/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.db;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.db.DB;
import org.eclipse.test.internal.performance.db.Report;
import org.eclipse.test.internal.performance.db.TimeSeries;
import org.eclipse.test.internal.performance.db.Variations;
import org.eclipse.test.internal.performance.eval.StatisticsSession;

public class Scenario {
    private static final boolean DEBUG = false;
    private SharedState fSharedState;
    private String fScenarioName;
    private String[] fSeriesNames;
    private StatisticsSession[] fSessions;
    private Map fSeries = new HashMap();
    private Dim[] fDimensions;

    public Scenario(String scenario, Variations variations, String seriesKey, Dim[] dimensions) {
        Assert.assertFalse((scenario.indexOf(37) >= 0 ? 1 : 0) != 0);
        this.fScenarioName = scenario;
        this.fSharedState = new SharedState(variations, scenario, seriesKey, dimensions);
    }

    public Scenario(String scenario, SharedState sharedState) {
        Assert.assertFalse((scenario.indexOf(37) >= 0 ? 1 : 0) != 0);
        this.fScenarioName = scenario;
        this.fSharedState = sharedState;
    }

    public String getScenarioName() {
        return this.fScenarioName;
    }

    public Dim[] getDimensions() {
        this.loadSessions();
        if (this.fDimensions == null) {
            return new Dim[0];
        }
        return this.fDimensions;
    }

    public String[] getTimeSeriesLabels() {
        this.loadSeriesNames();
        if (this.fSeriesNames == null) {
            return new String[0];
        }
        return this.fSeriesNames;
    }

    public String[] getFailureMessages() {
        this.loadSeriesNames();
        return this.fSharedState.getFailures(this.fSeriesNames, this.fScenarioName);
    }

    public TimeSeries getTimeSeries(Dim dim) {
        this.loadSessions();
        TimeSeries ts = (TimeSeries)this.fSeries.get(dim);
        if (ts == null) {
            double[] ds = new double[this.fSessions.length];
            double[] sd = new double[this.fSessions.length];
            int i = 0;
            while (i < ds.length) {
                ds[i] = this.fSessions[i].getAverage(dim);
                sd[i] = this.fSessions[i].getStddev(dim);
                ++i;
            }
            ts = new TimeSeries(this.fSeriesNames, ds, sd);
            this.fSeries.put(dim, ts);
        }
        return ts;
    }

    public void dump(PrintStream ps, String key) {
        ps.println("Scenario: " + this.getScenarioName());
        Report r = new Report(2);
        String[] timeSeriesLabels = this.getTimeSeriesLabels();
        r.addCell(String.valueOf(key) + ":");
        int j = 0;
        while (j < timeSeriesLabels.length) {
            r.addCellRight(timeSeriesLabels[j]);
            ++j;
        }
        r.nextRow();
        Dim[] dimensions = this.getDimensions();
        int i = 0;
        while (i < dimensions.length) {
            Dim dim = dimensions[i];
            r.addCell(String.valueOf(dim.getName()) + ':');
            TimeSeries ts = this.getTimeSeries(dim);
            int n = ts.getLength();
            int j2 = 0;
            while (j2 < n) {
                String stddev = "";
                double stddev2 = ts.getStddev(j2);
                if (stddev2 != 0.0) {
                    stddev = " [" + dim.getDisplayValue(stddev2) + "]";
                }
                r.addCellRight(String.valueOf(dim.getDisplayValue(ts.getValue(j2))) + stddev);
                ++j2;
            }
            r.nextRow();
            ++i;
        }
        r.print(ps);
        ps.println();
    }

    private void loadSeriesNames() {
        if (this.fSeriesNames == null) {
            this.fSeriesNames = DB.querySeriesValues(this.fScenarioName, this.fSharedState.fVariations, this.fSharedState.fSeriesKey);
        }
    }

    private void loadSessions() {
        if (this.fSessions != null) {
            return;
        }
        this.loadSeriesNames();
        Variations v = (Variations)this.fSharedState.fVariations.clone();
        ArrayList<StatisticsSession> sessions = new ArrayList<StatisticsSession>();
        ArrayList<String> names2 = new ArrayList<String>();
        HashSet dims = new HashSet();
        int t = 0;
        while (t < this.fSeriesNames.length) {
            v.put(this.fSharedState.fSeriesKey, this.fSeriesNames[t]);
            DataPoint[] dps = DB.queryDataPoints(v, this.fScenarioName, this.fSharedState.fQueryDimensions);
            if (dps.length > 0) {
                dims.addAll(dps[0].getDimensions2());
                sessions.add(new StatisticsSession(dps));
                names2.add(this.fSeriesNames[t]);
            }
            ++t;
        }
        this.fSessions = sessions.toArray(new StatisticsSession[sessions.size()]);
        this.fSeriesNames = names2.toArray(new String[sessions.size()]);
        this.fDimensions = dims.toArray(new Dim[dims.size()]);
        Arrays.sort(this.fDimensions, new Comparator(){

            public int compare(Object o1, Object o2) {
                Dim d1 = (Dim)o1;
                Dim d2 = (Dim)o2;
                return d1.getName().compareTo(d2.getName());
            }
        });
    }

    public static class SharedState {
        private Variations fVariations;
        private String fSeriesKey;
        private Set fQueryDimensions;
        private String fScenarioPattern;
        private Map fMessages;

        SharedState(Variations variations, String scenarioPattern, String seriesKey, Dim[] dimensions) {
            this.fVariations = variations;
            this.fScenarioPattern = scenarioPattern;
            this.fSeriesKey = seriesKey;
            if (dimensions != null && dimensions.length > 0) {
                this.fQueryDimensions = new HashSet();
                int i = 0;
                while (i < dimensions.length) {
                    this.fQueryDimensions.add(dimensions[i]);
                    ++i;
                }
            }
        }

        String[] getFailures(String[] names, String scenarioId) {
            int i;
            if (this.fMessages == null) {
                this.fMessages = new HashMap();
                Variations v = (Variations)this.fVariations.clone();
                i = 0;
                while (i < names.length) {
                    v.put(this.fSeriesKey, names[i]);
                    Map map = DB.queryFailure(this.fScenarioPattern, v);
                    this.fMessages.put(names[i], map);
                    ++i;
                }
            }
            String[] result = new String[names.length];
            i = 0;
            while (i < names.length) {
                Map messages = (Map)this.fMessages.get(names[i]);
                if (messages != null) {
                    result[i] = (String)messages.get(scenarioId);
                }
                ++i;
            }
            return result;
        }
    }
}

