/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.PerformanceMonitor;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;

class PerformanceMonitorLinux
extends PerformanceMonitor {
    private static long JIFFIES = 10L;

    PerformanceMonitorLinux() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectOperatingSystemCounters(Map scalars) {
        PerformanceMonitorLinux performanceMonitorLinux = this;
        synchronized (performanceMonitorLinux) {
            StringTokenizer st = this.readTokens("/proc/self/stat", false);
            if (st != null) {
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                long utime = Long.parseLong(st.nextToken());
                long stime = Long.parseLong(st.nextToken());
                st.nextToken();
                st.nextToken();
                this.addScalar(scalars, InternalDimensions.CPU_TIME, (utime + stime) * JIFFIES);
            }
            long currentTime = System.currentTimeMillis();
            if (!PerformanceTestPlugin.isOldDB()) {
                this.addScalar(scalars, InternalDimensions.SYSTEM_TIME, currentTime);
            }
            super.collectOperatingSystemCounters(scalars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectGlobalPerformanceInfo(Map scalars) {
        PerformanceMonitorLinux performanceMonitorLinux = this;
        synchronized (performanceMonitorLinux) {
            StringTokenizer st = this.readOutput("free -b", true);
            if (st != null) {
                st.nextToken();
                st.nextToken();
                long used = Long.parseLong(st.nextToken());
                this.addScalar(scalars, InternalDimensions.USED_LINUX_MEM, used);
            }
            super.collectGlobalPerformanceInfo(scalars);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringTokenizer readTokens(String procPath, boolean skipFirst) {
        BufferedReader rdr;
        block11: {
            StringTokenizer stringTokenizer;
            rdr = null;
            try {
                try {
                    rdr = new BufferedReader(new FileReader(procPath));
                    if (skipFirst) {
                        rdr.readLine();
                    }
                    stringTokenizer = new StringTokenizer(rdr.readLine());
                    Object var5_5 = null;
                }
                catch (IOException e) {
                    PerformanceTestPlugin.log(e);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    if (rdr == null) throw throwable;
                    rdr.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (rdr == null) return stringTokenizer;
            rdr.close();
            return stringTokenizer;
        }
        Object var5_7 = null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (rdr == null) return null;
        rdr.close();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringTokenizer readOutput(String cmd, boolean skipFirst) {
        BufferedReader rdr;
        block11: {
            StringTokenizer stringTokenizer;
            rdr = null;
            try {
                try {
                    Process process = Runtime.getRuntime().exec(cmd);
                    rdr = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    if (skipFirst) {
                        rdr.readLine();
                    }
                    stringTokenizer = new StringTokenizer(rdr.readLine());
                    Object var5_7 = null;
                }
                catch (IOException e) {
                    PerformanceTestPlugin.log(e);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    if (rdr == null) throw throwable;
                    rdr.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (rdr == null) return stringTokenizer;
            rdr.close();
            return stringTokenizer;
        }
        Object var5_9 = null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (rdr == null) return null;
        rdr.close();
        return null;
    }
}

