/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import org.eclipse.test.internal.performance.db.Variations;

public class PerformanceTestPlugin {
    public static final String CONFIG = "config";
    public static final String BUILD = "build";
    private static final String DEFAULT_DB_NAME = "perfDB";
    private static final String DEFAULT_DB_USER = "app";
    private static final String DEFAULT_DB_PASSWORD = "app";
    private static final String DB_NAME = "dbname";
    private static final String DB_USER = "dbuser";
    private static final String DB_PASSWD = "dbpasswd";
    private static final String ECLIPSE_PERF_DBLOC = "eclipse.perf.dbloc";
    private static final String ECLIPSE_PERF_ASSERTAGAINST = "eclipse.perf.assertAgainst";
    private static final String ECLIPSE_PERF_CONFIG = "eclipse.perf.config";
    public static final String PLUGIN_ID = "org.eclipse.test.performance";
    public static final int INTERNAL_ERROR = 1;
    private static PerformanceTestPlugin fgPlugin;
    private static boolean fgOldDBInitialized;
    private static boolean fgOldDB;

    public PerformanceTestPlugin() {
        fgPlugin = this;
    }

    static boolean isOldDB() {
        if (!fgOldDBInitialized) {
            String loc = PerformanceTestPlugin.getDBLocation();
            if (loc != null && loc.indexOf("relengbuildserv") >= 0) {
                fgOldDB = true;
            }
            fgOldDBInitialized = true;
        }
        return fgOldDB;
    }

    public static PerformanceTestPlugin getDefault() {
        return fgPlugin;
    }

    public static String getDBLocation() {
        String dbloc = System.getProperty(ECLIPSE_PERF_DBLOC);
        if (dbloc != null) {
            Variations keys = new Variations();
            keys.parsePairs("eclipse.perf.dbloc=" + dbloc);
            return keys.getProperty(ECLIPSE_PERF_DBLOC);
        }
        return null;
    }

    public static String getDBName() {
        String dbloc = System.getProperty(ECLIPSE_PERF_DBLOC);
        if (dbloc != null) {
            Variations keys = new Variations();
            keys.parsePairs("eclipse.perf.dbloc=" + dbloc);
            return keys.getProperty(DB_NAME, DEFAULT_DB_NAME);
        }
        return DEFAULT_DB_NAME;
    }

    public static String getDBUser() {
        String dbloc = System.getProperty(ECLIPSE_PERF_DBLOC);
        if (dbloc != null) {
            Variations keys = new Variations();
            keys.parsePairs("eclipse.perf.dbloc=" + dbloc);
            return keys.getProperty(DB_USER, "app");
        }
        return "app";
    }

    public static String getDBPassword() {
        String dbloc = System.getProperty(ECLIPSE_PERF_DBLOC);
        if (dbloc != null) {
            Variations keys = new Variations();
            keys.parsePairs("eclipse.perf.dbloc=" + dbloc);
            return keys.getProperty(DB_PASSWD, "app");
        }
        return "app";
    }

    public static Variations getVariations() {
        Variations keys = new Variations();
        String configKey = System.getProperty(ECLIPSE_PERF_CONFIG);
        if (configKey != null) {
            keys.parsePairs(configKey);
        }
        return keys;
    }

    public static Variations getAssertAgainst() {
        String assertKey = System.getProperty(ECLIPSE_PERF_ASSERTAGAINST);
        if (assertKey != null) {
            Variations keys = PerformanceTestPlugin.getVariations();
            if (keys == null) {
                keys = new Variations();
            }
            keys.parsePairs(assertKey);
            return keys;
        }
        return null;
    }

    public static void logError(String message) {
        if (message == null) {
            message = "";
        }
    }

    public static void logWarning(String message) {
        if (message == null) {
            message = "";
        }
    }

    public static void log(Throwable e) {
    }
}

