/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xmi.impl;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class SAXXMIHandler
extends XMIHandler {
    protected Locator locator;
    protected Attributes attribs;

    public SAXXMIHandler(XMLResource xmiResource, XMLHelper helper, Map options) {
        super(xmiResource, helper, options);
    }

    protected Object setAttributes(Object attributes) {
        Attributes oldAttribs = this.attribs;
        this.attribs = (Attributes)attributes;
        return oldAttribs;
    }

    public void setLocator(Object locator) {
        this.locator = (Locator)locator;
    }

    protected int getLineNumber() {
        if (this.locator != null) {
            return this.locator.getLineNumber();
        }
        return super.getLineNumber();
    }

    protected int getColumnNumber() {
        if (this.locator != null) {
            return this.locator.getColumnNumber();
        }
        return super.getColumnNumber();
    }

    protected boolean isNull() {
        return this.attribs.getValue("xsi:nil") != null;
    }

    protected void handleNamespaceAttribs() {
        int i = 0;
        int size = this.attribs.getLength();
        while (i < size) {
            String attrib = this.attribs.getQName(i);
            if (attrib.startsWith("xmlns")) {
                this.handleXMLNSAttribute(attrib, this.attribs.getValue(i));
            } else if ("xsi:schemaLocation".equals(attrib)) {
                this.handleXSISchemaLocation(this.attribs.getValue(i));
            } else if ("xsi:noNamespaceSchemaLocation".equals(attrib)) {
                this.handleXSINoNamespaceSchemaLocation(this.attribs.getValue(i));
            }
            ++i;
        }
    }

    protected String getXSIType() {
        String xsiType = this.attribs.getValue("xsi:type");
        if (xsiType == null) {
            xsiType = this.attribs.getValue("xmi:type");
        }
        return xsiType;
    }

    protected void handleObjectAttribs(EObject obj) {
        if (this.attribs != null) {
            InternalEObject internalEObject = (InternalEObject)obj;
            int i = 0;
            int size = this.attribs.getLength();
            while (i < size) {
                String name = this.attribs.getQName(i);
                if (name.equals("xmi:id")) {
                    this.xmlResource.setID((EObject)internalEObject, this.attribs.getValue(i));
                } else if (name.equals(this.hrefAttribute) && (!this.recordUnknownFeature || this.types.peek() != "unknownFeature")) {
                    this.handleProxy(internalEObject, this.attribs.getValue(i));
                } else if (!name.startsWith("xmlns") && !this.notFeatures.contains(name)) {
                    this.setAttribValue(obj, name, this.attribs.getValue(i));
                }
                ++i;
            }
        }
    }
}

