/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.PerformanceMonitor;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;

class PerformanceMonitorLinux
extends PerformanceMonitor {
    private static long JIFFIES = 10L;

    PerformanceMonitorLinux() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectOperatingSystemCounters(Map scalars) {
        PerformanceMonitorLinux performanceMonitorLinux = this;
        synchronized (performanceMonitorLinux) {
            StringTokenizer st = this.readTokens("/proc/self/stat", false);
            if (st != null) {
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                st.nextToken();
                long utime = Long.parseLong(st.nextToken());
                long stime = Long.parseLong(st.nextToken());
                st.nextToken();
                st.nextToken();
                this.addScalar(scalars, InternalDimensions.CPU_TIME, (utime + stime) * JIFFIES);
            }
            long currentTime = System.currentTimeMillis();
            if (!PerformanceTestPlugin.isOldDB()) {
                this.addScalar(scalars, InternalDimensions.SYSTEM_TIME, currentTime);
            }
            super.collectOperatingSystemCounters(scalars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectGlobalPerformanceInfo(Map scalars) {
        PerformanceMonitorLinux performanceMonitorLinux = this;
        synchronized (performanceMonitorLinux) {
            StringTokenizer st = this.readOutput("free -b", true);
            if (st != null) {
                st.nextToken();
                st.nextToken();
                long used = Long.parseLong(st.nextToken());
                this.addScalar(scalars, InternalDimensions.USED_LINUX_MEM, used);
            }
            super.collectGlobalPerformanceInfo(scalars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private StringTokenizer readTokens(String procPath, boolean skipFirst) {
        BufferedReader rdr = null;
        rdr = new BufferedReader(new FileReader(procPath));
        if (skipFirst) {
            rdr.readLine();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(rdr.readLine());
        Object var6_6 = null;
        try {
            if (rdr != null) {
                rdr.close();
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        return stringTokenizer;
        catch (IOException e) {
            try {
                PerformanceTestPlugin.log(e);
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    if (rdr != null) {
                        rdr.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (rdr != null) {
                    rdr.close();
                }
            }
            catch (IOException e2) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private StringTokenizer readOutput(String cmd, boolean skipFirst) {
        BufferedReader rdr = null;
        Process process = Runtime.getRuntime().exec(cmd);
        rdr = new BufferedReader(new InputStreamReader(process.getInputStream()));
        if (skipFirst) {
            rdr.readLine();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(rdr.readLine());
        Object var7_7 = null;
        try {
            if (rdr != null) {
                rdr.close();
            }
        }
        catch (IOException e2) {
            // empty catch block
        }
        return stringTokenizer;
        catch (IOException e) {
            try {
                PerformanceTestPlugin.log(e);
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (rdr != null) {
                        rdr.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (rdr != null) {
                    rdr.close();
                }
            }
            catch (IOException e2) {}
        }
        return null;
    }
}

