/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Sample;
import org.eclipse.test.internal.performance.data.Scalar;
import org.eclipse.test.internal.performance.db.SQL;
import org.eclipse.test.internal.performance.db.Scenario;
import org.eclipse.test.internal.performance.db.SummaryEntry;
import org.eclipse.test.internal.performance.db.TimeSeries;
import org.eclipse.test.internal.performance.db.Variations;
import org.eclipse.test.internal.performance.eval.StatisticsSession;
import org.eclipse.test.performance.Dimension;

public class DB {
    private static final boolean DEBUG = false;
    private static final boolean AGGREGATE = true;
    private static final String DERBY = "derby";
    private static final String CLOUDSCAPE = "cloudscape";
    private static DB fgDefault;
    private Connection fConnection;
    private SQL fSQL;
    private int fStoredSamples;
    private boolean fStoreCalled;
    private boolean fIsEmbedded;
    private String fDBType;

    public static DataPoint[] queryDataPoints(Variations variations, String scenarioName, Set dims) {
        return DB.getDefault().internalQueryDataPoints(variations, scenarioName, dims);
    }

    public static Scenario[] queryScenarios(String configName, String buildPattern, String scenarioPattern) {
        Variations variations = new Variations();
        variations.put("config", configName);
        variations.put("build", buildPattern);
        return DB.queryScenarios(variations, scenarioPattern, "build", null);
    }

    public static Scenario[] queryScenarios(String configName, String[] buildPatterns, String scenarioPattern, Dim[] dimensions) {
        Variations variations = new Variations();
        variations.put("config", configName);
        variations.put("build", buildPatterns);
        return DB.queryScenarios(variations, scenarioPattern, "build", dimensions);
    }

    public static Scenario queryScenario(String configName, String[] buildPatterns, String scenarioName) {
        Variations variations = new Variations();
        variations.put("config", configName);
        variations.put("build", buildPatterns);
        return new Scenario(scenarioName, variations, "build", null);
    }

    public static Scenario[] queryScenarios(Variations variations, String scenarioPattern, String seriesKey, Dim[] dimensions) {
        String[] scenarioNames = DB.getDefault().internalQueryScenarioNames(variations, scenarioPattern);
        if (scenarioNames == null) {
            return new Scenario[0];
        }
        Scenario.SharedState ss = new Scenario.SharedState(variations, scenarioPattern, seriesKey, dimensions);
        Scenario[] tables = new Scenario[scenarioNames.length];
        for (int i = 0; i < scenarioNames.length; ++i) {
            tables[i] = new Scenario(scenarioNames[i], ss);
        }
        return tables;
    }

    public static SummaryEntry[] querySummaries(Variations variationPatterns, String scenarioPattern) {
        return DB.getDefault().internalQuerySummaries(variationPatterns, scenarioPattern);
    }

    public static void queryBuildNames(List names, Variations variationPatterns, String scenarioPattern) {
        DB.getDefault().internalQueryDistinctValues(names, "build", variationPatterns, scenarioPattern);
    }

    public static void queryDistinctValues(List values, String key, Variations variationPatterns, String scenarioPattern) {
        DB.getDefault().internalQueryDistinctValues(values, key, variationPatterns, scenarioPattern);
    }

    public static String[] querySeriesValues(String scenarioName, Variations v, String seriesKey) {
        return DB.getDefault().internalQuerySeriesValues(v, scenarioName, seriesKey);
    }

    public static Scenario getScenarioSeries(String scenarioName, Variations v, String seriesKey, String startBuild, String endBuild, Dim[] dims) {
        v = (Variations)v.clone();
        v.put(seriesKey, new String[]{startBuild, endBuild});
        Scenario.SharedState ss = new Scenario.SharedState(v, scenarioName, seriesKey, dims);
        Scenario scenario = new Scenario(scenarioName, ss);
        TimeSeries ts = scenario.getTimeSeries(dims[0]);
        if (ts.getLength() < 2) {
            v.put(seriesKey, "%");
            String[] names = DB.querySeriesValues(scenarioName, v, seriesKey);
            if (names.length >= 2) {
                String start = DB.findClosest(names, startBuild);
                String end = DB.findClosest(names, endBuild);
                v.put(seriesKey, new String[]{start, end});
                scenario = new Scenario(scenarioName, ss);
            }
        }
        return scenario;
    }

    public static Map queryFailure(String scenarioPattern, Variations variations) {
        return DB.getDefault().internalQueryFailure(scenarioPattern, variations);
    }

    private static String findClosest(String[] names, String name) {
        for (int i = 0; i < names.length; ++i) {
            if (!names[i].equals(name)) continue;
            return name;
        }
        Pattern pattern = Pattern.compile("200[3-9][01][0-9][0-3][0-9]");
        Matcher matcher = pattern.matcher(name);
        if (!matcher.find()) {
            return name;
        }
        int x = Integer.parseInt(name.substring(matcher.start(), matcher.end()));
        int ix = -1;
        int mind = 0;
        for (int i = 0; i < names.length; ++i) {
            matcher.reset(names[i]);
            if (!matcher.find()) continue;
            int y = Integer.parseInt(names[i].substring(matcher.start(), matcher.end()));
            int d = Math.abs(y - x);
            if (ix >= 0 && d >= mind) continue;
            mind = d;
            ix = i;
        }
        if (ix >= 0) {
            return names[ix];
        }
        return name;
    }

    public static boolean store(Variations variations, Sample sample) {
        return DB.getDefault().internalStore(variations, sample);
    }

    public static void markAsFailed(Variations variations, Sample sample, String failMesg) {
        DB.getDefault().internalMarkAsFailed(variations, sample, failMesg);
    }

    public static Connection getConnection() {
        return DB.getDefault().fConnection;
    }

    public static boolean isActive() {
        return fgDefault != null && fgDefault.getSQL() != null;
    }

    private DB() {
    }

    static synchronized DB getDefault() {
        if (fgDefault == null) {
            fgDefault = new DB();
            fgDefault.connect();
            if (PerformanceTestPlugin.getDefault() == null) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        DB.shutdown();
                    }
                });
            }
        }
        return fgDefault;
    }

    public static void shutdown() {
        if (fgDefault != null) {
            fgDefault.disconnect();
            fgDefault = null;
        }
    }

    SQL getSQL() {
        return this.fSQL;
    }

    private void internalMarkAsFailed(Variations variations, Sample sample, String failMesg) {
        if (this.fSQL == null) {
            return;
        }
        try {
            int variation_id = this.fSQL.getVariations(variations);
            int scenario_id = this.fSQL.getScenario(sample.getScenarioID());
            this.fSQL.insertFailure(variation_id, scenario_id, failMesg);
            this.fConnection.commit();
        }
        catch (SQLException e) {
            PerformanceTestPlugin.log(e);
            try {
                this.fConnection.rollback();
            }
            catch (SQLException e1) {
                PerformanceTestPlugin.log(e1);
            }
        }
    }

    private boolean internalStore(Variations variations, Sample sample) {
        int j;
        if (this.fSQL == null || sample == null) {
            return false;
        }
        DataPoint[] dataPoints = sample.getDataPoints();
        int n = dataPoints.length;
        if (n <= 0) {
            return false;
        }
        Scalar[] sc = null;
        long[] mins = null;
        Dim[] dimensions = null;
        StatisticsSession ss = null;
        ss = new StatisticsSession(dataPoints);
        dimensions = dataPoints[0].getDimensions();
        sc = dataPoints[0].getScalars();
        mins = new long[sc.length];
        HashSet<Integer> set = new HashSet<Integer>();
        for (j = 0; j < dataPoints.length; ++j) {
            DataPoint dp = dataPoints[j];
            set.add(new Integer(dp.getStep()));
        }
        switch (set.size()) {
            case 2: {
                for (j = 0; j < dimensions.length; ++j) {
                    Dim dimension = dimensions[j];
                    mins[j] = ss.getMin(dimension);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < dataPoints.length; ++i) {
                    for (int j2 = 0; j2 < dimensions.length; ++j2) {
                        Dim dimension = dimensions[j2];
                        mins[j2] = ss.getMin(dimension);
                    }
                }
                break;
            }
            default: {
                PerformanceTestPlugin.logError("DB.internalStore: too many steps in DataPoint");
                return false;
            }
        }
        try {
            int variation_id = this.fSQL.getVariations(variations);
            int scenario_id = this.fSQL.getScenario(sample.getScenarioID());
            if (sample.isSummary()) {
                boolean isGlobal = sample.isGlobal();
                Dimension[] summaryDimensions = sample.getSummaryDimensions();
                for (int i = 0; i < summaryDimensions.length; ++i) {
                    Dimension dimension = summaryDimensions[i];
                    if (!(dimension instanceof Dim)) continue;
                    this.fSQL.createSummaryEntry(variation_id, scenario_id, ((Dim)dimension).getId(), isGlobal);
                }
                String shortName = sample.getShortname();
                if (shortName != null) {
                    this.fSQL.setScenarioShortName(scenario_id, shortName);
                }
            }
            int sample_id = this.fSQL.createSample(variation_id, scenario_id, new Timestamp(sample.getStartTime()));
            if (sc != null) {
                int datapoint_id = this.fSQL.createDataPoint(sample_id, 0, -3);
                for (int k = 0; k < sc.length; ++k) {
                    int dim_id = sc[k].getDimension().getId();
                    this.fSQL.insertScalar(datapoint_id, dim_id, mins[k]);
                }
            } else {
                for (int i = 0; i < dataPoints.length; ++i) {
                    DataPoint dp = dataPoints[i];
                    int datapoint_id = this.fSQL.createDataPoint(sample_id, i, dp.getStep());
                    Scalar[] scalars = dp.getScalars();
                    for (int j3 = 0; j3 < scalars.length; ++j3) {
                        Scalar scalar = scalars[j3];
                        int dim_id = scalar.getDimension().getId();
                        long min = 0L;
                        if (dimensions.length > 0) {
                            Dim dimension = dimensions[0];
                            min = ss.getMin(dimension);
                        }
                        this.fSQL.insertScalar(datapoint_id, dim_id, min);
                    }
                }
            }
            this.fConnection.commit();
            ++this.fStoredSamples;
            this.fStoreCalled = true;
        }
        catch (SQLException e) {
            PerformanceTestPlugin.log(e);
            try {
                this.fConnection.rollback();
            }
            catch (SQLException e1) {
                PerformanceTestPlugin.log(e1);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataPoint[] internalQueryDataPoints(Variations variations, String scenarioName, Set dimSet) {
        if (this.fSQL == null) {
            return null;
        }
        ResultSet rs = null;
        ArrayList<DataPoint> dataPoints = new ArrayList<DataPoint>();
        rs = this.fSQL.queryDataPoints(variations, scenarioName);
        while (rs.next()) {
            int datapoint_id = rs.getInt(1);
            int step = rs.getInt(2);
            HashMap<Dim, Scalar> map = new HashMap<Dim, Scalar>();
            ResultSet rs2 = this.fSQL.queryScalars(datapoint_id);
            while (rs2.next()) {
                int dim_id = rs2.getInt(1);
                long value = rs2.getBigDecimal(2).longValue();
                Dim dim = Dim.getDimension(dim_id);
                if (dim == null || dimSet != null && !dimSet.contains(dim)) continue;
                map.put(dim, new Scalar(dim, value));
            }
            if (map.size() > 0) {
                dataPoints.add(new DataPoint(step, map));
            }
            rs2.close();
        }
        rs.close();
        int n = dataPoints.size();
        DataPoint[] dataPointArray = dataPoints.toArray(new DataPoint[n]);
        Object var15_15 = null;
        if (rs == null) return dataPointArray;
        try {
            rs.close();
            return dataPointArray;
        }
        catch (SQLException e1) {
            // empty catch block
        }
        return dataPointArray;
        catch (SQLException e) {
            try {
                PerformanceTestPlugin.log(e);
                Object var15_16 = null;
                if (rs == null) return null;
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                if (rs == null) throw throwable;
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                rs.close();
                return null;
            }
            catch (SQLException e1) {}
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] internalQueryScenarioNames(Variations variations, String scenarioPattern) {
        if (this.fSQL == null) {
            return null;
        }
        ResultSet result = null;
        result = this.fSQL.queryScenarios(variations, scenarioPattern);
        ArrayList<String> scenarios = new ArrayList<String>();
        int i = 0;
        while (result.next()) {
            scenarios.add(result.getString(1));
            ++i;
        }
        String[] stringArray = scenarios.toArray(new String[scenarios.size()]);
        Object var7_8 = null;
        if (result == null) return stringArray;
        try {
            result.close();
            return stringArray;
        }
        catch (SQLException e1) {
            // empty catch block
        }
        return stringArray;
        catch (SQLException e) {
            try {
                PerformanceTestPlugin.log(e);
                Object var7_9 = null;
                if (result == null) return null;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                if (result == null) throw throwable;
                try {
                    result.close();
                    throw throwable;
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                result.close();
                return null;
            }
            catch (SQLException e1) {}
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void internalQueryDistinctValues(List values, String seriesKey, Variations variations, String scenarioPattern) {
        if (this.fSQL == null) {
            return;
        }
        ResultSet result = null;
        result = this.fSQL.queryVariations(variations.toExactMatchString(), scenarioPattern);
        int i = 0;
        while (result.next()) {
            Variations v = new Variations();
            v.parseDB(result.getString(1));
            String build = v.getProperty(seriesKey);
            if (build != null && !values.contains(build)) {
                values.add(build);
            }
            ++i;
        }
        Object var10_10 = null;
        if (result == null) return;
        try {
            result.close();
            return;
        }
        catch (SQLException e1) {}
        return;
        {
            catch (SQLException e) {
                PerformanceTestPlugin.log(e);
                Object var10_11 = null;
                if (result == null) return;
                try {
                    result.close();
                    return;
                }
                catch (SQLException e1) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (result == null) throw throwable;
            try {
                result.close();
                throw throwable;
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SummaryEntry[] internalQuerySummaries(Variations variationPatterns, String scenarioPattern) {
        if (this.fSQL == null) {
            return null;
        }
        ResultSet result = null;
        ArrayList<SummaryEntry> fingerprints = new ArrayList<SummaryEntry>();
        ResultSet rs = scenarioPattern != null ? this.fSQL.querySummaryEntries(variationPatterns, scenarioPattern) : this.fSQL.queryGlobalSummaryEntries(variationPatterns);
        while (rs.next()) {
            String scenarioName = rs.getString(1);
            String shortName = rs.getString(2);
            int dim_id = rs.getInt(3);
            boolean isGlobal = rs.getShort(4) == 1;
            fingerprints.add(new SummaryEntry(scenarioName, shortName, Dim.getDimension(dim_id), isGlobal));
        }
        SummaryEntry[] summaryEntryArray = fingerprints.toArray(new SummaryEntry[fingerprints.size()]);
        Object var11_11 = null;
        if (result == null) return summaryEntryArray;
        try {
            result.close();
            return summaryEntryArray;
        }
        catch (SQLException e1) {
            // empty catch block
        }
        return summaryEntryArray;
        catch (SQLException e) {
            try {
                PerformanceTestPlugin.log(e);
                Object var11_12 = null;
                if (result == null) return null;
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (result == null) throw throwable;
                try {
                    result.close();
                    throw throwable;
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                result.close();
                return null;
            }
            catch (SQLException e1) {}
            return null;
        }
    }

    private String[] internalQuerySeriesValues(Variations v, String scenarioName, String seriesKey) {
        boolean isCloned = false;
        String[] seriesPatterns = null;
        Object object = v.get(seriesKey);
        if (object instanceof String[]) {
            seriesPatterns = (String[])object;
        } else if (object instanceof String) {
            seriesPatterns = new String[]{(String)object};
        } else {
            Assert.assertTrue((boolean)false);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < seriesPatterns.length; ++i) {
            if (seriesPatterns[i].indexOf(37) >= 0) {
                if (!isCloned) {
                    v = (Variations)v.clone();
                    isCloned = true;
                }
                v.put(seriesKey, seriesPatterns[i]);
                this.internalQueryDistinctValues(values, seriesKey, v, scenarioName);
                continue;
            }
            values.add(seriesPatterns[i]);
        }
        String[] names = values.toArray(new String[values.size()]);
        boolean sort = true;
        Pattern pattern = Pattern.compile("200[3-9][01][0-9][0-3][0-9]");
        final Matcher matcher = pattern.matcher("");
        for (int i = 0; i < names.length; ++i) {
            matcher.reset(names[i]);
            if (matcher.find()) continue;
            sort = false;
            break;
        }
        if (sort) {
            Arrays.sort(names, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    matcher.reset(s1);
                    if (matcher.find()) {
                        s1 = s1.substring(matcher.start());
                    }
                    matcher.reset(s2);
                    if (matcher.find()) {
                        s2 = s2.substring(matcher.start());
                    }
                    return s1.compareTo(s2);
                }
            });
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map internalQueryFailure(String scenarioPattern, Variations variations) {
        if (this.fSQL == null) {
            return null;
        }
        ResultSet result = null;
        HashMap<String, String> map = new HashMap<String, String>();
        result = this.fSQL.queryFailure(variations, scenarioPattern);
        while (result.next()) {
            String scenario = result.getString(1);
            String message = result.getString(2);
            map.put(scenario, message);
        }
        HashMap<String, String> hashMap = map;
        Object var8_8 = null;
        if (result == null) return hashMap;
        try {
            result.close();
            return hashMap;
        }
        catch (SQLException e1) {
            // empty catch block
        }
        return hashMap;
        catch (SQLException e) {
            try {
                PerformanceTestPlugin.log(e);
                Object var8_9 = null;
                if (result == null) return null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (result == null) throw throwable;
                try {
                    result.close();
                    throw throwable;
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                result.close();
                return null;
            }
            catch (SQLException e1) {}
            return null;
        }
    }

    private void connect() {
        if (this.fConnection != null) {
            return;
        }
        String dbloc = PerformanceTestPlugin.getDBLocation();
        if (dbloc == null) {
            return;
        }
        String dbname = PerformanceTestPlugin.getDBName();
        String url = null;
        Properties info = new Properties();
        this.fDBType = DERBY;
        try {
            if (dbloc.startsWith("net://")) {
                this.fIsEmbedded = false;
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                info.put("user", PerformanceTestPlugin.getDBUser());
                info.put("password", PerformanceTestPlugin.getDBPassword());
                info.put("retrieveMessagesFromServerOnGetMessage", "true");
                url = dbloc + "/" + dbname + ";create=true";
            } else {
                File f;
                if ("Mac OS X".equals(System.getProperty("os.name"))) {
                    System.setProperty("derby.storage.fileSyncTransactionLog", "true");
                }
                this.fIsEmbedded = true;
                try {
                    Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
                }
                catch (ClassNotFoundException e) {
                    Class.forName("com.ihost.cs.jdbc.CloudscapeDriver");
                    this.fDBType = CLOUDSCAPE;
                }
                if (dbloc.length() == 0) {
                    String user_home = System.getProperty("user.home");
                    if (user_home == null) {
                        return;
                    }
                    f = new File(user_home, this.fDBType);
                } else {
                    f = new File(dbloc);
                }
                url = new File(f, dbname).getAbsolutePath();
                info.put("create", "true");
            }
            try {
                this.fConnection = DriverManager.getConnection("jdbc:" + this.fDBType + ":" + url, info);
            }
            catch (SQLException e) {
                if ("08001".equals(e.getSQLState()) && DERBY.equals(this.fDBType)) {
                    this.fDBType = CLOUDSCAPE;
                    this.fConnection = DriverManager.getConnection("jdbc:" + this.fDBType + ":" + url, info);
                }
                throw e;
            }
            this.fConnection.setAutoCommit(false);
            this.fSQL = new SQL(this.fConnection);
            this.fConnection.commit();
        }
        catch (SQLException ex) {
            PerformanceTestPlugin.logError(ex.getMessage());
        }
        catch (ClassNotFoundException e) {
            PerformanceTestPlugin.log(e);
        }
    }

    private void disconnect() {
        block11: {
            if (this.fSQL != null) {
                try {
                    this.fSQL.dispose();
                }
                catch (SQLException e1) {
                    PerformanceTestPlugin.log(e1);
                }
                this.fSQL = null;
            }
            if (this.fConnection != null) {
                try {
                    this.fConnection.commit();
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                }
                try {
                    this.fConnection.close();
                }
                catch (SQLException e) {
                    PerformanceTestPlugin.log(e);
                }
                this.fConnection = null;
            }
            if (this.fIsEmbedded) {
                try {
                    DriverManager.getConnection("jdbc:" + this.fDBType + ":;shutdown=true");
                }
                catch (SQLException e) {
                    String message = e.getMessage();
                    if (message.indexOf("system shutdown.") >= 0) break block11;
                    e.printStackTrace();
                }
            }
        }
    }
}

