/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.eval;

import java.util.HashSet;
import junit.framework.Assert;
import org.eclipse.test.internal.performance.InternalPerformanceMeter;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Sample;
import org.eclipse.test.internal.performance.db.DB;
import org.eclipse.test.internal.performance.db.Variations;
import org.eclipse.test.internal.performance.eval.AssertChecker;
import org.eclipse.test.internal.performance.eval.EmptyEvaluator;
import org.eclipse.test.internal.performance.eval.StatisticsSession;
import org.eclipse.test.performance.PerformanceMeter;

public class Evaluator
extends EmptyEvaluator {
    private AssertChecker[] fCheckers;

    public void setAssertCheckers(AssertChecker[] asserts) {
        this.fCheckers = asserts;
    }

    public void evaluate(PerformanceMeter performanceMeter) throws RuntimeException {
        if (this.fCheckers == null) {
            return;
        }
        Variations refKeys = PerformanceTestPlugin.getAssertAgainst();
        if (refKeys == null) {
            return;
        }
        if (!(performanceMeter instanceof InternalPerformanceMeter)) {
            return;
        }
        InternalPerformanceMeter ipm = (InternalPerformanceMeter)performanceMeter;
        Sample session = ipm.getSample();
        Assert.assertTrue((String)"metering session is null", (session != null ? 1 : 0) != 0);
        String scenarioName = session.getScenarioID();
        HashSet<Dim> allDimensions = new HashSet<Dim>();
        for (int i = 0; i < this.fCheckers.length; ++i) {
            AssertChecker chk = this.fCheckers[i];
            Dim[] dims = chk.getDimensions();
            for (int j = 0; j < dims.length; ++j) {
                allDimensions.add(dims[j]);
            }
        }
        Variations config = PerformanceTestPlugin.getVariations();
        DataPoint[] sessionDatapoints = config != null ? DB.queryDataPoints(config, scenarioName, allDimensions) : session.getDataPoints();
        if (sessionDatapoints == null || sessionDatapoints.length == 0) {
            PerformanceTestPlugin.logWarning("no session data named '" + config + "' found");
            return;
        }
        DataPoint[] datapoints = DB.queryDataPoints(refKeys, scenarioName, allDimensions);
        if (datapoints == null || datapoints.length == 0) {
            PerformanceTestPlugin.logWarning("no reference data named '" + refKeys + "' found");
            return;
        }
        StatisticsSession referenceStats = new StatisticsSession(datapoints);
        StatisticsSession measuredStats = new StatisticsSession(sessionDatapoints);
        StringBuffer failMesg = new StringBuffer("Performance criteria not met when compared to '" + refKeys + "':");
        boolean pass = true;
        for (int i = 0; i < this.fCheckers.length; ++i) {
            AssertChecker chk = this.fCheckers[i];
            pass &= chk.test(referenceStats, measuredStats, failMesg);
        }
        if (!pass && config != null) {
            DB.markAsFailed(config, session, failMesg.toString());
        }
    }
}

