/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.db;

import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class Variations
extends Properties {
    private static final long serialVersionUID = 1L;

    public Variations() {
    }

    public Variations(String configValue, String buildValue) {
        if (configValue != null) {
            this.put("config", configValue);
        }
        if (buildValue != null) {
            this.put("build", buildValue);
        }
    }

    public Variations(String keyValuePairs) {
        this.parsePairs(keyValuePairs);
    }

    public String toExactMatchString() {
        return Variations.toDB(this, false);
    }

    public String toQueryPattern() {
        return Variations.toDB(this, true);
    }

    public void parsePairs(String keyvaluepairs) {
        this.parse(keyvaluepairs, ";");
    }

    public void parseDB(String keyvaluepairs) {
        this.parse(keyvaluepairs, "|");
    }

    private void parse(String keyvaluepairs, String separator) {
        StringTokenizer st = new StringTokenizer(keyvaluepairs, separator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int i = token.indexOf(61);
            if (i < 1) {
                throw new IllegalArgumentException("kev/value pair '" + token + "' is illformed");
            }
            String value = token.substring(i + 1);
            token = token.substring(0, i);
            this.put(token, value);
        }
    }

    private static String toDB(Properties keyValues, boolean asQuery) {
        Set<Object> set = keyValues.keySet();
        Object[] keys = set.toArray(new String[set.size()]);
        Arrays.sort(keys);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < keys.length; ++i) {
            if (asQuery) {
                sb.append('%');
            }
            Object key = keys[i];
            String value = keyValues.getProperty((String)key);
            sb.append('|');
            sb.append((String)key);
            sb.append('=');
            if (value != null) {
                sb.append(value);
            }
            sb.append('|');
        }
        if (asQuery) {
            sb.append('%');
        }
        return sb.toString();
    }
}

