/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.eval;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.test.internal.performance.db.DB;

public class TestStatsHelper {
    private static String dbloc = "";
    private Connection fConnection;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Please supply derby perf.dbloc (path to dbroot (embedded) or net://localhost;dbuser=app;dbpasswd=app (server)) on command line.");
            System.err.println("eg., TestStatsHelper net://localhost;dbuser=app;dbpasswd=app");
            System.err.println("eg., TestStatsHelper E:\\workspace\\releng");
        } else {
            TestStatsHelper helper = new TestStatsHelper(args[0]);
            System.setProperty("eclipse.perf.dbloc", dbloc);
            System.out.println("Adjusting derby database at " + dbloc);
            try {
                if (!helper.hasColumn("STDDEV")) {
                    System.out.println("STDDEV (Standard Deviation) column does not exist. Creating...");
                    helper.addColumnToTable("STDDEV", "SCALAR", "double not null default 0.0");
                } else {
                    System.out.println("STDDEV column already exists.");
                }
                if (!helper.hasColumn("RANGE")) {
                    System.out.println("RANGE (max - min) column does not exist. Creating...");
                    helper.addColumnToTable("RANGE", "SCALAR", "double not null default 0.0");
                } else {
                    System.out.println("RANGE column already exists.");
                }
                if (!helper.hasColumn("NUM")) {
                    System.out.println("NUM (N) column does not exist. Creating...");
                    helper.addColumnToTable("NUM", "SCALAR", "double not null default 0.0");
                } else {
                    System.out.println("NUM column already exists.");
                }
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            System.out.println("Done.");
        }
    }

    public TestStatsHelper(String dbl) {
        dbloc = dbl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumnToTable(String colname, String tablename, String additional) throws SQLException {
        Statement stmt = null;
        try {
            if (this.fConnection == null) {
                this.fConnection = DB.getConnection();
            }
            stmt = this.fConnection.createStatement();
            stmt.executeUpdate("alter table " + tablename + " add column " + colname + " " + additional);
            this.fConnection.commit();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasColumn(String colname) throws SQLException {
        Statement stmt = null;
        boolean columnExists = false;
        try {
            if (this.fConnection == null) {
                this.fConnection = DB.getConnection();
            }
            stmt = this.fConnection.createStatement();
            ResultSet rs = stmt.executeQuery("select COLUMNNAME from SYS.SYSCOLUMNS where COLUMNNAME like '" + colname.toUpperCase() + "' and COLUMNNAME not like 'SYS%'");
            while (rs.next()) {
                String columnname = rs.getString(1);
                if (!columnname.equalsIgnoreCase(colname)) continue;
                columnExists = true;
                break;
            }
            this.fConnection.commit();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return columnExists;
    }
}

