/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.provider;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.provider.EObjectItemProvider;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EModelElementItemProvider
extends EObjectItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public EModelElementItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    @Override
    public String getText(Object object) {
        return this.getString("_UI_EModelElement_type");
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(EModelElement.class)) {
            case 0: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS, EcoreFactory.eINSTANCE.createEAnnotation()));
    }

    public String stripToNull(String value) {
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ItemPropertyDescriptorWithUniqueChoiceOfValueLabels
    extends ItemPropertyDescriptor {
        protected Map<Object, String> uniqueNameMap;

        public ItemPropertyDescriptorWithUniqueChoiceOfValueLabels(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, boolean multiLine, boolean sortChoices, Object staticImage, String category, String[] filterFlags) {
            super(adapterFactory, resourceLocator, displayName, description, feature, isSettable, multiLine, sortChoices, staticImage, category, filterFlags);
        }

        public IItemLabelProvider getLabelProvider(Object object) {
            if (this.uniqueNameMap != null) {
                final Map<Object, String> uniqueNameMap = this.uniqueNameMap;
                this.uniqueNameMap = null;
                return new ItemPropertyDescriptor.ItemDelegator(this, this.adapterFactory, this.resourceLocator){

                    public String getText(Object object) {
                        String result = (String)uniqueNameMap.get(object);
                        return result != null ? result : super.getText(object);
                    }
                };
            }
            return super.getLabelProvider(object);
        }

        protected Map<Object, String> computeUniqueLabels(Object object, Collection<?> items) {
            Resource resource = ((EObject)object).eResource();
            URI base = resource == null ? URI.createURI((String)"") : resource.getURI();
            HashSet<String> conflictingLabels = new HashSet<String>();
            HashMap labelToObjectMap = new HashMap();
            IItemLabelProvider labelProvider = this.getLabelProvider(object);
            for (Object item : items) {
                String label = labelProvider.getText(item);
                if ("".equals(label)) {
                    if (item == null) continue;
                    labelToObjectMap.put("- " + EcoreUtil.getURI((EObject)((EObject)item)).deresolve(base), item);
                    continue;
                }
                if (conflictingLabels.contains(label)) {
                    labelToObjectMap.put(String.valueOf(label) + " - " + EcoreUtil.getURI((EObject)((EObject)item)).deresolve(base), item);
                    continue;
                }
                Object collision = labelToObjectMap.put(label, item);
                if (collision == null) continue;
                conflictingLabels.add(label);
                labelToObjectMap.remove(label);
                labelToObjectMap.put(String.valueOf(label) + " - " + EcoreUtil.getURI((EObject)((EObject)item)).deresolve(base), item);
                labelToObjectMap.put(String.valueOf(label) + " - " + EcoreUtil.getURI((EObject)((EObject)collision)).deresolve(base), collision);
            }
            HashMap<Object, String> result = new HashMap<Object, String>();
            for (Map.Entry entry : labelToObjectMap.entrySet()) {
                result.put(entry.getValue(), (String)entry.getKey());
            }
            return result;
        }

        public Collection<?> getChoiceOfValues(Object object) {
            LinkedList result = super.getChoiceOfValues(object);
            if (this.feature instanceof EReference && object instanceof EObject) {
                ResourceSet resourceSet;
                LinkedList eObjects = new LinkedList(result);
                Resource resource = ((EObject)object).eResource();
                if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
                    HashSet visited = new HashSet(eObjects);
                    EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
                    for (String nsURI : packageRegistry.keySet()) {
                        ItemPropertyDescriptorWithUniqueChoiceOfValueLabels.collectReachableObjectsOfType(visited, eObjects, (EObject)packageRegistry.getEPackage(nsURI), (EClassifier)this.feature.getEType());
                    }
                }
                result = eObjects;
            }
            return result;
        }
    }
}

