/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.ide.undo.DeleteResourcesOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExampleInstallerWizard
extends Wizard
implements INewWizard,
IShellProvider {
    protected static final IOverwriteQuery OVERWRITE_ALL_QUERY = new IOverwriteQuery(){

        public String queryOverwrite(String pathString) {
            return "ALL";
        }
    };
    protected IWorkbench workbench;
    protected IStructuredSelection structuredSelection;
    protected ProjectPage projectPage;

    public AbstractExampleInstallerWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(CommonUIPlugin.INSTANCE.getString("_UI_ExampleInstallerWizard_title"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.structuredSelection = selection;
    }

    protected abstract List<ProjectDescriptor> getProjectDescriptors();

    protected abstract List<FileToOpen> getFilesToOpen();

    public void dispose() {
        this.projectPage = null;
        super.dispose();
    }

    public void addPages() {
        this.projectPage = new ProjectPage("projectPage", CommonUIPlugin.INSTANCE.getString("_UI_ProjectPage_title"), null);
        this.projectPage.setDescription(CommonUIPlugin.INSTANCE.getString("_UI_ProjectPage_description"));
        this.addPage((IWizardPage)this.projectPage);
    }

    public boolean performFinish() {
        final Exception exceptionWrapper = new Exception();
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(CommonUIPlugin.INSTANCE.getString("_UI_InstallingExample_message"), 3);
                    WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                            Diagnostic diagnostic = AbstractExampleInstallerWizard.this.deleteExistingProjects((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            if (diagnostic.getSeverity() != 0) {
                                exceptionWrapper.initCause((Throwable)new DiagnosticException(diagnostic));
                                throw new InterruptedException();
                            }
                            try {
                                AbstractExampleInstallerWizard.this.installExample(monitor);
                            }
                            catch (Exception e) {
                                exceptionWrapper.initCause(e);
                                throw new InterruptedException();
                            }
                        }
                    };
                    op.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    AbstractExampleInstallerWizard.this.openFiles((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    monitor.done();
                }
            });
            return true;
        }
        catch (InterruptedException interruptedException) {
            if (exceptionWrapper.getCause() != null) {
                this.openErrorDialog(CommonUIPlugin.INSTANCE.getString("_UI_InstallExampleError_message"), exceptionWrapper.getCause());
            }
        }
        catch (InvocationTargetException e) {
            CommonUIPlugin.INSTANCE.log(e);
        }
        if (this.projectPage != null && !this.projectPage.getControl().isDisposed()) {
            this.projectPage.refresh();
        }
        return false;
    }

    protected Diagnostic deleteExistingProjects(IProgressMonitor monitor) {
        StringBuilder projectNames = new StringBuilder();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        for (ProjectDescriptor projectDescriptor : this.getProjectDescriptors()) {
            IProject project = projectDescriptor.getProject();
            if (!project.exists()) continue;
            projectNames.append(", '").append(project.getName()).append("'");
            projects.add(project);
        }
        if (!projects.isEmpty()) {
            projectNames.delete(0, ", ".length());
            String title = null;
            String message = null;
            if (projects.size() == 1) {
                title = CommonUIPlugin.INSTANCE.getString("_UI_ConfirmSingleDeletion_title");
                message = CommonUIPlugin.INSTANCE.getString("_UI_ConfirmSingleDeletion_message", new String[]{projectNames.toString()});
            } else {
                title = CommonUIPlugin.INSTANCE.getString("_UI_ConfirmMultipleDeletion_title");
                message = CommonUIPlugin.INSTANCE.getString("_UI_ConfirmMultipleDeletion_message", new String[]{projectNames.toString()});
            }
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)message)) {
                DeleteResourcesOperation op = new DeleteResourcesOperation((IResource[])projects.toArray(new IProject[projects.size()]), "deleteprojects", true);
                try {
                    return BasicDiagnostic.toDiagnostic((IStatus)op.execute((IProgressMonitor)new SubProgressMonitor(monitor, 1), null));
                }
                catch (ExecutionException e) {
                    return BasicDiagnostic.toDiagnostic((Throwable)e);
                }
            }
            return Diagnostic.CANCEL_INSTANCE;
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected void installExample(IProgressMonitor progressMonitor) throws Exception {
        List<ProjectDescriptor> projectDescriptors = this.getProjectDescriptors();
        progressMonitor.beginTask(CommonUIPlugin.INSTANCE.getString("_UI_CreatingProjects_message"), 2 * projectDescriptors.size());
        for (ProjectDescriptor projectDescriptor : projectDescriptors) {
            ImportOperation importOperation = this.createImportOperation(projectDescriptor);
            this.createProject(projectDescriptor, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            importOperation.setContext(this.getShell());
            importOperation.run((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        progressMonitor.done();
    }

    protected void openFiles(IProgressMonitor progressMonitor) {
        List<FileToOpen> filesToOpen = this.getFilesToOpen();
        if (!filesToOpen.isEmpty()) {
            progressMonitor.beginTask(CommonUIPlugin.INSTANCE.getString("_UI_OpeningFiles_message"), filesToOpen.size());
            for (FileToOpen fileToOpen : filesToOpen) {
                IFile workspaceFile = fileToOpen.getWorkspaceFile();
                if (workspaceFile == null || !workspaceFile.exists()) continue;
                try {
                    this.openEditor(workspaceFile, fileToOpen.getEditorID());
                    progressMonitor.worked(1);
                }
                catch (PartInitException e) {
                    CommonUIPlugin.INSTANCE.log((Object)e);
                }
            }
            progressMonitor.done();
        }
    }

    protected void openErrorDialog(String message, Throwable throwable) {
        DiagnosticDialog.open(this.getShell(), CommonUIPlugin.INSTANCE.getString("_UI_Error_label"), message, BasicDiagnostic.toDiagnostic((Throwable)throwable));
    }

    protected void createProject(ProjectDescriptor projectDescriptor, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(CommonUIPlugin.INSTANCE.getString("_UI_CreateProject_message", new String[]{projectDescriptor.getName()}), 3);
        IProject project = projectDescriptor.getProject();
        project.create((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
    }

    protected ImportOperation createImportOperation(ProjectDescriptor projectDescriptor) throws Exception {
        URI contentURI = projectDescriptor.getContentURI();
        if (contentURI.hasTrailingPathSeparator()) {
            return this.createDirectoryImportOperation(projectDescriptor);
        }
        return this.createFileImportOperation(projectDescriptor);
    }

    protected ImportOperation createDirectoryImportOperation(ProjectDescriptor projectDescriptor) throws Exception {
        File directory;
        String location;
        URI contentURI = projectDescriptor.getContentURI();
        if (contentURI.isPlatform()) {
            contentURI = CommonPlugin.asLocalURI((URI)contentURI);
        }
        if ((location = contentURI.toFileString()) != null && (directory = new File(location)).isDirectory() && directory.canRead()) {
            ArrayList<File> filesToImport = new ArrayList<File>();
            filesToImport.addAll(Arrays.asList(directory.listFiles()));
            ImportOperation importOperation = new ImportOperation(projectDescriptor.getProject().getFullPath(), (Object)directory, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, OVERWRITE_ALL_QUERY, filesToImport);
            importOperation.setCreateContainerStructure(false);
            return importOperation;
        }
        throw new Exception(CommonUIPlugin.INSTANCE.getString("_UI_DirectoryError_message", new String[]{contentURI.toString()}));
    }

    protected ImportOperation createFileImportOperation(ProjectDescriptor projectDescriptor) throws Exception {
        File file;
        String location;
        URI contentURI = projectDescriptor.getContentURI();
        if (contentURI.isPlatform()) {
            contentURI = CommonPlugin.asLocalURI((URI)contentURI);
        }
        if ((location = contentURI.toFileString()) != null && (file = new File(location)).isFile() && file.canRead() && this.isZipFile(file)) {
            return this.createZipImportOperation(projectDescriptor, file);
        }
        throw new Exception(CommonUIPlugin.INSTANCE.getString("_UI_FileError_message", new String[]{contentURI.toString()}));
    }

    protected boolean isZipFile(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            zipFile.close();
            return true;
        }
        catch (ZipException zipException) {
        }
        catch (IOException iOException) {}
        return false;
    }

    protected ImportOperation createZipImportOperation(ProjectDescriptor projectDescriptor, File file) throws Exception {
        ZipFile zipFile = file.getName().endsWith(".jar") ? new JarFile(file) : new ZipFile(file);
        ZipFileStructureProvider zipFileStructureProvider = new ZipFileStructureProvider(zipFile);
        return new ImportOperation(projectDescriptor.getProject().getFullPath(), (Object)zipFileStructureProvider.getRoot(), (IImportStructureProvider)zipFileStructureProvider, OVERWRITE_ALL_QUERY);
    }

    protected IWorkbench getWorkbench() {
        return this.workbench;
    }

    protected IStructuredSelection getSelection() {
        return this.structuredSelection;
    }

    protected void openEditor(IFile file, String editorID) throws PartInitException {
        IEditorRegistry editorRegistry = this.getWorkbench().getEditorRegistry();
        if (editorID == null || editorRegistry.findEditor(editorID) == null) {
            editorID = this.getWorkbench().getEditorRegistry().getDefaultEditor(file.getFullPath().toString()).getId();
        }
        IWorkbenchPage page = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.openEditor((IEditorInput)new FileEditorInput(file), editorID, true, 2);
    }

    public static class FileToOpen {
        protected String location;
        protected String editorID;
        protected IFile workspaceFile;

        public String getEditorID() {
            return this.editorID;
        }

        public void setEditorID(String editorID) {
            this.editorID = editorID;
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public IFile getWorkspaceFile() {
            if (this.workspaceFile == null) {
                this.workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getLocation()));
            }
            return this.workspaceFile;
        }
    }

    public static class ProjectDescriptor {
        protected String name;
        protected URI contentURI;
        protected String description;
        protected IProject project;

        public URI getContentURI() {
            return this.contentURI;
        }

        public void setContentURI(URI contentURI) {
            this.contentURI = contentURI;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public IProject getProject() {
            if (this.project == null) {
                this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getName());
            }
            return this.project;
        }
    }

    public class ProjectPage
    extends WizardPage {
        protected org.eclipse.swt.widgets.List projectList;
        protected Text descriptionText;
        protected Button renameButton;

        public ProjectPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        public void createControl(Composite parent) {
            SashForm sashForm = new SashForm(parent, 512);
            sashForm.setLayoutData((Object)new GridData(1808));
            this.projectList = new org.eclipse.swt.widgets.List((Composite)sashForm, 2052);
            this.projectList.setLayoutData((Object)new GridData(1808));
            this.projectList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProjectPage.this.itemSelected();
                }
            });
            this.projectList.setFocus();
            Composite composite = new Composite((Composite)sashForm, 0);
            GridLayout layout = new GridLayout(2, false);
            int margin = -5;
            int spacing = 3;
            layout.marginTop = margin;
            layout.marginLeft = margin;
            layout.marginRight = margin;
            layout.marginBottom = margin;
            layout.horizontalSpacing = spacing;
            layout.verticalSpacing = spacing;
            composite.setLayout((Layout)layout);
            this.descriptionText = new Text(composite, 2634);
            GridData gridData = new GridData(1808);
            gridData.heightHint = this.convertHeightInCharsToPixels(2);
            gridData.grabExcessVerticalSpace = true;
            this.descriptionText.setLayoutData((Object)gridData);
            Composite buttonComposite = new Composite(composite, 0);
            buttonComposite.setLayoutData((Object)new GridData(130));
            buttonComposite.setLayout((Layout)new GridLayout());
            GridLayout layout2 = new GridLayout();
            int margin2 = -5;
            int spacing2 = 3;
            layout2.marginTop = margin2;
            layout2.marginLeft = margin2;
            layout2.marginRight = margin2;
            layout2.marginBottom = margin2;
            layout2.horizontalSpacing = spacing2;
            layout2.verticalSpacing = spacing2;
            buttonComposite.setLayout((Layout)layout2);
            this.renameButton = new Button(buttonComposite, 8);
            this.renameButton.setLayoutData((Object)new GridData(800));
            this.renameButton.setText(CommonUIPlugin.INSTANCE.getString("_UI_Rename_label"));
            this.renameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProjectPage.this.renameExistingProject();
                }
            });
            this.renameButton.setEnabled(false);
            this.refresh();
            sashForm.setWeights(new int[]{70, 30});
            this.setControl((Control)sashForm);
        }

        public void refresh() {
            if (AbstractExampleInstallerWizard.this.getProjectDescriptors().isEmpty()) {
                this.setErrorMessage(CommonUIPlugin.INSTANCE.getString("_UI_NoProjectError_message"));
                this.setPageComplete(false);
            } else {
                this.setErrorMessage(null);
                int selectionIndex = this.projectList.getSelectionIndex();
                if (selectionIndex < 0) {
                    selectionIndex = 0;
                }
                this.projectList.removeAll();
                for (ProjectDescriptor projectDescriptor : AbstractExampleInstallerWizard.this.getProjectDescriptors()) {
                    String name = projectDescriptor.getName();
                    boolean exists = projectDescriptor.getProject().exists();
                    String item = exists ? CommonUIPlugin.INSTANCE.getString("_UI_ExistingProjectName_message", new String[]{name}) : name;
                    this.projectList.add(item);
                    this.projectList.setData(item, (Object)projectDescriptor);
                }
                if (this.getControl() != null) {
                    this.projectList.setSelection(selectionIndex);
                    this.itemSelected();
                }
                this.setPageComplete(true);
            }
        }

        public void setVisible(boolean visible) {
            if (visible && this.projectList.getItemCount() > 0 && this.projectList != null && this.projectList.getSelectionCount() == 0) {
                int index = 0;
                int count = 0;
                for (ProjectDescriptor projectDescriptor : AbstractExampleInstallerWizard.this.getProjectDescriptors()) {
                    if (projectDescriptor.getProject().exists()) {
                        index = count;
                        break;
                    }
                    ++count;
                }
                this.projectList.select(index);
                this.refresh();
            }
            super.setVisible(visible);
        }

        protected ProjectDescriptor getSelectedProjectDescriptor() {
            return this.projectList.getSelectionCount() == 0 ? null : (ProjectDescriptor)this.projectList.getData(this.projectList.getSelection()[0]);
        }

        protected void itemSelected() {
            ProjectDescriptor projectDescriptor = this.getSelectedProjectDescriptor();
            if (projectDescriptor != null) {
                String description;
                boolean exists = projectDescriptor.getProject().exists();
                this.renameButton.setEnabled(exists);
                String string = description = projectDescriptor.getDescription() != null ? projectDescriptor.getDescription() : "";
                if (exists) {
                    String renameMessage = CommonUIPlugin.INSTANCE.getString("_UI_ProjectRename_message");
                    description = description == "" ? renameMessage : CommonUIPlugin.INSTANCE.getString("_UI_ProjectDescriptionAndRename_message", new String[]{description, renameMessage});
                }
                this.descriptionText.setText(description);
            }
        }

        protected void renameExistingProject() {
            ProjectDescriptor projectDescriptor = this.getSelectedProjectDescriptor();
            if (projectDescriptor != null && projectDescriptor.getProject().exists()) {
                RenameResourceAction renameResourceAction = new RenameResourceAction((IShellProvider)AbstractExampleInstallerWizard.this);
                renameResourceAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)projectDescriptor.getProject()));
                renameResourceAction.run();
                projectDescriptor.project = null;
                this.refresh();
            }
        }
    }
}

