/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mapping.presentation;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.viewer.ExtendedTableTreeViewer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.DecoratorAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IItemProviderDecorator;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderDecorator;
import org.eclipse.emf.edit.ui.action.DelegatingCommandAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTableTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.mapping.MappedObjectState;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingFactory;
import org.eclipse.emf.mapping.MappingPackage;
import org.eclipse.emf.mapping.MappingPlugin;
import org.eclipse.emf.mapping.MappingRoot;
import org.eclipse.emf.mapping.action.CreateMappingAction;
import org.eclipse.emf.mapping.action.CreateOneSidedMappingAction;
import org.eclipse.emf.mapping.action.NameMatchMappingAction;
import org.eclipse.emf.mapping.action.RemoveMappingAction;
import org.eclipse.emf.mapping.action.TypeMatchMappingAction;
import org.eclipse.emf.mapping.command.CreateMappingCommand;
import org.eclipse.emf.mapping.command.PersistentCommandStack;
import org.eclipse.emf.mapping.command.RemoveMappingCommand;
import org.eclipse.emf.mapping.command.RestoreInitialStateCommand;
import org.eclipse.emf.mapping.domain.AdapterFactoryMappingDomain;
import org.eclipse.emf.mapping.domain.MappingDomain;
import org.eclipse.emf.mapping.presentation.IComposedSelection;
import org.eclipse.emf.mapping.presentation.MappingDomainLabelProvider;
import org.eclipse.emf.mapping.presentation.MappingUIPlugin;
import org.eclipse.emf.mapping.presentation.SimpleMappedObjectViewer;
import org.eclipse.emf.mapping.provider.MappedObjectItemProvider;
import org.eclipse.emf.mapping.provider.MappingItemProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappingEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener {
    protected static final String DIVIDER = MappingPlugin.getPlugin().getString("_UI_Mapping_label_separator");
    protected static final String SEPARATOR = String.valueOf(MappingPlugin.getPlugin().getString("_UI_Mapping_label_separator")) + " ";
    protected String topLabel = MappingUIPlugin.getPlugin().getString("_UI_Top_label");
    protected String bottomLabel = MappingUIPlugin.getPlugin().getString("_UI_Bottom_label");
    protected Image topImage = MappingUIPlugin.getPlugin().getImage("full/cview16/TopLogo");
    protected Image bottomImage = MappingUIPlugin.getPlugin().getImage("full/cview16/BottomLogo");
    protected boolean isNotificationEnabled = true;
    protected IFileEditorInput modelFile;
    protected MappingRoot mappingRoot;
    protected AdapterFactoryMappingDomain mappingDomain;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected Action contentOutlineFilterAction;
    protected PropertySheetPage propertySheetPage;
    protected SimpleMappedObjectViewer leftSelectionViewer;
    protected MyDecoratorAdapterFactory leftSelectionFactory;
    protected SimpleMappedObjectViewer rightSelectionViewer;
    protected MyDecoratorAdapterFactory rightSelectionFactory;
    protected ViewerPane overviewViewerPane;
    protected OverviewViewer overviewViewer;
    protected OverviewDecoratorAdapterFactory overviewFactory;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected Viewer dropViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == MappingEditor.this.contentOutlinePage) {
                    MappingEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)MappingEditor.this);
                    MappingEditor.this.setCurrentViewer((Viewer)MappingEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet && ((PropertySheet)p).getCurrentPage() == MappingEditor.this.propertySheetPage) {
                MappingEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)MappingEditor.this);
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected CommandStackListener commandStackListener = new CommandStackListener(){

        public void commandStackChanged(final EventObject event) {
            MappingEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MappingEditor.this.firePropertyChange(257);
                    Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                    if (mostRecentCommand != null) {
                        MappingEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                    }
                    (this).MappingEditor.this.leftSelectionViewer.updateActions();
                    (this).MappingEditor.this.rightSelectionViewer.updateActions();
                    if ((this).MappingEditor.this.propertySheetPage != null) {
                        (this).MappingEditor.this.propertySheetPage.refresh();
                    }
                }
            });
        }
    };
    protected static final String SELECTED_MAPPING_PREFIX = String.valueOf(MappingUIPlugin.getPlugin().getString("_UI_SelectedMapping_statusline_prefix")) + " ";
    protected static final String SELECTED_MAPPED_OBJECT_PREFIX = String.valueOf(MappingUIPlugin.getPlugin().getString("_UI_SelectedMappedObject_statusline_prefix")) + " ";
    protected String overviewSummaryColumnLabel;

    public String getTopLabel() {
        return this.topLabel;
    }

    public String getBottomLabel() {
        return this.bottomLabel;
    }

    public Image getTopImage() {
        return this.topImage;
    }

    public Image getBottomImage() {
        return this.bottomImage;
    }

    public boolean isNotificationEnabled() {
        return this.isNotificationEnabled;
    }

    public void setNotificationEnabled(boolean isNotificationEnabled) {
        this.isNotificationEnabled = isNotificationEnabled;
        if (isNotificationEnabled) {
            if (this.leftSelectionViewer != null) {
                this.leftSelectionViewer.refresh();
                this.rightSelectionViewer.refresh();
                this.overviewViewer.refresh();
            }
            if (this.contentOutlineViewer != null) {
                this.contentOutlineViewer.refresh();
            }
            if (this.propertySheetPage != null) {
                this.propertySheetPage.refresh();
            }
        }
    }

    protected void firePropertyChange(int type) {
        super.firePropertyChange(type);
    }

    protected abstract AdapterFactoryMappingDomain createMappingDomain();

    public void setSelectionToViewer(final Collection<?> collection) {
        if (collection != null && !collection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    ArrayList indirectMappedObjects = new ArrayList();
                    ArrayList mappedInputs = new ArrayList();
                    ArrayList mappedOutputs = new ArrayList();
                    ArrayList<Mapping> mappings = new ArrayList<Mapping>();
                    for (Object object : collection) {
                        if (object instanceof Mapping) {
                            mappings.add((Mapping)object);
                            continue;
                        }
                        if (MappingEditor.this.mappingDomain.getMappingRoot().isInputObject(object)) {
                            mappedInputs.add(object);
                            indirectMappedObjects.add(object);
                            continue;
                        }
                        if (!MappingEditor.this.mappingDomain.getMappingRoot().isOutputObject(object)) continue;
                        mappedOutputs.add(object);
                        indirectMappedObjects.add(object);
                    }
                    block1: for (Mapping mapping : mappings) {
                        indirectMappedObjects.addAll(mapping.getMappedObjects());
                        Mapping parent = mapping.getNestedIn();
                        while (parent != null) {
                            if (mappings.contains(parent)) continue block1;
                            parent = parent.getNestedIn();
                        }
                        mappedOutputs.addAll(mapping.getOutputs());
                        mappedInputs.addAll(mapping.getInputs());
                    }
                    if (!indirectMappedObjects.isEmpty()) {
                        MappingEditor.this.overviewViewer.setSelection((ISelection)new StructuredSelection(indirectMappedObjects.toArray()), true);
                    }
                    if (!mappings.isEmpty() && MappingEditor.this.contentOutlineViewer != null) {
                        MappingEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(mappings.toArray()), true);
                    }
                    Viewer affectedViewer = MappingEditor.this.dropViewer == null ? MappingEditor.this.currentViewer : MappingEditor.this.dropViewer;
                    MappingEditor.this.dropViewer = null;
                    if (affectedViewer != null) {
                        if (affectedViewer == MappingEditor.this.leftSelectionViewer) {
                            ArrayList topMappedObjects;
                            ArrayList arrayList = topMappedObjects = MappingEditor.this.mappingRoot.isTopToBottom() ? mappedInputs : mappedOutputs;
                            if (!topMappedObjects.isEmpty()) {
                                MappingEditor.this.leftSelectionViewer.setSelection((ISelection)new StructuredSelection(topMappedObjects.toArray()), true);
                            }
                        } else if (affectedViewer == MappingEditor.this.rightSelectionViewer) {
                            ArrayList bottomMappedObjects;
                            ArrayList arrayList = bottomMappedObjects = !MappingEditor.this.mappingRoot.isTopToBottom() ? mappedInputs : mappedOutputs;
                            if (!bottomMappedObjects.isEmpty()) {
                                MappingEditor.this.rightSelectionViewer.setSelection((ISelection)new StructuredSelection(bottomMappedObjects.toArray()), true);
                            }
                        } else if (!collection.isEmpty()) {
                            affectedViewer.setSelection((ISelection)new StructuredSelection(collection.toArray()), true);
                        }
                    }
                }
            };
            runnable.run();
        } else {
            this.dropViewer = null;
        }
    }

    public EditingDomain getEditingDomain() {
        return this.mappingDomain;
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
        }
        this.setCurrentViewer(this.currentViewerPane.getViewer());
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        MappingEditor.this.setSelection(event.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection(this.currentViewer.getSelection());
        }
    }

    protected void createContextMenuFor(final StructuredViewer structuredViewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(structuredViewer.getControl());
        structuredViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)structuredViewer);
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        structuredViewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)structuredViewer));
        structuredViewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.mappingDomain, (Viewer)structuredViewer){

            public void drop(DropTargetEvent event) {
                MappingEditor.this.dropViewer = structuredViewer;
                super.drop(event);
            }
        });
    }

    public void createPages() {
        this.modelFile = (IFileEditorInput)this.getEditorInput();
        this.handleCreation();
        this.mappingDomain.getCommandStack().execute(RestoreInitialStateCommand.create((MappingDomain)this.mappingDomain));
        this.mappingDomain.getCommandStack().addCommandStackListener(this.commandStackListener);
        SashForm compositePage = new SashForm(this.getContainer(), 512);
        SashForm topSashForm = new SashForm((Composite)compositePage, 256);
        MyViewerPane leftSelectionViewerPane = new MyViewerPane(this.getSite().getPage(), (IWorkbenchPart)this, (MappingDomain)this.mappingDomain, true);
        leftSelectionViewerPane.createControl((Composite)topSashForm);
        this.leftSelectionViewer = (SimpleMappedObjectViewer)leftSelectionViewerPane.getViewer();
        MyViewerPane rightSelectionViewerPane = new MyViewerPane(this.getSite().getPage(), (IWorkbenchPart)this, (MappingDomain)this.mappingDomain, false);
        rightSelectionViewerPane.createControl((Composite)topSashForm);
        this.rightSelectionViewer = (SimpleMappedObjectViewer)rightSelectionViewerPane.getViewer();
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Collection<?> mappedObjects;
                if (MappingEditor.this.currentViewer == MappingEditor.this.contentOutlineViewer) {
                    mappedObjects = MappingEditor.this.getMappedObjects(event.getSelection());
                    StructuredSelection selection = new StructuredSelection(mappedObjects.toArray());
                    MappingEditor.this.leftSelectionViewer.setSelection((ISelection)selection, true);
                    MappingEditor.this.rightSelectionViewer.setSelection((ISelection)selection, true);
                    HashSet indirectMappedObjects = new HashSet();
                    HashSet primaryMappedObjects = new HashSet();
                    for (Object object : mappedObjects) {
                        if (MappingEditor.this.overviewViewer.isSecondaryMappedObject(MappingEditor.this.mappingRoot, object)) {
                            for (Mapping mapping : MappingEditor.this.mappingRoot.getMappings(object)) {
                                indirectMappedObjects.addAll(MappingEditor.this.overviewViewer.getPrimaryMappedObjects(mapping));
                            }
                            continue;
                        }
                        if (!MappingEditor.this.overviewViewer.isPrimaryMappedObject(MappingEditor.this.mappingRoot, object)) continue;
                        primaryMappedObjects.add(object);
                    }
                    if (!primaryMappedObjects.isEmpty()) {
                        MappingEditor.this.overviewViewer.setSelection((ISelection)new StructuredSelection(primaryMappedObjects.toArray()), true);
                    } else if (!indirectMappedObjects.isEmpty()) {
                        MappingEditor.this.overviewViewer.setSelection((ISelection)new StructuredSelection(indirectMappedObjects.toArray()), true);
                    }
                } else if (MappingEditor.this.currentViewer == MappingEditor.this.leftSelectionViewer || MappingEditor.this.currentViewer == MappingEditor.this.rightSelectionViewer) {
                    mappedObjects = new HashSet();
                    for (Mapping mapping : MappingEditor.this.mappingRoot.getAllMappings((Collection)((IStructuredSelection)event.getSelection()).toList())) {
                        mappedObjects.addAll(MappingEditor.this.overviewViewer.getPrimaryMappedObjects(mapping));
                    }
                    if (!mappedObjects.isEmpty()) {
                        MappingEditor.this.overviewViewer.setSelection((ISelection)new StructuredSelection(mappedObjects.toArray()), true);
                    } else {
                        MappingEditor.this.overviewViewer.setSelection(event.getSelection(), true);
                    }
                } else if (MappingEditor.this.currentViewer == MappingEditor.this.overviewViewer) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    if (!selection.isEmpty() && MappingEditor.this.contentOutlineViewer != null) {
                        MappingEditor.this.contentOutlineViewer.setSelection((ISelection)selection, true);
                    }
                    Collection<?> mappedObjects2 = MappingEditor.this.getMappedObjects((ISelection)selection);
                    MappingEditor.this.leftSelectionViewer.setSelection((ISelection)new StructuredSelection(mappedObjects2.toArray()));
                    MappingEditor.this.rightSelectionViewer.setSelection((ISelection)new StructuredSelection(mappedObjects2.toArray()));
                }
                if (MappingEditor.this.currentViewer == MappingEditor.this.leftSelectionViewer || MappingEditor.this.currentViewer == MappingEditor.this.rightSelectionViewer) {
                    Collection mappings = MappingEditor.this.mappingRoot.getAllMappings((Collection)((IComposedSelection)event.getSelection()).getCombinedSelection().toList());
                    if (mappings.isEmpty()) {
                        mappings = MappingEditor.this.mappingRoot.getAllMappings((Collection)((IStructuredSelection)event.getSelection()).toList());
                    }
                    if (!mappings.isEmpty() && MappingEditor.this.contentOutlineViewer != null) {
                        MappingEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(mappings.toArray()), true);
                    }
                }
            }
        });
        this.leftSelectionViewer.setOtherViewer(this.rightSelectionViewer);
        this.rightSelectionViewer.setOtherViewer(this.leftSelectionViewer);
        this.leftSelectionViewer.makeContributions((IMenuManager)leftSelectionViewerPane.getMenuManager(), (IToolBarManager)leftSelectionViewerPane.getToolBarManager(), this.getActionBars().getStatusLineManager());
        this.leftSelectionFactory = new MyDecoratorAdapterFactory(this.mappingDomain.getAdapterFactory(), this.leftSelectionViewer.getFilterMappedObjectsAction(), true){

            protected boolean doMappingRefresh(Object object) {
                if (MappingEditor.this.leftSelectionViewer.getFilterMappedObjectsAction().isChecked()) {
                    MappingEditor.this.leftSelectionViewer.getFilterMappedObjectsAction().setChecked(false);
                    MappingEditor.this.leftSelectionViewer.getFilterMappedObjectsAction().run();
                }
                return true;
            }
        };
        this.leftSelectionFactory.adapt(this.mappingRoot, ITreeItemContentProvider.class);
        this.leftSelectionViewer.setAdapterFactory((AdapterFactory)this.leftSelectionFactory);
        this.leftSelectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.leftSelectionFactory){

            public void notifyChanged(Notification note) {
                if (note.getNotifier() == MappingEditor.this.mappingRoot && (note.getFeature() == MappingPackage.eINSTANCE.getMapping_Outputs() || note.getFeature() == MappingPackage.eINSTANCE.getMapping_Inputs())) {
                    MappingEditor.this.leftSelectionViewer.setInput(new ItemProvider((Collection)MappingEditor.this.mappingRoot.getTops()));
                } else {
                    super.notifyChanged(note);
                }
            }
        });
        this.leftSelectionViewer.setLabelProvider((IBaseLabelProvider)new MappingDomainLabelProvider(this.mappingDomain));
        this.leftSelectionViewer.setAutoExpandLevel(2);
        this.leftSelectionViewer.setInput(new ItemProvider((Collection)this.mappingRoot.getTops()));
        this.leftSelectionViewer.setSelection((ISelection)new StructuredSelection(this.mappingRoot.getTops().toArray()));
        leftSelectionViewerPane.setTitle(this.getTopLabel(), this.getTopImage());
        this.rightSelectionViewer.makeContributions((IMenuManager)rightSelectionViewerPane.getMenuManager(), (IToolBarManager)rightSelectionViewerPane.getToolBarManager(), this.getActionBars().getStatusLineManager());
        this.rightSelectionFactory = new MyDecoratorAdapterFactory(this.mappingDomain.getAdapterFactory(), this.rightSelectionViewer.getFilterMappedObjectsAction(), true){

            protected boolean doMappingRefresh(Object object) {
                if (MappingEditor.this.rightSelectionViewer.getFilterMappedObjectsAction().isChecked()) {
                    MappingEditor.this.rightSelectionViewer.getFilterMappedObjectsAction().setChecked(false);
                    MappingEditor.this.rightSelectionViewer.getFilterMappedObjectsAction().run();
                }
                return true;
            }
        };
        this.rightSelectionFactory.adapt(this.mappingRoot, ITreeItemContentProvider.class);
        this.rightSelectionViewer.setAdapterFactory((AdapterFactory)this.rightSelectionFactory);
        this.rightSelectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.rightSelectionFactory){

            public void notifyChanged(Notification note) {
                if (note.getNotifier() == MappingEditor.this.mappingRoot && (note.getFeature() == MappingPackage.eINSTANCE.getMapping_Outputs() || note.getFeature() == MappingPackage.eINSTANCE.getMapping_Inputs())) {
                    MappingEditor.this.rightSelectionViewer.setInput(new ItemProvider((Collection)MappingEditor.this.mappingRoot.getBottoms()));
                } else {
                    super.notifyChanged(note);
                }
            }
        });
        this.rightSelectionViewer.setLabelProvider((IBaseLabelProvider)new MappingDomainLabelProvider(this.mappingDomain));
        this.rightSelectionViewer.setAutoExpandLevel(2);
        this.rightSelectionViewer.setInput(new ItemProvider((Collection)this.mappingRoot.getBottoms()));
        this.rightSelectionViewer.setSelection((ISelection)new StructuredSelection(this.mappingRoot.getBottoms().toArray()));
        rightSelectionViewerPane.setTitle(this.getBottomLabel(), this.getBottomImage());
        this.overviewViewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                return MappingEditor.this.createOverviewViewer(composite);
            }

            public void requestActivation() {
                super.requestActivation();
                MappingEditor.this.setCurrentViewerPane(this);
            }

            public void showFocus(boolean inFocus) {
                super.showFocus(inFocus);
                if (!inFocus) {
                    MappingEditor.this.overviewViewer.dismissCellEditor();
                }
            }
        };
        this.overviewViewerPane.createControl((Composite)compositePage);
        this.overviewViewer = (OverviewViewer)this.overviewViewerPane.getViewer();
        this.overviewViewer.setAutoExpandLevel(2);
        this.overviewViewerPane.setTitle(MappingUIPlugin.getPlugin().getString("_UI_Overview_label"), this.getDefaultCheckedShowTopFirst() ? MappingUIPlugin.getPlugin().getImage("full/cview16/OverviewLogo") : MappingUIPlugin.getPlugin().getImage("full/cview16/OverviewLogoFlipped"));
        this.overviewViewer.makeContributions((IMenuManager)this.overviewViewerPane.getMenuManager(), (IToolBarManager)this.overviewViewerPane.getToolBarManager(), this.getActionBars().getStatusLineManager());
        this.overviewFactory = this.createOverviewDecoratorAdapterFactory();
        this.overviewViewer.setAdapterFactory((AdapterFactory)this.overviewFactory);
        this.overviewFactory.adapt(this.mappingRoot, ITreeItemContentProvider.class);
        this.overviewViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.overviewFactory){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput != null) {
                    AdapterFactoryTreeIterator children = new AdapterFactoryTreeIterator(MappingEditor.this.mappingDomain.getAdapterFactory(), newInput);
                    while (children.hasNext()) {
                        Object child = children.next();
                        this.adapterFactory.adapt(child, ITreeItemContentProvider.class);
                    }
                }
                super.inputChanged(viewer, oldInput, newInput);
            }
        });
        this.overviewViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.overviewFactory));
        this.overviewViewer.setInput(new ItemProvider(this.overviewViewer.getPrimaryMappedObjects((Mapping)this.mappingRoot)));
        this.createContextMenuFor((StructuredViewer)this.leftSelectionViewer);
        this.createContextMenuFor((StructuredViewer)this.rightSelectionViewer);
        this.createContextMenuFor((StructuredViewer)this.overviewViewer);
        int pageIndex = this.addPage((Control)compositePage);
        this.setPageText(pageIndex, MappingUIPlugin.getPlugin().getString("_UI_Composition_label"));
        this.setActivePage(0);
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    MappingEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    public String getURIFromFile(IFile file) {
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString();
    }

    protected void handleCreation() {
        try {
            Resource resource = this.mappingDomain.loadResource(this.getURIFromFile(this.modelFile.getFile()));
            if (resource.getContents().isEmpty()) {
                this.handleMissingModelFile();
            } else {
                Object rootObject = resource.getContents().get(0);
                if (rootObject instanceof MappingRoot) {
                    this.setMappingRoot((MappingRoot)rootObject);
                } else {
                    this.handleMissingModelFile();
                }
            }
        }
        catch (Exception exception) {
            this.handleCreationException(exception);
        }
    }

    protected abstract void handleMissingModelFile();

    protected void handleCreationException(Exception exception) {
        exception.printStackTrace();
        this.setMappingRoot(MappingFactory.eINSTANCE.createMappingRoot());
    }

    protected void setMappingRoot(MappingRoot mappingRoot) {
        this.mappingRoot = mappingRoot;
        this.mappingRoot.setDomain((MappingDomain)this.mappingDomain);
        if (this.contentOutlineViewer != null && this.contentOutlineViewer.getInput() == null) {
            this.contentOutlineViewer.setInput((Object)new ItemProvider(Collections.singleton(mappingRoot)));
            ArrayList<MappingRoot> selection = new ArrayList<MappingRoot>();
            selection.add(mappingRoot);
            this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(selection), true);
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.getContentOutlinePage();
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    MappingEditor.this.contentOutlineFilterAction = new Action(MappingUIPlugin.getPlugin().getString("_UI_FilterMappedObjects_menu_item"), MappingUIPlugin.getPlugin().getImageDescriptor("full/elcl16/OutlineFilter")){

                        public void run() {
                            ((MyContentOutlinePage)this).MappingEditor.this.contentOutlineViewer.getControl().setVisible(false);
                            Object[] expandedElements = ((MyContentOutlinePage)this).MappingEditor.this.contentOutlineViewer.getExpandedElements();
                            HashSet selectedObjects = new HashSet();
                            for (Object selectedObject : ((IStructuredSelection)((MyContentOutlinePage)this).MappingEditor.this.contentOutlineViewer.getSelection()).toList()) {
                                selectedObjects.add(selectedObject);
                                selectedObjects.add(selectedObject instanceof MappedObjectItemProvider ? ((MappedObjectItemProvider)selectedObject).getMapping() : selectedObject);
                            }
                            Object input = ((MyContentOutlinePage)this).MappingEditor.this.contentOutlineViewer.getInput();
                            ((MyContentOutlinePage)this).MappingEditor.this.contentOutlineViewer.setInput(input);
                            ((MyContentOutlinePage)this).MappingEditor.this.contentOutlineViewer.setExpandedElements(expandedElements);
                            ((MyContentOutlinePage)this).MappingEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(selectedObjects.toArray()), true);
                            ((MyContentOutlinePage)this).MappingEditor.this.contentOutlineViewer.getControl().setVisible(true);
                        }

                        public void setChecked(boolean checked) {
                            super.setChecked(checked);
                            this.setToolTipText(MappingUIPlugin.getPlugin().getString(checked ? "_UI_OutlineFilter_checked_description" : "_UI_OutlineFilter_unchecked_description"));
                        }
                    };
                    MappingEditor.this.contentOutlineFilterAction.setChecked(true);
                    MappingEditor.this.contentOutlineFilterAction.setHoverImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/clcl16/OutlineFilter"));
                    MappingEditor.this.contentOutlineFilterAction.setDisabledImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/dlcl16/OutlineFilter"));
                    super.createControl(parent);
                    MappingEditor.this.contentOutlineViewer = this.getTreeViewer();
                    MappingEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    MappingEditor.this.contentOutlineViewer.setAutoExpandLevel(2);
                    MappingEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(MappingEditor.this.mappingDomain.getAdapterFactory()){

                        public Object[] getChildren(Object object) {
                            return ((MyContentOutlinePage)this).MappingEditor.this.contentOutlineFilterAction.isChecked() ? ((Mapping)object).getNested().toArray() : super.getChildren(object);
                        }

                        public boolean hasChildren(Object object) {
                            return ((MyContentOutlinePage)this).MappingEditor.this.contentOutlineFilterAction.isChecked() ? object instanceof Mapping && !((Mapping)object).getNested().isEmpty() : object instanceof Mapping;
                        }
                    });
                    MappingEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new MappingDomainLabelProvider(MappingEditor.this.mappingDomain));
                    if (MappingEditor.this.mappingRoot != null) {
                        MappingEditor.this.contentOutlineViewer.setInput((Object)new ItemProvider(Collections.singleton(MappingEditor.this.mappingRoot)));
                    }
                    MappingEditor.this.createContextMenuFor((StructuredViewer)MappingEditor.this.contentOutlineViewer);
                    if (MappingEditor.this.mappingRoot != null) {
                        ArrayList<MappingRoot> selection = new ArrayList<MappingRoot>();
                        selection.add(MappingEditor.this.mappingRoot);
                        MappingEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(selection), true);
                    }
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    MappingEditor.this.contentOutlineStatusLineManager = actionBars.getStatusLineManager();
                    actionBars.getToolBarManager().add((IAction)MappingEditor.this.contentOutlineFilterAction);
                    actionBars.getMenuManager().add((IAction)MappingEditor.this.contentOutlineFilterAction);
                    MappingEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage(){

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    MappingEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider(this.mappingDomain.getAdapterFactory()));
        }
        return this.propertySheetPage;
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.mappingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        this.doSaveHelper(this.modelFile.getFile());
    }

    protected void doSaveHelper(final IFile file) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    if (MappingEditor.this.mappingDomain.getCommandStack() instanceof PersistentCommandStack) {
                        MappingEditor.this.mappingRoot.setCommandStack(((PersistentCommandStack)MappingEditor.this.mappingDomain.getCommandStack()).getEncoding());
                    }
                    Resource r = MappingEditor.this.mappingRoot.eResource();
                    r.save(Collections.EMPTY_MAP);
                    file.refreshLocal(1, monitor);
                    if (!MappingEditor.this.mappingRoot.isOutputReadOnly()) {
                        HashSet<Resource> mappedObjectResources = new HashSet<Resource>();
                        for (EObject output : MappingEditor.this.mappingRoot.getOutputs()) {
                            Resource mappedObjectResource = output.eResource();
                            if (mappedObjectResource == null || !mappedObjectResources.add(mappedObjectResource)) continue;
                            mappedObjectResource.save(Collections.EMPTY_MAP);
                            URL resolvedURL = FileLocator.resolve((URL)new URL(mappedObjectResource.getURI().toString()));
                            IFile mappedObjectFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(resolvedURL.getFile()));
                            if (mappedObjectFile == null) continue;
                            mappedObjectFile.refreshLocal(1, monitor);
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.mappingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            System.err.println(MappingPlugin.getPlugin().getString("_EXC_SaveFailed"));
            exception.printStackTrace();
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.mappingRoot.eResource().setURI(URI.createURI((String)this.getURIFromFile(file)));
            this.modelFile = new FileEditorInput(file);
            this.setInputWithNotify((IEditorInput)this.modelFile);
            this.setPartName(file.getName());
            this.doSaveHelper(file);
        }
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException(MappingUIPlugin.getPlugin().getString("_EXC_InvalidEditorInput"));
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        this.setPartName(((IFileEditorInput)editorInput).getFile().getName());
        this.mappingDomain = this.createMappingDomain();
        this.editorSelection = new StructuredSelection();
    }

    public void setFocus() {
        if (this.currentViewerPane != null) {
            this.currentViewerPane.setFocus();
        } else {
            this.getControl(this.getActivePage()).setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager = this.getActionBars().getStatusLineManager();
        if (this.currentViewer == this.contentOutlineViewer) {
            statusLineManager = this.contentOutlineStatusLineManager;
        }
        if (selection instanceof IComposedSelection) {
            List objects = ((IComposedSelection)selection).getCombinedSelection().toList();
            String text = MappingItemProvider.getText((MappingRoot)this.mappingDomain.getMappingRoot(), (AdapterFactory)this.mappingDomain.getAdapterFactory(), (Collection)objects, (String)"/");
            statusLineManager.setMessage(String.valueOf(SELECTED_MAPPING_PREFIX) + text);
        } else if (selection instanceof IStructuredSelection) {
            List collection = ((IStructuredSelection)selection).toList();
            switch (collection.size()) {
                case 0: {
                    statusLineManager.setMessage(MappingUIPlugin.getPlugin().getString("_UI_Selected_statusline_prefix", "0"));
                    break;
                }
                case 1: {
                    Object object = collection.iterator().next();
                    if (object instanceof Mapping) {
                        String text = MappingItemProvider.getText((MappingRoot)this.mappingDomain.getMappingRoot(), (AdapterFactory)this.mappingDomain.getAdapterFactory(), (Collection)((Mapping)object).getMappedObjects(), (String)"/");
                        statusLineManager.setMessage(String.valueOf(SELECTED_MAPPING_PREFIX) + text);
                        break;
                    }
                    if (object instanceof MappedObjectItemProvider) {
                        object = ((MappedObjectItemProvider)object).getMappedObject();
                    }
                    String text = MappingItemProvider.getText((MappingRoot)this.mappingDomain.getMappingRoot(), (AdapterFactory)this.mappingDomain.getAdapterFactory(), Collections.singleton(object), (String)"/");
                    statusLineManager.setMessage(String.valueOf(SELECTED_MAPPED_OBJECT_PREFIX) + text);
                    break;
                }
                default: {
                    statusLineManager.setMessage(MappingUIPlugin.getPlugin().getString("_UI_Selected_statusline_prefix", String.valueOf(collection.size())));
                    break;
                }
            }
        } else {
            statusLineManager.setMessage("");
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public Collection<?> getMappedObjects(ISelection selection) {
        ArrayList<Object> result;
        block7: {
            block6: {
                result = new ArrayList<Object>();
                if (!(selection instanceof IComposedSelection)) break block6;
                ISelection[] selections = ((IComposedSelection)selection).getSelections();
                int i = 0;
                while (i < selections.length) {
                    result.addAll(this.getMappedObjects(selections[i]));
                    ++i;
                }
                break block7;
            }
            if (!(selection instanceof IStructuredSelection)) break block7;
            for (Object selectedElement : ((IStructuredSelection)selection).toList()) {
                if (selectedElement instanceof MappedObjectItemProvider) {
                    selectedElement = ((MappedObjectItemProvider)selectedElement).getMappedObject();
                }
                if (this.mappingDomain.getMappingRoot().isInputObject(selectedElement) || this.mappingDomain.getMappingRoot().isOutputObject(selectedElement)) {
                    result.add(selectedElement);
                    continue;
                }
                Object[] selectedElementChildren = this.mappingDomain.getChildren(selectedElement).toArray();
                int i = 0;
                while (i < selectedElementChildren.length) {
                    Object selectedElementChild = selectedElementChildren[i];
                    if (!(selectedElementChild instanceof Mapping)) {
                        result.addAll(this.getMappedObjects((ISelection)new StructuredSelection(selectedElementChild)));
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public Collection<? extends Mapping> getMappings(ISelection selection) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        if (selection instanceof IStructuredSelection) {
            for (Object selectedElement : ((IStructuredSelection)selection).toList()) {
                if (selectedElement instanceof Mapping) {
                    result.add((Mapping)selectedElement);
                    continue;
                }
                if (selectedElement instanceof MappedObjectItemProvider) {
                    result.add(((MappedObjectItemProvider)selectedElement).getMapping());
                    continue;
                }
                return Collections.emptyList();
            }
        }
        return result;
    }

    public AdapterFactoryMappingDomain getMappingDomain() {
        return this.mappingDomain;
    }

    public Viewer getCurrentViewer() {
        return this.currentViewer;
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        if (this.mappingDomain != null) {
            AdapterFactory adapterFactory = this.mappingDomain.getAdapterFactory();
            if (adapterFactory instanceof IDisposable) {
                ((IDisposable)adapterFactory).dispose();
            }
            this.mappingDomain.getCommandStack().removeCommandStackListener(this.commandStackListener);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        if (this.leftSelectionFactory != null) {
            this.leftSelectionFactory.dispose();
            this.rightSelectionFactory.dispose();
            this.overviewFactory.dispose();
        }
        this.getActionBarContributor().setActiveEditor(null);
        if (this.mappingRoot != null) {
            this.mappingRoot.dispose();
        }
        super.dispose();
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public String getOverviewSummaryColumnLabel() {
        return this.overviewSummaryColumnLabel;
    }

    public Object getOverviewSummaryColumnImage(Object o) {
        return null;
    }

    public String getOverviewSummaryColumnText(Object o) {
        return "";
    }

    public boolean hasLaunchedOverviewSummaryColumnEditor(Object object) {
        return false;
    }

    public void createLaunchedOverviewSummaryColumnEditor(Composite parent, Object object) {
    }

    public boolean getDefaultCheckedShowTopFirst() {
        return !this.mappingDomain.getMappingRoot().isTopToBottom();
    }

    public boolean getDefaultShowMultipleColumns() {
        return false;
    }

    public boolean getDefaultFilterUnmappedObjects() {
        return true;
    }

    protected OverviewViewer createOverviewViewer(Composite composite) {
        return new OverviewViewer(this, composite);
    }

    protected OverviewDecoratorAdapterFactory createOverviewDecoratorAdapterFactory() {
        return new OverviewDecoratorAdapterFactory(this.mappingDomain.getAdapterFactory(), this.overviewViewer.getFilterUnmappedObjectsAction(), false, this.overviewViewer.getMultipleColumnsAction());
    }

    public static class ActionBarContributor
    extends EditingDomainActionBarContributor {
        protected DelegatingCommandAction removeMappingAction = new DelegatingCommandAction((IEditorActionDelegate)new RemoveMappingAction());
        protected DelegatingCommandAction createMappingAction = new DelegatingCommandAction((IEditorActionDelegate)new CreateMappingAction());
        protected DelegatingCommandAction createOneSidedMappingAction = new DelegatingCommandAction((IEditorActionDelegate)new CreateOneSidedMappingAction());
        protected DelegatingCommandAction nameMatchMappingAction = new DelegatingCommandAction((IEditorActionDelegate)new NameMatchMappingAction());
        protected DelegatingCommandAction typeMatchMappingAction = new DelegatingCommandAction((IEditorActionDelegate)new TypeMatchMappingAction());

        public void setActiveEditor(IEditorPart part) {
            super.setActiveEditor(part);
            this.removeMappingAction.setActiveWorkbenchPart((IWorkbenchPart)part);
            this.createMappingAction.setActiveWorkbenchPart((IWorkbenchPart)part);
            this.createOneSidedMappingAction.setActiveWorkbenchPart((IWorkbenchPart)part);
            this.nameMatchMappingAction.setActiveWorkbenchPart((IWorkbenchPart)part);
            this.typeMatchMappingAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        }

        public void contributeToToolBar(IToolBarManager toolBarManager) {
            toolBarManager.add((IContributionItem)new Separator("mapping-settings"));
            toolBarManager.add((IContributionItem)new Separator("mapping-additions"));
            toolBarManager.add((IContributionItem)new Separator("mapping-global-actions"));
            super.contributeToToolBar(toolBarManager);
        }
    }

    protected static class DelayedColumnFitter
    extends ControlAdapter {
        protected Table table;
        protected DelayedLayout delayedLayout;
        protected int columnResizeTime;
        protected int oldWidth;
        protected boolean inLayout;

        protected DelayedColumnFitter() {
        }

        public void controlResized(ControlEvent event) {
            if (event.getSource() instanceof Table) {
                this.table = (Table)event.getSource();
                if (this.delayedLayout == null) {
                    this.delayedLayout = new DelayedLayout(event.time);
                }
            } else if (!this.inLayout) {
                this.columnResizeTime = event.time;
            }
        }

        protected class DelayedLayout
        implements Runnable {
            protected TableLayout layout;
            protected int newWidth;
            protected boolean ignore;

            public DelayedLayout(int time) {
                this.newWidth = DelayedColumnFitter.this.table.getClientArea().width;
                if (DelayedColumnFitter.this.oldWidth != this.newWidth && DelayedColumnFitter.this.oldWidth != 0) {
                    this.layout = new TableLayout();
                    TableColumn[] tableColumns = DelayedColumnFitter.this.table.getColumns();
                    int i = 0;
                    while (i < tableColumns.length) {
                        this.layout.addColumnData((ColumnLayoutData)new ColumnWeightData(tableColumns[i].getWidth(), true));
                        ++i;
                    }
                    if (DelayedColumnFitter.this.columnResizeTime != 0 && time - DelayedColumnFitter.this.columnResizeTime < 500) {
                        this.ignore = true;
                    }
                } else {
                    this.ignore = true;
                }
                DelayedColumnFitter.this.oldWidth = this.newWidth;
                DelayedColumnFitter.this.columnResizeTime = 0;
                DelayedColumnFitter.this.table.getDisplay().asyncExec((Runnable)this);
            }

            public void run() {
                DelayedColumnFitter.this.delayedLayout = null;
                if (!DelayedColumnFitter.this.table.isDisposed() && !this.ignore) {
                    DelayedColumnFitter.this.columnResizeTime = 0;
                    DelayedColumnFitter.this.table.setLayout((Layout)this.layout);
                    DelayedColumnFitter.this.inLayout = true;
                    DelayedColumnFitter.this.table.layout();
                    DelayedColumnFitter.this.inLayout = false;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MyDecoratorAdapterFactory
    extends DecoratorAdapterFactory {
        protected Collection<Object> listeningItemProviderDecorators;
        protected Action action;
        protected Action multipleColumnsAction;
        protected boolean exclude;

        public MyDecoratorAdapterFactory(AdapterFactory adapterFactory, Action action, boolean exclude, Action multipleColumnsAction) {
            this(adapterFactory, action, exclude);
            this.multipleColumnsAction = multipleColumnsAction;
        }

        public MyDecoratorAdapterFactory(AdapterFactory adapterFactory, Action action, boolean exclude) {
            super(adapterFactory);
            this.listeningItemProviderDecorators = new HashSet<Object>();
            this.action = action;
            this.exclude = exclude;
        }

        public boolean isFactoryForType(Object t) {
            return super.isFactoryForType(t) || t == ITableItemLabelProvider.class;
        }

        public Object adapt(Object o, Object t) {
            MappedObjectState mappedObjectState;
            Object result = super.adapt(o, t == ITableItemLabelProvider.class ? IItemLabelProvider.class : t);
            if (result != null && (mappedObjectState = MappingEditor.this.mappingDomain.getMappingRoot().getMappedObjectState(o)) != null && this.listeningItemProviderDecorators.add(o)) {
                ((MyItemProviderDecorator)((Object)result)).setMappedObjectState(mappedObjectState);
            }
            return result;
        }

        protected boolean doMappingRefresh(Object object) {
            return false;
        }

        protected void doMappedObjectRefresh(Object object) {
        }

        public List<?> getPrimaryMappedObjects(Mapping mapping) {
            return Collections.EMPTY_LIST;
        }

        public List<?> getSecondaryMappedObjects(Mapping mapping) {
            return Collections.EMPTY_LIST;
        }

        protected IItemProviderDecorator createItemProviderDecorator(Object object, Object type) {
            MyItemProviderDecorator result = new MyItemProviderDecorator((AdapterFactory)this);
            return result;
        }

        public void fireNotifyChanged(Notification note) {
            if (MappingEditor.this.isNotificationEnabled()) {
                super.fireNotifyChanged(note);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyItemProviderDecorator
        extends ItemProviderDecorator
        implements IStructuredItemContentProvider,
        ITreeItemContentProvider,
        IItemPropertySource,
        IEditingDomainItemProvider,
        IItemLabelProvider,
        ITableItemLabelProvider {
            protected Collection<MappedObjectState> mappedObjectStates;

            public MyItemProviderDecorator(AdapterFactory adapterFactory) {
                super(adapterFactory);
                this.mappedObjectStates = new ArrayList<MappedObjectState>();
            }

            public Collection<?> getChildren(Object o) {
                if (MyDecoratorAdapterFactory.this.action.isChecked()) {
                    ArrayList result = new ArrayList(super.getChildren(o));
                    Iterator results = result.iterator();
                    block0: while (results.hasNext()) {
                        Object child = results.next();
                        AdapterFactoryTreeIterator tree = new AdapterFactoryTreeIterator(MyDecoratorAdapterFactory.this.getDecoratedAdapterFactory(), child, true);
                        while (tree.hasNext()) {
                            Object descendant = tree.next();
                            if (((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingDomain.getMappingRoot().getMappings(descendant).isEmpty() == MyDecoratorAdapterFactory.this.exclude) continue block0;
                        }
                        results.remove();
                    }
                    return result;
                }
                return super.getChildren(o);
            }

            public boolean hasChildren(Object o) {
                if (MyDecoratorAdapterFactory.this.action.isChecked()) {
                    AdapterFactoryTreeIterator tree = new AdapterFactoryTreeIterator(MyDecoratorAdapterFactory.this.getDecoratedAdapterFactory(), o, false);
                    while (tree.hasNext()) {
                        Object descendant = tree.next();
                        if (((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingDomain.getMappingRoot().getMappings(descendant).isEmpty() != MyDecoratorAdapterFactory.this.exclude) continue;
                        return true;
                    }
                    return false;
                }
                return super.hasChildren(o);
            }

            public Object getSummaryColumnImage(Object o) {
                return MappingEditor.this.getOverviewSummaryColumnImage(o);
            }

            public Object getColumnImage(Object o, int columnIndex) {
                if (columnIndex == 0) {
                    return super.getImage(o);
                }
                if (MyDecoratorAdapterFactory.this.multipleColumnsAction == null || !MyDecoratorAdapterFactory.this.multipleColumnsAction.isEnabled() || !MyDecoratorAdapterFactory.this.multipleColumnsAction.isChecked()) {
                    if (columnIndex == 2) {
                        return this.getSummaryColumnImage(o);
                    }
                    ArrayList mappedObjects = new ArrayList();
                    Collection mappings = ((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingRoot.getMappings(o);
                    for (Mapping mapping : mappings) {
                        for (Iterator<Object> mappedObject : MyDecoratorAdapterFactory.this.getSecondaryMappedObjects(mapping)) {
                            if (mappedObjects.contains(mappedObject)) continue;
                            mappedObjects.add(mappedObject);
                        }
                    }
                    Object result = null;
                    for (Object e : mappedObjects) {
                        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)MyDecoratorAdapterFactory.this.adapt(e, IItemLabelProvider.class);
                        Object image = itemLabelProvider.getImage(e);
                        if (result == null) {
                            result = image;
                            continue;
                        }
                        if (result.equals(image)) continue;
                        result = MappingPlugin.getPlugin().getImage("full/obj16/MultipleImages");
                        break;
                    }
                    return result;
                }
                Collection<Object> secondaryMappedObjectsCollection = MyDecoratorAdapterFactory.this.getSecondaryMappedObjects((Mapping)((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingRoot);
                if (secondaryMappedObjectsCollection.size() == 1) {
                    secondaryMappedObjectsCollection = ((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingDomain.getChildren(secondaryMappedObjectsCollection.iterator().next());
                }
                int count = 0;
                for (Object secondardMappedObject : secondaryMappedObjectsCollection) {
                    if (++count != columnIndex) continue;
                    HashSet mappedObjects = new HashSet();
                    Collection mappings = ((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingRoot.getMappings(o);
                    for (Mapping mapping : mappings) {
                        mappedObjects.addAll(MyDecoratorAdapterFactory.this.getSecondaryMappedObjects(mapping));
                    }
                    Object result = null;
                    Iterator iterator = mappedObjects.iterator();
                    block5: while (iterator.hasNext()) {
                        Object mappedObject;
                        Object parent = mappedObject = iterator.next();
                        while (parent instanceof EObject) {
                            if (parent == secondardMappedObject) {
                                IItemLabelProvider itemLabelProvider = (IItemLabelProvider)MyDecoratorAdapterFactory.this.adapt(mappedObject, IItemLabelProvider.class);
                                Object image = itemLabelProvider.getImage(mappedObject);
                                if (result == null) {
                                    result = image;
                                    continue block5;
                                }
                                if (result.equals(image)) continue block5;
                                result = MappingPlugin.getPlugin().getImage("full/obj16/MultipleImages");
                                continue block5;
                            }
                            parent = ((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingDomain.getParent(parent);
                        }
                    }
                    return result;
                }
                return this.getSummaryColumnImage(o);
            }

            public String getSummaryColumnText(Object o) {
                return MappingEditor.this.getOverviewSummaryColumnText(o);
            }

            public String getColumnText(Object o, int columnIndex) {
                if (columnIndex == 0) {
                    return super.getText(o);
                }
                if (MyDecoratorAdapterFactory.this.multipleColumnsAction == null || !MyDecoratorAdapterFactory.this.multipleColumnsAction.isEnabled() || !MyDecoratorAdapterFactory.this.multipleColumnsAction.isChecked()) {
                    if (columnIndex == 2) {
                        return this.getSummaryColumnText(o);
                    }
                    ArrayList mappedObjects = new ArrayList();
                    Collection mappings = ((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingRoot.getMappings(o);
                    for (Mapping mapping : mappings) {
                        for (Iterator<Object> mappedObject : MyDecoratorAdapterFactory.this.getSecondaryMappedObjects(mapping)) {
                            if (mappedObjects.contains(mappedObject)) continue;
                            mappedObjects.add(mappedObject);
                        }
                    }
                    StringBuffer label = new StringBuffer();
                    for (Object e : mappedObjects) {
                        if (label.length() > 0) {
                            label.append(SEPARATOR);
                        }
                        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)MyDecoratorAdapterFactory.this.adapt(e, IItemLabelProvider.class);
                        label.append(itemLabelProvider.getText(e));
                    }
                    return label.toString();
                }
                Collection<Object> secondaryMappedObjectsCollection = MyDecoratorAdapterFactory.this.getSecondaryMappedObjects((Mapping)((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingRoot);
                if (secondaryMappedObjectsCollection.size() == 1) {
                    secondaryMappedObjectsCollection = ((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingDomain.getChildren(secondaryMappedObjectsCollection.iterator().next());
                }
                int count = 0;
                for (Object secondardMappedObject : secondaryMappedObjectsCollection) {
                    if (++count != columnIndex) continue;
                    HashSet mappedObjects = new HashSet();
                    Collection mappings = ((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingRoot.getMappings(o);
                    for (Mapping mapping : mappings) {
                        mappedObjects.addAll(MyDecoratorAdapterFactory.this.getSecondaryMappedObjects(mapping));
                    }
                    StringBuffer label = new StringBuffer();
                    Iterator iterator = mappedObjects.iterator();
                    block5: while (iterator.hasNext()) {
                        Object mappedObject;
                        Object parent = mappedObject = iterator.next();
                        while (parent instanceof EObject) {
                            if (parent == secondardMappedObject) {
                                if (label.length() > 0) {
                                    label.append(SEPARATOR);
                                }
                                IItemLabelProvider itemLabelProvider = (IItemLabelProvider)MyDecoratorAdapterFactory.this.adapt(mappedObject, IItemLabelProvider.class);
                                label.append(itemLabelProvider.getText(mappedObject));
                                continue block5;
                            }
                            parent = ((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingDomain.getParent(parent);
                        }
                    }
                    return label.toString();
                }
                return this.getSummaryColumnText(o);
            }

            public void fireNotifyChanged(Notification note) {
                super.fireNotifyChanged(note);
            }

            /*
             * WARNING - void declaration
             */
            public void notifyChanged(Notification note) {
                if (((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingDomain.getMappingRoot().isInputObject(note.getNotifier()) || ((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingDomain.getMappingRoot().isOutputObject(note.getNotifier())) {
                    if (note.getFeatureID(null) == -2) {
                        ENotificationImpl newNote = new ENotificationImpl((InternalEObject)note.getNotifier(), 1, null, null, null, -1);
                        super.notifyChanged((Notification)newNote);
                        if (MyDecoratorAdapterFactory.this.action.isChecked() && (note.getNewValue() instanceof Mapping || note.getOldValue() instanceof Mapping) && !MyDecoratorAdapterFactory.this.doMappingRefresh(note.getNotifier())) {
                            void var3_5;
                            Object object = this.getParent(note.getNotifier());
                            while (var3_5 instanceof EObject) {
                                if (((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingDomain.getMappingRoot().getMappings((Object)var3_5).isEmpty() == MyDecoratorAdapterFactory.this.exclude) {
                                    ENotificationImpl newNote2 = new ENotificationImpl((InternalEObject)var3_5, 3, null, null, null, -1);
                                    super.notifyChanged((Notification)newNote2);
                                    break;
                                }
                                Object object2 = ((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingDomain.getParent((Object)var3_5);
                            }
                            if (note.getOldValue() instanceof Mapping) {
                                for (Object obj : MyDecoratorAdapterFactory.this.getPrimaryMappedObjects((Mapping)note.getOldValue())) {
                                    ENotificationImpl newNote2 = new ENotificationImpl((InternalEObject)obj, 1, null, null, null, -1);
                                    super.notifyChanged((Notification)newNote2);
                                }
                            } else if (note.getNewValue() instanceof Mapping) {
                                for (Object obj : MyDecoratorAdapterFactory.this.getPrimaryMappedObjects((Mapping)note.getNewValue())) {
                                    ENotificationImpl newNote2 = new ENotificationImpl((InternalEObject)obj, 1, null, null, null, -1);
                                    super.notifyChanged((Notification)newNote2);
                                }
                            }
                        }
                    } else if (note.getFeatureID(null) != -3) {
                        ArrayList<Object> additions = new ArrayList<Object>();
                        switch (note.getEventType()) {
                            case 3: {
                                additions.add(note.getNewValue());
                                break;
                            }
                            case 5: {
                                additions.addAll((Collection)note.getNewValue());
                                break;
                            }
                            case 1: {
                                if (note.getPosition() == -1) {
                                    MyDecoratorAdapterFactory.this.doMappedObjectRefresh(note.getNotifier());
                                    break;
                                }
                                additions.add(note.getNewValue());
                            }
                        }
                        for (Object e : additions) {
                            AdapterFactoryTreeIterator objects = new AdapterFactoryTreeIterator(((MyDecoratorAdapterFactory)MyDecoratorAdapterFactory.this).MappingEditor.this.mappingDomain.getAdapterFactory(), e);
                            while (objects.hasNext()) {
                                Object child = objects.next();
                                this.adapterFactory.adapt(child, ITreeItemContentProvider.class);
                            }
                        }
                    }
                }
                super.notifyChanged(note);
            }

            public void setMappedObjectState(MappedObjectState mappedObjectState) {
                mappedObjectState.addListener((INotifyChangedListener)this);
                this.mappedObjectStates.add(mappedObjectState);
            }

            public void dispose() {
                if (this.mappedObjectStates != null) {
                    for (MappedObjectState mappedObjectState : this.mappedObjectStates) {
                        mappedObjectState.removeListener((INotifyChangedListener)this);
                    }
                }
                this.mappedObjectStates.clear();
                super.dispose();
            }
        }
    }

    protected class MyViewerPane
    extends ViewerPane {
        protected MappingDomain domain;
        protected boolean isTop;

        public MyViewerPane(IWorkbenchPage page, IWorkbenchPart part, MappingDomain domain, boolean isTop) {
            super(page, part);
            this.domain = domain;
            this.isTop = isTop;
        }

        public Viewer createViewer(Composite composite) {
            return new SimpleMappedObjectViewer(this.domain, new Tree(composite, 2), this.isTop);
        }

        public void requestActivation() {
            super.requestActivation();
            MappingEditor.this.setCurrentViewerPane(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OverviewDecoratorAdapterFactory
    extends MyDecoratorAdapterFactory {
        INotifyChangedListener notifyChangedListener;

        public OverviewDecoratorAdapterFactory(AdapterFactory adapterFactory, Action action, boolean exclude, Action multipleColumnsAction) {
            super(adapterFactory, action, exclude, multipleColumnsAction);
            this.notifyChangedListener = new INotifyChangedListener(){

                public void notifyChanged(Notification note) {
                    if (note.getNotifier() instanceof Mapping) {
                        Mapping mapping = (Mapping)note.getNotifier();
                        if (note.getFeature() == MappingPackage.eINSTANCE.getMapping_Inputs() || note.getFeature() == MappingPackage.eINSTANCE.getMapping_Outputs() || MappingEditor.this.getOverviewSummaryColumnLabel() != null && note.getFeature() == MappingPackage.eINSTANCE.getMapping_Helper()) {
                            for (Object mappedObject : mapping.getMappedObjects()) {
                                ENotificationImpl newNote = new ENotificationImpl((InternalEObject)mappedObject, 1, null, null, null, -1);
                                OverviewDecoratorAdapterFactory.this.fireNotifyChanged((Notification)newNote);
                            }
                        }
                    }
                }
            };
            ((IChangeNotifier)this.decoratedAdapterFactory).addListener(this.notifyChangedListener);
        }

        @Override
        public void fireNotifyChanged(Notification note) {
            MappingRoot mappingRoot = MappingEditor.this.mappingDomain.getMappingRoot();
            if (note.getNotifier() == mappingRoot && (note.getFeature() == MappingPackage.eINSTANCE.getMapping_Outputs() || note.getFeature() == MappingPackage.eINSTANCE.getMapping_Inputs())) {
                MappingEditor.this.overviewViewer.setVisible(false);
                MappingEditor.this.overviewViewer.preserveState();
                MappingEditor.this.overviewViewer.init();
                MappingEditor.this.overviewViewer.setInput(new ItemProvider(MappingEditor.this.overviewViewer.getPrimaryMappedObjects((Mapping)MappingEditor.this.mappingDomain.getMappingRoot())));
                MappingEditor.this.overviewViewer.restoreState();
                MappingEditor.this.overviewViewer.setVisible(true);
            } else if (MappingEditor.this.isNotificationEnabled()) {
                super.fireNotifyChanged(note);
            }
            if (MappingEditor.this.isNotificationEnabled()) {
                MappingEditor.this.overviewViewer.refreshCell();
            }
        }

        @Override
        public List<?> getPrimaryMappedObjects(Mapping mapping) {
            return MappingEditor.this.overviewViewer.getPrimaryMappedObjects(mapping);
        }

        @Override
        public List<?> getSecondaryMappedObjects(Mapping mapping) {
            return MappingEditor.this.overviewViewer.getSecondaryMappedObjects(mapping);
        }

        @Override
        protected void doMappedObjectRefresh(Object object) {
            MappingRoot mappingRoot = MappingEditor.this.mappingDomain.getMappingRoot();
            Collection mappings = mappingRoot.getMappings(object);
            HashSet primaryMappedObjects = new HashSet();
            for (Mapping mapping : mappings) {
                primaryMappedObjects.addAll(this.getPrimaryMappedObjects(mapping));
            }
            if (!primaryMappedObjects.contains(object)) {
                for (Object primaryMappedObject : primaryMappedObjects) {
                    if (!MappingEditor.this.isNotificationEnabled()) continue;
                    ENotificationImpl newNote = new ENotificationImpl((InternalEObject)primaryMappedObject, 1, null, null, null, -1);
                    super.fireNotifyChanged((Notification)newNote);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static class OverviewViewer
    extends ExtendedTableTreeViewer {
        protected SimpleMappedObjectViewer otherViewer;
        protected MappingEditor mappingEditor;
        protected AdapterFactoryMappingDomain mappingDomain;
        protected AdapterFactory adapterFactory;
        protected Action filterUnmappedObjects;
        protected Action multipleColumns;
        protected Action showTopFirst;
        protected TableTree tableTree;
        protected Table table;
        protected AdapterFactoryTableTreeEditor tableTreeEditor;
        ControlListener controlListener = new DelayedColumnFitter();
        protected Collection<Object> expandedObjects = new HashSet<Object>();
        protected Collection<Object> selectedObjects = new HashSet<Object>();

        public OverviewViewer(MappingEditor editor, Composite composite) {
            super(composite);
            this.mappingEditor = editor;
            this.mappingDomain = editor.getMappingDomain();
            this.tableTree = this.getTableTree();
            this.table = this.tableTree.getTable();
            this.table.getVerticalBar().setVisible(true);
            this.table.setHeaderVisible(true);
            this.table.setLinesVisible(true);
            TableItem item = new TableItem(this.table, 0);
            item.setImage(1, ExtendedImageRegistry.getInstance().getImage(MappingPlugin.getPlugin().getImage("full/obj16/MultipleImages")));
            TableTreeItem itemx = new TableTreeItem(this.tableTree, 0, 0);
            itemx.setImage(1, ExtendedImageRegistry.getInstance().getImage(MappingPlugin.getPlugin().getImage("full/obj16/MultipleImages")));
            itemx.dispose();
            item.dispose();
            this.table.addControlListener(this.controlListener);
            this.tableTreeEditor = new AdapterFactoryTableTreeEditor(this.tableTree, this.mappingDomain.getAdapterFactory()){
                TreeViewer dropDownTreeViewer;
                Collection<Object> dropDownRoots;
                Collection<Object> mappedObjects;
                Mapping mapping;
                HashMap<Object, Object> filteredChildren;

                public boolean hasDropDownEditor(Object object, int column) {
                    if (column == 0 || column == this.table.getColumnCount() - 1 && OverviewViewer.this.mappingEditor.getOverviewSummaryColumnLabel() != null) {
                        return false;
                    }
                    MappingRoot mappingRoot = OverviewViewer.this.mappingDomain.getMappingRoot();
                    this.dropDownTreeViewer = null;
                    this.dropDownRoots = new ArrayList<Object>();
                    this.mappedObjects = new ArrayList<Object>();
                    this.mapping = null;
                    this.filteredChildren = new HashMap();
                    if (OverviewViewer.this.multipleColumns == null || OverviewViewer.this.multipleColumns.isEnabled() && !OverviewViewer.this.multipleColumns.isChecked()) {
                        Collection mappings = mappingRoot.getMappings(object);
                        for (Mapping mappingCandidate : mappings) {
                            if (this.mapping != null) {
                                return false;
                            }
                            this.mapping = mappingCandidate;
                            for (Object mappedObject : OverviewViewer.this.getSecondaryMappedObjects(this.mapping)) {
                                if (this.mappedObjects.contains(mappedObject)) continue;
                                this.mappedObjects.add(mappedObject);
                            }
                        }
                        this.dropDownRoots.addAll(OverviewViewer.this.getSecondaryMappedObjects((Mapping)mappingRoot));
                    } else {
                        Collection<Object> secondaryMappedObjectsCollection = OverviewViewer.this.getSecondaryMappedObjects((Mapping)mappingRoot);
                        if (secondaryMappedObjectsCollection.size() == 1) {
                            secondaryMappedObjectsCollection = OverviewViewer.this.mappingDomain.getChildren(secondaryMappedObjectsCollection.iterator().next());
                        }
                        int count = 0;
                        for (Object secondaryMappedObject : secondaryMappedObjectsCollection) {
                            if (++count != column) continue;
                            this.dropDownRoots.add(secondaryMappedObject);
                            this.mappedObjects = new HashSet<Object>();
                            Collection mappings = mappingRoot.getMappings(object);
                            for (Mapping mappingCandidate : mappings) {
                                if (this.mapping != null) {
                                    return false;
                                }
                                this.mapping = mappingCandidate;
                                this.mappedObjects.addAll(OverviewViewer.this.getSecondaryMappedObjects(this.mapping));
                            }
                        }
                    }
                    if (this.mapping == mappingRoot) {
                        return false;
                    }
                    ArrayList<Object> dropDownTree = new ArrayList<Object>();
                    Set<Object> primaryMappedObjects = this.mapping != null ? OverviewViewer.this.getPrimaryMappedObjects(this.mapping) : Collections.singleton(object);
                    for (Object o : this.dropDownRoots) {
                        if (!this.filter(dropDownTree, this.mapping, primaryMappedObjects, o)) continue;
                        dropDownTree.add(o);
                    }
                    if (dropDownTree.isEmpty()) {
                        return false;
                    }
                    this.dropDownRoots = dropDownTree;
                    return true;
                }

                protected boolean filter(Collection<?> dropDownTree, Mapping mapping, Collection<?> primaryMappedObjects, Object candidate) {
                    ArrayList children = new ArrayList();
                    for (Object child : OverviewViewer.this.mappingDomain.getChildren(candidate)) {
                        if (!this.filter(dropDownTree, mapping, primaryMappedObjects, child)) continue;
                        children.add(child);
                    }
                    this.filteredChildren.put(candidate, children);
                    return !children.isEmpty() || this.canCreateMapping(primaryMappedObjects, candidate);
                }

                protected boolean canCreateMapping(Collection<?> primaryObjects, Object secondaryObject) {
                    if (!OverviewViewer.this.showTopFirst.isChecked() != OverviewViewer.this.mappingDomain.getMappingRoot().isTopToBottom()) {
                        return OverviewViewer.this.mappingDomain.getMappingRoot().canCreateMapping(Collections.singleton(secondaryObject), primaryObjects, this.mapping);
                    }
                    return OverviewViewer.this.mappingDomain.getMappingRoot().canCreateMapping(primaryObjects, Collections.singleton(secondaryObject), this.mapping);
                }

                public Control createDropDownEditor(Composite parent, Object object, int column) {
                    this.dropDownTreeViewer = new TreeViewer(new Tree(parent, 0x800002));
                    this.dropDownTreeViewer.setAutoExpandLevel(2);
                    this.dropDownTreeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory){

                        public boolean hasChildren(Object o) {
                            Collection children = (Collection)filteredChildren.get(o);
                            return children != null && !children.isEmpty();
                        }

                        public Object[] getChildren(Object o) {
                            Collection children = (Collection)filteredChildren.get(o);
                            return (children != null ? children : Collections.EMPTY_LIST).toArray();
                        }
                    });
                    this.dropDownTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
                    this.dropDownTreeViewer.setInput((Object)new ItemProvider(this.dropDownRoots));
                    if (!this.mappedObjects.isEmpty()) {
                        this.dropDownTreeViewer.setSelection((ISelection)new StructuredSelection(this.mappedObjects.toArray()), true);
                    }
                    return this.dropDownTreeViewer.getControl();
                }

                public boolean hasLaunchedEditor(Object object, int column) {
                    return OverviewViewer.this.mappingEditor.getOverviewSummaryColumnLabel() != null && column == this.table.getColumnCount() - 1 && OverviewViewer.this.mappingEditor.hasLaunchedOverviewSummaryColumnEditor(object);
                }

                public void createLaunchedEditor(Composite parent, Object object, int column) {
                    OverviewViewer.this.mappingEditor.createLaunchedOverviewSummaryColumnEditor(parent, object);
                }

                public void apply() {
                    if (this.dropDownTreeViewer == null) {
                        return;
                    }
                    List list = ((IStructuredSelection)this.dropDownTreeViewer.getSelection()).toList();
                    EList selection = new ArrayList(list);
                    if (this.mapping == null) {
                        if (!selection.isEmpty()) {
                            selection.add(this.currentTableTreeItem.getData());
                            Command command = CreateMappingCommand.create((MappingDomain)OverviewViewer.this.mappingDomain, selection);
                            OverviewViewer.this.mappingDomain.getCommandStack().execute(command);
                        }
                    } else if (!selection.isEmpty()) {
                        EList outputs;
                        boolean flip = !OverviewViewer.this.showTopFirst.isChecked() ^ OverviewViewer.this.mappingDomain.getMappingRoot().isTopToBottom();
                        EList inputs = flip ? selection : this.mapping.getInputs();
                        EList eList = outputs = flip ? this.mapping.getOutputs() : selection;
                        if (!(inputs.containsAll((Collection<?>)this.mapping.getInputs()) && this.mapping.getInputs().containsAll((Collection)inputs) && outputs.containsAll((Collection<?>)this.mapping.getOutputs()) && this.mapping.getOutputs().containsAll((Collection)outputs))) {
                            CommandWrapper command = new CommandWrapper((OverviewViewer.this.mappingDomain.getMappingEnablementFlags() & 0x100) == 0 ? RemoveCommand.create((EditingDomain)OverviewViewer.this.mappingDomain, Collections.singleton(this.mapping)) : RemoveMappingCommand.create((MappingDomain)OverviewViewer.this.mappingDomain, Collections.singleton(this.mapping)), (Collection)inputs, (Collection)outputs){
                                protected Command createCommand;
                                private final /* synthetic */ Collection val$inputs;
                                private final /* synthetic */ Collection val$outputs;
                                {
                                    this.val$inputs = collection;
                                    this.val$outputs = collection2;
                                    super($anonymous0);
                                }

                                protected boolean prepare() {
                                    boolean result = super.prepare() && (this).OverviewViewer.this.mappingDomain.getMappingRoot().canCreateMapping(this.val$inputs, this.val$outputs, mapping);
                                    return result;
                                }

                                public void execute() {
                                    super.execute();
                                    this.createCommand = CreateMappingCommand.create((MappingDomain)(this).OverviewViewer.this.mappingDomain, (Collection)this.val$inputs, (Collection)this.val$outputs);
                                    this.createCommand.execute();
                                }

                                public void undo() {
                                    this.createCommand.undo();
                                    super.undo();
                                }

                                public void redo() {
                                    super.redo();
                                    this.createCommand.redo();
                                }

                                public Collection<?> getResult() {
                                    return this.createCommand.getResult();
                                }

                                public Collection<?> getAffectedObjects() {
                                    return this.createCommand.getAffectedObjects();
                                }

                                public void dispose() {
                                    super.dispose();
                                    if (this.createCommand != null) {
                                        this.createCommand.dispose();
                                    }
                                }
                            };
                            OverviewViewer.this.mappingDomain.getCommandStack().execute((Command)command);
                        }
                    }
                    super.apply();
                    this.dropDownTreeViewer = null;
                }
            };
        }

        public void cancelEditing() {
            super.cancelEditing();
            this.tableTreeEditor.dismiss();
        }

        public boolean isPrimaryMappedObject(MappingRoot mappingRoot, Object object) {
            return !this.showTopFirst.isChecked() == mappingRoot.isTopToBottom() ? mappingRoot.isInputObject(object) : mappingRoot.isOutputObject(object);
        }

        public boolean isSecondaryMappedObject(MappingRoot mappingRoot, Object object) {
            return !this.showTopFirst.isChecked() != mappingRoot.isTopToBottom() ? mappingRoot.isInputObject(object) : mappingRoot.isOutputObject(object);
        }

        public List<?> getPrimaryMappedObjects(Mapping mapping) {
            return !this.showTopFirst.isChecked() == this.mappingDomain.getMappingRoot().isTopToBottom() ? mapping.getInputs() : mapping.getOutputs();
        }

        public List<?> getSecondaryMappedObjects(Mapping mapping) {
            return !this.showTopFirst.isChecked() != this.mappingDomain.getMappingRoot().isTopToBottom() ? mapping.getInputs() : mapping.getOutputs();
        }

        public void preserveState() {
            Collection<Object> oldExpandedObjects = this.expandedObjects;
            this.expandedObjects = new HashSet<Object>(Arrays.asList(this.getExpandedElements()));
            oldExpandedObjects.removeAll(this.expandedObjects);
            for (Object oldExpandedObject : oldExpandedObjects) {
                Widget item = this.findItem(oldExpandedObject);
                if (item != null) continue;
                this.expandedObjects.add(oldExpandedObject);
            }
            Collection<Object> oldSelectedObjects = this.selectedObjects;
            this.selectedObjects = new HashSet<Object>();
            MappingRoot mappingRoot = this.mappingDomain.getMappingRoot();
            for (Object selectedObject : ((IStructuredSelection)super.getSelection()).toList()) {
                this.selectedObjects.add(selectedObject);
                for (Mapping mapping : mappingRoot.getMappings(selectedObject)) {
                    this.selectedObjects.addAll((Collection<Object>)(mapping.getInputs().contains(selectedObject) ? mapping.getOutputs() : mapping.getInputs()));
                }
            }
            if (this.selectedObjects.isEmpty()) {
                this.selectedObjects = oldSelectedObjects;
            }
        }

        public void restoreState() {
            this.setExpandedElements(this.expandedObjects.toArray());
            this.setSelection((ISelection)new StructuredSelection(this.selectedObjects.toArray()), true);
        }

        public void init() {
            this.tableTree.removeAll();
            TableColumn[] columns = this.table.getColumns();
            int i = 0;
            while (i < columns.length) {
                columns[i].dispose();
                ++i;
            }
            TableLayout layout = new TableLayout();
            this.table.setLayout((Layout)layout);
            TableColumn objectColumn = new TableColumn(this.table, 0);
            objectColumn.addControlListener(this.controlListener);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, true));
            objectColumn.setText(!this.showTopFirst.isChecked() ? this.mappingEditor.getTopLabel() : this.mappingEditor.getBottomLabel());
            objectColumn.setResizable(true);
            if (this.multipleColumns != null) {
                List<?> secondaryMappedObjects = this.getSecondaryMappedObjects((Mapping)this.mappingDomain.getMappingRoot());
                this.multipleColumns.setEnabled(secondaryMappedObjects.size() > 1 || secondaryMappedObjects.size() == 1 && this.mappingDomain.getChildren(secondaryMappedObjects.iterator().next()).size() > 1);
                if (!this.multipleColumns.isEnabled()) {
                    this.multipleColumns.setChecked(false);
                }
            }
            String summaryColumnLabel = this.mappingEditor.getOverviewSummaryColumnLabel();
            if (this.multipleColumns == null || !this.multipleColumns.isChecked()) {
                TableColumn otherColumn = new TableColumn(this.table, 0);
                otherColumn.addControlListener(this.controlListener);
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, true));
                otherColumn.setText(this.showTopFirst.isChecked() ? this.mappingEditor.getTopLabel() : this.mappingEditor.getBottomLabel());
                otherColumn.setResizable(true);
                if (summaryColumnLabel != null) {
                    TableColumn summaryColumn = new TableColumn(this.table, 0);
                    summaryColumn.addControlListener(this.controlListener);
                    layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, true));
                    summaryColumn.setText(summaryColumnLabel);
                    summaryColumn.setResizable(true);
                    this.setColumnProperties(new String[]{"a", "b", "c"});
                } else {
                    this.setColumnProperties(new String[]{"a", "b"});
                }
            } else {
                ArrayList<String> properties = new ArrayList<String>();
                Collection<Object> secondaryMappedObjectsCollection = this.getSecondaryMappedObjects((Mapping)this.mappingDomain.getMappingRoot());
                if (secondaryMappedObjectsCollection.size() == 1) {
                    secondaryMappedObjectsCollection = this.mappingDomain.getChildren(secondaryMappedObjectsCollection.iterator().next());
                }
                for (Object mappedObject : secondaryMappedObjectsCollection) {
                    TableColumn mappedObjectColumn = new TableColumn(this.table, 0);
                    mappedObjectColumn.addControlListener(this.controlListener);
                    layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, true));
                    String text = ((ILabelProvider)this.getLabelProvider()).getText(mappedObject);
                    mappedObjectColumn.setText(text);
                    mappedObjectColumn.setResizable(true);
                    properties.add(text);
                }
                if (summaryColumnLabel != null) {
                    properties.add("summaryColumnLabel");
                    TableColumn summaryColumn = new TableColumn(this.table, 0);
                    summaryColumn.addControlListener(this.controlListener);
                    layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, true));
                    summaryColumn.setText(summaryColumnLabel);
                    summaryColumn.setResizable(true);
                }
                this.setColumnProperties(properties.toArray(new String[properties.size()]));
                this.setColumnProperties(properties.toArray(new String[properties.size()]));
            }
            this.table.layout();
        }

        public void setAdapterFactory(AdapterFactory adapterFactory) {
            this.adapterFactory = adapterFactory;
        }

        public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
            this.showTopFirst = new Action("", MappingUIPlugin.getPlugin().getImageDescriptor("full/elcl16/ExchangeSourceAndTarget")){

                public void run() {
                    OverviewViewer.this.getControl().setVisible(false);
                    OverviewViewer.this.dismissCellEditor();
                    OverviewViewer.this.preserveState();
                    OverviewViewer.this.init();
                    OverviewViewer.this.setInput(new ItemProvider(OverviewViewer.this.getPrimaryMappedObjects((Mapping)OverviewViewer.this.mappingDomain.getMappingRoot())));
                    OverviewViewer.this.restoreState();
                    OverviewViewer.this.getControl().setVisible(true);
                }

                public void setChecked(boolean checked) {
                    super.setChecked(checked);
                    this.setToolTipText(MessageFormat.format(MappingUIPlugin.getPlugin().getString("_UI_ShowTopFirst_description"), checked ? OverviewViewer.this.mappingEditor.getTopLabel() : OverviewViewer.this.mappingEditor.getBottomLabel()));
                    this.setText(MessageFormat.format(MappingUIPlugin.getPlugin().getString("_UI_ShowTopFirst_menu_item"), checked ? OverviewViewer.this.mappingEditor.getTopLabel() : OverviewViewer.this.mappingEditor.getBottomLabel()));
                    OverviewViewer.this.mappingEditor.overviewViewerPane.setTitle(MappingUIPlugin.getPlugin().getString("_UI_Overview_label"), !checked ? MappingUIPlugin.getPlugin().getImage("full/cview16/OverviewLogo") : MappingUIPlugin.getPlugin().getImage("full/cview16/OverviewLogoFlipped"));
                }
            };
            this.showTopFirst.setChecked(!this.mappingEditor.getDefaultCheckedShowTopFirst());
            this.showTopFirst.setHoverImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/clcl16/ExchangeSourceAndTarget"));
            this.showTopFirst.setDisabledImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/dlcl16/ExchangeSourceAndTarget"));
            toolBarManager.add((IAction)this.showTopFirst);
            menuManager.add((IAction)this.showTopFirst);
            this.multipleColumns = new Action(MappingUIPlugin.getPlugin().getString("_UI_ShowMultipleColumns_menu_item"), MappingUIPlugin.getPlugin().getImageDescriptor("full/elcl16/ShowMultipleTopsOrBottoms")){

                public void run() {
                    OverviewViewer.this.getControl().setVisible(false);
                    OverviewViewer.this.preserveState();
                    OverviewViewer.this.dismissCellEditor();
                    OverviewViewer.this.init();
                    OverviewViewer.this.setInput(OverviewViewer.this.getInput());
                    OverviewViewer.this.restoreState();
                    OverviewViewer.this.getControl().setVisible(true);
                }

                public void setChecked(boolean checked) {
                    super.setChecked(checked);
                    this.setToolTipText(MappingUIPlugin.getPlugin().getString(checked ? "_UI_ShowMultipleColumns_checked_description" : "_UI_ShowMultipleColumns_unchecked_description"));
                }
            };
            this.multipleColumns.setChecked(this.mappingEditor.getDefaultShowMultipleColumns());
            List<?> secondaryMappedObjects = this.getSecondaryMappedObjects((Mapping)this.mappingDomain.getMappingRoot());
            this.multipleColumns.setEnabled(secondaryMappedObjects.size() > 1 || secondaryMappedObjects.size() == 1 && this.mappingDomain.getChildren(secondaryMappedObjects.iterator().next()).size() > 1);
            this.multipleColumns.setHoverImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/clcl16/ShowMultipleTopsOrBottoms"));
            this.multipleColumns.setDisabledImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/dlcl16/ShowMultipleTopsOrBottoms"));
            toolBarManager.add((IAction)this.multipleColumns);
            menuManager.add((IAction)this.multipleColumns);
            this.filterUnmappedObjects = new Action(MappingUIPlugin.getPlugin().getString("_UI_FilterUnmappedObjects_menu_item"), MappingUIPlugin.getPlugin().getImageDescriptor("full/elcl16/ShowOnlyMappedObjects")){

                public void run() {
                    OverviewViewer.this.preserveState();
                    OverviewViewer.this.dismissCellEditor();
                    OverviewViewer.this.setInput(OverviewViewer.this.getInput());
                    OverviewViewer.this.restoreState();
                }

                public void setChecked(boolean checked) {
                    super.setChecked(checked);
                    this.setToolTipText(MappingUIPlugin.getPlugin().getString(checked ? "_UI_FilterUnmappedObjects_checked_description" : "_UI_FilterUnmappedObjects_unchecked_description"));
                }
            };
            this.filterUnmappedObjects.setChecked(this.mappingEditor.getDefaultFilterUnmappedObjects());
            this.filterUnmappedObjects.setHoverImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/clcl16/ShowOnlyMappedObjects"));
            this.filterUnmappedObjects.setDisabledImageDescriptor(MappingUIPlugin.getPlugin().getImageDescriptor("full/dlcl16/ShowOnlyMappedObjects"));
            toolBarManager.add((IAction)this.filterUnmappedObjects);
            menuManager.add((IAction)this.filterUnmappedObjects);
            toolBarManager.update(true);
            menuManager.update(true);
            this.init();
        }

        public Action getFilterUnmappedObjectsAction() {
            return this.filterUnmappedObjects;
        }

        public Action getMultipleColumnsAction() {
            return this.multipleColumns;
        }

        public Action getShowTopFirstAction() {
            return this.showTopFirst;
        }

        public ISelection getSelection() {
            IStructuredSelection theSelection = (IStructuredSelection)super.getSelection();
            ArrayList result = new ArrayList();
            for (Object object : theSelection.toList()) {
                result.addAll(this.mappingDomain.getMappingRoot().getMappings(object));
            }
            return result.isEmpty() ? theSelection : new StructuredSelection(result.toArray());
        }

        public void dismissCellEditor() {
            this.tableTreeEditor.dismiss();
        }

        public void refreshCell() {
            if (this.tableTreeEditor.getEditor() != null) {
                this.tableTreeEditor.getEditor().redraw();
            }
        }

        protected void setSelectionToWidget(List list, boolean reveal) {
            ArrayList filteredSelection = new ArrayList();
            if (list != null) {
                filteredSelection.addAll(list);
                Iterator i = filteredSelection.iterator();
                while (i.hasNext()) {
                    Object selectedObject = i.next();
                    if (this.findItem(selectedObject) != null || this.internalExpand(selectedObject, false) != null) continue;
                    i.remove();
                }
            }
            super.setSelectionToWidget(filteredSelection, reveal);
        }

        public void setVisible(boolean visible) {
            this.getControl().setVisible(visible);
        }
    }
}

