/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.presentation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.celleditor.ExtendedComboBoxCellEditor;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.impl.SAXXMLHandler;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;
import org.eclipse.xsd.presentation.XSDEditorPlugin;
import org.eclipse.xsd.provider.XSDItemProviderAdapterFactory;
import org.eclipse.xsd.provider.XSDSemanticItemProviderAdapterFactory;
import org.eclipse.xsd.util.XSDParser;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSwitch;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider {
    protected XSDSchema xsdSchema;
    protected AdapterFactoryEditingDomain editingDomain;
    protected XSDItemProviderAdapterFactory syntacticAdapterFactory;
    protected XSDItemProviderAdapterFactory semanticAdapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected TextEditor textEditor;
    protected ISourceViewer sourceViewer;
    protected TreeViewer syntacticSelectionViewer;
    protected TreeViewer semanticSelectionViewer;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected SelectDiagnosticAction selectNextDiagnosticsAction;
    protected SelectDiagnosticAction selectPreviousDiagnosticsAction;
    protected SelectUseAction selectNextUseAction;
    protected SelectUseAction selectPreviousUseAction;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            XSDEditor.this.handlePartActivated(p);
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected boolean handledStructuredModelChange = false;
    protected boolean validateAutomatically = true;

    public XSDEditor() {
        this.syntacticAdapterFactory = new XSDItemProviderAdapterFactory();
        this.semanticAdapterFactory = new XSDSemanticItemProviderAdapterFactory();
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                XSDEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        XSDEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            XSDEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        XSDEditor.this.handleStructuredModelChange();
                        XSDEditor.this.updateActions();
                        if ((this).XSDEditor.this.propertySheetPage != null) {
                            (this).XSDEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.syntacticAdapterFactory, (CommandStack)commandStack);
        this.editingDomain.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
    }

    protected void updateActions() {
        if (this.selectNextDiagnosticsAction != null) {
            this.selectNextDiagnosticsAction.updateAction();
            this.selectPreviousDiagnosticsAction.updateAction();
            this.selectNextUseAction.updateAction();
            this.selectPreviousUseAction.updateAction();
        }
    }

    protected String determineEncoding() {
        String encoding = (String)((XSDResourceImpl)this.xsdSchema.eResource()).getDefaultSaveOptions().get(XSDResourceImpl.XSD_ENCODING);
        if (encoding != null && DataValue.EncodingMap.getIANA2JavaMapping((String)encoding) != null) {
            encoding = DataValue.EncodingMap.getIANA2JavaMapping((String)encoding);
        }
        return encoding;
    }

    protected void handleStructuredModelChange() {
        IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
        if (this.xsdSchema.getElement() == null) {
            this.xsdSchema.updateElement();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.xsdSchema.eResource().save((OutputStream)out, null);
            String encoding = this.determineEncoding();
            String newContent = encoding == null ? out.toString() : out.toString(encoding);
            String oldContent = document.get();
            int startIndex = 0;
            while (startIndex < newContent.length() && startIndex < oldContent.length() && newContent.charAt(startIndex) == oldContent.charAt(startIndex)) {
                ++startIndex;
            }
            int newEndIndex = newContent.length() - 1;
            int oldEndIndex = oldContent.length() - 1;
            while (newEndIndex >= startIndex && oldEndIndex >= startIndex && newContent.charAt(newEndIndex) == oldContent.charAt(oldEndIndex)) {
                --newEndIndex;
                --oldEndIndex;
            }
            String replacement = newContent.substring(startIndex, newEndIndex + 1);
            int length = oldEndIndex - startIndex + 1;
            this.handledStructuredModelChange = true;
            document.replace(startIndex, length, replacement);
        }
        catch (Exception exception) {
            XSDEditorPlugin.INSTANCE.log(exception);
        }
    }

    protected void handlePartActivated(IWorkbenchPart workbenchPart) {
        if (workbenchPart == this) {
            if (this.getActivePage() == 0) {
                this.setCurrentViewer((Viewer)this.sourceViewer);
            }
        } else if (workbenchPart instanceof ContentOutline) {
            if (((ContentOutline)workbenchPart).getCurrentPage() == this.contentOutlinePage) {
                this.getEditorSite().getActionBarContributor().setActiveEditor((IEditorPart)this);
                this.setCurrentViewer((Viewer)this.contentOutlineViewer);
            }
        } else if (workbenchPart instanceof PropertySheet && ((PropertySheet)workbenchPart).getCurrentPage() == this.propertySheetPage) {
            this.getActionBarContributor().setActiveEditor((IEditorPart)this);
        }
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(final Collection<?> collection) {
        if (collection != null && !collection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (XSDEditor.this.currentViewer != null) {
                        XSDEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(collection.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
        }
        if (this.currentViewerPane != null) {
            this.setCurrentViewer(this.currentViewerPane.getViewer());
        }
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        XSDEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void createPages() {
        this.createSourcePage();
        this.createSemanticsPage();
        this.createSyntaxPage();
        this.setActivePage(0);
        this.setCurrentViewer((Viewer)this.sourceViewer);
    }

    protected void createResource(String uri) {
        this.extendedCreateResource(uri);
    }

    protected void standardCreateResource(String uri) {
        XSDResourceImpl xsdResource = (XSDResourceImpl)this.editingDomain.loadResource(uri);
        this.xsdSchema = xsdResource.getSchema();
    }

    protected void extendedCreateResource(String uri) {
        this.editingDomain.getResourceSet().getLoadOptions().put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
        try {
            XSDResourceImpl xsdResource = (XSDResourceImpl)this.editingDomain.getResourceSet().createResource(URI.createURI((String)uri));
            xsdResource.load(this.editingDomain.getResourceSet().getLoadOptions());
            this.xsdSchema = xsdResource.getSchema();
        }
        catch (Exception exception) {
            XSDEditorPlugin.INSTANCE.log(exception);
        }
    }

    protected void createModel() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                try {
                    progressMonitor.beginTask("", 12);
                    XSDEditor.this.editingDomain.getResourceSet().getLoadOptions().put(XSDResourceImpl.XSD_PROGRESS_MONITOR, progressMonitor);
                    XSDEditor.this.createResource(EditUIUtil.getURI((IEditorInput)XSDEditor.this.getEditorInput()).toString());
                    XSDEditor.this.editingDomain.getResourceSet().getLoadOptions().remove(XSDResourceImpl.XSD_PROGRESS_MONITOR);
                    progressMonitor.worked(1);
                    progressMonitor.subTask(XSDEditorPlugin.INSTANCE.getString("_UI_Validating_message"));
                    if (XSDEditor.this.xsdSchema.getDiagnostics().isEmpty()) {
                        XSDEditor.this.xsdSchema.validate();
                    }
                    if (XSDEditor.this.determineEncoding() != null && XSDEditor.this.getEditorInput() instanceof IFileEditorInput) {
                        ((IFileEditorInput)XSDEditor.this.getEditorInput()).getFile().setCharset(XSDEditor.this.determineEncoding(), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 2));
                    }
                    progressMonitor.worked(1);
                    progressMonitor.subTask(XSDEditorPlugin.INSTANCE.getString("_UI_ReportingErrors_message"));
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception exception) {
            XSDEditorPlugin.INSTANCE.log(exception);
        }
    }

    protected void handleSourceCaretPosition() {
        int offset = this.sourceViewer.getTextWidget().getCaretOffset();
        Element element = this.xsdSchema.getElement();
        if (element != null) {
            IDocument document = this.sourceViewer.getDocument();
            int line = 0;
            int lineOffset = 0;
            try {
                line = document.getLineOfOffset(offset);
                lineOffset = document.getLineOffset(line);
            }
            catch (BadLocationException badLocationException) {}
            int column = offset - lineOffset;
            Element bestElement = this.findBestElement(element, line + 1, column + 1);
            if (bestElement != null) {
                this.handleSelectedNodes(Collections.singleton(bestElement));
            }
        }
    }

    public Element findBestElement(Element element, int line, int column) {
        int startLine = XSDParser.getStartLine((Node)element);
        int startColumn = XSDParser.getStartColumn((Node)element);
        int endLine = XSDParser.getEndLine((Node)element);
        int endColumn = XSDParser.getEndColumn((Node)element);
        Element candidate = null;
        if ((line == startLine ? column >= startColumn : line > startLine) && (line == endLine ? column <= endColumn : line < endLine)) {
            candidate = element;
            Node child = element.getFirstChild();
            while (child != null) {
                Element childElement;
                Element betterCandidate;
                if (child.getNodeType() == 1 && (betterCandidate = this.findBestElement(childElement = (Element)child, line, column)) != null) {
                    candidate = betterCandidate;
                    break;
                }
                child = child.getNextSibling();
            }
        }
        return candidate;
    }

    public void handleSelectedNodes(Collection<? extends Node> nodes) {
        ArrayList<XSDConcreteComponent> selection = new ArrayList<XSDConcreteComponent>();
        for (Node node : nodes) {
            XSDConcreteComponent bestXSDConcreteComponent = this.xsdSchema.getCorrespondingComponent(node);
            if (bestXSDConcreteComponent == null) continue;
            boolean add = true;
            XSDConcreteComponent parent = bestXSDConcreteComponent;
            while (parent != null) {
                if (selection.contains(parent)) {
                    add = false;
                    break;
                }
                parent = parent.getContainer();
            }
            if (!add) continue;
            XSDConcreteComponent container = bestXSDConcreteComponent.getContainer();
            if (container instanceof XSDParticle || container instanceof XSDAttributeUse) {
                bestXSDConcreteComponent = container;
            }
            selection.add(bestXSDConcreteComponent);
        }
        if (!selection.isEmpty()) {
            StructuredSelection structuredSelection = new StructuredSelection(selection.toArray());
            if (this.contentOutlineViewer != null) {
                this.contentOutlineViewer.setSelection((ISelection)structuredSelection, true);
            }
            this.setSelection((ISelection)structuredSelection);
            this.handleContentOutlineSelectionForTextEditor((ISelection)structuredSelection, false);
        }
    }

    protected void handleDocumentChange() {
        try {
            XSDParser xsdParser = new XSDParser(null);
            String documentContent = this.sourceViewer.getDocument().get();
            xsdParser.parseString(documentContent);
            this.xsdSchema.clearDiagnostics();
            xsdParser.setSchema(this.xsdSchema);
            if (this.validateAutomatically) {
                this.xsdSchema.validate();
                this.handleDiagnostics(null);
            }
        }
        catch (Exception exception) {
            XSDEditorPlugin.INSTANCE.log(exception);
        }
    }

    protected void createSourcePage() {
        try {
            this.textEditor = new TextEditor(){

                public ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
                    ISourceViewer result = super.createSourceViewer(parent, ruler, styles);
                    result.getTextWidget().addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDown(MouseEvent event) {
                            XSDEditor.this.handleSourceCaretPosition();
                        }
                    });
                    result.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent event) {
                            switch (event.keyCode) {
                                case 0x1000001: 
                                case 0x1000002: 
                                case 0x1000003: 
                                case 0x1000004: 
                                case 0x1000005: 
                                case 0x1000006: {
                                    XSDEditor.this.handleSourceCaretPosition();
                                }
                            }
                        }
                    });
                    XSDEditor.this.sourceViewer = result;
                    return result;
                }
            };
            this.createModel();
            int pageIndex = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
            this.handleDiagnostics(null);
            this.setPageText(pageIndex, XSDEditorPlugin.INSTANCE.getString("_UI_Source_title"));
            IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
            document.addDocumentListener(new IDocumentListener(){
                protected Timer timer = new Timer();
                protected TimerTask timerTask;

                public void documentAboutToBeChanged(DocumentEvent documentEvent) {
                }

                public void documentChanged(DocumentEvent documentEvent) {
                    try {
                        if (this.timerTask != null) {
                            this.timerTask.cancel();
                        }
                        if (XSDEditor.this.handledStructuredModelChange) {
                            XSDEditor.this.handledStructuredModelChange = false;
                            XSDEditor.this.handleDocumentChange();
                        } else {
                            this.timerTask = new TimerTask(){

                                public void run() {
                                    XSDEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                                        public void run() {
                                            XSDEditor.this.handleDocumentChange();
                                        }
                                    });
                                }
                            };
                            this.timer.schedule(this.timerTask, 1000L);
                        }
                    }
                    catch (Exception exception) {
                        XSDEditorPlugin.INSTANCE.log(exception);
                    }
                }
            });
        }
        catch (Exception exception) {
            XSDEditorPlugin.INSTANCE.log(exception);
        }
    }

    protected void createSemanticsPage() {
        ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                Tree tree = new Tree(composite, 2);
                TreeViewer newTreeViewer = new TreeViewer(tree);
                return newTreeViewer;
            }

            public void requestActivation() {
                super.requestActivation();
                XSDEditor.this.setCurrentViewerPane(this);
            }
        };
        viewerPane.createControl(this.getContainer());
        this.semanticSelectionViewer = (TreeViewer)viewerPane.getViewer();
        this.semanticSelectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.semanticAdapterFactory));
        this.semanticSelectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.semanticAdapterFactory));
        this.semanticSelectionViewer.setAutoExpandLevel(2);
        this.semanticSelectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                if (XSDEditor.this.currentViewer == XSDEditor.this.semanticSelectionViewer && XSDEditor.this.contentOutlineViewer != null) {
                    XSDEditor.this.contentOutlineViewer.setSelection(selectionChangedEvent.getSelection(), true);
                }
            }
        });
        this.semanticSelectionViewer.setInput((Object)new ItemProvider(Collections.singleton(this.xsdSchema)));
        viewerPane.setTitle((Object)this.xsdSchema);
        new AdapterFactoryTreeEditor(this.semanticSelectionViewer.getTree(), (AdapterFactory)this.semanticAdapterFactory);
        this.createContextMenuFor((StructuredViewer)this.semanticSelectionViewer);
        int pageIndex = this.addPage(viewerPane.getControl());
        this.setPageText(pageIndex, XSDEditorPlugin.INSTANCE.getString("_UI_Semantics_title"));
    }

    protected void createSyntaxPage() {
        ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                Tree tree = new Tree(composite, 2);
                TreeViewer newTreeViewer = new TreeViewer(tree);
                return newTreeViewer;
            }

            public void requestActivation() {
                super.requestActivation();
                XSDEditor.this.setCurrentViewerPane(this);
            }
        };
        viewerPane.createControl(this.getContainer());
        this.syntacticSelectionViewer = (TreeViewer)viewerPane.getViewer();
        this.syntacticSelectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.syntacticAdapterFactory));
        this.syntacticSelectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.syntacticAdapterFactory));
        this.syntacticSelectionViewer.setAutoExpandLevel(2);
        this.syntacticSelectionViewer.setInput((Object)new ItemProvider(Collections.singleton(this.xsdSchema)));
        viewerPane.setTitle((Object)this.xsdSchema);
        new AdapterFactoryTreeEditor(this.syntacticSelectionViewer.getTree(), (AdapterFactory)this.syntacticAdapterFactory);
        this.createContextMenuFor((StructuredViewer)this.syntacticSelectionViewer);
        int pageIndex = this.addPage(viewerPane.getControl());
        this.setPageText(pageIndex, XSDEditorPlugin.INSTANCE.getString("_UI_Syntax_title"));
    }

    protected void initializeMarkerPosition(IMarker marker, XSDDiagnostic xsdDiagnostic) throws CoreException {
        Node node = xsdDiagnostic.getNode();
        if (node != null && node.getNodeType() == 2) {
            node = ((Attr)node).getOwnerElement();
        }
        if (node != null && XSDParser.getUserData((Node)node) != null) {
            int startLine = XSDParser.getStartLine((Node)node) - 1;
            int startColumn = XSDParser.getStartColumn((Node)node);
            int endLine = XSDParser.getEndLine((Node)node) - 1;
            int endColumn = XSDParser.getEndColumn((Node)node);
            marker.setAttribute("lineNumber", startLine);
            try {
                IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
                marker.setAttribute("charStart", document.getLineOffset(startLine) + startColumn - 1);
                marker.setAttribute("charEnd", document.getLineOffset(endLine) + endColumn - 1);
            }
            catch (BadLocationException badLocationException) {}
        } else {
            marker.setAttribute("lineNumber", xsdDiagnostic.getLine());
        }
    }

    protected void handleDiagnostics(IProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor localProgressMonitor) throws CoreException {
                    XSDEditor.this.handleDiagnostics(localProgressMonitor);
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(operation, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception exception) {
                XSDEditorPlugin.INSTANCE.log(exception);
            }
        } else {
            XSDConcreteComponent newSelection = null;
            if (this.getEditorInput() instanceof IFileEditorInput) {
                try {
                    IFileEditorInput modelFile = (IFileEditorInput)this.getEditorInput();
                    IFile file = modelFile.getFile();
                    IMarker[] markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
                    ArrayList<IMarker> deletableMarkers = new ArrayList<IMarker>(Arrays.asList(markers));
                    if (this.validateAutomatically) {
                        for (XSDDiagnostic xsdDiagnostic : this.xsdSchema.getAllDiagnostics()) {
                            String uriReferencePath = this.xsdSchema.eResource().getURIFragment((EObject)xsdDiagnostic);
                            IMarker marker = null;
                            int i = 0;
                            while (i < markers.length) {
                                if (markers[i].getAttribute("diagnostic", "").equals(uriReferencePath)) {
                                    marker = markers[i];
                                    deletableMarkers.remove(marker);
                                    break;
                                }
                                ++i;
                            }
                            if (marker == null) {
                                marker = file.createMarker("org.eclipse.xsd.diagnostic");
                                marker.setAttribute("diagnostic", (Object)uriReferencePath);
                            }
                            this.initializeMarkerPosition(marker, xsdDiagnostic);
                            marker.setAttribute("message", (Object)xsdDiagnostic.getMessage());
                            switch (xsdDiagnostic.getSeverity().getValue()) {
                                case 0: 
                                case 1: {
                                    if (newSelection == null) {
                                        newSelection = xsdDiagnostic.getPrimaryComponent();
                                    }
                                    marker.setAttribute("severity", 2);
                                    break;
                                }
                                case 2: {
                                    marker.setAttribute("severity", 1);
                                    break;
                                }
                                case 3: {
                                    marker.setAttribute("severity", 0);
                                }
                            }
                        }
                    }
                    for (IMarker marker : deletableMarkers) {
                        marker.delete();
                    }
                }
                catch (Exception exception) {
                    XSDEditorPlugin.INSTANCE.log(exception);
                }
            }
            if (this.editorSelection != null) {
                this.setSelection(this.editorSelection);
            } else if (newSelection != null) {
                StructuredSelection errorSelection = new StructuredSelection(newSelection);
                this.getSite().getShell().getDisplay().asyncExec(new Runnable((IStructuredSelection)errorSelection){
                    private final /* synthetic */ IStructuredSelection val$errorSelection;
                    {
                        this.val$errorSelection = iStructuredSelection;
                    }

                    public void run() {
                        if (XSDEditor.this.contentOutlineViewer != null) {
                            XSDEditor.this.contentOutlineViewer.setSelection((ISelection)this.val$errorSelection, true);
                        }
                        if (XSDEditor.this.sourceViewer != null) {
                            XSDEditor.this.handleContentOutlineSelectionForTextEditor((ISelection)this.val$errorSelection, true);
                        }
                        XSDEditor.this.setSelection((ISelection)this.val$errorSelection);
                        XSDEditor.this.handleSourceCaretPosition();
                    }
                });
            }
        }
    }

    protected void pageChange(int pageIndex) {
        Control control;
        super.pageChange(pageIndex);
        if (pageIndex == 0) {
            this.setCurrentViewerPane(null);
            this.setCurrentViewer((Viewer)this.sourceViewer);
        }
        if ((control = this.getControl(pageIndex)) != null) {
            control.setVisible(true);
            control.setFocus();
        }
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.getContentOutlinePage();
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        return this.textEditor.getAdapter(key);
    }

    public static XSDConcreteComponent getResolvedObject(XSDConcreteComponent xsdConcreteComponent) {
        XSDConcreteComponent result = (XSDConcreteComponent)new XSDSwitch<Object>(){

            public Object caseXSDAttributeUse(XSDAttributeUse xsdAttributeUse) {
                return xsdAttributeUse.getAttributeDeclaration().getResolvedAttributeDeclaration();
            }

            public Object caseXSDAttributeDeclaration(XSDAttributeDeclaration xsdAttributeDeclaration) {
                return xsdAttributeDeclaration.getResolvedAttributeDeclaration();
            }

            public Object caseXSDAttributeGroupDefinition(XSDAttributeGroupDefinition xsdAttributeGroupDefinition) {
                return xsdAttributeGroupDefinition.getResolvedAttributeGroupDefinition();
            }

            public Object caseXSDElementDeclaration(XSDElementDeclaration xsdElementDeclaration) {
                return xsdElementDeclaration.getResolvedElementDeclaration();
            }

            public Object caseXSDModelGroupDefinition(XSDModelGroupDefinition xsdModelGroupDefinition) {
                return xsdModelGroupDefinition.getResolvedModelGroupDefinition();
            }

            public Object caseXSDParticle(XSDParticle xsdParticle) {
                XSDConcreteComponent resolvedObject = XSDEditor.getResolvedObject((XSDConcreteComponent)xsdParticle.getContent());
                if (resolvedObject instanceof XSDModelGroup) {
                    return xsdParticle;
                }
                return resolvedObject;
            }
        }.doSwitch((EObject)xsdConcreteComponent);
        return result == null ? xsdConcreteComponent : result;
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    XSDEditor.this.contentOutlineViewer = this.getTreeViewer();
                    XSDEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    XSDEditor.this.contentOutlineViewer.setAutoExpandLevel(2);
                    XSDEditor.this.selectNextDiagnosticsAction = new SelectDiagnosticAction(true, (StructuredViewer)XSDEditor.this.contentOutlineViewer);
                    XSDEditor.this.selectPreviousDiagnosticsAction = new SelectDiagnosticAction(false, (StructuredViewer)XSDEditor.this.contentOutlineViewer);
                    XSDEditor.this.selectNextUseAction = new SelectUseAction(true, (StructuredViewer)XSDEditor.this.contentOutlineViewer);
                    XSDEditor.this.selectPreviousUseAction = new SelectUseAction(false, (StructuredViewer)XSDEditor.this.contentOutlineViewer);
                    XSDEditor.this.contentOutlineViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

                        public void mouseDoubleClick(MouseEvent event) {
                            IStructuredSelection selection = (IStructuredSelection)((MyContentOutlinePage)this).XSDEditor.this.contentOutlineViewer.getSelection();
                            for (Object object : selection.toList()) {
                                XSDComplexTypeDefinition xsdComplexTypeDefinition;
                                XSDSimpleTypeDefinition baseTypeDefinition;
                                XSDSimpleTypeDefinition typeDefinition;
                                XSDConcreteComponent resolvedObject;
                                XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)object;
                                if (xsdConcreteComponent != (resolvedObject = XSDEditor.getResolvedObject(xsdConcreteComponent))) {
                                    ((MyContentOutlinePage)this).XSDEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{resolvedObject}), true);
                                    break;
                                }
                                if (xsdConcreteComponent instanceof XSDAttributeDeclaration) {
                                    XSDAttributeDeclaration xsdAttributeDeclaration = (XSDAttributeDeclaration)xsdConcreteComponent;
                                    typeDefinition = xsdAttributeDeclaration.getTypeDefinition();
                                    if (typeDefinition == null || typeDefinition.getSchema() != xsdAttributeDeclaration.getSchema()) continue;
                                    ((MyContentOutlinePage)this).XSDEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{typeDefinition}), true);
                                    break;
                                }
                                if (xsdConcreteComponent instanceof XSDElementDeclaration) {
                                    XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)xsdConcreteComponent;
                                    typeDefinition = xsdElementDeclaration.getTypeDefinition();
                                    if (typeDefinition == null || typeDefinition.getSchema() != xsdElementDeclaration.getSchema()) continue;
                                    ((MyContentOutlinePage)this).XSDEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{typeDefinition}), true);
                                    break;
                                }
                                if (xsdConcreteComponent instanceof XSDSimpleTypeDefinition) {
                                    XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)xsdConcreteComponent;
                                    baseTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
                                    if (baseTypeDefinition != null && baseTypeDefinition.getSchema() == xsdSimpleTypeDefinition.getSchema()) {
                                        ((MyContentOutlinePage)this).XSDEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{baseTypeDefinition}), true);
                                        break;
                                    }
                                    XSDSimpleTypeDefinition itemTypeDefinition = xsdSimpleTypeDefinition.getItemTypeDefinition();
                                    if (itemTypeDefinition != null && itemTypeDefinition.getSchema() == xsdSimpleTypeDefinition.getSchema()) {
                                        ((MyContentOutlinePage)this).XSDEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{itemTypeDefinition}), true);
                                        break;
                                    }
                                    EList memberTypeDefinitions = xsdSimpleTypeDefinition.getMemberTypeDefinitions();
                                    if (memberTypeDefinitions.isEmpty()) continue;
                                    ((MyContentOutlinePage)this).XSDEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(memberTypeDefinitions.toArray()), true);
                                    break;
                                }
                                if (!(xsdConcreteComponent instanceof XSDComplexTypeDefinition) || (baseTypeDefinition = (xsdComplexTypeDefinition = (XSDComplexTypeDefinition)xsdConcreteComponent).getBaseTypeDefinition()) == null || baseTypeDefinition.getSchema() != xsdComplexTypeDefinition.getSchema()) continue;
                                ((MyContentOutlinePage)this).XSDEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(new Object[]{baseTypeDefinition}), true);
                                break;
                            }
                        }
                    });
                    XSDEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)XSDEditor.this.syntacticAdapterFactory));
                    XSDEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)XSDEditor.this.syntacticAdapterFactory));
                    XSDEditor.this.contentOutlineViewer.setInput((Object)new ItemProvider(Collections.singleton(XSDEditor.this.xsdSchema)));
                    XSDEditor.this.createContextMenuFor((StructuredViewer)XSDEditor.this.contentOutlineViewer);
                    ArrayList<XSDSchema> selection = new ArrayList<XSDSchema>();
                    selection.add(XSDEditor.this.xsdSchema);
                    XSDEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(selection), true);
                    this.addSelectionChangedListener(new ISelectionChangedListener(){

                        public void selectionChanged(SelectionChangedEvent event) {
                            ISelection s = event.getSelection();
                            if (((MyContentOutlinePage)this).XSDEditor.this.contentOutlineViewer == ((MyContentOutlinePage)this).XSDEditor.this.currentViewer) {
                                XSDEditor.this.handleContentOutlineSelection(s);
                            }
                            ((MyContentOutlinePage)this).XSDEditor.this.selectNextDiagnosticsAction.setCurrentObjects(((IStructuredSelection)s).toList());
                            ((MyContentOutlinePage)this).XSDEditor.this.selectPreviousDiagnosticsAction.setCurrentObjects(((IStructuredSelection)s).toList());
                            ((MyContentOutlinePage)this).XSDEditor.this.selectNextUseAction.setCurrentObjects(((IStructuredSelection)s).toList());
                            ((MyContentOutlinePage)this).XSDEditor.this.selectPreviousUseAction.setCurrentObjects(((IStructuredSelection)s).toList());
                        }
                    });
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    XSDEditor.this.contentOutlineStatusLineManager = actionBars.getStatusLineManager();
                    actionBars.getToolBarManager().add((IAction)XSDEditor.this.selectNextUseAction);
                    actionBars.getToolBarManager().add((IAction)XSDEditor.this.selectPreviousUseAction);
                    actionBars.getToolBarManager().add((IAction)XSDEditor.this.selectNextDiagnosticsAction);
                    actionBars.getToolBarManager().add((IAction)XSDEditor.this.selectPreviousDiagnosticsAction);
                    actionBars.getMenuManager().add((IAction)XSDEditor.this.selectNextDiagnosticsAction);
                    actionBars.getMenuManager().add((IAction)XSDEditor.this.selectPreviousDiagnosticsAction);
                    actionBars.getMenuManager().add((IAction)XSDEditor.this.selectNextUseAction);
                    actionBars.getMenuManager().add((IAction)XSDEditor.this.selectPreviousUseAction);
                    XSDEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (XSDEditor.this.contentOutlineViewer == XSDEditor.this.currentViewer) {
                        XSDEditor.this.handleContentOutlineSelection(event.getSelection());
                    }
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage(){

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    XSDEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.syntacticAdapterFactory){

                protected IPropertySource createPropertySource(Object object, IItemPropertySource itemPropertySource) {
                    return new PropertySource(object, itemPropertySource){

                        protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
                            return new PropertyDescriptor(this.object, itemPropertyDescriptor){

                                public CellEditor createPropertyEditor(Composite composite) {
                                    Collection choiceOfValues;
                                    EStructuralFeature feature;
                                    EClassifier getEType;
                                    if (!this.itemPropertyDescriptor.canSetProperty(this.object)) {
                                        return null;
                                    }
                                    CellEditor result = null;
                                    Object genericFeature = this.itemPropertyDescriptor.getFeature(this.object);
                                    if (genericFeature instanceof EStructuralFeature && (getEType = (feature = (EStructuralFeature)genericFeature).getEType()) == ecorePackage.getEBoolean() && (choiceOfValues = this.itemPropertyDescriptor.getChoiceOfValues(this.object)) != null) {
                                        result = new ExtendedComboBoxCellEditor(composite, new ArrayList(choiceOfValues), this.getLabelProvider(), true);
                                    }
                                    if (result == null) {
                                        result = super.createPropertyEditor(composite);
                                    }
                                    return result;
                                }
                            };
                        }
                    };
                }
            });
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        if ((this.currentViewerPane != null || this.getActivePage() == 0) && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            if (this.getActivePage() == 0) {
                this.handleContentOutlineSelectionForTextEditor(selection, true);
            } else if (this.currentViewerPane.getViewer() == this.syntacticSelectionViewer) {
                this.syntacticSelectionViewer.setSelection(selection);
            } else if (this.currentViewerPane.getViewer() == this.semanticSelectionViewer) {
                ArrayList<XSDConcreteComponent> selectionList = new ArrayList<XSDConcreteComponent>();
                for (Object object : ((IStructuredSelection)selection).toList()) {
                    selectionList.add(XSDEditor.getResolvedObject((XSDConcreteComponent)object));
                }
                this.semanticSelectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
            }
        }
    }

    public void handleContentOutlineSelectionForTextEditor(ISelection selection, boolean reveal) {
        Element element;
        XSDParticle xsdParticle;
        XSDParticleContent content;
        XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)((IStructuredSelection)selection).iterator().next();
        if (xsdConcreteComponent instanceof XSDParticle && (content = (xsdParticle = (XSDParticle)xsdConcreteComponent).getContent()) != null) {
            xsdConcreteComponent = content;
        }
        if ((element = xsdConcreteComponent.getElement()) != null) {
            try {
                IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
                int startLine = XSDParser.getStartLine((Node)element);
                int startColumn = XSDParser.getStartColumn((Node)element);
                int endLine = XSDParser.getEndLine((Node)element);
                int endColumn = XSDParser.getEndColumn((Node)element);
                int startOffset = document.getLineOffset(startLine - 1);
                startOffset += startColumn - 1;
                int endOffset = document.getLineOffset(endLine - 1);
                endOffset += endColumn - 1;
                if (startLine == endLine) {
                    this.textEditor.setHighlightRange(startOffset, endOffset - startOffset, false);
                    if (reveal) {
                        this.textEditor.selectAndReveal(startOffset, endOffset - startOffset);
                    }
                } else {
                    this.textEditor.setHighlightRange(startOffset, endOffset - startOffset, reveal);
                }
            }
            catch (Exception exception) {
                XSDEditorPlugin.INSTANCE.log(exception);
            }
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded() || this.textEditor != null && this.textEditor.isDirty();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    XSDEditor.this.xsdSchema.eResource().save(Collections.EMPTY_MAP);
                }
                catch (Exception exception) {
                    XSDEditorPlugin.INSTANCE.log(exception);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(false, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.textEditor.doRevertToSaved();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            XSDEditorPlugin.INSTANCE.log(exception);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.xsdSchema.eResource().setURI(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
            FileEditorInput modelFile = new FileEditorInput(file);
            this.setInput((IEditorInput)modelFile);
            this.setPartName(file.getName());
            this.doSave(this.getActionBars().getStatusLineManager().getProgressMonitor());
        }
    }

    public void gotoMarker(IMarker marker) {
        try {
            this.setActivePage(0);
            ((IGotoMarker)this.textEditor.getAdapter(IGotoMarker.class)).gotoMarker(marker);
        }
        catch (Exception exception) {
            XSDEditorPlugin.INSTANCE.log(exception);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)new MultiPageSelectionProvider((MultiPageEditorPart)this));
        site.getPage().addPartListener(this.partListener);
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, selection);
        ((MultiPageSelectionProvider)this.getSite().getSelectionProvider()).fireSelectionChanged(selectionChangedEvent);
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(selectionChangedEvent);
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(XSDEditorPlugin.INSTANCE.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        XSDConcreteComponent xsdConcreteComponent;
                        Object object = collection.iterator().next();
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.syntacticAdapterFactory).getText(object);
                        text = XSDEditorPlugin.INSTANCE.getString("_UI_SingleObjectSelected", new Object[]{text});
                        if (object instanceof XSDConcreteComponent && !(xsdConcreteComponent = (XSDConcreteComponent)object).getDiagnostics().isEmpty()) {
                            text = ((XSDDiagnostic)xsdConcreteComponent.getDiagnostics().get(0)).getMessage();
                        }
                        statusLineManager.setMessage(text);
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(XSDEditorPlugin.INSTANCE.getString("_UI_MultiObjectSelected", new Object[]{Integer.toString(collection.size())}));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePartListener(this.partListener);
        this.semanticAdapterFactory.dispose();
        this.syntacticAdapterFactory.dispose();
    }

    public void setValidateAutomatically(boolean validateAutomatically) {
        this.validateAutomatically = validateAutomatically;
        if (validateAutomatically) {
            this.handleDocumentChange();
        } else {
            this.handleDiagnostics(null);
        }
    }

    public boolean isValidateAutomatically() {
        return this.validateAutomatically;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ActionBarContributor
    extends EditingDomainActionBarContributor
    implements ISelectionChangedListener {
        protected IEditorPart activeEditorPart;
        protected ISelectionProvider selectionProvider;
        protected IAction refreshViewerAction = new Action(XSDEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

            public boolean isEnabled() {
                return ActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
            }

            public void run() {
                Viewer viewer;
                if (ActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)ActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                    viewer.refresh();
                }
            }
        };
        protected IAction showPropertiesViewAction = new Action(XSDEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

            public void run() {
                try {
                    ActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
                }
                catch (PartInitException exception) {
                    XSDEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
        };
        protected IAction validateAutomaticallyAction = new Action(XSDEditorPlugin.INSTANCE.getString("_UI_ValidateAutomatically_menu_item")){

            public void run() {
                ((XSDEditor)ActionBarContributor.this.activeEditorPart).setValidateAutomatically(this.isChecked());
            }
        };
        protected Collection<IAction> createChildActions = Collections.emptyList();
        protected IMenuManager createChildMenuManager;
        protected Collection<IAction> createSiblingActions = Collections.emptyList();
        protected IMenuManager createSiblingMenuManager;

        public ActionBarContributor() {
            super(1);
        }

        public void contributeToMenu(IMenuManager menuManager) {
            super.contributeToMenu(menuManager);
            MenuManager submenuManager = new MenuManager(XSDEditorPlugin.INSTANCE.getString("_UI_XSDEditor_menu"), "org.eclipse.xsdMenuID");
            menuManager.insertAfter("additions", (IContributionItem)submenuManager);
            submenuManager.add((IContributionItem)new Separator("settings"));
            submenuManager.add((IContributionItem)new Separator("actions"));
            submenuManager.add((IContributionItem)new Separator("additions"));
            submenuManager.add((IContributionItem)new Separator("additions-end"));
            this.createChildMenuManager = new MenuManager(XSDEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
            this.createSiblingMenuManager = new MenuManager(XSDEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
            submenuManager.insertBefore("additions", (IContributionItem)new Separator("actions"));
            submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
            submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
            submenuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager menuManager) {
                    menuManager.updateAll(true);
                }
            });
            this.validateAutomaticallyAction.setChecked(true);
            submenuManager.insertAfter("additions-end", this.validateAutomaticallyAction);
            this.addGlobalActions((IMenuManager)submenuManager);
        }

        public void contributeToToolBar(IToolBarManager toolBarManager) {
            toolBarManager.add((IContributionItem)new Separator("xsd-settings"));
            toolBarManager.add((IContributionItem)new Separator("xsd-additions"));
        }

        public void setActiveEditor(IEditorPart part) {
            super.setActiveEditor(part);
            this.activeEditorPart = part;
            if (this.selectionProvider != null) {
                this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
            if (part instanceof XSDEditor) {
                this.validateAutomaticallyAction.setChecked(((XSDEditor)part).isValidateAutomatically());
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (this.createChildMenuManager != null) {
                this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
            }
            if (this.createSiblingMenuManager != null) {
                this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
            }
            Collection<Object> newChildDescriptors = Collections.emptyList();
            Collection<Object> newSiblingDescriptors = Collections.emptyList();
            ISelection sel = event.getSelection();
            if (sel instanceof IStructuredSelection && ((IStructuredSelection)sel).size() == 1) {
                Object object = ((IStructuredSelection)sel).getFirstElement();
                EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
                newChildDescriptors = domain.getNewChildDescriptors(object, null);
                newSiblingDescriptors = domain.getNewChildDescriptors(domain.getParent(object), object);
            }
            this.createChildActions = this.generateCreateChildActions(newChildDescriptors, sel);
            this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, sel);
            if (this.createChildMenuManager != null) {
                this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
                this.createChildMenuManager.update(true);
            }
            if (this.createSiblingMenuManager != null) {
                this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
                this.createSiblingMenuManager.update(true);
            }
        }

        protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
            LinkedList<IAction> actions = new LinkedList<IAction>();
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.activeEditorPart, selection, descriptor));
            }
            return actions;
        }

        protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
            LinkedList<IAction> actions = new LinkedList<IAction>();
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
            return actions;
        }

        protected void populateManager(IContributionManager manager, Collection<IAction> actions, String ID) {
            for (IAction action : actions) {
                if (ID != null) {
                    manager.insertBefore(ID, action);
                    continue;
                }
                manager.add(action);
            }
        }

        protected void depopulateManager(IContributionManager manager, Collection<IAction> actions) {
            IContributionItem[] item = manager.getItems();
            int i = 0;
            while (i < item.length) {
                IAction action;
                IContributionItem curItem = item[i];
                while (curItem instanceof SubContributionItem) {
                    curItem = ((SubContributionItem)curItem).getInnerItem();
                }
                if (curItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)curItem).getAction())) {
                    manager.remove(curItem);
                }
                ++i;
            }
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            super.menuAboutToShow(menuManager);
            MenuManager submenuManager = new MenuManager(XSDEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
            this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
            menuManager.insertBefore("edit", (IContributionItem)submenuManager);
            submenuManager = new MenuManager(XSDEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
            this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
            menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        }

        protected void addGlobalActions(IMenuManager menuManager) {
            menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
            menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
            this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
            menuManager.insertAfter("ui-actions", this.refreshViewerAction);
            super.addGlobalActions(menuManager);
        }
    }

    public static class GenericXMLLoadAction
    extends ActionDelegate
    implements IActionDelegate {
        protected IFile file;
        protected IContainer container;

        public void run(IAction action) {
            if (this.file != null) {
                this.execute(this.file);
            } else {
                this.execute(this.container);
            }
        }

        public void execute(IContainer container) {
            try {
                IResource[] contents = container.members();
                int i = 0;
                while (i < contents.length) {
                    IResource resource = contents[i];
                    if (resource.getType() == 1) {
                        if ("xml".equals(resource.getLocation().getFileExtension()) && resource.getName().indexOf(".xml") == resource.getName().lastIndexOf(".xml")) {
                            this.execute((IFile)resource);
                        }
                    } else {
                        this.execute((IContainer)resource);
                    }
                    ++i;
                }
            }
            catch (CoreException exception) {
                XSDEditorPlugin.INSTANCE.log((Object)exception);
                exception.printStackTrace();
            }
        }

        public void execute(IFile file) {
            OutputStream outputStream;
            Document document;
            XSDParser xsdParser;
            System.err.println("Processing: " + file.getFullPath());
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xml", new GenericXMLResourceFactoryImpl());
            Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true);
            resource.setURI(URI.createPlatformResourceURI((String)(String.valueOf(file.getFullPath().toString()) + ".save.xml"), (boolean)true));
            try {
                resource.save(Collections.EMPTY_MAP);
            }
            catch (IOException exception) {
                XSDEditorPlugin.INSTANCE.log(exception);
                exception.printStackTrace();
            }
            ArrayList<EPackage> ePackages = new ArrayList<EPackage>();
            for (Resource otherResource : resourceSet.getResources()) {
                for (Object object : otherResource.getContents()) {
                    if (!(object instanceof EPackage)) continue;
                    ePackages.add((EPackage)object);
                }
            }
            Resource ePackagesResource = resourceSet.createResource(URI.createPlatformResourceURI((String)(String.valueOf(file.getFullPath().toString()) + ".ecore"), (boolean)true));
            ePackagesResource.getContents().addAll(EcoreUtil.copyAll(ePackages));
            try {
                ePackagesResource.save(Collections.EMPTY_MAP);
            }
            catch (IOException exception) {
                XSDEditorPlugin.INSTANCE.log(exception);
                exception.printStackTrace();
            }
            try {
                xsdParser = new XSDParser(null);
                xsdParser.parse(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString());
                document = xsdParser.getDocument();
                outputStream = resourceSet.getURIConverter().createOutputStream(URI.createPlatformResourceURI((String)(String.valueOf(file.getFullPath().toString()) + ".format.xml"), (boolean)true));
                XSDResourceImpl.serialize((OutputStream)outputStream, (Document)document);
                outputStream.close();
            }
            catch (IOException exception) {
                XSDEditorPlugin.INSTANCE.log(exception);
                exception.printStackTrace();
            }
            try {
                xsdParser = new XSDParser(null);
                xsdParser.parse(URI.createPlatformResourceURI((String)(String.valueOf(file.getFullPath().toString()) + ".save.xml"), (boolean)true).toString());
                document = xsdParser.getDocument();
                outputStream = resourceSet.getURIConverter().createOutputStream(URI.createPlatformResourceURI((String)(String.valueOf(file.getFullPath().toString()) + ".save.format.xml"), (boolean)true));
                XSDResourceImpl.serialize((OutputStream)outputStream, (Document)document);
                outputStream.close();
            }
            catch (IOException exception) {
                XSDEditorPlugin.INSTANCE.log(exception);
                exception.printStackTrace();
            }
        }

        public void selectionChanged(IAction action, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                Object object = ((IStructuredSelection)selection).getFirstElement();
                if (object instanceof IFile) {
                    this.file = (IFile)object;
                    action.setEnabled(true);
                    return;
                }
                if (object instanceof IContainer) {
                    this.container = (IContainer)object;
                    action.setEnabled(true);
                    return;
                }
            }
            this.file = null;
            this.container = null;
            action.setEnabled(false);
        }
    }

    public static class GenericXMLResourceFactoryImpl
    extends XMLResourceFactoryImpl {
        public Resource createResource(URI uri) {
            GenericXMLResourceImpl result = new GenericXMLResourceImpl(uri);
            result.getDefaultSaveOptions().put("EXTENDED_META_DATA", Boolean.TRUE);
            result.getDefaultLoadOptions().put("EXTENDED_META_DATA", Boolean.TRUE);
            result.getDefaultLoadOptions().put("USE_LEXICAL_HANDLER", Boolean.TRUE);
            result.getDefaultSaveOptions().put("LINE_WIDTH", new Integer(80));
            result.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.TRUE);
            return result;
        }
    }

    public static class GenericXMLResourceImpl
    extends XMLResourceImpl {
        protected XSDEcoreBuilder xsdEcoreBuilder;

        public GenericXMLResourceImpl(URI uri) {
            super(uri);
        }

        protected XMLLoad createXMLLoad() {
            return new XMLLoadImpl(this.createXMLHelper()){

                protected DefaultHandler makeDefaultHandler() {
                    return new SAXXMLHandler(this.resource, this.helper, this.options){

                        protected void handleTopLocations(String prefix, String name) {
                            String namespaceURI;
                            if (this.urisToLocations != null) {
                                (this).GenericXMLResourceImpl.this.xsdEcoreBuilder = new XSDEcoreBuilder(this.extendedMetaData);
                                Collection resources = (this).GenericXMLResourceImpl.this.xsdEcoreBuilder.generateResources(this.urisToLocations.values());
                                resource.getResourceSet().getResources().addAll(resources);
                            }
                            if (this.extendedMetaData.getPackage(namespaceURI = this.helper.getURI(prefix)) == null) {
                                this.extendedMetaData.demandFeature(namespaceURI, name, true);
                            }
                        }
                    };
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SelectDiagnosticAction
    extends SelectObjectAction {
        boolean isForward;

        public SelectDiagnosticAction(boolean isForward, StructuredViewer structuredViewer) {
            super(structuredViewer, isForward ? "Select &Next Diagnosed Object" : "Select &Previous Diagnosed Object", ExtendedImageRegistry.INSTANCE.getImageDescriptor(XSDEditorPlugin.INSTANCE.getImage(isForward ? "full/elcl16/SelectNextDiagnosticObject" : "full/elcl16/SelectPreviousDiagnosticObject")));
            this.isForward = isForward;
            this.setHoverImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(XSDEditorPlugin.INSTANCE.getImage(isForward ? "full/clcl16/SelectNextDiagnosticObject" : "full/clcl16/SelectPreviousDiagnosticObject")));
            this.setDisabledImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(XSDEditorPlugin.INSTANCE.getImage(isForward ? "full/dlcl16/SelectNextDiagnosticObject" : "full/dlcl16/SelectPreviousDiagnosticObject")));
        }

        public void updateAction() {
            this.setCurrentObjects(((IStructuredSelection)this.structuredViewer.getSelection()).toList());
        }

        public void setCurrentObjects(List<?> objects) {
            XSDConcreteComponent result = null;
            boolean isStarted = false;
            TreeIterator tree = XSDEditor.this.editingDomain.treeIterator((Object)XSDEditor.this.xsdSchema);
            while (tree.hasNext()) {
                XSDConcreteComponent xsdConcreteComponent = (XSDConcreteComponent)tree.next();
                if (!this.isForward && objects.contains(xsdConcreteComponent)) break;
                if (isStarted || !this.isForward) {
                    if (xsdConcreteComponent.getDiagnostics().isEmpty() && (!(xsdConcreteComponent instanceof XSDParticle) || ((XSDParticle)xsdConcreteComponent).getContent().getDiagnostics().isEmpty()) && (!(xsdConcreteComponent instanceof XSDAttributeUse) || ((XSDAttributeUse)xsdConcreteComponent).getContent().getDiagnostics().isEmpty())) continue;
                    if (isStarted) {
                        result = xsdConcreteComponent;
                        break;
                    }
                    result = xsdConcreteComponent;
                    continue;
                }
                if (!objects.contains(xsdConcreteComponent)) continue;
                isStarted = true;
            }
            this.setObjectToSelect(result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SelectObjectAction
    extends Action {
        protected Collection<?> objectsToSelect;
        protected StructuredViewer structuredViewer;

        public SelectObjectAction(StructuredViewer structuredViewer, String text, ImageDescriptor imageDescriptor) {
            super(text, imageDescriptor);
            this.structuredViewer = structuredViewer;
            this.setEnabled(false);
        }

        public void setObjectToSelect(Object objectToSelect) {
            this.setObjectsToSelect(objectToSelect != null ? Collections.singleton(objectToSelect) : Collections.EMPTY_LIST);
        }

        public void setObjectsToSelect(Collection<?> objectsToSelect) {
            this.objectsToSelect = new ArrayList(objectsToSelect);
            this.setEnabled(!objectsToSelect.isEmpty());
        }

        public void run() {
            this.structuredViewer.setSelection((ISelection)new StructuredSelection(this.objectsToSelect.toArray()), true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SelectUseAction
    extends SelectObjectAction {
        boolean isForward;

        public SelectUseAction(boolean isForward, StructuredViewer structuredViewer) {
            super(structuredViewer, isForward ? "Select &Next Use" : "Select &Previous Use", ExtendedImageRegistry.INSTANCE.getImageDescriptor(XSDEditorPlugin.INSTANCE.getImage(isForward ? "full/elcl16/SelectNextUseObject" : "full/elcl16/SelectPreviousUseObject")));
            this.isForward = isForward;
            this.setHoverImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(XSDEditorPlugin.INSTANCE.getImage(isForward ? "full/clcl16/SelectNextUseObject" : "full/clcl16/SelectPreviousUseObject")));
            this.setDisabledImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(XSDEditorPlugin.INSTANCE.getImage(isForward ? "full/dlcl16/SelectNextUseObject" : "full/dlcl16/SelectPreviousUseObject")));
        }

        public void updateAction() {
            this.setCurrentObjects(((IStructuredSelection)this.structuredViewer.getSelection()).toList());
        }

        public void setCurrentObjects(List<?> objects) {
            XSDConcreteComponent resolvedObject;
            XSDConcreteComponent xsdConcreteComponent;
            XSDConcreteComponent result = null;
            ArrayList<XSDConcreteComponent> resolvedObjects = new ArrayList<XSDConcreteComponent>();
            for (Object object : objects) {
                xsdConcreteComponent = (XSDConcreteComponent)object;
                resolvedObject = XSDEditor.getResolvedObject(xsdConcreteComponent);
                if (resolvedObject == this) continue;
                resolvedObjects.add(resolvedObject);
            }
            boolean isStarted = false;
            TreeIterator tree = XSDEditor.this.editingDomain.treeIterator((Object)XSDEditor.this.xsdSchema);
            while (tree.hasNext()) {
                xsdConcreteComponent = (XSDConcreteComponent)tree.next();
                if (!this.isForward && objects.contains(xsdConcreteComponent)) break;
                if (isStarted || !this.isForward) {
                    resolvedObject = XSDEditor.getResolvedObject(xsdConcreteComponent);
                    if (!resolvedObjects.contains(resolvedObject)) continue;
                    if (isStarted) {
                        result = xsdConcreteComponent;
                        break;
                    }
                    result = xsdConcreteComponent;
                    continue;
                }
                if (!objects.contains(xsdConcreteComponent)) continue;
                isStarted = true;
            }
            this.setObjectToSelect(result);
        }
    }
}

