/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.sdo.impl;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.change.impl.ChangeDescriptionImpl;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.sdo.EChangeSummary;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.sdo.InternalEDataObject;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.sdo.util.BasicESequence;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.eclipse.emf.ecore.util.DelegatingFeatureMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EChangeSummaryImpl
extends ChangeDescriptionImpl
implements EChangeSummary,
InternalEDataObject {
    private static final long serialVersionUID = 1L;
    protected static final boolean LOGGING_EDEFAULT = false;
    protected EDataGraph eDataGraph;
    protected ChangeRecorder changeRecorder = null;
    protected EList<EObject> cachedObjectsToDetach = null;
    protected HashMap<DataObject, List<ChangeSummary.Setting>> cachedSDOObjectChanges = new HashMap();
    protected Set<EObject> deletedObjects;

    protected EChangeSummaryImpl() {
    }

    protected EClass eStaticClass() {
        return SDOPackage.Literals.ECHANGE_SUMMARY;
    }

    public boolean isLogging() {
        return this.changeRecorder != null;
    }

    @Override
    public EDataGraph getEDataGraph() {
        return this.eDataGraph;
    }

    public NotificationChain basicSetEDataGraph(EDataGraph newEDataGraph, NotificationChain msgs) {
        EDataGraph oldEDataGraph = this.eDataGraph;
        this.eDataGraph = newEDataGraph;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldEDataGraph, (Object)newEDataGraph);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setEDataGraph(EDataGraph newEDataGraph) {
        if (newEDataGraph != this.eDataGraph) {
            NotificationChain msgs = null;
            if (this.eDataGraph != null) {
                msgs = ((InternalEObject)this.eDataGraph).eInverseRemove((InternalEObject)this, 4, EDataGraph.class, msgs);
            }
            if (newEDataGraph != null) {
                msgs = ((InternalEObject)newEDataGraph).eInverseAdd((InternalEObject)this, 4, EDataGraph.class, msgs);
            }
            if ((msgs = this.basicSetEDataGraph(newEDataGraph, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)newEDataGraph, (Object)newEDataGraph));
        }
    }

    public void beginLogging() {
        if (this.isLogging()) {
            throw new IllegalStateException("Already logging");
        }
        this.getObjectsToAttach().clear();
        this.getObjectChanges().clear();
        this.getResourceChanges().clear();
        this.oldContainmentInformation = null;
        this.changeRecorder = new SDOChangeRecorder();
        this.changeRecorder.beginRecording(Collections.singleton(this.getEDataGraph().getRootResource()));
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, false, true));
        }
    }

    @Override
    public void resumeLogging() {
        if (this.isLogging()) {
            throw new IllegalStateException("Already logging");
        }
        this.oldContainmentInformation = null;
        this.changeRecorder = new SDOChangeRecorder();
        this.changeRecorder.beginRecording((ChangeDescription)this, Collections.singleton(this.getEDataGraph().getRootResource()));
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, false, true));
        }
    }

    public void endLogging() {
        if (!this.isLogging()) {
            throw new IllegalStateException("Not currently logging");
        }
        this.changeRecorder.endRecording();
        this.changeRecorder.dispose();
        this.changeRecorder = null;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, true, false));
        }
    }

    public boolean isCreated(DataObject dataObject) {
        return this.getObjectsToDetach().contains((Object)dataObject);
    }

    public boolean isDeleted(DataObject dataObject) {
        return this.getDeletedObjects().contains(dataObject);
    }

    public List<ChangeSummary.Setting> getOldValues(DataObject dataObject) {
        Object sdoSettings = this.cachedSDOObjectChanges.get(dataObject);
        if (sdoSettings != null) {
            return sdoSettings;
        }
        List settings = (List)this.getObjectChanges().get((Object)dataObject);
        if (settings == null) {
            settings = Collections.emptyList();
        } else {
            int i = 0;
            while (i < settings.size()) {
                FeatureChange change = (FeatureChange)settings.get(i);
                EStructuralFeature feature = change.getFeature();
                if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
                    List values = (List)change.getValue();
                    if (sdoSettings == null) {
                        List asSettings = settings;
                        sdoSettings = new BasicEList(asSettings);
                    }
                    DelegatingFeatureMap featureMap = new DelegatingFeatureMap((InternalEObject)dataObject, feature, values){
                        private static final long serialVersionUID = 1L;
                        protected final List<FeatureMap.Entry> theList;
                        {
                            this.theList = list;
                        }

                        protected List<FeatureMap.Entry> delegateList() {
                            return this.theList;
                        }
                    };
                    sdoSettings.set(i, SDOFactory.eINSTANCE.createEChangeSummarySetting(feature, new BasicESequence((FeatureMap.Internal)featureMap), change.isSet()));
                    int k = 0;
                    while (k < featureMap.size()) {
                        EStructuralFeature f = featureMap.getEStructuralFeature(k);
                        sdoSettings.add(SDOFactory.eINSTANCE.createEChangeSummarySetting(f, featureMap.get(f, false), true));
                        ++k;
                    }
                }
                ++i;
            }
        }
        if (sdoSettings == null) {
            List asSettings = settings;
            sdoSettings = asSettings;
        }
        this.cachedSDOObjectChanges.put(dataObject, (List<ChangeSummary.Setting>)sdoSettings);
        return sdoSettings;
    }

    @Override
    public void summarize() {
        if (!this.isLogging()) {
            throw new IllegalStateException("Not currently logging");
        }
        this.changeRecorder.summarize();
    }

    @Override
    public boolean isChanged(DataObject dataObject) {
        return this.getObjectChanges().containsKey((Object)dataObject) && !this.isDeleted(dataObject) && !this.isCreated(dataObject);
    }

    @Override
    public ChangeSummary.Setting getOldValue(DataObject dataObject, Property property) {
        for (ChangeSummary.Setting setting : this.getOldValues(dataObject)) {
            if (setting.getProperty() != property) continue;
            return setting;
        }
        return null;
    }

    @Override
    public DataObject getOldContainer(DataObject dataObject) {
        return (DataObject)this.getOldContainer((EObject)dataObject);
    }

    @Override
    public Property getOldContainmentProperty(DataObject dataObject) {
        return SDOUtil.adaptProperty((EStructuralFeature)this.getOldContainmentFeature((EObject)dataObject));
    }

    public EList<EObject> getObjectsToDetach() {
        if (this.cachedObjectsToDetach == null) {
            this.cachedObjectsToDetach = super.getObjectsToDetach();
        }
        return this.cachedObjectsToDetach;
    }

    public Object get(String path) {
        return SDOUtil.get((EObject)this, path);
    }

    public void set(String path, Object value) {
        SDOUtil.set((EObject)this, path, value);
    }

    public boolean isSet(String path) {
        return SDOUtil.isSet((EObject)this, path);
    }

    public void unset(String path) {
        SDOUtil.unset((EObject)this, path);
    }

    public Object get(int propertyIndex) {
        return SDOUtil.get((EObject)this, propertyIndex);
    }

    public void set(int propertyIndex, Object value) {
        SDOUtil.set((EObject)this, propertyIndex, value);
    }

    public boolean isSet(int propertyIndex) {
        return SDOUtil.isSet((EObject)this, propertyIndex);
    }

    public void unset(int propertyIndex) {
        SDOUtil.unset((EObject)this, propertyIndex);
    }

    public Object get(Property property) {
        return SDOUtil.get((EObject)this, property);
    }

    public void set(Property property, Object value) {
        SDOUtil.set((EObject)this, property, value);
    }

    public boolean isSet(Property property) {
        return SDOUtil.isSet((EObject)this, property);
    }

    public void unset(Property property) {
        SDOUtil.unset((EObject)this, property);
    }

    public DataObject getContainer() {
        return SDOUtil.getContainer(this);
    }

    public Property getContainmentProperty() {
        return SDOUtil.getContainmentProperty(this);
    }

    public DataGraph getDataGraph() {
        return this.getEDataGraph();
    }

    protected void preApply(boolean reverse) {
        super.preApply(reverse);
        this.deletedObjects = null;
    }

    protected Set<EObject> getDeletedObjects() {
        if (this.deletedObjects == null) {
            this.deletedObjects = new HashSet<EObject>();
            TreeIterator i = EcoreUtil.getAllContents((Collection)this.getObjectsToAttach());
            while (i.hasNext()) {
                this.deletedObjects.add((EObject)i.next());
            }
        }
        return this.deletedObjects;
    }

    public EList<DataObject> getChangedDataObjectsGen() {
        UniqueEList.FastCompare result = new UniqueEList.FastCompare(this.getDeletedObjects());
        result.addAll(this.getObjectsToDetach());
        for (Map.Entry entry : this.getObjectChanges()) {
            result.add((Object)((EObject)entry.getKey()));
        }
        UniqueEList.FastCompare asDataObjects = result;
        return asDataObjects;
    }

    public List<DataObject> getChangedDataObjects() {
        return this.getChangedDataObjectsGen();
    }

    public Type getType() {
        return SDOUtil.getType(this);
    }

    public BigDecimal getBigDecimal(String path) {
        return SDOUtil.getBigDecimal((EObject)this, path);
    }

    public BigInteger getBigInteger(String path) {
        return SDOUtil.getBigInteger((EObject)this, path);
    }

    public boolean getBoolean(String path) {
        return SDOUtil.getBoolean((EObject)this, path);
    }

    public byte getByte(String path) {
        return SDOUtil.getByte((EObject)this, path);
    }

    public byte[] getBytes(String path) {
        return SDOUtil.getBytes((EObject)this, path);
    }

    public char getChar(String path) {
        return SDOUtil.getChar((EObject)this, path);
    }

    public DataObject getDataObject(String path) {
        return SDOUtil.getDataObject((EObject)this, path);
    }

    public Date getDate(String path) {
        return SDOUtil.getDate((EObject)this, path);
    }

    public double getDouble(String path) {
        return SDOUtil.getDouble((EObject)this, path);
    }

    public float getFloat(String path) {
        return SDOUtil.getFloat((EObject)this, path);
    }

    public int getInt(String path) {
        return SDOUtil.getInt((EObject)this, path);
    }

    public List getList(String path) {
        return SDOUtil.getList((EObject)this, path);
    }

    public long getLong(String path) {
        return SDOUtil.getLong((EObject)this, path);
    }

    public Sequence getSequence(String path) {
        return SDOUtil.getSequence((EObject)this, path);
    }

    public short getShort(String path) {
        return SDOUtil.getShort((EObject)this, path);
    }

    public String getString(String path) {
        return SDOUtil.getString((EObject)this, path);
    }

    public void setBigDecimal(String path, BigDecimal value) {
        SDOUtil.setBigDecimal((EObject)this, path, value);
    }

    public void setBigInteger(String path, BigInteger value) {
        SDOUtil.setBigInteger((EObject)this, path, value);
    }

    public void setBoolean(String path, boolean value) {
        SDOUtil.setBoolean((EObject)this, path, value);
    }

    public void setByte(String path, byte value) {
        SDOUtil.setByte((EObject)this, path, value);
    }

    public void setBytes(String path, byte[] value) {
        SDOUtil.setBytes((EObject)this, path, value);
    }

    public void setChar(String path, char value) {
        SDOUtil.setChar((EObject)this, path, value);
    }

    public void setDataObject(String path, DataObject value) {
        SDOUtil.setDataObject((EObject)this, path, value);
    }

    public void setDate(String path, Date value) {
        SDOUtil.setDate((EObject)this, path, value);
    }

    public void setDouble(String path, double value) {
        SDOUtil.setDouble((EObject)this, path, value);
    }

    public void setFloat(String path, float value) {
        SDOUtil.setFloat((EObject)this, path, value);
    }

    public void setInt(String path, int value) {
        SDOUtil.setInt((EObject)this, path, value);
    }

    public void setList(String path, List value) {
        SDOUtil.setList((EObject)this, path, value);
    }

    public void setLong(String path, long value) {
        SDOUtil.setLong((EObject)this, path, value);
    }

    public void setShort(String path, short value) {
        SDOUtil.setShort((EObject)this, path, value);
    }

    public void setString(String path, String value) {
        SDOUtil.setString((EObject)this, path, value);
    }

    public BigDecimal getBigDecimal(int propertyIndex) {
        return SDOUtil.getBigDecimal((EObject)this, propertyIndex);
    }

    public BigInteger getBigInteger(int propertyIndex) {
        return SDOUtil.getBigInteger((EObject)this, propertyIndex);
    }

    public boolean getBoolean(int propertyIndex) {
        return SDOUtil.getBoolean((EObject)this, propertyIndex);
    }

    public byte getByte(int propertyIndex) {
        return SDOUtil.getByte((EObject)this, propertyIndex);
    }

    public byte[] getBytes(int propertyIndex) {
        return SDOUtil.getBytes((EObject)this, propertyIndex);
    }

    public char getChar(int propertyIndex) {
        return SDOUtil.getChar((EObject)this, propertyIndex);
    }

    public DataObject getDataObject(int propertyIndex) {
        return SDOUtil.getDataObject((EObject)this, propertyIndex);
    }

    public Date getDate(int propertyIndex) {
        return SDOUtil.getDate((EObject)this, propertyIndex);
    }

    public double getDouble(int propertyIndex) {
        return SDOUtil.getDouble((EObject)this, propertyIndex);
    }

    public float getFloat(int propertyIndex) {
        return SDOUtil.getFloat((EObject)this, propertyIndex);
    }

    public int getInt(int propertyIndex) {
        return SDOUtil.getInt((EObject)this, propertyIndex);
    }

    public List getList(int propertyIndex) {
        return SDOUtil.getList((EObject)this, propertyIndex);
    }

    public long getLong(int propertyIndex) {
        return SDOUtil.getLong((EObject)this, propertyIndex);
    }

    public Sequence getSequence(int propertyIndex) {
        return SDOUtil.getSequence((EObject)this, propertyIndex);
    }

    public short getShort(int propertyIndex) {
        return SDOUtil.getShort((EObject)this, propertyIndex);
    }

    public String getString(int propertyIndex) {
        return SDOUtil.getString((EObject)this, propertyIndex);
    }

    public void setBigDecimal(int propertyIndex, BigDecimal value) {
        SDOUtil.setBigDecimal((EObject)this, propertyIndex, value);
    }

    public void setBigInteger(int propertyIndex, BigInteger value) {
        SDOUtil.setBigInteger((EObject)this, propertyIndex, value);
    }

    public void setBoolean(int propertyIndex, boolean value) {
        SDOUtil.setBoolean((EObject)this, propertyIndex, value);
    }

    public void setByte(int propertyIndex, byte value) {
        SDOUtil.setByte((EObject)this, propertyIndex, value);
    }

    public void setBytes(int propertyIndex, byte[] value) {
        SDOUtil.setBytes((EObject)this, propertyIndex, value);
    }

    public void setChar(int propertyIndex, char value) {
        SDOUtil.setChar((EObject)this, propertyIndex, value);
    }

    public void setDataObject(int propertyIndex, DataObject value) {
        SDOUtil.setDataObject((EObject)this, propertyIndex, value);
    }

    public void setDate(int propertyIndex, Date value) {
        SDOUtil.setDate((EObject)this, propertyIndex, value);
    }

    public void setDouble(int propertyIndex, double value) {
        SDOUtil.setDouble((EObject)this, propertyIndex, value);
    }

    public void setFloat(int propertyIndex, float value) {
        SDOUtil.setFloat((EObject)this, propertyIndex, value);
    }

    public void setInt(int propertyIndex, int value) {
        SDOUtil.setInt((EObject)this, propertyIndex, value);
    }

    public void setList(int propertyIndex, List value) {
        SDOUtil.setList((EObject)this, propertyIndex, value);
    }

    public void setLong(int propertyIndex, long value) {
        SDOUtil.setLong((EObject)this, propertyIndex, value);
    }

    public void setShort(int propertyIndex, short value) {
        SDOUtil.setShort((EObject)this, propertyIndex, value);
    }

    public void setString(int propertyIndex, String value) {
        SDOUtil.setString((EObject)this, propertyIndex, value);
    }

    public BigDecimal getBigDecimal(Property property) {
        return SDOUtil.getBigDecimal((EObject)this, property);
    }

    public BigInteger getBigInteger(Property property) {
        return SDOUtil.getBigInteger((EObject)this, property);
    }

    public boolean getBoolean(Property property) {
        return SDOUtil.getBoolean((EObject)this, property);
    }

    public byte getByte(Property property) {
        return SDOUtil.getByte((EObject)this, property);
    }

    public byte[] getBytes(Property property) {
        return SDOUtil.getBytes((EObject)this, property);
    }

    public char getChar(Property property) {
        return SDOUtil.getChar((EObject)this, property);
    }

    public DataObject getDataObject(Property property) {
        return SDOUtil.getDataObject((EObject)this, property);
    }

    public Date getDate(Property property) {
        return SDOUtil.getDate((EObject)this, property);
    }

    public double getDouble(Property property) {
        return SDOUtil.getDouble((EObject)this, property);
    }

    public float getFloat(Property property) {
        return SDOUtil.getFloat((EObject)this, property);
    }

    public int getInt(Property property) {
        return SDOUtil.getInt((EObject)this, property);
    }

    public List getList(Property property) {
        return SDOUtil.getList((EObject)this, property);
    }

    public long getLong(Property property) {
        return SDOUtil.getLong((EObject)this, property);
    }

    public Sequence getSequence(Property property) {
        return SDOUtil.getSequence((EObject)this, property);
    }

    public short getShort(Property property) {
        return SDOUtil.getShort((EObject)this, property);
    }

    public String getString(Property property) {
        return SDOUtil.getString((EObject)this, property);
    }

    public void setBigDecimal(Property property, BigDecimal value) {
        SDOUtil.setBigDecimal((EObject)this, property, value);
    }

    public void setBigInteger(Property property, BigInteger value) {
        SDOUtil.setBigInteger((EObject)this, property, value);
    }

    public void setBoolean(Property property, boolean value) {
        SDOUtil.setBoolean((EObject)this, property, value);
    }

    public void setByte(Property property, byte value) {
        SDOUtil.setByte((EObject)this, property, value);
    }

    public void setBytes(Property property, byte[] value) {
        SDOUtil.setBytes((EObject)this, property, value);
    }

    public void setChar(Property property, char value) {
        SDOUtil.setChar((EObject)this, property, value);
    }

    public void setDataObject(Property property, DataObject value) {
        SDOUtil.setDataObject((EObject)this, property, value);
    }

    public void setDate(Property property, Date value) {
        SDOUtil.setDate((EObject)this, property, value);
    }

    public void setDouble(Property property, double value) {
        SDOUtil.setDouble((EObject)this, property, value);
    }

    public void setFloat(Property property, float value) {
        SDOUtil.setFloat((EObject)this, property, value);
    }

    public void setInt(Property property, int value) {
        SDOUtil.setInt((EObject)this, property, value);
    }

    public void setList(Property property, List value) {
        SDOUtil.setList((EObject)this, property, value);
    }

    public void setLong(Property property, long value) {
        SDOUtil.setLong((EObject)this, property, value);
    }

    public void setShort(Property property, short value) {
        SDOUtil.setShort((EObject)this, property, value);
    }

    public void setString(Property property, String value) {
        SDOUtil.setString((EObject)this, property, value);
    }

    public DataObject createDataObject(String propertyName) {
        return SDOUtil.createDataObject((EObject)this, propertyName);
    }

    public DataObject createDataObject(int propertyIndex) {
        return SDOUtil.createDataObject((EObject)this, propertyIndex);
    }

    public DataObject createDataObject(Property property) {
        return SDOUtil.createDataObject((EObject)this, property);
    }

    public DataObject createDataObject(String propertyName, String namespaceURI, String typeName) {
        return SDOUtil.createDataObject((EObject)this, propertyName, namespaceURI, typeName);
    }

    public DataObject createDataObject(int propertyIndex, String namespaceURI, String typeName) {
        return SDOUtil.createDataObject((EObject)this, propertyIndex, namespaceURI, typeName);
    }

    public DataObject createDataObject(Property property, Type type) {
        return SDOUtil.createDataObject((EObject)this, property, type);
    }

    public void delete() {
        SDOUtil.delete(this);
    }

    @Override
    public List<Property> getInstanceProperties() {
        return SDOUtil.getInstanceProperties(this);
    }

    @Override
    public Object writeReplace() throws ObjectStreamException {
        return SDOUtil.writeReplace(this);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                if (this.eDataGraph != null) {
                    msgs = ((InternalEObject)this.eDataGraph).eInverseRemove((InternalEObject)this, 4, EDataGraph.class, msgs);
                }
                return this.basicSetEDataGraph((EDataGraph)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return this.basicSetEDataGraph(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 4: {
                return this.isLogging() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return this.getDataGraph();
            }
            case 6: {
                return this.getChangedDataObjects();
            }
            case 7: {
                return this.getEDataGraph();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.setEDataGraph((EDataGraph)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.setEDataGraph(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 4: {
                return this.isLogging();
            }
            case 5: {
                return this.getDataGraph() != null;
            }
            case 6: {
                return !this.getChangedDataObjects().isEmpty();
            }
            case 7: {
                return this.eDataGraph != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == ChangeSummary.class) {
            switch (derivedFeatureID) {
                case 4: {
                    return 0;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == ChangeSummary.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 4;
                }
                case 1: {
                    return 5;
                }
                case 2: {
                    return 6;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SDOChangeRecorder
    extends ChangeRecorder {
        public void beginRecording(ChangeDescription changeDescription, Collection<?> rootObjects) {
            EChangeSummaryImpl.this.deletedObjects = null;
            EChangeSummaryImpl.this.cachedObjectsToDetach = null;
            EChangeSummaryImpl.this.cachedSDOObjectChanges.clear();
            super.beginRecording(changeDescription, rootObjects);
        }

        protected ChangeDescription createChangeDescription() {
            return EChangeSummaryImpl.this;
        }

        protected FeatureChange createFeatureChange(EObject eObject, EStructuralFeature eStructuralFeature, Object value, boolean isSet) {
            EProperty eProperty = SDOUtil.adaptProperty(eStructuralFeature);
            if (eProperty.isReadOnly() && SDOUtil.getDataGraph(eObject) != null) {
                throw new IllegalStateException("The property '" + eProperty.getName() + "' of type '" + SDOUtil.adaptType((EClassifier)eStructuralFeature.getEContainingClass()).getName() + "' is read only");
            }
            return SDOFactory.eINSTANCE.createEChangeSummarySetting(eStructuralFeature, value, isSet);
        }

        protected void consolidateChanges() {
            EChangeSummaryImpl.this.deletedObjects = null;
            EChangeSummaryImpl.this.cachedObjectsToDetach = null;
            EChangeSummaryImpl.this.cachedSDOObjectChanges.clear();
            super.consolidateChanges();
        }
    }
}

