/**
 * <copyright>
 *
 * Copyright (c) 2003-2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: SDOPackageImpl.java,v 1.19 2008/04/27 20:31:14 davidms Exp $
 */
package org.eclipse.emf.ecore.sdo.impl;


import java.io.ObjectStreamException;
import java.io.Serializable;

import java.util.List;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.change.ChangePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.sdo.EChangeSummary;
import org.eclipse.emf.ecore.sdo.EChangeSummarySetting;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.sdo.EDataObjectAnyType;
import org.eclipse.emf.ecore.sdo.EDataObjectSimpleAnyType;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.sdo.EType;
import org.eclipse.emf.ecore.sdo.InternalEDataObject;
import org.eclipse.emf.ecore.sdo.SDOFactory;
import org.eclipse.emf.ecore.sdo.SDOPackage;
import org.eclipse.emf.ecore.sdo.util.ESequence;

import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;


/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class SDOPackageImpl extends EPackageImpl implements SDOPackage
{
  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eDataObjectEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eDataGraphEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eChangeSummaryEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass ePropertyEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass dataObjectEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eSequenceEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass dataGraphEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass changeSummaryEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eTypeEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass typeEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass propertyEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass sequenceEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eChangeSummarySettingEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass internalEDataObjectEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eDataObjectAnyTypeEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eDataObjectSimpleAnyTypeEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass eJavaSerializableEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EClass changeSummarySettingEClass = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EDataType eJavaListEDataType = null;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private EDataType eObjectStreamExceptionEDataType = null;

  /**
   * Creates an instance of the model <b>Package</b>, registered with
   * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
   * package URI value.
   * <p>Note: the correct way to create the package is via the static
   * factory method {@link #init init()}, which also performs
   * initialization of the package, or returns the registered package,
   * if one already exists.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.eclipse.emf.ecore.EPackage.Registry
   * @see org.eclipse.emf.ecore.sdo.SDOPackage#eNS_URI
   * @see #init()
   * @generated
   */
  private SDOPackageImpl()
  {
    super(eNS_URI, SDOFactory.eINSTANCE);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private static boolean isInited = false;

  /**
   * Creates, registers, and initializes the <b>Package</b> for this
   * model, and for any others upon which it depends.  Simple
   * dependencies are satisfied by calling this method on all
   * dependent packages before doing anything else.  This method drives
   * initialization for interdependent packages directly, in parallel
   * with this package, itself.
   * <p>Of this package and its interdependencies, all packages which
   * have not yet been registered by their URI values are first created
   * and registered.  The packages are then initialized in two steps:
   * meta-model objects for all of the packages are created before any
   * are initialized, since one package's meta-model objects may refer to
   * those of another.
   * <p>Invocation of this method will not affect any packages that have
   * already been initialized.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #eNS_URI
   * @see #createPackageContents()
   * @see #initializePackageContents()
   * @generated
   */
  public static SDOPackage init()
  {
    if (isInited) return (SDOPackage)EPackage.Registry.INSTANCE.getEPackage(SDOPackage.eNS_URI);

    // Obtain or create and register package
    SDOPackageImpl theSDOPackage = (SDOPackageImpl)(EPackage.Registry.INSTANCE.getEPackage(eNS_URI) instanceof SDOPackageImpl ? EPackage.Registry.INSTANCE.getEPackage(eNS_URI) : new SDOPackageImpl());

    isInited = true;

    // Initialize simple dependencies
    XMLTypePackage.eINSTANCE.eClass();
    ChangePackage.eINSTANCE.eClass();

    // Create package meta-data objects
    theSDOPackage.createPackageContents();

    // Initialize created meta-data
    theSDOPackage.initializePackageContents();

    // Mark meta-data to indicate it can't be changed
    theSDOPackage.freeze();

    return theSDOPackage;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEDataObject()
  {
    return eDataObjectEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEDataGraph()
  {
    return eDataGraphEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getEDataGraph_ResourceSet()
  {
    return (EAttribute)eDataGraphEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getEDataGraph_RootResource()
  {
    return (EAttribute)eDataGraphEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getEDataGraph_EChangeSummary()
  {
    return (EReference)eDataGraphEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getEDataGraph_ERootObject()
  {
    return (EReference)eDataGraphEClass.getEStructuralFeatures().get(3);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEChangeSummary()
  {
    return eChangeSummaryEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getEChangeSummary_EDataGraph()
  {
    return (EReference)eChangeSummaryEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEProperty()
  {
    return ePropertyEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getEProperty_EStructuralFeature()
  {
    return (EReference)ePropertyEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getDataObject()
  {
    return dataObjectEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getESequence()
  {
    return eSequenceEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getDataGraph()
  {
    return dataGraphEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getDataGraph_RootObject()
  {
    return (EReference)dataGraphEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getDataGraph_ChangeSummary()
  {
    return (EReference)dataGraphEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getChangeSummary()
  {
    return changeSummaryEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getChangeSummary_Logging()
  {
    return (EAttribute)changeSummaryEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getChangeSummary_DataGraph()
  {
    return (EReference)changeSummaryEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getChangeSummary_ChangedDataObjects()
  {
    return (EReference)changeSummaryEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEType()
  {
    return eTypeEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getEType_EClassifier()
  {
    return (EReference)eTypeEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getType()
  {
    return typeEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getType_Name()
  {
    return (EAttribute)typeEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getType_URI()
  {
    return (EAttribute)typeEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getType_InstanceClass()
  {
    return (EAttribute)typeEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getType_Properties()
  {
    return (EReference)typeEClass.getEStructuralFeatures().get(3);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getProperty()
  {
    return propertyEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getProperty_Name()
  {
    return (EAttribute)propertyEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getProperty_Many()
  {
    return (EAttribute)propertyEClass.getEStructuralFeatures().get(1);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getProperty_Containment()
  {
    return (EAttribute)propertyEClass.getEStructuralFeatures().get(2);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EAttribute getProperty_Default()
  {
    return (EAttribute)propertyEClass.getEStructuralFeatures().get(3);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getProperty_Type()
  {
    return (EReference)propertyEClass.getEStructuralFeatures().get(4);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getProperty_ContainingType()
  {
    return (EReference)propertyEClass.getEStructuralFeatures().get(5);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getSequence()
  {
    return sequenceEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEChangeSummarySetting()
  {
    return eChangeSummarySettingEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getInternalEDataObject()
  {
    return internalEDataObjectEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEDataObjectAnyType()
  {
    return eDataObjectAnyTypeEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEDataObjectSimpleAnyType()
  {
    return eDataObjectSimpleAnyTypeEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getEJavaSerializable()
  {
    return eJavaSerializableEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EClass getChangeSummarySetting()
  {
    return changeSummarySettingEClass;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EReference getChangeSummarySetting_Property()
  {
    return (EReference)changeSummarySettingEClass.getEStructuralFeatures().get(0);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EDataType getEJavaList()
  {
    return eJavaListEDataType;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EDataType getEObjectStreamException()
  {
    return eObjectStreamExceptionEDataType;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public SDOFactory getSDOFactory()
  {
    return (SDOFactory)getEFactoryInstance();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private boolean isCreated = false;

  /**
   * Creates the meta-model objects for the package.  This method is
   * guarded to have no affect on any invocation but its first.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void createPackageContents()
  {
    if (isCreated) return;
    isCreated = true;

    // Create classes and their features
    eChangeSummaryEClass = createEClass(ECHANGE_SUMMARY);
    createEReference(eChangeSummaryEClass, ECHANGE_SUMMARY__EDATA_GRAPH);

    eChangeSummarySettingEClass = createEClass(ECHANGE_SUMMARY_SETTING);

    eDataGraphEClass = createEClass(EDATA_GRAPH);
    createEAttribute(eDataGraphEClass, EDATA_GRAPH__RESOURCE_SET);
    createEAttribute(eDataGraphEClass, EDATA_GRAPH__ROOT_RESOURCE);
    createEReference(eDataGraphEClass, EDATA_GRAPH__ECHANGE_SUMMARY);
    createEReference(eDataGraphEClass, EDATA_GRAPH__EROOT_OBJECT);

    eDataObjectEClass = createEClass(EDATA_OBJECT);

    ePropertyEClass = createEClass(EPROPERTY);
    createEReference(ePropertyEClass, EPROPERTY__ESTRUCTURAL_FEATURE);

    changeSummaryEClass = createEClass(CHANGE_SUMMARY);
    createEAttribute(changeSummaryEClass, CHANGE_SUMMARY__LOGGING);
    createEReference(changeSummaryEClass, CHANGE_SUMMARY__DATA_GRAPH);
    createEReference(changeSummaryEClass, CHANGE_SUMMARY__CHANGED_DATA_OBJECTS);

    changeSummarySettingEClass = createEClass(CHANGE_SUMMARY_SETTING);
    createEReference(changeSummarySettingEClass, CHANGE_SUMMARY_SETTING__PROPERTY);

    dataGraphEClass = createEClass(DATA_GRAPH);
    createEReference(dataGraphEClass, DATA_GRAPH__ROOT_OBJECT);
    createEReference(dataGraphEClass, DATA_GRAPH__CHANGE_SUMMARY);

    dataObjectEClass = createEClass(DATA_OBJECT);

    eSequenceEClass = createEClass(ESEQUENCE);

    eTypeEClass = createEClass(ETYPE);
    createEReference(eTypeEClass, ETYPE__ECLASSIFIER);

    propertyEClass = createEClass(PROPERTY);
    createEAttribute(propertyEClass, PROPERTY__NAME);
    createEAttribute(propertyEClass, PROPERTY__MANY);
    createEAttribute(propertyEClass, PROPERTY__CONTAINMENT);
    createEAttribute(propertyEClass, PROPERTY__DEFAULT);
    createEReference(propertyEClass, PROPERTY__TYPE);
    createEReference(propertyEClass, PROPERTY__CONTAINING_TYPE);

    sequenceEClass = createEClass(SEQUENCE);

    typeEClass = createEClass(TYPE);
    createEAttribute(typeEClass, TYPE__NAME);
    createEAttribute(typeEClass, TYPE__URI);
    createEAttribute(typeEClass, TYPE__INSTANCE_CLASS);
    createEReference(typeEClass, TYPE__PROPERTIES);

    internalEDataObjectEClass = createEClass(INTERNAL_EDATA_OBJECT);

    eDataObjectAnyTypeEClass = createEClass(EDATA_OBJECT_ANY_TYPE);

    eDataObjectSimpleAnyTypeEClass = createEClass(EDATA_OBJECT_SIMPLE_ANY_TYPE);

    eJavaSerializableEClass = createEClass(EJAVA_SERIALIZABLE);

    // Create data types
    eJavaListEDataType = createEDataType(EJAVA_LIST);
    eObjectStreamExceptionEDataType = createEDataType(EOBJECT_STREAM_EXCEPTION);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private boolean isInitialized = false;

  /**
   * Complete the initialization of the package and its meta-model.  This
   * method is guarded to have no affect on any invocation but its first.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void initializePackageContents()
  {
    if (isInitialized) return;
    isInitialized = true;

    // Initialize package
    setName(eNAME);
    setNsPrefix(eNS_PREFIX);
    setNsURI(eNS_URI);

    // Obtain other dependent packages
    ChangePackage theChangePackage = (ChangePackage)EPackage.Registry.INSTANCE.getEPackage(ChangePackage.eNS_URI);
    EcorePackage theEcorePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage(EcorePackage.eNS_URI);
    XMLTypePackage theXMLTypePackage = (XMLTypePackage)EPackage.Registry.INSTANCE.getEPackage(XMLTypePackage.eNS_URI);

    // Create type parameters
    addETypeParameter(eJavaListEDataType, "T");

    // Set bounds for type parameters

    // Add supertypes to classes
    eChangeSummaryEClass.getESuperTypes().add(theChangePackage.getChangeDescription());
    eChangeSummaryEClass.getESuperTypes().add(this.getChangeSummary());
    eChangeSummarySettingEClass.getESuperTypes().add(theChangePackage.getFeatureChange());
    eChangeSummarySettingEClass.getESuperTypes().add(this.getChangeSummarySetting());
    eDataGraphEClass.getESuperTypes().add(this.getDataGraph());
    eDataObjectEClass.getESuperTypes().add(theEcorePackage.getEObject());
    eDataObjectEClass.getESuperTypes().add(this.getDataObject());
    ePropertyEClass.getESuperTypes().add(this.getProperty());
    dataGraphEClass.getESuperTypes().add(this.getEJavaSerializable());
    dataObjectEClass.getESuperTypes().add(this.getEJavaSerializable());
    eSequenceEClass.getESuperTypes().add(this.getSequence());
    eTypeEClass.getESuperTypes().add(this.getType());
    internalEDataObjectEClass.getESuperTypes().add(this.getEDataObject());
    eDataObjectAnyTypeEClass.getESuperTypes().add(theXMLTypePackage.getAnyType());
    eDataObjectAnyTypeEClass.getESuperTypes().add(this.getEDataObject());
    eDataObjectSimpleAnyTypeEClass.getESuperTypes().add(theXMLTypePackage.getSimpleAnyType());
    eDataObjectSimpleAnyTypeEClass.getESuperTypes().add(this.getEDataObjectAnyType());

    // Initialize classes and features; add operations and parameters
    initEClass(eChangeSummaryEClass, EChangeSummary.class, "EChangeSummary", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getEChangeSummary_EDataGraph(), this.getEDataGraph(), this.getEDataGraph_EChangeSummary(), "eDataGraph", null, 1, 1, EChangeSummary.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    addEOperation(eChangeSummaryEClass, null, "summarize", 0, 1, IS_UNIQUE, IS_ORDERED);

    addEOperation(eChangeSummaryEClass, null, "resumeLogging", 0, 1, IS_UNIQUE, IS_ORDERED);

    initEClass(eChangeSummarySettingEClass, EChangeSummarySetting.class, "EChangeSummarySetting", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

    initEClass(eDataGraphEClass, EDataGraph.class, "EDataGraph", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getEDataGraph_ResourceSet(), theEcorePackage.getEResourceSet(), "resourceSet", null, 0, 1, EDataGraph.class, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getEDataGraph_RootResource(), theEcorePackage.getEResource(), "rootResource", null, 0, 1, EDataGraph.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getEDataGraph_EChangeSummary(), this.getEChangeSummary(), this.getEChangeSummary_EDataGraph(), "eChangeSummary", null, 1, 1, EDataGraph.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getEDataGraph_ERootObject(), theEcorePackage.getEObject(), null, "eRootObject", null, 1, 1, EDataGraph.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    EOperation op = addEOperation(eDataGraphEClass, theEcorePackage.getEClassifier(), "getEClassifier", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "namespaceURI", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "typeName", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(eDataGraphEClass, theEcorePackage.getEObject(), "createEObject", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEClass(), "type", 0, 1, IS_UNIQUE, IS_ORDERED);

    initEClass(eDataObjectEClass, EDataObject.class, "EDataObject", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

    op = addEOperation(eDataObjectEClass, null, "getInstanceProperties", 0, 1, IS_UNIQUE, IS_ORDERED);
    EGenericType g1 = createEGenericType(this.getEJavaList());
    EGenericType g2 = createEGenericType(this.getProperty());
    g1.getETypeArguments().add(g2);
    initEOperation(op, g1);

    initEClass(ePropertyEClass, EProperty.class, "EProperty", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getEProperty_EStructuralFeature(), theEcorePackage.getEStructuralFeature(), null, "eStructuralFeature", null, 1, 1, EProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(changeSummaryEClass, ChangeSummary.class, "ChangeSummary", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getChangeSummary_Logging(), ecorePackage.getEBoolean(), "logging", null, 0, 1, ChangeSummary.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getChangeSummary_DataGraph(), this.getDataGraph(), this.getDataGraph_ChangeSummary(), "dataGraph", null, 1, 1, ChangeSummary.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getChangeSummary_ChangedDataObjects(), this.getDataObject(), null, "changedDataObjects", null, 0, -1, ChangeSummary.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    addEOperation(changeSummaryEClass, null, "beginLogging", 0, 1, IS_UNIQUE, IS_ORDERED);

    addEOperation(changeSummaryEClass, null, "endLogging", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(changeSummaryEClass, ecorePackage.getEBoolean(), "isCreated", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getDataObject(), "dataObject", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(changeSummaryEClass, ecorePackage.getEBoolean(), "isDeleted", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getDataObject(), "dataObject", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(changeSummaryEClass, this.getEJavaList(), "getOldValues", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getDataObject(), "dataObject", 0, 1, IS_UNIQUE, IS_ORDERED);

    initEClass(changeSummarySettingEClass, ChangeSummary.Setting.class, "ChangeSummarySetting", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);
    initEReference(getChangeSummarySetting_Property(), this.getProperty(), null, "property", null, 1, 1, ChangeSummary.Setting.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    addEOperation(changeSummarySettingEClass, ecorePackage.getEBoolean(), "isSet", 0, 1, IS_UNIQUE, IS_ORDERED);

    addEOperation(changeSummarySettingEClass, theEcorePackage.getEJavaObject(), "getValue", 0, 1, IS_UNIQUE, IS_ORDERED);

    initEClass(dataGraphEClass, DataGraph.class, "DataGraph", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);
    initEReference(getDataGraph_RootObject(), this.getDataObject(), null, "rootObject", null, 1, 1, DataGraph.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getDataGraph_ChangeSummary(), this.getChangeSummary(), this.getChangeSummary_DataGraph(), "changeSummary", null, 1, 1, DataGraph.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    op = addEOperation(dataGraphEClass, this.getDataObject(), "createRootObject", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "namespaceURI", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "typeName", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataGraphEClass, this.getDataObject(), "createRootObject", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getType(), "type", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataGraphEClass, this.getType(), "getType", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "namespaceURI", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "typeName", 0, 1, IS_UNIQUE, IS_ORDERED);

    initEClass(dataObjectEClass, DataObject.class, "DataObject", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEJavaObject(), "get", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "set", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEJavaObject(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEBoolean(), "isSet", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "unset", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEJavaObject(), "get", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "set", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEJavaObject(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEBoolean(), "isSet", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "unset", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEJavaObject(), "get", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "set", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEJavaObject(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEBoolean(), "isSet", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "unset", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    addEOperation(dataObjectEClass, this.getDataObject(), "getContainer", 0, 1, IS_UNIQUE, IS_ORDERED);

    addEOperation(dataObjectEClass, this.getProperty(), "getContainmentProperty", 0, 1, IS_UNIQUE, IS_ORDERED);

    addEOperation(dataObjectEClass, this.getDataGraph(), "getDataGraph", 0, 1, IS_UNIQUE, IS_ORDERED);

    addEOperation(dataObjectEClass, this.getType(), "getType", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEBigDecimal(), "getBigDecimal", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEBigInteger(), "getBigInteger", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEBoolean(), "getBoolean", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEByte(), "getByte", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEByteArray(), "getBytes", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEChar(), "getChar", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, this.getDataObject(), "getDataObject", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEDate(), "getDate", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEDouble(), "getDouble", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEFloat(), "getFloat", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEInt(), "getInt", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, this.getEJavaList(), "getList", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getELong(), "getLong", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, this.getSequence(), "getSequence", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEShort(), "getShort", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEString(), "getString", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setBigDecimal", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEBigDecimal(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setBigInteger", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEBigInteger(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setBoolean", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEBoolean(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setByte", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEByte(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setBytes", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEByteArray(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setChar", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEChar(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setDataObject", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getDataObject(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setDate", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEDate(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setDouble", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEDouble(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setFloat", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEFloat(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setInt", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setList", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getEJavaList(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setLong", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getELong(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setShort", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEShort(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setString", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "path", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEBigDecimal(), "getBigDecimal", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEBigInteger(), "getBigInteger", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEBoolean(), "getBoolean", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEByte(), "getByte", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEByteArray(), "getBytes", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEChar(), "getChar", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, this.getDataObject(), "getDataObject", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEDate(), "getDate", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEDouble(), "getDouble", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEFloat(), "getFloat", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEInt(), "getInt", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, this.getEJavaList(), "getList", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getELong(), "getLong", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, this.getSequence(), "getSequence", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEShort(), "getShort", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEString(), "getString", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setBigDecimal", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEBigDecimal(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setBigInteger", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEBigInteger(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setBoolean", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEBoolean(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setByte", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEByte(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setBytes", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEByteArray(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setChar", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEChar(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setDataObject", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getDataObject(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setDate", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEDate(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setDouble", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEDouble(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setFloat", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEFloat(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setInt", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setList", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getEJavaList(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setLong", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getELong(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setShort", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEShort(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setString", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEBigDecimal(), "getBigDecimal", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEBigInteger(), "getBigInteger", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEBoolean(), "getBoolean", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEByte(), "getByte", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEByteArray(), "getBytes", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEChar(), "getChar", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, this.getDataObject(), "getDataObject", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, theEcorePackage.getEDate(), "getDate", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEDouble(), "getDouble", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEFloat(), "getFloat", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEInt(), "getInt", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, this.getEJavaList(), "getList", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getELong(), "getLong", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, this.getSequence(), "getSequence", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEShort(), "getShort", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, ecorePackage.getEString(), "getString", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setBigDecimal", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEBigDecimal(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setBigInteger", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEBigInteger(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setBoolean", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEBoolean(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setByte", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEByte(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setBytes", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEByteArray(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setChar", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEChar(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setDataObject", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getDataObject(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setDate", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEDate(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setDouble", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEDouble(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setFloat", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEFloat(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setInt", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setList", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getEJavaList(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setLong", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getELong(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setShort", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEShort(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, null, "setString", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, this.getDataObject(), "createDataObject", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "propertyName", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, this.getDataObject(), "createDataObject", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, this.getDataObject(), "createDataObject", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, this.getDataObject(), "createDataObject", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "propertyName", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "namespaceURI", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "typeName", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, this.getDataObject(), "createDataObject", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "namespaceURI", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "typeName", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(dataObjectEClass, this.getDataObject(), "createDataObject", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getType(), "type", 0, 1, IS_UNIQUE, IS_ORDERED);

    addEOperation(dataObjectEClass, null, "delete", 0, 1, IS_UNIQUE, IS_ORDERED);

    initEClass(eSequenceEClass, ESequence.class, "ESequence", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);

    addEOperation(eSequenceEClass, theEcorePackage.getEFeatureMap(), "featureMap", 0, 1, IS_UNIQUE, IS_ORDERED);

    initEClass(eTypeEClass, EType.class, "EType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
    initEReference(getEType_EClassifier(), theEcorePackage.getEClassifier(), null, "eClassifier", null, 1, 1, EType.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    op = addEOperation(eTypeEClass, this.getEProperty(), "getEProperty", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "propertyName", 0, 1, IS_UNIQUE, IS_ORDERED);

    initEClass(propertyEClass, Property.class, "Property", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getProperty_Name(), ecorePackage.getEString(), "name", null, 0, 1, Property.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getProperty_Many(), ecorePackage.getEBoolean(), "many", null, 0, 1, Property.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getProperty_Containment(), ecorePackage.getEBoolean(), "containment", null, 0, 1, Property.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getProperty_Default(), theEcorePackage.getEJavaObject(), "default", null, 0, 1, Property.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getProperty_Type(), this.getType(), null, "type", null, 1, 1, Property.class, !IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getProperty_ContainingType(), this.getType(), this.getType_Properties(), "containingType", null, 1, 1, Property.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    initEClass(sequenceEClass, Sequence.class, "Sequence", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);

    addEOperation(sequenceEClass, ecorePackage.getEInt(), "size", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(sequenceEClass, this.getProperty(), "getProperty", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "index", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(sequenceEClass, theEcorePackage.getEJavaObject(), "getValue", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "index", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(sequenceEClass, theEcorePackage.getEJavaObject(), "setValue", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "index", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEJavaObject(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(sequenceEClass, ecorePackage.getEBoolean(), "add", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "propertyName", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEJavaObject(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(sequenceEClass, ecorePackage.getEBoolean(), "add", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEJavaObject(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(sequenceEClass, ecorePackage.getEBoolean(), "add", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEJavaObject(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(sequenceEClass, null, "add", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "index", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "propertyName", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEJavaObject(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(sequenceEClass, null, "add", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "index", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "propertyIndex", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEJavaObject(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(sequenceEClass, null, "add", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEInt(), "index", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, this.getProperty(), "property", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEJavaObject(), "value", 0, 1, IS_UNIQUE, IS_ORDERED);

    initEClass(typeEClass, Type.class, "Type", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);
    initEAttribute(getType_Name(), ecorePackage.getEString(), "name", null, 0, 1, Type.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getType_URI(), ecorePackage.getEString(), "uRI", null, 0, 1, Type.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEAttribute(getType_InstanceClass(), theEcorePackage.getEJavaClass(), "instanceClass", null, 0, 1, Type.class, IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
    initEReference(getType_Properties(), this.getProperty(), this.getProperty_ContainingType(), "properties", null, 0, -1, Type.class, !IS_TRANSIENT, IS_VOLATILE, !IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

    op = addEOperation(typeEClass, ecorePackage.getEBoolean(), "isInstance", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, theEcorePackage.getEJavaObject(), "object", 0, 1, IS_UNIQUE, IS_ORDERED);

    op = addEOperation(typeEClass, this.getProperty(), "getProperty", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEParameter(op, ecorePackage.getEString(), "propertyName", 0, 1, IS_UNIQUE, IS_ORDERED);

    initEClass(internalEDataObjectEClass, InternalEDataObject.class, "InternalEDataObject", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

    op = addEOperation(internalEDataObjectEClass, theEcorePackage.getEJavaObject(), "writeReplace", 0, 1, IS_UNIQUE, IS_ORDERED);
    addEException(op, this.getEObjectStreamException());

    initEClass(eDataObjectAnyTypeEClass, EDataObjectAnyType.class, "EDataObjectAnyType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

    initEClass(eDataObjectSimpleAnyTypeEClass, EDataObjectSimpleAnyType.class, "EDataObjectSimpleAnyType", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

    initEClass(eJavaSerializableEClass, Serializable.class, "EJavaSerializable", IS_ABSTRACT, IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);

    // Initialize data types
    initEDataType(eJavaListEDataType, List.class, "EJavaList", !IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
    initEDataType(eObjectStreamExceptionEDataType, ObjectStreamException.class, "EObjectStreamException", !IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);

    // Create resource
    createResource(eNS_URI);

    // Create annotations
    // http:///org/eclipse/emf/ecore/util/ExtendedMetaData
    createExtendedMetaDataAnnotations();
  }

  /**
   * Initializes the annotations for <b>http:///org/eclipse/emf/ecore/util/ExtendedMetaData</b>.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected void createExtendedMetaDataAnnotations()
  {
    String source = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";																																																																																																																								
    addAnnotation
      (eDataObjectAnyTypeEClass, 
       source, 
       new String[] 
       {
       "kind", "mixed"
       });		
    addAnnotation
      (eDataObjectSimpleAnyTypeEClass, 
       source, 
       new String[] 
       {
       "kind", "simple"
       });
  }

} //SDOPackageImpl
