/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.InternalPerformanceMeter;
import org.eclipse.test.internal.performance.data.Assert;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Sample;
import org.eclipse.test.internal.performance.data.Scalar;

public class SystemTimePerformanceMeter
extends InternalPerformanceMeter {
    private static final int DEFAULT_INITIAL_CAPACITY = 3;
    private long fStartDate;
    private List fStartTime;
    private List fStopTime;

    public SystemTimePerformanceMeter(String scenarioId) {
        this(scenarioId, 3);
        this.fStartDate = System.currentTimeMillis();
    }

    public SystemTimePerformanceMeter(String scenarioId, int initalCapacity) {
        super(scenarioId);
        this.fStartTime = new ArrayList(initalCapacity);
        this.fStopTime = new ArrayList(initalCapacity);
    }

    public void start() {
        this.fStartTime.add(new Long(System.currentTimeMillis()));
    }

    public void stop() {
        this.fStopTime.add(new Long(System.currentTimeMillis()));
    }

    public void commit() {
        Assert.isTrue(this.fStartTime.size() == this.fStopTime.size());
        System.out.println("Scenario: " + this.getScenarioName());
        int maxOccurenceLength = String.valueOf(this.fStartTime.size()).length();
        for (int i = 0; i < this.fStartTime.size(); ++i) {
            String occurence = String.valueOf(i + 1);
            System.out.println("Occurence " + this.replicate(" ", maxOccurenceLength - occurence.length()) + occurence + ": " + ((Long)this.fStopTime.get(i) - (Long)this.fStartTime.get(i)));
        }
    }

    private String replicate(String s, int n) {
        StringBuffer buf = new StringBuffer(n * s.length());
        for (int i = 0; i < n; ++i) {
            buf.append(s);
        }
        return buf.toString();
    }

    public void dispose() {
        this.fStartTime = null;
        this.fStopTime = null;
        super.dispose();
    }

    public Sample getSample() {
        Assert.isTrue(this.fStartTime.size() == this.fStopTime.size());
        HashMap properties = new HashMap();
        DataPoint[] data = new DataPoint[2 * this.fStartTime.size()];
        for (int i = 0; i < this.fStartTime.size(); ++i) {
            data[2 * i] = this.createDataPoint(0, InternalDimensions.SYSTEM_TIME, (Long)this.fStartTime.get(i));
            data[2 * i + 1] = this.createDataPoint(1, InternalDimensions.SYSTEM_TIME, (Long)this.fStopTime.get(i));
        }
        return new Sample(this.getScenarioName(), this.fStartDate, properties, data);
    }

    private DataPoint createDataPoint(int step, Dim dimension, long value) {
        HashMap<Dim, Scalar> scalars = new HashMap<Dim, Scalar>();
        scalars.put(dimension, new Scalar(dimension, value));
        return new DataPoint(step, scalars);
    }
}

