/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.eval;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import junit.framework.Assert;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Scalar;

public class StatisticsSession {
    private final DataPoint[] fDataPoints;
    private final Map fStatistics = new HashMap();

    public StatisticsSession(DataPoint[] datapoints) {
        this.fDataPoints = datapoints;
    }

    public double getAverage(Dim dimension) {
        return this.getStats((Dim)dimension).average;
    }

    public long getMin(Dim dimension) {
        return this.getStats((Dim)dimension).min;
    }

    public long getSum(Dim dimension) {
        return this.getStats((Dim)dimension).sum;
    }

    public long getCount(Dim dimension) {
        return this.getStats((Dim)dimension).count;
    }

    private Statistics getStats(Dim dimension) {
        Statistics stats = (Statistics)this.fStatistics.get(dimension);
        if (stats == null) {
            stats = this.computeStats(dimension);
            this.fStatistics.put(dimension, stats);
        }
        return stats;
    }

    private Statistics computeStats(Dim dimension) {
        Statistics stats = new Statistics();
        HashSet<Integer> set = new HashSet<Integer>();
        for (int j = 0; j < this.fDataPoints.length; ++j) {
            DataPoint dp = this.fDataPoints[j];
            set.add(new Integer(dp.getStep()));
        }
        long[] mags = new long[this.fDataPoints.length];
        switch (set.size()) {
            case 1: {
                for (int i = 0; i < this.fDataPoints.length; ++i) {
                    long magnitude;
                    Scalar sc = this.fDataPoints[i].getScalar(dimension);
                    if (sc == null) continue;
                    mags[i] = magnitude = sc.getMagnitude();
                    stats.sum += magnitude;
                    ++stats.count;
                }
                if (stats.count <= 0L) break;
                stats.average = stats.sum / stats.count;
                break;
            }
            case 2: {
                for (int i = 0; i < this.fDataPoints.length - 1; i += 2) {
                    long magnitude;
                    DataPoint before = this.fDataPoints[i];
                    Assert.assertTrue((String)"wrong order of steps", (before.getStep() == 0 ? 1 : 0) != 0);
                    DataPoint after = this.fDataPoints[i + 1];
                    Assert.assertTrue((String)"wrong order of steps", (after.getStep() == 1 ? 1 : 0) != 0);
                    Scalar delta = this.getDelta(before, after, dimension);
                    mags[i] = magnitude = delta.getMagnitude();
                    stats.sum += magnitude;
                    ++stats.count;
                }
                if (stats.count <= 0L) break;
                stats.average = stats.sum / stats.count;
                break;
            }
            default: {
                Assert.assertTrue((String)"cannot handle more than two steps", (boolean)false);
            }
        }
        if (dimension.getName().indexOf("Time") > -1) {
            stats.min = StatisticsSession.getMin(mags);
            stats.average = stats.min;
        }
        return stats;
    }

    private static long[] removeZeros(long[] vals) {
        Vector<Long> v = new Vector<Long>();
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == 0L) continue;
            v.add(new Long(vals[i]));
        }
        long[] vals2 = new long[v.size()];
        for (int i = 0; i < vals2.length; ++i) {
            vals2[i] = (Long)v.get(i);
        }
        return vals2;
    }

    private Scalar getDelta(DataPoint before, DataPoint after, Dim dimension) {
        Scalar one = before.getScalar(dimension);
        Assert.assertTrue((String)("reference has no value for dimension " + dimension), (one != null ? 1 : 0) != 0);
        Scalar two = after.getScalar(dimension);
        Assert.assertTrue((String)("reference has no value for dimension " + dimension), (two != null ? 1 : 0) != 0);
        return new Scalar(one.getDimension(), two.getMagnitude() - one.getMagnitude());
    }

    private static long getMin(long[] vals) {
        long min = -1L;
        if (vals != null && vals.length >= 1) {
            vals = StatisticsSession.removeZeros(vals);
            Arrays.sort(vals);
            min = vals[0];
        }
        return min;
    }

    public boolean contains(Dim dimension) {
        if (this.fDataPoints.length > 0) {
            return this.fDataPoints[0].contains(dimension);
        }
        return false;
    }

    static final class Statistics {
        public long count;
        public long sum;
        public double average;
        public long min;

        Statistics() {
        }
    }
}

