/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.performance;

import junit.framework.TestCase;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;

public class PerformanceTestCase
extends TestCase {
    protected PerformanceMeter fPerformanceMeter;

    public PerformanceTestCase() {
    }

    public PerformanceTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        Performance performance = Performance.getDefault();
        this.fPerformanceMeter = performance.createPerformanceMeter(performance.getDefaultScenarioId(this));
    }

    protected void tearDown() throws Exception {
        this.fPerformanceMeter.dispose();
    }

    public void tagAsGlobalSummary(String shortName, Dimension dimension) {
        Performance performance = Performance.getDefault();
        performance.tagAsGlobalSummary(this.fPerformanceMeter, shortName, new Dimension[]{dimension});
    }

    public void tagAsGlobalSummary(String shortName, Dimension[] dimensions) {
        Performance performance = Performance.getDefault();
        performance.tagAsGlobalSummary(this.fPerformanceMeter, shortName, dimensions);
    }

    public void tagAsSummary(String shortName, Dimension dimension) {
        Performance performance = Performance.getDefault();
        performance.tagAsSummary(this.fPerformanceMeter, shortName, new Dimension[]{dimension});
    }

    public void tagAsSummary(String shortName, Dimension[] dimensions) {
        Performance performance = Performance.getDefault();
        performance.tagAsSummary(this.fPerformanceMeter, shortName, dimensions);
    }

    protected void startMeasuring() {
        this.fPerformanceMeter.start();
    }

    protected void stopMeasuring() {
        this.fPerformanceMeter.stop();
    }

    protected void commitMeasurements() {
        this.fPerformanceMeter.commit();
    }

    protected void assertPerformance() {
        Performance.getDefault().assertPerformance(this.fPerformanceMeter);
    }

    protected void assertPerformanceInRelativeBand(Dimension dim, int lowerPercentage, int upperPercentage) {
        Performance.getDefault().assertPerformanceInRelativeBand(this.fPerformanceMeter, dim, lowerPercentage, upperPercentage);
    }
}

