/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerHelper {
    protected String getMarkerID() {
        return "org.eclipse.core.resources.problemmarker";
    }

    protected IFile getFile(Object datum) {
        if (datum instanceof IFileEditorInput) {
            return ((IFileEditorInput)datum).getFile();
        }
        if (datum instanceof IFile) {
            return (IFile)datum;
        }
        if (datum instanceof Diagnostic) {
            return this.getFile((Diagnostic)datum);
        }
        return null;
    }

    protected IFile getFile(Diagnostic diagnostic) {
        List data = diagnostic.getData();
        if (data != null) {
            for (Object datum : data) {
                IFile result = this.getFile(datum);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    protected IFile getFile(URI uri) {
        String platformResourceString = uri.toPlatformString(true);
        return platformResourceString != null ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformResourceString)) : null;
    }

    public void createMarkers(Diagnostic diagnostic) throws CoreException {
        if (diagnostic.getChildren().isEmpty()) {
            this.createMarkers((IResource)this.getFile(diagnostic), diagnostic, null);
        } else if (diagnostic.getMessage() == null) {
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                this.createMarkers(childDiagnostic);
            }
        } else {
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                this.createMarkers((IResource)this.getFile(childDiagnostic), childDiagnostic, diagnostic);
            }
        }
    }

    protected void createMarkers(IResource resource, Diagnostic diagnostic, Diagnostic parentDiagnostic) throws CoreException {
        if (resource != null && resource.exists()) {
            IMarker marker = resource.createMarker(this.getMarkerID());
            int severity = diagnostic.getSeverity();
            if (severity < 2) {
                marker.setAttribute("severity", 0);
            } else if (severity < 4) {
                marker.setAttribute("severity", 1);
            } else {
                marker.setAttribute("severity", 2);
            }
            String message = this.composeMessage(diagnostic, parentDiagnostic);
            if (message != null) {
                marker.setAttribute("message", (Object)message);
            }
            this.adjustMarker(marker, diagnostic, parentDiagnostic);
        }
    }

    protected void adjustMarker(IMarker marker, Diagnostic diagnostic, Diagnostic parentDiagnostic) throws CoreException {
    }

    protected String composeMessage(Diagnostic diagnostic, Diagnostic parentDiagnostic) {
        return diagnostic.getMessage();
    }

    public boolean hasMarkers(Object object) {
        return this.hasMarkers(object, false, 0);
    }

    public boolean hasMarkers(Object object, boolean includeSubtypes, int depth) {
        return this.hasMarkers((IResource)this.getFile(object), includeSubtypes, depth);
    }

    protected boolean hasMarkers(IResource resource, boolean includeSubtypes, int depth) {
        if (resource != null && resource.exists()) {
            try {
                IMarker[] markers = resource.findMarkers(this.getMarkerID(), includeSubtypes, depth);
                return markers.length > 0;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    public void deleteMarkers(Object object) {
        this.deleteMarkers(object, false, 0);
    }

    public void deleteMarkers(Object object, boolean includeSubtypes, int depth) {
        this.deleteMarkers((IResource)this.getFile(object), includeSubtypes, depth);
    }

    protected void deleteMarkers(IResource resource, boolean includeSubtypes, int depth) {
        if (resource != null && resource.exists()) {
            try {
                resource.deleteMarkers(this.getMarkerID(), includeSubtypes, depth);
            }
            catch (CoreException e) {
                CommonUIPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    public IEditorInput getEditorInput(Object object) {
        IFile file = this.getFile(object);
        if (file != null) {
            return new FileEditorInput(file);
        }
        return null;
    }

    public List<?> getTargetObjects(Object object, IMarker marker) {
        return Collections.EMPTY_LIST;
    }
}

