/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.DiagnosticComposite;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class ProblemEditorPart
extends EditorPart {
    protected Diagnostic diagnostic;
    protected String editorToOpen;
    protected Label imageLabel;
    protected Text messageText;
    protected Button detailsButton;
    protected Composite detailsComposite;
    protected DiagnosticComposite diagnosticComposite;
    protected TextProvider textProvider = new TextProvider();

    public void dispose() {
        this.diagnostic = null;
        this.imageLabel = null;
        this.messageText = null;
        this.detailsButton = null;
        this.detailsComposite = null;
        this.diagnosticComposite = null;
        this.textProvider = null;
        super.dispose();
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
        if (this.diagnosticComposite != null) {
            this.diagnosticComposite.setTextProvider(textProvider);
        }
    }

    public TextProvider getTextProvider() {
        return this.textProvider;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(CommonUIPlugin.getPlugin().getString("_UI_Problems_label"));
    }

    public void createPartControl(Composite parent) {
        int margins;
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        int spacing = 8;
        layout.marginBottom = margins = 8;
        layout.marginTop = margins;
        layout.marginLeft = margins;
        layout.marginRight = margins;
        layout.horizontalSpacing = spacing;
        layout.verticalSpacing = spacing;
        parent.setLayout((Layout)layout);
        this.imageLabel = new Label(parent, 0);
        this.messageText = new Text(parent, 524362);
        this.messageText.setLayoutData((Object)new GridData(770));
        this.messageText.setBackground(this.messageText.getDisplay().getSystemColor(22));
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(130));
        buttonComposite.setLayout((Layout)new GridLayout());
        GridLayout layout2 = new GridLayout();
        int spacing2 = 3;
        layout2.marginTop = -5;
        layout2.marginRight = -5;
        layout2.horizontalSpacing = spacing2;
        layout2.verticalSpacing = spacing2;
        buttonComposite.setLayout((Layout)layout2);
        this.editorToOpen = this.computeEditorToOpen();
        if (this.editorToOpen != null) {
            Button openButton = new Button(buttonComposite, 8);
            openButton.setLayoutData((Object)new GridData(800));
            openButton.setText(CommonUIPlugin.getPlugin().getString("_UI_ErrorEditor_OpenEditor_label"));
            openButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ProblemEditorPart.this.openEditor();
                }
            });
        }
        this.detailsButton = new Button(buttonComposite, 8);
        this.detailsButton.setLayoutData((Object)new GridData(800));
        this.detailsButton.setData((Object)Boolean.FALSE);
        this.detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProblemEditorPart.this.toggleDetails();
            }
        });
        this.updateDetails();
        this.detailsComposite = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 2;
        this.detailsComposite.setLayoutData((Object)data);
        GridLayout layout3 = new GridLayout();
        int margin = -5;
        int spacing3 = 3;
        layout3.marginTop = margin;
        layout3.marginLeft = margin;
        layout3.marginRight = margin;
        layout3.marginBottom = margin;
        layout3.horizontalSpacing = spacing3;
        layout3.verticalSpacing = spacing3;
        this.detailsComposite.setLayout((Layout)layout3);
        this.refresh();
        parent.layout(true);
    }

    public Diagnostic getDiagnostic() {
        return this.diagnostic;
    }

    public void setDiagnostic(Diagnostic diagnostic) {
        this.diagnostic = diagnostic;
        this.refresh();
    }

    protected void refresh() {
        if (this.diagnostic != null && this.messageText != null) {
            Image image = this.getImage();
            if (image != null) {
                this.imageLabel.setImage(image);
                this.imageLabel.setLayoutData((Object)new GridData(66));
            }
            this.messageText.setText(this.getMessage());
            if (this.diagnosticComposite != null && this.diagnosticComposite.getDiagnostic() != this.diagnostic) {
                this.diagnosticComposite.setDiagnostic(this.diagnostic);
            }
        }
    }

    protected Image getImage() {
        Display display = Display.getCurrent();
        switch (this.diagnostic.getSeverity()) {
            case 4: {
                return display.getSystemImage(1);
            }
            case 2: {
                return display.getSystemImage(8);
            }
        }
        return display.getSystemImage(2);
    }

    protected String getMessage() {
        return this.getTextProvider().getMessage(this.getDiagnostic());
    }

    protected void updateDetails() {
        if (this.detailsButton.getData() == Boolean.TRUE) {
            if (this.diagnosticComposite == null) {
                this.diagnosticComposite = new DiagnosticComposite(this.detailsComposite, 0);
                this.diagnosticComposite.setSeverityMask(DiagnosticComposite.ERROR_WARNING_MASK);
                this.diagnosticComposite.setLayoutData(new GridData(1808));
                if (this.getTextProvider() != null) {
                    this.diagnosticComposite.setTextProvider(this.getTextProvider());
                }
                this.diagnosticComposite.initialize(this.getDiagnostic());
                this.detailsComposite.layout(true);
            } else {
                this.diagnosticComposite.setVisible(true);
            }
            this.detailsButton.setText(IDialogConstants.get().HIDE_DETAILS_LABEL);
        } else {
            if (this.diagnosticComposite != null) {
                this.diagnosticComposite.setVisible(false);
            }
            this.detailsButton.setText(IDialogConstants.get().SHOW_DETAILS_LABEL);
        }
    }

    protected void toggleDetails() {
        this.detailsButton.setData((Object)(this.detailsButton.getData() == Boolean.TRUE ? Boolean.FALSE : Boolean.TRUE));
        this.updateDetails();
    }

    protected String computeEditorToOpen() {
        IEditorDescriptor editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("foo.txt");
        return editorDescriptor != null ? editorDescriptor.getId() : null;
    }

    protected void openEditor() {
        if (this.editorToOpen != null) {
            try {
                IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorInput editorInput = this.getEditorInput();
                workbenchPage.openEditor(editorInput, this.editorToOpen, true, 3);
            }
            catch (Exception exception) {
                this.openErrorDialog(CommonUIPlugin.getPlugin().getString("_UI_OpenEditorError_message"), exception);
            }
        }
    }

    protected void openErrorDialog(String message, Exception exception) {
        DiagnosticDialog.open(Display.getCurrent().getActiveShell(), CommonUIPlugin.getPlugin().getString("_UI_Error_label"), message, BasicDiagnostic.toDiagnostic((Throwable)exception));
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }

    public static class TextProvider
    extends DiagnosticComposite.TextProvider {
        public String getMessage(Diagnostic rootDiagnostic) {
            return rootDiagnostic.getSeverity() == 0 ? CommonUIPlugin.getPlugin().getString("_UI_NoProblems_message") : (rootDiagnostic.getMessage() != null ? rootDiagnostic.getMessage() : CommonUIPlugin.getPlugin().getString("_UI_DefaultProblem_message"));
        }
    }
}

