/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.oda.ecore.ui.impl;

import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.oda.ecore.ui.ODAEcoreUIPlugin;
import org.eclipse.emf.oda.ecore.ui.impl.EcoreDataSourcePropertyPage;
import org.eclipse.emf.oda.ecore.ui.impl.EcoreDataSourceWizardPage;
import org.eclipse.emf.oda.ecore.util.StringUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EcoreDataSourcePageHelper {
    protected static String DEFAULT_MESSAGE = ODAEcoreUIPlugin.INSTANCE.getString("_UI_DefaultDataSource_message");
    protected EcoreDataSourceWizardPage wizardPage = null;
    protected EcoreDataSourcePropertyPage propertyPage = null;
    protected Text resourceField = null;

    protected EcoreDataSourcePageHelper(EcoreDataSourceWizardPage page) {
        assert (page != null);
        this.wizardPage = page;
    }

    protected EcoreDataSourcePageHelper(EcoreDataSourcePropertyPage page) {
        assert (page != null);
        this.propertyPage = page;
    }

    protected String getResource() {
        return this.resourceField == null ? null : this.resourceField.getText();
    }

    protected void createCustomControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.createResourceControl(composite);
    }

    protected void createResourceControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        Label resourceLabel = new Label(composite, 0);
        resourceLabel.setText(ODAEcoreUIPlugin.INSTANCE.getString("_UI_Resource_label"));
        this.resourceField = new Text(composite, 2048);
        this.resourceField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                EcoreDataSourcePageHelper.this.validateData();
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.resourceField);
        Button resourceButton = new Button(composite, 8);
        resourceButton.setText(ODAEcoreUIPlugin.INSTANCE.getString("_UI_Select_label"));
        resourceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                List uris;
                ResourceDialog dialog = new ResourceDialog(EcoreDataSourcePageHelper.this.getControl().getShell(), null, 4);
                if (dialog.open() == 0 && (uris = dialog.getURIs()).size() > 0) {
                    EcoreDataSourcePageHelper.this.resourceField.setText(((URI)uris.get(0)).toString());
                }
            }
        });
    }

    protected void initCustomControl(Properties properties) {
        if (properties == null) {
            return;
        }
        String resource = properties.getProperty("resource");
        if (!StringUtil.isEmpty((String)resource)) {
            this.resourceField.setText(resource);
        }
        this.validateData();
    }

    protected Properties collectCustomProperties(Properties properties) {
        String resource;
        if (properties == null) {
            properties = new Properties();
        }
        if (!StringUtil.isEmpty((String)(resource = this.getResource()))) {
            properties.setProperty("resource", resource);
        }
        return properties;
    }

    protected void validateData() {
        boolean isValid;
        String resource = this.getResource();
        boolean bl = isValid = !StringUtil.isEmpty((String)resource);
        if (isValid) {
            try {
                URI.createURI((String)resource);
                this.setMessage(DEFAULT_MESSAGE, 0);
            }
            catch (Exception e) {
                this.setMessage(e.getLocalizedMessage(), 3);
            }
        } else {
            this.setMessage(ODAEcoreUIPlugin.INSTANCE.getString("_UI_ResourceCannotBeEmpty_message"), 3);
        }
        this.setPageComplete(isValid);
    }

    protected Control getControl() {
        if (this.wizardPage != null) {
            return this.wizardPage.getControl();
        }
        if (this.propertyPage != null) {
            return this.propertyPage.getControl();
        }
        return null;
    }

    protected void setPageComplete(boolean complete) {
        if (this.wizardPage != null) {
            this.wizardPage.setPageComplete(complete);
        } else if (this.propertyPage != null) {
            this.propertyPage.setValid(complete);
        }
    }

    protected void setMessage(String newMessage, int newType) {
        if (this.wizardPage != null) {
            this.wizardPage.setMessage(newMessage, newType);
        } else if (this.propertyPage != null) {
            this.propertyPage.setMessage(newMessage, newType);
        }
    }
}

