/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.ui;

import java.io.File;
import java.lang.reflect.Constructor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.URIEditorInputFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.osgi.framework.Bundle;

public class URIEditorInput
implements IEditorInput,
IPersistableElement {
    private URI uri;
    private String name;
    protected static final String BUNDLE_TAG = "bundle";
    protected static final String CLASS_TAG = "class";
    protected static final String URI_TAG = "uri";
    protected static final String NAME_TAG = "name";

    public URIEditorInput(URI uri) {
        this.uri = uri;
    }

    public URIEditorInput(URI uri, String name) {
        this.uri = uri;
        this.name = name;
    }

    public URIEditorInput(IMemento memento) {
        this.loadState(memento);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof URIEditorInput && this.uri.equals((Object)((URIEditorInput)o).getURI());
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean exists() {
        if (this.getURI().isFile()) {
            return new File(this.getURI().toFileString()).exists();
        }
        if (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) {
            return EclipseUtil.exists(this.uri);
        }
        return false;
    }

    public String getName() {
        if (this.name == null) {
            URI uri = this.getURI();
            return URI.decode((String)(uri.isHierarchical() && uri.lastSegment() != null ? uri.lastSegment() : uri.toString()));
        }
        return this.name;
    }

    public String getToolTipText() {
        return this.getURI().toString();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public Object getAdapter(Class adapter) {
        Object result;
        if (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE && (result = EclipseUtil.getAdapter(adapter, this.uri)) != null) {
            return result;
        }
        return null;
    }

    public String getFactoryId() {
        return URIEditorInputFactory.ID;
    }

    protected String getBundleSymbolicName() {
        return CommonUIPlugin.getPlugin().getSymbolicName();
    }

    static URIEditorInput create(IMemento memento) {
        String bundleSymbolicName = memento.getString(BUNDLE_TAG);
        String className = memento.getString(CLASS_TAG);
        try {
            Bundle bundle = Platform.getBundle((String)bundleSymbolicName);
            Class theClass = bundle.loadClass(className);
            Constructor constructor = theClass.getConstructor(IMemento.class);
            return (URIEditorInput)constructor.newInstance(memento);
        }
        catch (Exception exception) {
            CommonUIPlugin.INSTANCE.log(exception);
            return new URIEditorInput(memento);
        }
    }

    public void saveState(IMemento memento) {
        memento.putString(BUNDLE_TAG, this.getBundleSymbolicName());
        memento.putString(CLASS_TAG, this.getClass().getName());
        memento.putString(URI_TAG, this.uri.toString());
        memento.putString(NAME_TAG, this.name);
    }

    protected void loadState(IMemento memento) {
        this.uri = URI.createURI((String)memento.getString(URI_TAG));
        this.name = memento.getString(NAME_TAG);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class EclipseUtil {
        protected EclipseUtil() {
        }

        @Deprecated
        public static Object getAdatper(Class<?> adapter, URI uri) {
            return EclipseUtil.getAdapter(adapter, uri);
        }

        public static Object getAdapter(Class<?> adapter, URI uri) {
            if ((adapter == IFile.class || adapter == IResource.class) && uri.isPlatformResource()) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
            }
            return null;
        }

        public static boolean exists(URI uri) {
            if (uri.isPlatformResource()) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))).exists();
            }
            return false;
        }
    }
}

