/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.examples.jet.article2.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.examples.jet.article2.TypesafeEnumPlugin;
import org.eclipse.emf.examples.jet.article2.codegen.Config;
import org.eclipse.emf.examples.jet.article2.codegen.JETGateway;
import org.eclipse.emf.examples.jet.article2.ui.NewTypesafeEnumCreationWizardPage;
import org.eclipse.emf.examples.jet.article2.ui.NewTypesafeEnumCreationWizardPageAttributes;
import org.eclipse.emf.examples.jet.article2.ui.NewTypesafeEnumCreationWizardPageInstances;
import org.eclipse.emf.examples.jet.article2.ui.WizardMessages;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewTypesafeEnumCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench mWorkbench;
    private IStructuredSelection mSelection;
    private static final String DIALOG_SETTINGS_KEY = "NewTypesafeEnumCreationWizard";
    private NewTypesafeEnumCreationWizardPage mPage1;
    private NewTypesafeEnumCreationWizardPageAttributes mPage2;
    private NewTypesafeEnumCreationWizardPageInstances mPage3;

    public NewTypesafeEnumCreationWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(TypesafeEnumPlugin.getImageDescriptor("icons/newclass_wiz.gif"));
        this.initDialogSettings();
        this.setWindowTitle(WizardMessages.getString("Wizard.title.new"));
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.mWorkbench = workbench;
        this.mSelection = currentSelection;
    }

    public void addPages() {
        super.addPages();
        this.mPage1 = new NewTypesafeEnumCreationWizardPage();
        this.addPage((IWizardPage)this.mPage1);
        this.mPage1.init(this.getSelection());
        this.mPage2 = new NewTypesafeEnumCreationWizardPageAttributes();
        this.addPage((IWizardPage)this.mPage2);
        this.mPage3 = new NewTypesafeEnumCreationWizardPageInstances();
        this.addPage((IWizardPage)this.mPage3);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        Config config = new Config();
        config.setModel(this.mPage1.getTypesafeEnumModel());
        config.setPackageName(this.mPage1.getPackageText());
        config.setTargetFile(String.valueOf(this.mPage1.getTypeName()) + ".java");
        config.setTargetFolder(this.mPage1.getPackageFragmentRootText());
        config.setClasspathVariable("JET_TUTORIAL");
        config.setPluginId(TypesafeEnumPlugin.getPluginId());
        config.setTemplateRelativeUri("templates/TypeSafeEnumeration.javajet");
        JETGateway gateway = new JETGateway(config);
        String content = gateway.generate(monitor);
        IFile file = gateway.save(monitor, content.getBytes());
        this.selectAndReveal((IResource)file);
        this.openResource((IResource)file);
    }

    public boolean performFinish() {
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                try {
                    NewTypesafeEnumCreationWizard.this.finishPage(monitor);
                }
                catch (InterruptedException e) {
                    throw new OperationCanceledException(e.getMessage());
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op));
        }
        catch (InvocationTargetException e) {
            this.handleFinishException(this.getShell(), e);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        Diagnostic diagnostic = BasicDiagnostic.toDiagnostic((Throwable)e);
        TypesafeEnumPlugin.log(diagnostic);
        String title = WizardMessages.getString("Wizard.op_error.title");
        String message = WizardMessages.getString("Wizard.op_error.message");
        DiagnosticDialog.open((Shell)shell, (String)title, (String)message, (Diagnostic)diagnostic);
    }

    protected void openResource(final IResource resource) {
        Display display;
        IWorkbenchPage activePage;
        if (resource.getType() == 1 && (activePage = TypesafeEnumPlugin.getActivePage()) != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)resource), (boolean)true);
                    }
                    catch (PartInitException e) {
                        TypesafeEnumPlugin.log(e);
                    }
                }
            });
        }
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)this.mWorkbench.getActiveWorkbenchWindow());
    }

    public IStructuredSelection getSelection() {
        return this.mSelection;
    }

    protected void initDialogSettings() {
        IDialogSettings pluginSettings = TypesafeEnumPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = pluginSettings.getSection(DIALOG_SETTINGS_KEY);
        if (wizardSettings == null) {
            wizardSettings = new DialogSettings(DIALOG_SETTINGS_KEY);
            pluginSettings.addSection(wizardSettings);
        }
        this.setDialogSettings(wizardSettings);
    }

    private static class WorkbenchRunnableAdapter
    implements IRunnableWithProgress {
        private IWorkspaceRunnable fWorkspaceRunnable;

        public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable) {
            this.fWorkspaceRunnable = runnable;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                JavaCore.run((IWorkspaceRunnable)this.fWorkspaceRunnable, (IProgressMonitor)monitor);
            }
            catch (OperationCanceledException e) {
                throw new InterruptedException(e.getMessage());
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

