/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportManager {
    protected SortedSet<String> imports = new TreeSet<String>();
    protected HashMap<String, String> shortNameToImportMap = new HashMap();
    protected HashSet<String> importedPackages = new HashSet();
    private String lineDelimiter;
    private StringBuilder importStringBuilder;
    private StringBuffer importStringBuffer;
    private int importInsertionPoint;
    protected HashSet<String> javaLangImports = null;

    public ImportManager(String compilationUnitPackage, String compilationUnitShortName) {
        this(compilationUnitPackage);
        this.addMasterImport(compilationUnitPackage, compilationUnitShortName);
    }

    public ImportManager(String compilationUnitPackage) {
        this.importedPackages.add(this.collapse(compilationUnitPackage));
    }

    private String collapse(String s) {
        char[] src = s.toCharArray();
        char[] result = null;
        int srcLength = src.length;
        int resultLenth = -1;
        int i = 0;
        while (i < srcLength) {
            if (Character.isWhitespace(src[i])) {
                if (result == null) {
                    result = new char[srcLength];
                    System.arraycopy(src, 0, result, 0, i);
                    resultLenth = i;
                }
            } else if (result != null) {
                result[resultLenth++] = src[i];
            }
            ++i;
        }
        return result != null ? new String(result, 0, resultLenth) : s;
    }

    private String normalize(String name) {
        int j = name.indexOf(91);
        return this.collapse(j == -1 ? name : name.substring(0, j));
    }

    private String getImportName(String qualifiedName) {
        int j = qualifiedName.indexOf(36);
        if (j == -1) {
            j = qualifiedName.indexOf(91);
        }
        return this.collapse(j == -1 ? qualifiedName : qualifiedName.substring(0, j));
    }

    private String getPackageName(String qualifiedName) {
        int j = qualifiedName.lastIndexOf(46);
        return j == -1 ? "" : this.collapse(qualifiedName.substring(0, j));
    }

    private String getShortName(String qualifiedName) {
        int i = qualifiedName.lastIndexOf(46) + 1;
        int j = qualifiedName.indexOf(36, i);
        if (j == -1) {
            j = qualifiedName.indexOf(91, i);
        }
        if (j == -1) {
            j = qualifiedName.length();
        }
        return this.collapse(qualifiedName.substring(i, j));
    }

    private String getRawName(String qualifiedName) {
        return qualifiedName.replace('$', '.');
    }

    private String getBaseName(String qualifiedName) {
        int i = qualifiedName.lastIndexOf(46) + 1;
        return qualifiedName.substring(i).replace('$', '.');
    }

    public String getImportedName(String qualifiedName, boolean autoImport) {
        int i = qualifiedName.indexOf(60);
        if (i == -1) {
            return this.basicGetImportedName(qualifiedName, autoImport);
        }
        StringBuilder result = new StringBuilder();
        int start = 0;
        int end = qualifiedName.length();
        while (i < end) {
            char c = qualifiedName.charAt(i);
            switch (c) {
                case '&': 
                case ',': 
                case '<': 
                case '>': {
                    if (start != i) {
                        result.append(this.basicGetImportedName(qualifiedName.substring(start, i), autoImport));
                    }
                    result.append(c);
                    start = i + 1;
                    break;
                }
                case '?': {
                    int j = i + 1;
                    while (j < end && Character.isWhitespace(qualifiedName.charAt(j))) {
                        ++j;
                    }
                    if (j + 6 < end && "extends".equals(qualifiedName.substring(j, j + 7))) {
                        result.append(qualifiedName.substring(i, j + 7));
                        i = j + 6;
                    } else if (j + 4 < end && "super".equals(qualifiedName.substring(j, j + 5))) {
                        result.append(qualifiedName.substring(i, j + 5));
                        i = j + 4;
                    } else {
                        result.append(c);
                    }
                    start = i + 1;
                }
                default: {
                    if (!Character.isWhitespace(c) || start != i) break;
                    result.append(c);
                    ++start;
                }
            }
            ++i;
        }
        return result.toString();
    }

    public String getImportedName(String qualifiedName) {
        return this.getImportedName(qualifiedName, false);
    }

    protected String basicGetImportedName(String qualifiedName, boolean autoImport) {
        int i = qualifiedName.lastIndexOf(46);
        if (i == -1) {
            return qualifiedName;
        }
        if (autoImport) {
            this.addImport(qualifiedName);
        }
        String rawName = this.getRawName(qualifiedName);
        char[] qualifiedNameChars = null;
        while (i != -1) {
            String baseName = this.getBaseName(qualifiedName);
            String importName = this.getImportName(qualifiedName);
            String shortName = this.getShortName(importName);
            String registeredName = this.shortNameToImportMap.get(shortName);
            if (registeredName == null) {
                if (qualifiedNameChars == null && importName.equals("java.lang." + shortName)) {
                    if (this.javaLangImports != null && this.javaLangImports.contains(shortName)) {
                        this.imports.add(importName);
                    }
                    return baseName;
                }
                if (this.importedPackages.contains(this.getPackageName(importName)) && (this.javaLangImports == null || !this.javaLangImports.contains(baseName))) {
                    return baseName;
                }
            } else if (importName.equals(registeredName)) {
                return baseName;
            }
            if ((i = qualifiedName.indexOf(36, i)) == -1) continue;
            if (qualifiedNameChars == null) {
                qualifiedNameChars = qualifiedName.toCharArray();
            }
            qualifiedNameChars[i] = 46;
            qualifiedName = new String(qualifiedNameChars);
        }
        return rawName;
    }

    public void addImport(String packageName, String shortName) {
        this.basicAddImport(this.normalize(packageName), this.normalize(shortName), null);
    }

    public void addImport(String qualifiedName) {
        String importName = this.getImportName(qualifiedName);
        this.basicAddImport(this.getPackageName(importName), this.getShortName(importName), importName);
    }

    private void basicAddImport(String packageName, String shortName, String importName) {
        if (importName == null) {
            importName = packageName + '.' + shortName;
        }
        if (shortName.equals("*")) {
            this.importedPackages.add(packageName);
            this.imports.add(importName);
        } else if (!this.shortNameToImportMap.containsKey(shortName) && this.shouldImport(packageName, shortName, importName)) {
            this.shortNameToImportMap.put(shortName, importName);
            if (!this.importedPackages.contains(packageName)) {
                this.imports.add(importName);
            }
        }
    }

    protected boolean shouldImport(String packageName, String shortName, String importName) {
        return !CodeGenUtil.isJavaDefaultType(shortName);
    }

    public void addPseudoImport(String qualifiedName) {
        String importName = this.getImportName(qualifiedName);
        String shortName = this.getShortName(importName);
        if (shortName.equals("*")) {
            String packageName = this.getPackageName(importName);
            this.importedPackages.add(packageName);
        } else {
            this.shortNameToImportMap.put(shortName, importName);
        }
    }

    public void addMasterImport(String packageName, String shortName) {
        packageName = this.normalize(packageName);
        shortName = this.normalize(shortName);
        this.shortNameToImportMap.put(shortName, packageName + '.' + shortName);
    }

    public boolean hasImport(String shortName) {
        return this.shortNameToImportMap.containsKey(this.normalize(shortName));
    }

    public Collection<String> getImports() {
        this.compactImports();
        return this.imports;
    }

    private void compactImports() {
        Iterator i = this.imports.iterator();
        while (i.hasNext()) {
            String importName = (String)i.next();
            if (this.getShortName(importName).equals("*") || !this.importedPackages.contains(this.getPackageName(importName))) continue;
            i.remove();
        }
    }

    public String getLineDelimiter() {
        return this.lineDelimiter == null ? System.getProperty("line.separator") : this.lineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    public String computeSortedImports() {
        String NL = this.getLineDelimiter();
        String previousPackageName = null;
        StringBuffer result = new StringBuffer();
        for (String importName : this.getImports()) {
            String packageName = this.getPackageName(importName);
            if (previousPackageName != null && !previousPackageName.equals(packageName)) {
                result.append(NL);
            }
            previousPackageName = packageName;
            result.append(String.valueOf(NL) + "import " + importName + ";");
        }
        return result.toString();
    }

    public void addCompilationUnitImports(String compilationUnitContents) {
        List<String> imports = EMFPlugin.IS_ECLIPSE_RUNNING ? EclipseHelper.getCompilationUnitImports(compilationUnitContents) : this.getCompilationUnitImports(compilationUnitContents);
        for (String qualifiedName : imports) {
            this.addPseudoImport(qualifiedName);
        }
    }

    private List<String> getCompilationUnitImports(String compilationUnitContents) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern importPattern = Pattern.compile("import\\s+([^\\s;]*);\\s*", 40);
        Matcher matcher = importPattern.matcher(compilationUnitContents);
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }

    public void markImportLocation(StringBuilder stringBuilder) {
        this.importStringBuffer = null;
        this.importStringBuilder = stringBuilder;
        this.importInsertionPoint = stringBuilder.length();
        this.addCompilationUnitImports(stringBuilder.toString());
    }

    public void markImportLocation(StringBuffer stringBuffer) {
        this.importStringBuilder = null;
        this.importStringBuffer = stringBuffer;
        this.importInsertionPoint = stringBuffer.length();
        this.addCompilationUnitImports(stringBuffer.toString());
    }

    public void emitSortedImports() {
        if (this.importStringBuilder != null) {
            this.importStringBuilder.insert(this.importInsertionPoint, this.computeSortedImports());
        } else if (this.importStringBuffer != null) {
            this.importStringBuffer.insert(this.importInsertionPoint, this.computeSortedImports());
        }
    }

    public void addJavaLangImports(List<String> javaLangClassNames) {
        if (!javaLangClassNames.isEmpty()) {
            this.javaLangImports = new HashSet();
            for (String shortName : javaLangClassNames) {
                this.javaLangImports.add(this.normalize(shortName));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EclipseHelper {
        private EclipseHelper() {
        }

        public static List<String> getCompilationUnitImports(String compilationUnitContents) {
            ArrayList<String> result = new ArrayList<String>();
            ASTParser parser = CodeGenUtil.EclipseUtil.newASTParser();
            parser.setSource(compilationUnitContents.toCharArray());
            CompilationUnit compilationUnit = (CompilationUnit)parser.createAST((IProgressMonitor)new NullProgressMonitor());
            for (ImportDeclaration importDeclaration : compilationUnit.imports()) {
                result.add(importDeclaration.getName().getFullyQualifiedName());
            }
            return result;
        }
    }
}

