/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.example.databinding.project.ui.rcp.dialogs;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.example.databinding.project.ui.rcp.databinding.EMFObservablesManager;
import org.eclipse.emf.example.databinding.project.ui.rcp.databinding.UpdateStrategyFactory;
import org.eclipse.emf.example.databinding.project.ui.rcp.dialogs.PersonFilterDialog;
import org.eclipse.emf.examples.databinding.project.core.IModelResource;
import org.eclipse.emf.examples.databinding.project.core.model.project.CommitterShip;
import org.eclipse.emf.examples.databinding.project.core.model.project.Person;
import org.eclipse.emf.examples.databinding.project.core.model.project.ProjectPackage;
import org.eclipse.jface.databinding.dialog.TitleAreaDialogSupport;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CommitterShipDialog
extends TitleAreaDialog {
    private final DataBindingContext ctx;
    private final CommitterShip committership;
    final IModelResource resource;
    private final boolean isnew;

    public CommitterShipDialog(Shell parentShell, IModelResource resource, CommitterShip committership, boolean isnew) {
        super(parentShell);
        this.committership = committership;
        this.resource = resource;
        this.isnew = isnew;
        this.ctx = new EMFDataBindingContext();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Edit Committership");
        this.setTitle("Edit Committership");
        this.setMessage("Edit the committership of a person in the project");
        final Composite comp = (Composite)super.createDialogArea(parent);
        EMFObservablesManager mgr = new EMFObservablesManager();
        mgr.runAndCollect(new Runnable(){

            public void run() {
                CommitterShipDialog.this.createForm(comp).setLayoutData((Object)new GridData(1808));
            }
        });
        return comp;
    }

    private Control createForm(final Composite comp) {
        Composite container = new Composite(comp, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Label l = new Label(container, 0);
        l.setText("Committer");
        IEMFEditValueProperty mprop = EMFEditProperties.value((EditingDomain)this.resource.getEditingDomain(), (EStructuralFeature)ProjectPackage.Literals.COMMITTER_SHIP__PERSON);
        ViewForm form = new ViewForm(container, 0x800800);
        form.setLayoutData((Object)new GridData(768));
        CLabel label = new CLabel((Composite)form, 0);
        form.setContent((Control)label);
        this.ctx.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)label), mprop.observe((Object)this.committership), null, new EMFUpdateValueStrategy().setConverter((IConverter)new PersonToStringConverter()));
        Button b = new Button(container, 8);
        b.setText("...");
        b.setEnabled(this.isnew);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Command cmd;
                PersonFilterDialog dialog = new PersonFilterDialog(comp.getShell(), CommitterShipDialog.this.resource);
                dialog.open();
                Person p = (Person)dialog.getFirstResult();
                if (p != null && (cmd = SetCommand.create((EditingDomain)CommitterShipDialog.this.resource.getEditingDomain(), (Object)CommitterShipDialog.this.committership, (Object)ProjectPackage.Literals.COMMITTER_SHIP__PERSON, (Object)p)).canExecute()) {
                    CommitterShipDialog.this.resource.executeCmd(cmd);
                }
            }
        });
        IWidgetValueProperty textProp = WidgetProperties.text((int)24);
        Label l2 = new Label(container, 0);
        l2.setText("Startdate");
        IEMFEditValueProperty mprop2 = EMFEditProperties.value((EditingDomain)this.resource.getEditingDomain(), (EStructuralFeature)ProjectPackage.Literals.COMMITTER_SHIP__START);
        Text t = new Text(container, 2048);
        t.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.ctx.bindValue((IObservableValue)textProp.observe((Widget)t), mprop2.observe((Object)this.committership), (UpdateValueStrategy)UpdateStrategyFactory.stringToDateNotNull("Can't convert start date value into a valid date", "The start date can not be null"), (UpdateValueStrategy)UpdateStrategyFactory.dateToString());
        l2 = new Label(container, 0);
        l2.setText("Enddate");
        mprop2 = EMFEditProperties.value((EditingDomain)this.resource.getEditingDomain(), (EStructuralFeature)ProjectPackage.Literals.COMMITTER_SHIP__END);
        t = new Text(container, 2048);
        t.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.ctx.bindValue((IObservableValue)textProp.observe((Widget)t), mprop2.observe((Object)this.committership), (UpdateValueStrategy)UpdateStrategyFactory.stringToDate("Can't convert end date value into a valid date"), (UpdateValueStrategy)UpdateStrategyFactory.dateToString());
        TitleAreaDialogSupport.create((TitleAreaDialog)this, (DataBindingContext)this.ctx);
        return container;
    }

    private class PersonToStringConverter
    extends Converter {
        public PersonToStringConverter() {
            super(Person.class, String.class);
        }

        public Object convert(Object fromObject) {
            if (fromObject != null) {
                Person p = (Person)fromObject;
                return String.valueOf(p.getLastname()) + ", " + p.getFirstname();
            }
            return null;
        }
    }
}

